# Dipolar physics: A review of experiments with magnetic quantum gases.

Lauriane Chomaz $^ { 1 , 2 }$ , Igor Ferrier-Barbut $^ { 3 , 4 }$ , Francesca Ferlaino $^ { 1 , 5 }$ , Bruno Laburthe-Tolra $^ { 6 , 7 }$ , Benjamin L. Lev $^ { 8 }$ , Tilman Pfau $^ 3$ . $^ { 1 }$ Institut für Experimentalphysik, Universität Innsbruck, Technikerstrasse 25, 6020 Innsbruck, Austria $^ 2$ Physikalisches Institut der Universität Heidelberg, Im Neuenheimer Feld 226, 69120 Heidelberg, Germany $^ 3$ Physikalisches Institut and Center for Integrated Quantum Science and Technology, Universität Stuttgart, Pfaffenwaldring 57, 70550 Stuttgart, Germany $^ 4$ Université Paris-Saclay, Institut d’Optique Graduate School, CNRS, Laboratoire Charles Fabry, 91127, Palaiseau, France 5 Institut für Quantenoptik und Quanteninformation, Österreichische Akademie der Wissenschaften, 6020 Innsbruck, Austria $^ 6$ Université Sorbonne Paris Nord, Laboratoire de Physique des Lasers, F-93430 Villetaneuse, France $^ 7$ CNRS, UMR 7538, LPL, F-93430, Villetaneuse, France and Departments of Physics and Applied Physics and Ginzton Laboratory, Stanford University, Stanford CA 94305, US (Dated: November 1, 2022)

Since the achievement of quantum degeneracy in gases of chromium atoms in 2004, the experimental investigation of ultracold gases made of highly magnetic atoms has blossomed. The field has yielded the observation of many unprecedented phenomena, in particular those in which long-range and anisotropic dipole-dipole interactions play a crucial role. In this review, we aim to present the aspects of the magnetic quantum-gas platform that make it unique for exploring ultracold and quantum physics as well as to give a thorough overview of experimental achievements.

Highly magnetic atoms distinguish themselves by the fact that their electronic ground-state configuration possesses a large spin (as well as a large $g$ factor). This results in a large magnetic moment and a rich electronic transition spectrum. Such transitions are useful for cooling, trapping, and manipulating these atoms. The complex atomic structure and large dipolar moments of these atoms also lead to a dense spectrum of resonances in their two-body scattering behaviour. These resonances can be used to control the interatomic interactions and, in particular, the relative importance of contact over dipolar interactions. These features provide exquisite control knobs for exploring the few- and many-body physics of dipolar quantum gases.

The study of dipolar effects in magnetic quantum gases has covered various few-body phenomena that are based on elastic and inelastic anisotropic scattering. Various many-body effects have also been demonstrated. These affect both the shape, stability, dynamics, and excitations of fully polarised repulsive Bose or Fermi gases. Beyond the mean-field instability, strong dipolar interactions competing with slightly weaker contact interactions between magnetic bosons yield new quantumstabilised states, among which are self-bound droplets, droplet assemblies, and supersolids. Dipolar interactions also deeply affect the physics of atomic gases with an internal degree of freedom as these interactions intrinsically couple spin and atomic motion. Finally, long-range dipolar interactions can stabilise strongly correlated excited states of 1D gases and also impact the physics of lattice-confined systems, both at the spin-polarised level (Hubbard models with off-site interactions) and at the spinful level (XYZ models). In the present manuscript, we aim to provide an extensive overview of the various related experimental achievements up to the present.

# Contents

I. Introduction to dipolar physics

A. Quantum gases with dipolar interactions 1. Electric dipoles 2. Magnetic dipoles   
B. The dipole-dipole interaction   
C. Main characteristics of dipolar interactions 1. Definition of ‘long-range’ 2. Consequences of anisotropy 3. Physical processes associated with dipolar interactions 4. Two-body dipolar scattering 5. Momentum-space DDI expression   
D. Many-body dipolar physics

1. Dipolar Bose quantum gases 8   
2. Dipolar Fermi quantum gases 10   
3. Dipolar gases in confined geometries 11   
4. Light-induced coupling of spins in   
magnetic atoms 12

II. The magnetic atoms 12

A. Chromium 12   
B. Lanthanides 13 1. Atomic energy spectrum of magnetic Lns 14 2. Optical cooling, trapping, and evaporative cooling of open-shell Ln 14   
C. Atom-light interactions in magnetic atoms 17 1. Atomic polarisability tensor 18 2. Tensor polarisability in magnetic atoms 18

D. Feshbach resonances in magnetic atoms 19   
1. Feshbach resonances in Chromium 20   
2. Feshbach resonances in magnetic Lns 21   
3. Feshbach molecules of magnetic atoms 24   
E. Comparison between the different systems 24

III. Ultracold dipolar scattering 25

A. Relevant aspects of scattering theory 26 1. Partial wave expansion 26 2. Ultracold limit and short-range interactions 262727 3. Role of quantum statistics   
B. Universal elastic dipolar scattering   
C. Universal inelastic dipolar scattering: Dipolar relaxation 28 1. Inelastic cross sections 28 2. Inelastic cross section measurements 29 3. Interaction range for dipolar relaxation 29 4. Quantum statistics and dipolar relaxation: Bose enhancement and Fermi suppression. 30 5. Control of dipolar relaxation via confinement 30 6. Dipolar relaxation and spinor physics 31   
D. Anisotropic scattering 3232 1. Anisotropy of rethermalisation 2. Anisotropic scattering halos

IV. Fully polarised repulsive bulk dipolar gases 33

A. Weakly interacting three-dimensional dipolar Bose gases 34 1. The mean-field description 34 2. Magnetostriction 353741 3. Elementary excitations of dBECs 4. Mean-field stability of dBECs   
B. Dipolar quantum-degenerate Fermi gases 44

V. Dipolar collapse and quantum stabilised states of Bose gases

A. Dipolar collapse 47   
B. Theoretical description of dipolar quantum stabilised states 48 1. Simple description of dipolar quantum stabilisation 48 2. Simple description of ultra-dilute liquid state. 48 3. Toward a quantitative theory description: extended Gross-Pitaevskii equation. 49   
C. Dipolar Quantum droplets 50 1. single droplet ground state in an external trap, eGPE phase diagram 50 2. First observations of droplet states: metastable droplet assemblies and the quest for the stabilisation mechanism 51 3. Crossover from a Bose-Einstein condensate to a large quantum droplet. 52 4. Droplet properties and their signature in the collective modes 53

5. Self-bound droplets and liquid-gas phase diagram 53 D. Dipolar Supersolids 54 1. Preliminary works 54 2. First experimental evidences of supersolid behaviors 55 3. eGPE phase diagram beyond the single-droplet regime: droplet assemblies and supersolid states. 56 4. Toward probing the dynamical response and superfluidity of dipolar supersolids 57 5. Supersolids with richer crystalline patterns and two-dimensional character 59

VI. Spin physics with highly magnetic atoms 59

A. Introduction to spinor physics 60 1. Magnetic atoms: a large composite spin 60 2. Spin-dependent one-body Hamiltonian for spinor gases 60 3. Spin-dependent interactions for large-spin atoms 60 4. Mean-field spinor physics with spin-dependent contact interactions 61 5. Beyond-mean-field spinor physics with spin-dependent contact interactions 62 6. How are dipolar interactions expected to impact spinor physics? 62   
B. Effects of dipolar interactions on spinor physics at constant magnetisation 62 1. Dipolar-induced spin textures in BECs 62 2. Gapped magnon excitations of BECs 63 3. Out-of-equilibrium spin dynamics at constant magnetisation 63 4. Effective spin- $1 / 2$ mixture of dipolar fermions 64   
C. Spinor physics with free magnetisation 64 1. Thermodynamics of a Bose gas with free magnetisation 65 2. Spontaneous demagnetisation of a BEC 66 3. New cooling methods 67   
D. Light-induced spin-dependent Hamiltonians in dipolar gases 67 1. Synthetic spin-orbit coupling in gases of magnetic atoms 68 2. Synthetic spin-dependent interactions in gases of magnetic atoms and generation of entangled quantum states 70

VII. Magnetic atoms in strongly confined geometries: low-dimensional gases and lattice systems

A. One-dimensional dipolar gases 71 1. The effective quasi-1D DDI and realisation of 1D dipolar gases 72 2. Thermalization in a dipolar quantum Newton’s cradle 73 3. Dipolar stabilisation of super-Tonks-Girardeau gases 74

4. Quantum holonomy, topological pumping, and strongly correlated prethermal states 75   
B. Spinless dipoles in lattices. 77 1. Extended Hubbard Hamiltonian and consequences 77 2. Experimental status 79   
C. Exploration of spin lattice models and quantum magnetism 79 1. Introduction 79 2. Free magnetisation and XYZ spin models 80 3. Fixed magnetisation and the secular NMR Hamiltonian (XXZ model) 81 4. Large spin magnetism 81 5. Magnetism as a function of lattice depth 81 6. Other experimental systems 82 7. Experimental status with magnetic atoms 82

VIII. Perspectives 84

References 85

# I. Introduction to dipolar physics

Ultracold gases have drawn considerable interest since the realisation of quantum degenerate Bose [1–3] and Fermi [4–6] gases in the mid-to-late 1990’s. This interest stems from many quarters within the physics community, but especially from those interested in using ultracold gases as test-bed systems for theoretical models, for exploring their properties as new—highly controllable— examples of strongly correlated matter, and for engineering them for quantum information processing [7–9].

Interparticle interactions fundamentally determine the properties of a quantum gas. Even in the weakly interacting limit, they dictate its shape, density, and the way it becomes excited. In the strongly interacting limit, even more drastic modifications of the system’s properties can arise, such as the appearance of exotic phases or excitation modes not describable by effective single-particle models. On the other hand, interactions can lead to inelastic processes that cause population loss from a trap and limit the accessible range of, e.g., temperature and density.

Quantum gases are typically dilute (compared to liquids and solids) and this allows their short-range interaction at low temperature to be accounted for in a simple fashion by a two-body (isotropic) contact pseudopotential [10, 11]. To go beyond the case of isotropic and short-range interactions—say using an ultracold system possessing strong dipolar interactions— gives access to a wide variety of new physical phenomena [11–18]. This review focuses on the experimental achievements of the last fifteen years to study such physics using one particular example of a dipolar system, viz., ultracold quantum gases made of atoms possessing a large magnetic dipole moment.

# A. Quantum gases with dipolar interactions

Several platforms exist with which to study the effect of dipole-dipole interactions (DDIs) in the ultracold gas context. For example, electric dipole moments may be induced using heteronuclear molecules [19–21] or Rydberg atoms [22–25] in an electric field or through the use of light-induced dipoles [17]. We note that long-range interactions, beyond the dipolar $1 / r ^ { 3 }$ scaling, can also be achieved in ultracold gas systems in other ways. For example, one method uses optical cavity or waveguidemediated interactions, which are fixed to be either global in range [26, 27] or may be tuned between long and short range [28–30]. Phonon-mediated interactions in trapped ion systems are another example of tunable-range interactions [31]. These systems often exhibit dipole strengths orders of magnitude larger than what is achievable with magnetic dipoles. However, other limitations can arise in these systems, e.g., short lifetimes, density limitations, and/or rapid dissipation. We briefly discuss the case of electric dipolar systems before exclusively focusing on magnetic systems.

# 1. Electric dipoles

There is no permanent electric dipole in an atom or in a molecule in its non-degenerate rotational ground state due to their rotational symmetry. Yet when an external electric field $E$ couples to the electric dipole moment operator, it mixes eigenstates of opposite parity. As the rotational symmetry is broken, an electric dipole moment is induced. The field to induce the electric dipole moment is lowest when the two states of opposite parity are closest in energy.

Some systems possess degenerate states of opposite parity, which allows the induced electric moment to arise at vanishingly small electric field [32]. Rydberg states in a hydrogen atom are an example of such a system: they possess electronically excited states of opposite parity that can be arbitrarily close. The electric dipole moment scales as $n ^ { 2 }$ , with $n$ the principal quantum number. Associating a Rydberg atom with a ground-state atom allows to form a Rydberg molecule with a permanent electric dipole moment [33]. Despite short lifetimes due to spontaneous emission, black-body radiation [34], and collisions, Rydberg gases have, over the last 10 years, been the centre of much experimental and theoretical activity. In particular, experiments are ongoing that investigate strongly correlated dipolar gases, lattice spin models, and Rydberg molecules [22, 23, 25, 35–39]. They are even the basis for a competitive quantum computing platform, which has been pushed forward by several newly founded companies (https://pasqal.io/, https://coldquanta.com/, https://www.quera.com/, https://www.atom-computing.com/).

A second, very productive field of research is the manipulation of heteronuclear molecules. In these, an electric field mixes two rotational states (for example $N = 0$ and $N \ = \ 1$ ) within the electronic molecular ground state. Ultracold molecular systems with a large electric dipole moment include: KRb [40–43], NaK [44– 46], RbCs [47, 48], NaRb [49], KCs [50], LiCs [51], NaLi [52, 53], SrF [54, 55], H2CO [56], CaF [57, 58], BaF [59]and YO [60, 61], HO [62, 63]. Due to their intrinsic complexity, cooling molecules has been an extremely challenging task. Recently, after many years of dedicated efforts [41, 44], the first quantum degenerate gas of polar molecules has been achieved with KRb [42, 43]. Many of the molecular systems have been shown to experience strong and rapid losses, which unfortunately presents an additional challenge for creating dense and ultracold samples. For the case of KRb, it is believed that the exo-energetic reaction KRb $+ \textrm { K R b } -$ K2+ Rb $^ 2$ drives the decay [64]. For other molecular systems such as NaK and NaRb, for which the equivalent reactions are endo-energetic, the lifetime also appears rather short at large densities for reasons that are yet to be fully understood [65]. The impact of losses could be reduced thanks to an ingenious control of their spatial dependence: Confining molecules in a quasi-two dimensional geometry enables one to take control off the stereodynamics of molecular reactions [66]. Producing molecules in three-dimensional optical lattices [41, 67] or optical tweezers [68, 69] prevents molecules from inelastically colliding due to their physical separation. Ultracold molecules now constitute a fast-expanding and promising field, especially for quantum simulation [20, 21].

# 2. Magnetic dipoles

In contrast to the situation with electric dipoles, elementary particles can have permanent magnetic dipoles even at zero field [70]. As a consequence, the effect of magnetic DDIs on quantum gases can be studied under full rotational symmetry at arbitrarily small magnetic fields. The magnetic dipole moment in atoms is primarily associated with the spin ( $\hat { S }$ ) and orbital ( $\hat { L }$ ) angular momentum of the electrons. The nucleus may also have a magnetic dipole moment, although it is three orders of magnitude smaller than the electron’s. Nevertheless, the nuclear spin ( $\hat { I }$ ) couples to the electronic spin within the atom, giving rise to the hyperfine structure ( $\hat { \pmb { F } } = \hat { \pmb { L } } + \hat { \pmb { S } } + \hat { \pmb { I } }$ ). Therefore, the sensitivity of a given Zeeman sublevel to magnetic fields indirectly depends on the nuclear spin. Only the fully stretched atomic state (i.e., maximal $\boldsymbol { F } = \boldsymbol { L } + \boldsymbol { S } + \boldsymbol { I }$ and $| m _ { F } | = F$ ) reaches the full magnetic moment provided by the electrons. Here, and all along this review, $X$ and $m _ { X }$ are the quantum numbers associated with the norm of the angular momentum operator $\hat { X }$ and its projection along the quantization axis, respectively. Additionally, we use the dimensionless version of the vectors and operators of angular momenta and spins such that the eigenvalues associated to the norm and projection of $\hat { X }$ are simply $\sqrt { X ( X - 1 ) }$ and $m _ { X }$ . In the above, $X = \{ F , L , S , I \}$ . Throughout the remainder of this review, we will usually denote by $\hat { S }$ the total angular momentum of a magnetic particle.

It is possible to study dipolar physics with alkali atoms [71]. However, the energy scale associated with DDIs is rather small, typically in the Hz range. Therefore, significant focus has been on so-called highly magnetic atoms, such as chromium (Cr; with a dipole moment of 6 Bohr magnetons, $\mu _ { B }$ ), erbium ( $\mathrm { E r }$ ; $7 \mu _ { B }$ ) and dysprosium (Dy; $1 0 \mu _ { B }$ ). In principle, other highly magnetic atoms can be studied, such as holmium (Ho; $9 \mu _ { B }$ ), thulium (Tm; $4 \mu _ { B }$ ) or europium (Eu; $9 \mu _ { B }$ ) [72– 75]. Moreover, it was demonstrated that one can use a Feshbach resonance to combine two $\mathrm { E r }$ atoms into a loosely bound molecule [76], which may possess up to twice the magnetic moment of the original atoms. Likewise, a nearly $2 0 \mu _ { B }$ -large magnetic moment is accessible with Dy $^ 2$ molecules [77]. These systems are described in detail in Sec. II.

# B. The dipole-dipole interaction

Generally speaking, the DDI between two dipoles, 1 and 2, separated by $\mathbfit { r }$ yields the following potential:

$$
V _ { \mathrm { d d } } ( \pmb { r } ) = \frac { \gamma _ { \mathrm { d } } } { 4 \pi r ^ { 3 } } \left[ \pmb { d _ { 1 } } \cdot \pmb { d _ { 2 } } - 3 \frac { \left( \pmb { d _ { 1 } } \cdot \pmb { r } \right) \left( \pmb { d _ { 2 } } \cdot \pmb { r } \right) } { r ^ { 2 } } \right] ,
$$

where $d _ { i }$ is the dipole moment of particles $i = \left\lfloor 1 , 2 \right\rfloor$ and $\gamma _ { \mathrm { d } }$ is the dipolar coupling constant and depends on the electric or magnetic nature of the dipoles. This expression is valid at long distances, where electron orbitals do not overlap.

• Magnetic dipoles: Classically, the dipolar interaction between two magnetic particles corresponds to the interaction of the spin $S _ { 1 }$ of the particle 1 with the magnetic field created by the spin $S _ { 2 }$ of the particle 2, and vice-versa. Here, $\hat { S }$ is a generic angular momentum which in general is given by the total angular momentum $\pmb { F }$ , see $\mathrm { 1 A 2 }$ . For a magnetic particle of spin $\hat { S } _ { i }$ , the dipole moment is given by $\hat { d } _ { i } = g _ { S } \mu _ { \mathrm { B } } \hat { S } _ { i }$ , where $g _ { S }$ is the $g$ -factor of the spin $S$ and the dipolar coupling constant $\gamma _ { \mathrm { d } } = \mu _ { 0 }$ is the vacuum magnetic permeability. We denote d2 = µ0(gS µB)2 and $C _ { \mathrm { d d } } = S ^ { 2 } d ^ { 2 }$ so that Vdd(r) ∝ S2d23 r 3 , see, e.g., Sec. I C 3. These constants set the DDI strength.

• Electric dipoles: For electric dipoles, $\gamma _ { \mathrm { d } } = 1 / \epsilon _ { 0 }$ , with $\epsilon _ { \mathrm { 0 } }$ the vacuum electric permittivity.

We now compare the magnetic and electric DDI strengths. Electric dipoles relate to charge displacement within a particle. Typical electric dipoles of molecules are of magnitude $e a _ { 0 }$ , given by the displacement of an elementary electric charge $e$ over the typical size of an atom, set by the Bohr radius $a _ { 0 }$ . In Rydberg atoms, the characteristic displacement of the electric charge is set by the Rydberg orbital radius, which scales as $n ^ { 2 }$ , the square of the Rydberg principal quantum number $n$ ; typically $n$ is of order a few tens. The dipole moment of a Rydberg atom is thus typically $n ^ { 2 }$ times than that of an atom in the ground state. The atomic magnetic dipole scale is given by $\mu _ { \mathrm { B } }$ . The typical ratio between the DDI strength of magnetic atoms and of polar molecules is therefore µ0µ B(ea0)2/ǫ0 $\begin{array} { r } { \frac { \mu _ { 0 } \mu _ { B } ^ { 2 } } { ( e a _ { 0 } ) ^ { 2 } / \epsilon _ { 0 } } = \alpha ^ { 2 } / 4 } \end{array}$ , where $\alpha \approx 1 / 1 3 7$ is the fine structure constant. The ratio is further reduced by a factor $n ^ { 4 }$ when comparing to Rydberg atoms. Thus, the typical magnetic DDI strength is orders of magnitude smaller than the typical electric DDI.

# C. Main characteristics of dipolar interactions

In the absence of DDIs, ground state atoms interact through van der Waals interactions. These interactions are short ranged, $1 / r ^ { 6 }$ , and are typically isotropic because the electronic cloud of most atoms is spherically symmetric in the ground state [78]. In contrast, the DDI introduced in Eq. (1) has a long-range $1 / r ^ { 3 }$ character. It is also anisotropic and can be either attractive or repulsive depending on the relative orientation of the dipoles; in particular, its elastic part varies as $1 - 3 \cos ^ { 2 } \theta$ , where $\theta$ is the angle between the relative position of the particles and their direction of polarisation.

# 1. Definition of ‘long-range’

Whether an interaction, in particular the DDI, is long range depends on the exact system under study, its dimensionality, and on the exact physical question addressed. We discuss below a number of physical questions that lead to slightly different definitions of the long-range character of the interaction at hand, with particular focus on power law potentials $U ( r ) \propto 1 / r ^ { n }$ .

• Collisional point of view (in 3D). Physically, for short-range interactions, particles need to approach at small distances to interact. By decomposing the relative motion of the particles into the relative orbital angular momentum eigenstates (so-called partial waves), denoted by the quantum numbers $( l , m )$ for the momentum’s norm and projection eigenvalues, one finds that at low collision energy, the centrifugal barrier $\textstyle { \frac { 2 l ( l + 1 ) \hbar ^ { 2 } } { m r ^ { 2 } } }$ prevents particles from approaching in higher partial waves ${ \mathit { l } } > 0$ . That is, the contributions from high partial waves vanish. For a $1 / r ^ { n }$ interacting potential, the scattering phase shift $\delta _ { l } ( k )$ at low collision momentum $k$ scales as $k ^ { 2 l + 1 }$ if $l < ( n - 3 ) / 2$ and as $k ^ { n - 2 }$ otherwise [79, 80]. Therefore, for $n \geq 4$ , the interaction is purely $s$ -wave at low energy and short ranged. In contrast, for $n = 3$ , $\delta _ { l } ( k ) \propto k$ for all partial waves. Therefore, all partial waves contribute to the scattering process even at low collision energy. The interaction is then long range and can be felt beyond the centrifugal barrier. The long-range character of the DDI is spectacularly manifest in the fact that polarised fermionic dipolar gases thermalize despite the absence of $s$ -wave interactions (due to the Pauli exclusion principle). This is in contrast to nondipolar polarised Fermi gases; see Sec. III.

Note: A thorough treatment of the above should account for the fact that the DDI is not a pure central potential $U ( r ) \propto 1 / r ^ { 3 }$ due to its anisotropic character. This is of particular consequence for inelastic dipolar collisions, which necessarily involve the anisotropic character of the interaction—see Sec. I C 2—and are actually short-range processes at large magnetic field despite the same $1 / r ^ { 3 }$ scaling as their elastic counterparts. See Sec. III C 3.

We also remark that the scattering picture can be modified in the presence of strong confinement, in particular in reduced dimensions; see, e.g., Sec. VII A.

• Thermodynamic point of view. Short-range interactions lead to an energy that is thermodynamically extensive. This is true when $\int _ { 0 } ^ { \infty } U ( r ) d ^ { D } r$ converges, which only happens when $n > D$ , where $D$ is the spatial dimension. Thus, from this point of view, $1 / r ^ { 3 }$ interactions are long range in 3D, but short range in 2D and 1D. Long-range-interacting systems possess peculiar thermodynamic properties, such as the non-equivalence of thermodynamic ensembles, the possibility for negative specific heat, and the spontaneous formation of structures. These arise because the hypothesis that the energy is additive in the thermodynamic limit— i.e., given the energy of two subsystems $A$ and $B$ , $E ( A \cup B ) = E ( A ) + E ( B )$ —breaks down when the interaction between the subsystems cannot be neglected [81]. The status of DDIs in 3D is therefore marginal since while there are distant couplings between sub-systems $A$ and $B$ , the integral $\int ^ { \infty } U ( \pmb { r } ) d ^ { 3 } \pmb { r }$ does converge due to the peculiar $d -$ wave shape of DDIs.

• Many-body physics perspective. In the context of many-body physics, DDIs may lead to qualitatively new behaviour, even when $D < 3$ . For example, the Mermin-Wagner theorem precludes the possibility of spontaneous breaking of a continuous symmetry and of long-range order in (homogeneous) low-D systems. However, in 2D, this applies only for short-range interacting systems with $n > 4$ [18, 82]. Therefore, in this context, DDIs can be seen as long-ranged even in 2D. Indeed, it has been predicted that ferromagnetic ordering should be stable in 2D for DDIs [83]. The meaning of long range in 1D for the DDI will be addressed in Sec. VII A.

• Mathematical physics perspective. Let us for completeness also briefly mention the mathematical physics point of view of the meaning of "long-range interaction." For an interaction potential ${ \sim } 1 / r ^ { n }$ , the scattering wave is only described by an asymptotic outgoing spherical wave weighted by an angledependent scattering amplitude for $n \ > \ 1$ . For $n \leq 1$ , e.g., the Coulomb potential, there are logarithmic corrections to the general form of the outgoing spherical wave, which defines another border between long and short-range potentials.

# 2. Consequences of anisotropy

The anisotropic character of the DDI greatly impacts the properties of dipolar gases. It introduces profound differences from the point of view of two-body physics and scattering properties—see Sec. III—and also on the collective many-body properties of quantum degenerate dipolar gases. In particular, the stability diagram of dipolar condensates is affected by an interplay between the anisotropy of the trap and the anisotropy of the interactions; this will be described in Secs. IV and V. We now briefly describe a few basic consequences of this anisotropy.

The DDI is attractive in one direction and repulsive in the other two directions. The shape of the interaction follows a $d$ -wave form mathematically described by the $j$ components of the spherical harmonics $Y _ { 2 } ^ { j }$ , in particular with $j = 0$ in a fully polarized situation. This means that when integrated over all space in 3D, the DDI between polarised dipoles converges to zero for a 3D homogeneous gas. Consequently, the mean-field physics of dipolar gases is dominated by border and boundary effects: the average interaction between particles will strongly depend on the shape of the cloud. In particular, an elongated trap along the axis of the dipoles will favour the collapse of the gas due to the predominately attractive interaction. The stability of dipolar condensates as a function of geometry is described in Sec. IV.

Another consequence of anisotropy is the existence of a special angle between the dipoles and the interatomic axis, $\theta _ { m } = \operatorname { a r c c o s } \sqrt { 1 / 3 } \approx 5 4 . 7 4 ^ { \circ }$ , at which DDIs vanish. More generally, controlling this angle can be used to tune the strength of DDIs, especially when performing experiments in reduced dimensions, as described in Sec. VII A. In a scheme inspired from NMR techniques, it has been suggested [84] and demonstrated [85] that by using timevarying magnetic fields, it is possible to time-average the DDI to reduce its amplitude or reverse its sign.

Finally, the anisotropy of the interaction has fundamental consequences from the point of view of collisions. The interaction potential is not central, and therefore the orbital angular momentum does not need to be conserved during a collision. The expansion in spherical harmonics yields the selection rule for angular momentum transitions $\Delta l = ( 0 , \pm 2 )$ . Moreover, partial waves of differing $\it l$ that contribute to the scattering become coupled. Finally, the angular momentum of the atoms’ internal state may also change during the collisions, opening the possibility for inelastic processes.

# 3. Physical processes associated with dipolar interactions

In view of describing the physical processes at play when two dipolar particles collide, it is useful to rewrite the dipolar potential between atoms 1 and 2 in terms of quantum operators [86]:

$$
\begin{array} { r l r } & { } & { V _ { \mathrm { d d } } ( \pmb { r } ) = \frac { d ^ { 2 } } { r ^ { 3 } } \bigg [ ( S _ { 1 } ^ { z } . S _ { 2 } ^ { z } + \frac { 1 } { 2 } \left( S _ { 1 } ^ { + } . S _ { 2 } ^ { - } + S _ { 1 } ^ { - } . S _ { 2 } ^ { + } \right) } \\ & { } & { ~ - \frac { 3 } { 4 } \left( 2 z S _ { 1 } ^ { z } + r ^ { - } S _ { 1 } ^ { + } + r ^ { + } S _ { 1 } ^ { - } \right) \times } \\ & { } & { \left( 2 z S _ { 2 } ^ { z } + r ^ { - } S _ { 2 } ^ { + } + r ^ { + } S _ { 2 } ^ { - } \right) \bigg ] , } \end{array}
$$

where $( x , y , z )$ is the normalised unit vector connecting both atoms, $r ^ { + } = ( x + i y )$ , $r ^ { - } = ( x - i y )$ , $S ^ { + } = \left( S ^ { x } + \right.$ $i S ^ { y }$ ), and $S ^ { - } = ( S ^ { x } - i S ^ { y } )$ . Note that both here and throughout this review, we use the dimensionless version of the vectors and operators of angular momenta and spins.

We describe three physical processes that arise from this expression:

i. Elastic dipole-dipole interactions, where the spin of each atom is conserved in time:

$$
V _ { \mathrm { { d d } } } ^ { \mathrm { { e l } } } ( \pmb { r } ) = \frac { d ^ { 2 } } { r ^ { 3 } } S _ { 1 } ^ { z } . S _ { 2 } ^ { z } \left( 1 - 3 z ^ { 2 } \right) .
$$

The experimental manifestation of this anisotropic Ising term on quantum degenerate dipolar gases has been extensively studied. It is the main process at play for most of the results presented in this review article: see Sec. III on scattering physics, Secs. IV and V on the collective properties of dipolar gases, the stability diagram, the instability dynamics and the stabilisation of so-called dipolar droplets, Sec. VII A on integrability breaking in 1D gases, and Sec. VII B on the extended BoseHubbard model.

ii. Exchange interactions, where two atoms exchange one unit of spin (Zeeman) excitation, while the total magnetisation and energy is conserved (in the absence of quadratic Zeeman effects):

$$
V _ { \mathrm { d d } } ^ { \mathrm { e x } } ( r ) = - \frac { 1 } { 4 } \frac { d ^ { 2 } } { r ^ { 3 } } \left( S _ { 1 } ^ { + } . S _ { 2 } ^ { - } + S _ { 1 } ^ { - } . S _ { 2 } ^ { + } \right) \left( 1 - 3 z ^ { 2 } \right) .
$$

This exchange term can drive spin dynamics at constant magnetisation as described in Sec. VI B 3 and dictates the physics of spinor dipolar gases in deep lattices, which is the topic of Sec. VII C. We note that the elastic and the exchange terms result in an anisotropic Heisenberg-like term (the so-called XXZ model).

iii. Relaxation terms describe the modification of the longitudinal magnetisation of the pair of atoms during the collision. There are two possible processes:

$$
\begin{array} { r l } & { V _ { \mathrm { { d d } } } ^ { \mathrm { { r e l } _ { 1 } } } ( \pmb { r } ) = - \displaystyle \frac { 3 } { 4 } \frac { d ^ { 2 } } { r ^ { 3 } } ( r ^ { + } ) ^ { 2 } S _ { 1 } ^ { - } . S _ { 2 } ^ { - } , } \\ & { V _ { \mathrm { { d d } } } ^ { \mathrm { { r e l } _ { 2 } } } ( \pmb { r } ) = - \displaystyle \frac { 3 } { 2 } \frac { d ^ { 2 } } { r ^ { 3 } } z r ^ { + } ( S _ { 1 } ^ { z } . S _ { 2 } ^ { - } + S _ { 2 } ^ { z } . S _ { 1 } ^ { - } ) , } \end{array}
$$

plus the conjugate processes. Spin momentum and angular orbital momentum exchange while the magnetic energy is transferred into kinetic energy. The second process describes single spin flips, while the first describes double spin flips (i.e., both atoms flipping their spin). These terms underlie most of the results presented in Secs. III C and VI, the latter describing spinor physics with free magnetisation.

# 4. Two-body dipolar scattering

The cross section classically describes the area, transverse to the relative motion, within which two particles must meet to scatter. In other words, the scattering cross section is related to the typical distance at which the wavefunction of the relative motion is distorted by the interaction. Employing the Heisenberg uncertainty principle, this distance $r _ { \mathrm { d } }$ for the DDI is typically set by an interplay between the DDI strength $S ^ { 2 } d ^ { 2 } / r _ { \mathrm { d } } ^ { 3 }$ and the energy cost to bend the wave function by an amount $r _ { \mathrm { d } }$ . Setting $S ^ { 2 } d ^ { 2 } / r _ { \mathrm { d } } ^ { 3 } = \hbar ^ { 2 } / m r _ { \mathrm { d } } ^ { 2 }$ defines the dipolar length [87]:

both dipolar and van der Waals interactions. The DDI cross sections are presented based on a first-order Born approximation, and the role of exchange statistics in these expressions is discussed.

In contrast to the van der Waals case, the dipolar cross section depends on only the mass of the atoms and their dipole moment. Because it is independent of the details of the molecular potentials, dipolar scattering assumes a universal character. One remarkable aspect is that the dipolar cross section follows the same universal scaling of Eq. (7) (up to numerical factors) regardless of particle exchange statistics. In particular, identical fermions have a finite dipolar cross section even at vanishingly small collision energy. This is a direct consequence of the longrange character of DDI, as discussed above. This topic will be discussed in Sec. III B. Inelastic dipolar scattering will be discussed in Sec. III C.

Finally, by integrating over all directions of the collision, the scattering theory outlined above obscures one of the central features of dipolar scattering, the anisotropic dependence on the colliding angle, which has been observed in both Er and Dy. This is the topic of Sec. III D.

# 5. Momentum-space DDI expression

The form of the Fourier transform of the interaction potential often provides insight regarding the physics of interacting particles. For example, it facilitates the description of two-body scattering physics because scattering theory tends to formulate the wavefunction in terms of momentum states. It also proves convenient in discussing elementary excitations of a quantum gas, which, in a uniform system, are characterised by a well-defined momentum.

The Fourier transform of the elastic part of the DDI, Eq. (3), is

$$
\widetilde { V _ { \mathrm { d d } } } ( k ) = \int e ^ { i k r } V _ { \mathrm { d d } } ^ { \mathrm { e l } } ( r ) d ^ { 3 } r = \frac { C _ { \mathrm { d d } } } { 3 } \left[ 3 \cos ( \theta _ { k } ) ^ { 2 } - 1 \right] ,
$$

$$
a _ { \mathrm { d d } } \equiv \frac { r _ { \mathrm { d } } } { 3 } = \frac { S ^ { 2 } d ^ { 2 } m } { 3 \hbar ^ { 2 } } = \frac { C _ { \mathrm { d d } } m } { 3 \hbar ^ { 2 } } ,
$$

where $m$ is the atomic mass. The order of magnitude of the scattering cross section is

where $\theta _ { k }$ is the angle between $\boldsymbol { k }$ and the polarisation of the dipoles. This form of the interaction is remarkable when compared to the contact interaction. While neither the Fourier transforms of the contact interaction nor the DDI depend on $k$ , the Fourier transform of the DDI retains a nontrivial angular dependence. Such a feature can give rise to an anisotropic dispersion relation of excitations, as described in Sec. IV.

$$
\sigma \approx r _ { \mathrm { { d } } } ^ { 2 } = { \frac { S ^ { 4 } d ^ { 4 } m ^ { 2 } } { \hbar ^ { 4 } } } .
$$

Likewise, one defines the range of the van der Waals potential $ { V _ { \mathrm { V d W } } } = -  { C _ { 6 } } / r ^ { 6 }$ as $r _ { \mathrm { v d W } } = ( m C _ { 6 } / \hbar ^ { 2 } ) ^ { 1 / 4 }$ , which sets the typical scattering cross section due to short-range interactions. The lengths $r _ { V d W }$ and $a _ { \mathrm { d d } }$ are typically in the nm range; i.e., much larger than both the Bohr radius $a _ { 0 }$ and the typical impact parameter at room temperature.

In Sec. III, we will describe the scattering theory for

That $\widetilde { V _ { \mathrm { d d } } } ( k )$ does not depend on the modulus of $\boldsymbol { k }$ can be understood from dimensional analysis: $\begin{array} { r } { \int d ^ { D } r \exp ( i k r ) \frac { 1 } { r ^ { 3 } } } \end{array}$ is independent of $k$ for $\textit { D } = \ 3$ . On the other hand, in a 2D system ( $D = 2$ ), we expect a different behaviour with a linear dependence on $k$ for small $k$ . Quite generally, the fact that the Fourier transform of $V _ { \mathrm { d d } }$ has a $\boldsymbol { k }$ dependence is an important feature for $\boldsymbol { D } \neq 3$ systems, in that the DDI introduces a tendency in these systems to develop structured excitations (rotons, solitons) and exotic phases (supersolid, crystals of quantum droplets, etc.). These excitations are described in Sec. IV. The quantum droplets occur when the gas spontaneously forms stable spatial arrangements of liquid-like droplets in dipolar Bose–Einstein condensates (dBECs) driven to the instability point of mechanical collapse. This is related to the emergence of new phases stabilised by beyond-mean-field effects and is described in Sec. V; see also Sec. I D 1.

# D. Many-body dipolar physics

The two-body processes outlined in the previous paragraphs are the elementary phenomena behind the very rich phenomenology associated with many-body physics in dipolar quantum gases. We introduce the various physical effects that will be further discussed in the Secs. IV– VII.

# 1. Dipolar Bose quantum gases

# a. Spin-polarised dipolar Bose quantum gases in the mean-field regime

Many-body physics is often intractable. However, most of the first experiments on ultracold gases of magnetic atoms have been performed with weakly interacting Bose–Einstein condensates (BECs), and the associated theory is tractable because interatomic correlations are small and so mean-field theories apply.

Due to Bose stimulation, in which the population of bosonic atoms at low energy favours the occupation of a unique single-particle orbital, it is natural to propose a variational ansatz where the many-body wavefunction is assumed to be $\begin{array} { r } { \phi ( \boldsymbol { r } _ { 1 } , . . . \boldsymbol { r } _ { N } ; t ) = \prod _ { i = 1 , . . . , N } \psi ( \boldsymbol { r } _ { i } , t ) } \end{array}$ . The single-particle wave-function $\psi ( r , t )$ is taken as a variational parameter to minimise the system’s total energy. This approach leads to the well-known Gross–Pitaevskii equation (GPE), which has been found to describe most of the properties of dilute BECs [11, 88–90].

When all atoms are polarised (and the polarisation axis set to $z$ ), the GPE of a dBEC is

$$
i \hbar { \frac { \partial } { \partial t } } \psi = \left[ { \frac { - \hbar ^ { 2 } \nabla ^ { 2 } } { 2 m } } + V _ { \mathrm { t r } } ( r ) + g \left| \psi \right| ^ { 2 } + \Phi _ { \mathrm { d d } } ( r , t ) \right] \psi , ( 9 )
$$

where Vtr(r) is the trap potential, g = 4π\~2m a is the coupling constant describing contact interactions of $s$ -wave scattering length $a$ ; see also Secs. II D and III [9, 91]. The mean field associated with the DDI is $\Phi _ { \mathrm { d d } } ( \boldsymbol { r } , t )$ [92, 93]:

$$
\begin{array} { l } { \displaystyle \Phi _ { \mathrm { d d } } ( \boldsymbol { r } , t ) = \int d \boldsymbol { r ^ { \prime } } \left| \psi ( \boldsymbol { r ^ { \prime } } , t ) \right| ^ { 2 } U _ { \mathrm { d d } } ( \boldsymbol { r } - \boldsymbol { r ^ { \prime } } ) , } \\ { \displaystyle U _ { \mathrm { d d } } ( \boldsymbol { r } ) = C _ { \mathrm { d d } } \frac { 1 - 3 \cos ^ { 2 } ( \theta ) } { \left| \boldsymbol { r } \right| ^ { 3 } } , } \end{array}
$$

where $\theta$ is the angle between $\mathbf { \nabla } ^ { \prime }$ and the polarisation axis $z$ . Only the elastic part of the DDI, Eq. (3), contributes due to polarisation in a fully stretched Zeeman substate. This term is non-linear and nonlocal. To quantify the strength of the DDI with respect to the contact interactions within a BEC, it is useful to introduce the dimensionless parameter

$$
\varepsilon _ { \mathrm { d d } } = \frac { C _ { \mathrm { d d } } m } { 3 \hbar ^ { 2 } a } = \frac { a _ { \mathrm { d d } } } { a } .
$$

We note that writing the GPE of a dipolar BEC in the form of Eq. (9) is in fact non-trivial. Its validity, which relies on describing the total inter-particle interactions via an effective pseudo-potential that is the simple sum of the contact pseudo-potential and the DDI potential, has been long debated. The efforts to prove the validity of this treatment as well as identify its limitation will be reviewed in Sec. $\mathrm { ~ I V ~ A ~ 1 ~ }$ . The applicability of the nonlocal GPE Eq. (9) for the case of weakly interacting trapped BECs of magnetic atoms in the stable regime, $\mathrm { e . g . , } \varepsilon _ { \mathrm { d d } } ~ < ~ 1$ in a 3D isotropic trap, has been supported by numerous theory and experimental works. In this regime, the anisotropic and nonlocal character of Eq. (10) substantially modifies the static and dynamical properties of the BEC compared to contact-only BECs. This will be extensively discussed in Sec. IV.

# $b$ . Spinor dipolar Bose quantum gases

In the presence of spin degrees of freedom, the exact form of the GPE depends on the spin of the atoms and can be found in Ref. [94]. Taking, for example, the case of a spin-1 atom – i.e. the simplest example pertaining to bosonic physics – the GPE takes the form

$$
\begin{array} { r l } { i \hbar \displaystyle \frac { d \psi _ { m } } { d t } = \biggl [ \displaystyle \frac { - \hbar ^ { 2 } \nabla ^ { 2 } } { 2 m } + V _ { \mathrm { t r } } ( r ) - p m + q m ^ { 2 } \biggr ] \psi _ { m } } & { } \\ { + c _ { 0 } n \psi _ { m } + c _ { 1 } \displaystyle \sum _ { m ^ { \prime } = - 1 } ^ { 1 } { S . s _ { m , m ^ { \prime } } \psi _ { m ^ { \prime } } } } & { } \\ { + C _ { \mathrm { d d } } \displaystyle \sum _ { m ^ { \prime } = - 1 } ^ { 1 } { \bf b } . s _ { m , m ^ { \prime } } \psi _ { m ^ { \prime } } , } \end{array}
$$

where $\psi _ { m }$ denotes the macroscopic wave function associated with the spin state of projection quantum number $m$ . The terms in $p$ and $q$ describe the linear and quadratic Zeeman energy shifts of the spin states, respectively. The trap is assumed to be spin-independent. The terms proportional to $c _ { 0 }$ and $c _ { 1 }$ are spin-independent and spindependent contact interactions, respectively. The spin density vector is $S$ , and $\pmb { \mathscr { s } } = \{ \mathscr { s } ^ { x } , \mathscr { s } ^ { y } , \mathscr { s } ^ { z } \}$ are the spin matrices. The DDIs are described by the term proportional to $C _ { \mathrm { d d } }$ , where the effective dipole field $\mathbf { b }$ is defined by

$$
b _ { \nu } = \int d \boldsymbol { r } ^ { \prime } \sum _ { \nu ^ { \prime } } Q _ { \nu , \nu ^ { \prime } } ( \boldsymbol { r } - \boldsymbol { r } ^ { \prime } ) S ^ { \nu ^ { \prime } } ( \boldsymbol { r } ^ { \prime } ) ,
$$

with

$$
Q _ { \nu , \nu ^ { \prime } } ( r ) = \frac { \delta _ { \nu , \nu ^ { \prime } } - 3 r _ { \nu } r _ { \nu ^ { \prime } } } { r ^ { 3 } } ,
$$

and $\nu , \nu ^ { \prime } = \{ x , y , z \}$ .

Equation (13) is central to the description of spinor dipolar physics, which is the subject of Sec. VI. In general, the DDIs cannot be neglected when $C _ { \mathrm { d d } }$ is comparable to either $c _ { 0 }$ or $c _ { 1 }$ . If $c _ { 1 } \ll c _ { 0 }$ , then the DDIs can be significant even when $\varepsilon _ { \mathrm { d d } } ~ \ll ~ 1$ [95]. Furthermore, magnetisation-changing processes effected by the term in Eq. (14) have no analogue in systems with only spherically-symmetric contact interactions. Such processes start to play a role when $C _ { \mathrm { d d } } n \simeq \{ p , q \}$ .

Finally, it is useful to stress that in the mean-field regime, DDIs described by Eqs. (10) and (14) correspond to the average magnetic field produced by all atoms within the condensate. This is due to the fact that correlations between atoms have been neglected, which is the essence of the mean-field approximation. In the case of spinor gases, the effect of quantum fluctuations and correlations can, however, be significant, even in the weakly interacting regime. This is due to entanglement or squeezing naturally arising in the spin degrees of freedom. The consequences of DDIs on the properties and behaviours of gases with spin degrees of freedom will be detailed in Sec. VI.

# c. Elementary excitations of a spin-polarised dipolar Bose quantum gas

The elementary excitations of a BEC are usually well described within a Bogoliubov treatment, which matches a linearisation of the GPE around the ground-state wavefunction [11, 88]. The theory yields a simple dispersion relation for a uniform 3D gas ( $V _ { \mathrm { t r } } = 0$ ):

$$
\epsilon ( k ) = \sqrt { \frac { \hbar ^ { 2 } k ^ { 2 } } { 2 m } \left( \frac { \hbar ^ { 2 } k ^ { 2 } } { 2 m } + 2 n \widetilde { V _ { \mathrm { i n t } } } ( k ) \right) } .
$$

This describes the energy of the elementary excitation of momentum $\boldsymbol { k }$ in a BEC of density $n$ . Here, $\widetilde { V _ { \mathrm { i n t } } } ( k )$ is the Fourier transform of the total interaction potential. In contact-interacting gases, $\widetilde { V _ { \mathrm { i n t } } } ( k ) = g$ . For a dBEC, $\widetilde { V _ { \mathrm { i n t } } } ( \pmb { k } ) = g + \widetilde { V _ { \mathrm { d d } } } ( \pmb { k } )$ . From the form of $\tilde { V _ { \mathrm { d d } } } ( k )$ (see Eq. 8), one can infer that the energy of a collective excitation of a dipolar fluid depends not only on the magnitude of its wavevector but also on its propagation direction. The dispersion relation of elementary excitations of an isotropic, homogeneous dipolar fluid is anisotropic. For a dBEC, the dispersion retains the initial linear phonon character, but with an anisotropic speed of sound $c$ ; the dispersion relation remains monotonic.

This picture is modified in a constrained geometry, where one externally lifts the spatial symmetry along at least one dimension by, e.g., imposing anisotropic trapping confinement [96]. The trap along the constrained dimension yields a new length scale. Because of the anisotropy and long-range character of the DDI, this length scale also becomes relevant to the description of the physics of the otherwise translationally invariant directions. In particular, it affects their elementary excitations.That is, a BEC that is more tightly trapped along the dipoles’ direction than transversely possesses a favoured wavelength in its dispersion relation at which the energy of the transverse excitations reaches a minimum [96–100]. This is referred to as a roton minimum in analogy to a similar minimum found in the dispersion relation of liquid helium [101–103]. These properties of dBECs are the topic of Sec. IV A 3.

# $d$ . Mean-field instability and collapse

At the mean-field level, the mechanical stability of fluids may be understood from analysing the dispersion relation of their excitations [11]. An instability occurs when the energy of an elementary excitation becomes zero, since then there is no cost for populating such a mode. In the 3D homogeneous case, the lowest energy modes are the long-wavelength phonons. Furthermore, due to the DDI anisotropy, phonons propagating in the plane perpendicular to the dipoles cost the least amount of energy. The speed of sound $c$ reaches 0 at $\varepsilon _ { \mathrm { d d } } = 1$ in this direction, which identifies the threshold for mechanical collapse of a 3D homogeneous dipolar BEC. This is remarkable, because the instability, arising from the attractive part of the DDI, occurs in a gas with a finite (and positive) value of the short-range contact interaction. Consequently, interactions are still present, even if cancelling at the mean field, and their beyond-mean-field contribution plays a crucial role in such a system; see Secs. IV A 4 and V A. This collapse, corresponding to a phonon instability, is called “global collapse,” [11, 93, 97, 104–107]. Generally speaking, in an ultracold quantum Bose gas, crossing the instability threshold leads to an implosion of the gas under the concomitant effects of two-body attraction and three-body inelastic collisions; these so-called Bose-Novas are well described by mean-field coherent dynamics [104, 105, 108–112]. In a dipolar quantum Bose gas, at the mean-field level, the anisotropy of the DDI is expected to impact the geometry of the collapse and its dynamics.

Furthermore, anisotropic external trapping modifies the dispersion relation, yielding additional modifications of the stability criterion as well as of the subsequent collapse. In particular, the long-range character of the DDI brings the length scales of the trap into play. The instability may be induced by the softening of excitation modes of a nonphononic nature (e.g., modes of small wavelengths or with angular structures). In these cases, the instability threshold is expected to be shifted compared to the $\varepsilon _ { \mathrm { d d } } = 1$ uniform value. In the collapse dynamics, structures at the corresponding length scale are then expected to be preferentially formed. The resultant “local collapse” corresponds to a “modulational instability” [96, 113–115]. The collapse dynamics may reveal the properties of the underlying mode driving the instability. The different regimes of global and local instability, and the related collapse or collapsing dynamics of dipolar Cr, $\mathrm { E r }$ , and Dy dBECs, are described in Secs. IV A 4 and V A.

# e. Quantum states stabilized by fluctuations: droplets and supersolids

Even if often well described by mean-field theory, dBECs are not classical fluids. As quantum fluids, they are liable to quantum fluctuations. Even at zero temperature, the vacuum population of its elementary excitations, yields interaction-induced modifications of the fluid’s energy and ground state. The Bogoliubov treatment allows one to perturbatively take into account these effects [11, 88, 116, 117]. The energy corrections are, in principle, negligible for weakly interacting gases; i.e., when na3 ≪ 1 and na3dd ≪ 1). However, the meanfield instability threshold described above occurs when the mean-field interactions are small, changing from repulsive to attractive on average. Importantly, while the overall interaction becomes negligible, the atoms still interact in a non-negligible way thanks to the competition of contact and dipolar interactions. In sufficiently dipolar gases, instead of a collapse, a remarkable phenomenon occurs at the instability threshold. Here, beyond meanfield effects provide sufficient repulsive interaction energy to stabilise the system. This leads to exotic phases on the attractive side of the mean-field instability threshold, including liquid-like droplet states (a quantum state that is stabilised by the opposite effects of mean-field and beyond-mean-field interactions, and even in absence of trapping potential), droplet assemblies (a state formed of several independent quantum droplets, self-organised in a crystalline structure), and supersolids (a self-organised crystalline states with global superfluid properties. In a simplified picture, it can be viewed as a ground state consisting of an overlapping assembly of droplets where the droplets are allowed to maintain a common phase via particle exchange). These recently discovered states are discussed in Sec. V C and V D.

# 2. Dipolar Fermi quantum gases

Fermionic dipolar atoms are also of great interest for exploring new physics. A remarkable property of dipolar Fermi gases lies in the fact that polarised samples remain interacting even in the ultracold regime. This is unlike nondipolar Fermi gases; see Sec. I C 1. Yet, the meanfield theory developed above does not appropriately describe fermionic ensembles because the ansatz used to write the many-body wavefunction is incompatible with the Pauli exclusion principle: it must be antisymmetrized due to fermionic exchange statistics. Therefore, it is generally not possible to neglect correlations in a Fermi gas at low temperature, even for small interactions. This makes a theoretical treatment of fermionic gases challenging. The simplest treatment of mean-field theory that includes the antisymmetrization of the wavefunction replaces the product ansatz used in Sec. I D 1 for $\psi ( { \pmb r } _ { 1 } , { \pmb r } _ { 2 } , { \pmb r } _ { 3 } , . . . , { \pmb r } _ { N } )$ by a Slater determinant. This procedure is known to be sufficient for a pure state without interactions. With interactions, it may still be sufficient, but with the single-particle wave-functions modified compared to the noninteracting case. This approach constitutes the Hartree-Fock theory [118, 119].

The mean DDI energy for an ensemble of $N$ atoms in a state $\psi ( { \pmb r } _ { 1 } , { \pmb r } _ { 2 } , { \pmb r } _ { 3 } , . . . , { \pmb r } _ { N } )$ is generally written as

$$
\begin{array} { l } { { \displaystyle E _ { \mathrm { d d } } = \int d r _ { 1 } . . . d r _ { N } \psi ^ { * } ( r _ { 1 } , r _ { 2 } , r _ { 3 } , . . . , r _ { N } ) } } \\ { { \displaystyle \sum _ { i , j } V _ { \mathrm { d d } } ( r _ { i } - r _ { j } ) \psi ( r _ { 1 } , r _ { 2 } , r _ { 3 } , . . . , r _ { N } ) } } \\ { { \displaystyle \qquad = \frac { N ( N - 1 ) } { 2 } \int d r d r ^ { \prime } \int d r _ { 3 } . . . d r _ { N } } } \\ { { \displaystyle \psi ^ { * } ( r , r ^ { \prime } , r _ { 3 } , . . . , r _ { N } ) V _ { \mathrm { d d } } ( r - r ^ { \prime } ) \psi ( r , r ^ { \prime } , r _ { 3 } , . . . , r _ { N } ) } } .  \end{array}
$$

Because of antisymmetrization, the integral $N ( N - 1 ) \times$ $\int d r _ { 3 } . . . d r _ { N } \psi ^ { * } ( r , r ^ { \prime } , r _ { 3 } , . . . , r _ { N } ) \times \psi ( r , r ^ { \prime } , r _ { 3 } , . . . , r _ { N } )$ does not reduce to $n ( \pmb { r } ) n ( \pmb { r } ^ { \prime } )$ as in the bosonic case. Though by using the Slater determinant ansatz, it can be simplified to $\rho _ { 1 } ( \pmb { r } , \pmb { r } ) \rho _ { 1 } ( \pmb { r } ^ { \prime } , \pmb { r } ^ { \prime } ) - \rho _ { 1 } ( \pmb { r } , \pmb { r } ^ { \prime } ) \rho _ { 1 } ( \pmb { r } ^ { \prime } , \pmb { r } )$ , where

$$
\begin{array} { c } { { \rho _ { 1 } ( r , r ^ { \prime } ) = N ( N - 1 ) \times \displaystyle \int d r _ { 2 } d r _ { 3 } . . . d r _ { N } } } \\ { { \psi ^ { * } ( r , r _ { 2 } , r _ { 3 } , . . . , r _ { N } ) \times \psi ( r ^ { \prime } , r _ { 2 } , r _ { 3 } , . . . , r _ { N } ) } } \end{array}
$$

is the one-body density matrix. Therefore, the DDI mean-field energy for the fermionic gas consists of two parts: the usual term, also called the direct or Hartree term

$$
E _ { d d } ^ { \mathrm { d i r } } = \frac { 1 } { 2 } \int d \boldsymbol { r } d \boldsymbol { r ^ { \prime } } V _ { \mathrm { d d } } ( \boldsymbol { r } - \boldsymbol { r ^ { \prime } } ) n ( \boldsymbol { r } ) n ( \boldsymbol { r ^ { \prime } } ) ,
$$

and an unusual term, called the Fock or exchange term, resulting from the requirement for an antisymmetric wavefunction upon particle exchange:

$$
E _ { \mathrm { d d } } ^ { \mathrm { e x c } } = - \frac { 1 } { 2 } \int d \boldsymbol { r } d \boldsymbol { r ^ { \prime } } V _ { \mathrm { d d } } ( \boldsymbol { r } - \boldsymbol { r ^ { \prime } } ) \rho _ { 1 } ( \boldsymbol { r ^ { \prime } } , \boldsymbol { r } ) \rho _ { 1 } ( \boldsymbol { r } , \boldsymbol { r ^ { \prime } } ) .
$$

This exchange term is zero in the case of a BEC. Based on Eqs. (19-20), and by performing the variational minimisation of the total energy with respect to $\psi$ , one can derive semiclassical (Hartree-Fock) equations for the degenerate Fermi gas (DFG). To describe a trapped Fermi gas, one can use a local-density approximation, which assumes that the atoms feel a local DDI [119–124]. This particular exchange interaction term, arising from the interplay of fermionic statistics and the nonlocal DDI, has several physical consequences—these will be the topic of Sec. IV B.

As previously discussed in Sec. I D 1, beyond-meanfield effects are typically weak for BECs in the weakly interacting regime (far from any instability). This is because the interaction energy is too small to create short-wavelength correlations in the gas. One way to reach strong correlations is to load the atoms into tight anisotropic traps or standing waves of light (so called optical lattice). Confined trapping geometries effectively reduce the atoms’ kinetic energy by restricting motion. By doing so, they allow the interaction and kinetic energies to play competing roles in the determination of how the system organises [7, 8, 82, 125–129]. In this review, we will discuss the experimental progress based on magnetic atoms in confined geometries; see Sec. VII. We note that important advances have been made with systems of polar molecules [20, 21, 41, 130] as well as of Rydberg atoms [22, 24, 25, 131–133]. Focusing on magnetic atoms, we discuss three main areas: (i) the physics in low-dimensional spaces and in particular 1D, where the motion of the particles arise only in some directions of space and is frozen transversely; (ii) the physics of spinless particles whose motion occurs, this time, along the specially confined directions in space, and in particular, along directions of a periodic external potential formed by an optical lattice. This realises extended Hubbard models for spinless dipolar particles; (iii) the case of spinful dipolar particles in such periodic external potentials, leading to quantum magnetism and XYZ models.

# a. Dipolar gases in lower dimensions

We now discuss a special case of lattice-confined geometries wherein atoms remain free to move in one or two directions of space while being tightly trapped (frozen) in the other(s). Such gases effectively realise lowerdimensional systems. Quantum physics in lower dimensions is fundamentally different from that in our usual 3D world. For instance, in both 1D and 2D, quantum fluctuations preclude long-range order, and, in 1D, bosons can act like fermions and vice-versa [7, 82, 125–127, 134, 135]. Exotic strongly correlated states may arise and interactions play a crucial role.

In 1D, many aspects of quantum physics for particles interacting via short-range potentials are understandable at an analytic level. In particular, solvable models, such as the Lieb-Liniger model, can often be evoked to describe such systems [127, 136]. When such models break down, e.g. by introduction long-range interactions, these systems can serve as testbeds for exotic strongly correlated many-body physics [137–139]. In the particular case of 1D dipolar gases, the DDI lifts integrability [140], thereby introducing chaotic dynamics that allows the gas to thermalize. Furthermore, control of the dipole orientation provides a knob with which to control the integrability-breaking mechanism and the induced thermalisation rates; see [141] and Sec. VII A.

Excited states of 1D Bose gases can possess correlations stronger than ideal Fermi gases [142]. These so-called super-Tonks-Girardeau states have been observed in a narrow range of attractive contact interaction strengths in nondipolar gases [143]. Repulsive dipolar interactions have been shown to completely stabilise these highly excited states regardless of contact interaction strength [144]. Dipolar stabilisation has provided access to a quantum holonomy of the underlying Hamiltonian that allows the gas to be topologically pumped to higher energy states. These prethermal states realise a form of quantum many-body scar state wherein a strongly correlated excited state evades thermalisation in an otherwise chaotic system [144, 145]. This physics will be discussed in Sec. VII A. Though initially explored in Refs. [141, 146], future work could aim to provide a more general understanding of 1D collisional physics in the presence of both the van der Waals interaction and the DDI, especially near a Feshbach resonance.

# $b$ . Extended Hubbard model

Another regime of interest arises when the motion of the particles takes place in a periodic external potential. This case, easily achieved by confining atoms in light standing waves, has been considered for a long time, in the ultracold community, and raised wide interest due to its similarity to the physics of electrons gases in crystals, and the possibility to realise very clean Hubbard models. The introduction of DDI within such lattice systems, yield novel physics even for spinless particles, by bringing new terms into the standard Hubbard Hamiltonian which standardly comprises a contact on-site interaction and tunnelling. Due to the DDI’s character, the new terms are anisotropic on-site and off-site interaction terms. The new interaction terms in dipolar lattices introduce competition between numerous energy scales. This yields exotic dynamical behaviours, excitations, as well as novel phases [14, 147]. In experiments, the relevance of the extended Hubbard model for dipolar bosons has been demonstrated, and the additional interactions terms quantified. The most exotic phases predicted based on the extended Hamiltonian have for now remained elusive. Current achievement and prospects are discussed in Sec. VII B.

# c. Spin physics in optical lattices

Finally, we will discuss lattice systems with spin degrees of freedom. By bringing into play dipolar exchange and relaxations terms—see Sec. I C 3—such systems realise models with a rich range of exotic dynamics and phases [7, 14, 147]. In particular, the off-site term induced by dipolar spin-exchange processes yield generic XYZ Heisenberg models. Of particular interest, a growth of quantum correlations is expected in such systems under the effect of inter-site spin-exchange interactions. Lattice spin models realised with magnetic atoms are discussed in Sec. VII C.

The engineering of synthetic coupling involving the particle’s spin, such as spin-spin or spin-orbit coupling, opens the door to the realisation of exotic states such as, on the many-body level, topological superfluids [148– 155] as well as highly nonclassical or topological spin states [156–159], that can even be produced at the singleatom level for large-spin atoms. Spin-dependent light shifts or optical Raman dressing of internal spin states may be used to effect such coupling for the introduction of abelian (magnetic field-like) or non-abelian (spinorbit coupling-like) gauge fields [160, 161]. Unfortunately, however, light fields also heat the atoms due to spontaneous emission, limiting the lifetime of systems. This may be circumvented by exploiting the level structure of magnetic atoms such as Dy and $\mathrm { E r }$ , while allowing dipolar interactions to play a role in the physics. Dipolar relaxation then sets new limits on the lifetime of these gases. Fortunately, there exist platforms in which the rate of dipolar relaxation is significantly reduced. One method uses a tightly confining potential in one or more spatial dimensions to suppress relaxation via phase-space restriction; see Refs. [162–164] and Sec. III C 5. Another method employs fermions in a large magnetic field so that dipolar relaxation may be suppressed due to Fermi statistics; see Refs. [162, 165] and Sec. III C 4. Exploiting such possibilities has yielded the realisation of long-lived SOC Fermi gases [166]. Related achievements and prospects are discussed in Sec. VI D 1.

# II. The magnetic atoms

The experimental research on dipolar quantum gases in the degenerate regime began in Stuttgart with the first production of a Bose-Einstein condensate made of chromium atoms in 2004 [167]. This achievement has since then attracted great interest, both from theorists and experimentalists. A second Cr BEC machine soon became available at Villetaneuse [168]. The interest in dipolar quantum degenerate gases was further sparked when it was shown that atoms with even larger magnetic moments than Cr, such as erbium [169] and dysprosium [170], could be efficiently laser cooled. Soon after, Bose and Fermi degenerate gases of both these lanthanide (Ln) atoms were produced, first at Urbana-Champaign (the group moved to Stanford in 2011) [171, 172], then at Innsbruck [173, 174]. Degenerate Fermi gases of Cr have also been produced in Villetaneuse [175]. These achievements, and the subsequent experiments, have stimulated much theoretical interest and activity in these systems. In response to these achievements, the field of dipolar gases made of magnetic atoms is now rapidly expanding. Experiments worldwide are being constructed to explore the fascinating properties of Ln atomic gases and many additional groups have realised gases in the ultracold [72–74, 176–184] and quantum degenerate [75, 185–

192] regimes.

In this section, we discuss the properties and the special features of the highly magnetic atomic species currently available in the quantum-degenerate regime, and in particular, their electronic structure and energy spectrum in comparison to the alkali atoms. We first recall a few features of Cr (Sec. II A; see also Ref. [17]) before presenting the magnetic Ln atoms (Secs. II B). We describe the basic method for cooling and trapping such species. Ultracold gases are typically created and confined in vacuum chambers using the techniques of Zeeman atomic beam slowers (ZSs), magneto-optical traps (MOTs), magnetic traps (MTs) and/or optical dipole traps (ODTs) [193]. In the case of magnetic atoms, pure MTs are of limited efficacy due to dipolar-relaxationinduced atom loss [86, 194, 195]; see also Sec. III C. The ZS, MOT and ODT techniques are more effective for magnetic atoms. The application of these slowing, cooling and trapping methods must take into account the special electronic structure of these magnetic atoms, which we will discuss.

In addition, we discuss the interactions of light with these atoms, specifically in regard to their large total orbital momentum; see Sec. II C. In Sec. II D, we discuss short-range scattering properties of the magnetic atoms including their scattering length $a$ and Feshbach resonances (FRs). Feshbach resonances enable the wide tunability, in both sign and amplitude, of $a$ . This allows one to control the dipolar character of magnetic gases too, since such properties often depend on the relative strength of the DDI to the contact interaction, $\varepsilon _ { \mathrm { d d } } = a _ { \mathrm { d d } } / a$ ; see Sec. I D 1. Moreover, FRs enable the production of more magnetic particles via the association of two atoms into a molecule. We discuss the related possibilities in both Cr and Ln atoms. We finally compare the overall tunability of the collisional properties of Cr and Ln in Sec. II E.

# A. Chromium

When the first ultracold-gas experiment with Cr atoms was started by the Stuttgart group, which began in Konstanz, prior to their move to Stuttgart, the aim was in fact to create a new instance of degenerate Fermi gas (due to the large abundance of its fermionic isotope). They realised only later, during a visit of K. Rzazewski in 1998, that it would be a great candidate for dipolar physics [12]. Focusing on the latter physics, using bosons, they achieved the first BECs of $^ { 5 2 } \mathrm { C r }$ [167]. Chromium52 atoms have a purely electronic spin of $S = 3$ and a $g$ -factor of $g _ { S } = 2$ in the ground state (denoted $^ 7 \mathrm { S _ { 3 } }$ using the standard notation $^ { 2 S + 1 } \mathrm { L } _ { J }$ ). The DDIs between these atoms are 36 times stronger than in the most magnetic case of alkalis because its magnetic dipole moment is $6 \mu _ { \mathrm { B } }$ , whereas alkalis’ moments are at most $1 \mu _ { \mathrm { B } }$ . The most abundant isotope of $\mathrm { C r }$ is $^ { 5 2 } \mathrm { C r }$ ; see table I. The atom has two other bosonic isotopes, $\mathrm { ^ { 5 0 } C r }$ and $^ { 5 4 } \mathrm { C r }$ , which have never been Bose-condensed. The fermionic isotope $\mathrm { ^ { 5 3 } C r }$ was cooled to degeneracy via a sympathetic cooling technique in 2014 [175]. Besides their dipolar character, ground state Cr atoms realise large spin systems (see Sec. VI A 1) whose magnetic properties are driven by both the DDI and their relatively strong, spindependent, isotropic contact interactions. The relevant scattering lengths are $a _ { S = 6 } { = } 1 0 2 . 5$ $a _ { 0 }$ [162], $a _ { S = 4 } { = } 5 6$ $a _ { 0 }$ , $a _ { S = 2 } = - 7 ~ a _ { 0 }$ [196], $a _ { S = 0 } = 1 3 . 5 ~ a _ { 0 }$ [197]; see Sec. II D for details.

Laser cooling of Cr was pioneered by J. McClelland for the purpose of creating collimated atomic beams for atom lithography [198]. A motivation for this work was based on the fact that the Cr ion is a colour centre in various host materials; e.g., it gives the red colour to a ruby crystal. This, controlling and positioning individual single colour centres could be possible through the threedimensional laser cooling of $\mathrm { C r }$ . Additionally, Cr sticks to most surfaces, and as such, Cr serves as an excellent material for etch masks: Using transversely cooled Cr atomic beams, one and two-dimensional structures at a resolution of a few tens of nanometers, as well as threedimensional structured doping, were demonstrated [199].

In the relatively high-density regime relevant for laser cooling, a large light-assisted inelastic cross-section was observed [200, 201] close to the Langevin limit [202]. This loss mechanism creates an intrinsic limitation to the density and number of atoms that can be efficiently captured in a Cr MOT. However, as the cooling transition $\mathrm { { } ^ { 7 } S _ { 3 }  { } ^ { 7 } P _ { 4 } }$ is not perfectly closed, metastable states $\mathrm { ( ^ { 5 } D _ { 3 , 4 } ) }$ are populated during the cooling process and are trapped in the quadrupole field of the MOT due to their large magnetic dipole moment. This provides continuous loading into a dark, but trappable, state that is immune to light-assisted collisions. Typically a few $1 0 ^ { 8 }$ atoms accumulate in this trap, with their number limited in density by inelastic collisions between these metastable atoms [203]. Using a repumper on the intercombination line $\mathrm { { } ^ { 5 } D _ { 3 , 4 } }  \mathrm { { } ^ { 7 } P _ { 3 , 4 } }$ produces a magnetically trapped sample in the $^ 7 \mathrm { S _ { 3 } }$ ground state [204]. The sample is sufficiently dense that evaporative cooling may proceed. However, such cooling is then limited by dipolar relaxation collisions, flipping spins into untrapped states and inducing heating from the released Zeeman energy [86, 162]. This may be avoided by loading into a crossed ODT an evaporatively precooled and spin-polarised sample, i.e., one in the strong-field seeking, lowest-energy Zeeman state. The gas could then be evaporatively cooled all the way to degeneracy [167]. Subsequent production schemes of Cr degenerate gases start by accumulating atoms in the metastable $\mathrm { ^ { 5 } D _ { 3 , 4 } }$ and ${ } ^ { 5 } \mathrm { S } _ { 2 }$ states directly from the MOT into an ODT. The atoms were then repumped to the ground state where all-optical evaporative cooling in the ODT produced the BEC [168]. Additional details regarding the key techniques and strategies to produce Cr BECs are described in an earlier review [17].

In contrast to the Lns, the ground state in Cr is an “ $S$ -state," which means that the mutual van der Waals interactions are isotropic. However, there are still sufficient Zeeman substates to provide a rich structure in the asymptotic molecular states. The DDI additionally provides a coupling between these states. Therefore, even without hyperfine structure, as it is the case for bosonic $\mathrm { C r }$ ( $I = 0$ ), a number of narrow FRs exist, as were first found and characterised in Ref. [196]. See section II D for details.

# B. Lanthanides

Atoms with multiple valence electrons and non- $S$ electronic ground state, such as the magnetic Lns, are of increasing interest to the study of strongly dipolar phenomena in atomic quantum gases. Among the magnetic Lns, Dy [171, 172] was the first to be brought to quantum degeneracy, shortly followed by $\mathrm { E r }$ [173, 174]; see Sec. II B 2 b. We note that Yb has been the first Ln to be Bose-condensed [205], but because of its closed-shell character, Yb has zero magnetic moment and is more similar to the alkaline earth atoms—it will not be discussed here. In addition, BECs of Tm were recently achieved [75]. We will now mostly focus on Dy and $\mathrm { E r }$ because they are the most widely employed for the quantum gas research reviewed here.

As summarised in Table I, $\mathrm { E r }$ and Dy have a number of special features that make them particularly appealing for quantum-gas experiments. Both $\mathrm { E r }$ and Dy possess many naturally abundant isotopes with a wide variability of properties, including several bosonic and fermionic isotopes. Besides different quantum statistics (bosonic or fermionic), the isotope variety also offers a useful diversity and tunability of scattering properties: Each isotope has a different background value of $a$ and a distinct Feshbach spectrum, the latter of which can be used to further tune $a$ ; see Sec. II D. Besides binary collisions, the rates of multibody collisional processes are also expected to change from one isotope to the other. This includes, in particular, the three-body inelastic collisions, which typically induce detrimental losses and heating in cold gases. The wide variability in collisional properties offer more opportunities for finding isotopes that can be efficiently cooled to quantum degeneracy. We note that this isotope variety is special to $\mathrm { E r }$ and Dy among the magnetic Lns: Eu, Tm and Ho all have only one stable (bosonic) isotope. This was one of the reasons for first focusing on Er and Dy within the Ln series.

Magnetic Lns have a large magnetic dipole moment in the electronic ground state (e. g. , $7 \mu _ { \mathrm { B } }$ for $\mathrm { E r }$ and $1 0 \mu _ { \mathrm { B } }$ for both Dy and Tb), and, because their mass appears in the DDI strength, the corresponding dipolar lengths are several times larger than Cr’s ( $a _ { \mathrm { d d } } \ : = \ : 1 5 a _ { 0 }$ ), with $a _ { \mathrm { d d } } = 6 5 . 5 a _ { 0 }$ and $a _ { \mathrm { d d } } = 1 3 1 a _ { 0 }$ in $\mathrm { E r }$ and Dy, respectively. In dipolar BECs (dBECs), the strength of the dipolar character of a quantum gas is proportional to the ratio $\varepsilon _ { \mathrm { d d } } = a _ { \mathrm { d d } } / a$ ; see Sec. I D 1. Magnetic Lns are sufficiently dipolar that their $\varepsilon _ { \mathrm { d d } }$ are typically of the order of $^ { 1 }$ at background level (i.e., away from FRs).

In addition to their strong dipolar character, magnetic Lns feature a large orbital momentum quantum number, $L$ , in their ground state ( $L = 5$ for $\mathrm { E r }$ and $L = 6$ for Dy). This is a major difference from Cr, where the large angular momentum arises purely from the electronic spin $S$ while $L \ = \ 0$ . The large $L$ value in the Ln case induces an orbital anisotropy, which causes the van der Waals interactions to be anisotropic, in addition to the DDI [206–208]. As we will discuss in Sec. II D, this orbital anisotropy has important consequences for the scattering properties of Lns [195, 206, 207, 209, 210], in particular for interspin interactions, as well as for their atomic polarizability [177, 211–216]; see Secs. II C, II D, and VI A 3.

In addition, and similar to Cr, magnetic Lns realise large-spin systems; see Sec. VI A 1. Finally, the large masses leads to low recoil energies, which is beneficial for optical trapping and laser cooling.

# 1. Atomic energy spectrum of magnetic Lns

The electronic configuration of magnetic Lns is $[ X e ] 4 f ^ { m } 6 s ^ { 2 }$ . It is characterised by a xenon-like core, an inner open $4 f$ shell with $m$ valence electrons, and an outer closed $6 s$ shell. Due to the electron vacancies in the inner shell, magnetic Ln are often called submerged-shell atoms. The unfilled $4 f$ shell plays a particularly important role in their high magnetism and orbital anisotropy.

Figure 1 shows the atomic energy spectra for the cases of $\mathrm { E r }$ and Dy, up to a wavenumber of $2 5 , 0 0 0 \mathrm { c m } ^ { - 1 }$ . Both species have an even-parity ground state with a large $J$ and many excited states of odd and even parity of various quantum numbers. A comprehensive set of spectroscopic data of all Ln elements can be found in Refs. [217–219]. Note that theory results that are based on the Cowan suite of codes [220, 221] and used to estimate the polarizability of Lns predict atomic transitions that have not yet been observed [213, 214]; see also Sec. II C. This reveals the still incomplete knowledge of Ln atomic spectra and their properties.

Unusually for those accustomed to alkali atoms, many of the energy levels in the electronic spectrum of Ln atoms do not conform to the usual LS-coupling scheme. In the LS scheme, the total electron spin $S$ and angular orbital momentum $L$ couple to form $J = L + S$ , but the large spin-orbit coupling of the electrons in Lns renders this scheme sub-optimal for some of the electronic levels. In this case, a $J _ { 1 } J _ { 2 }$ -coupling scheme is more appropriate [222]. In this $J _ { 1 } J _ { 2 }$ scheme, the electrons in each shell couple independently in a LS-coupling scheme, and then the total angular momentum quantum numbers from the different shells sum together. For instance, $4 f$ electrons give rise to $J _ { 1 }$ and the $6 s$ ones to $J _ { 2 }$ , and $J = J _ { 1 } + J _ { 2 }$ with quantum number $J$ , which is denoted as $( J _ { 1 } , J _ { 2 } ) _ { J }$ . For Lns, the LS scheme remains relevant for the ground state while the excited states (where spin-orbit coupling is stronger) typically follow a $J _ { 1 } J _ { 2 }$ -coupling scheme. Finally, the bosonic isotopes of Dy and $\mathrm { E r }$ have nuclei with an even number of protons and neutrons. This results in a zero nuclear spin $\mathbf { I }$ and no hyperfine structure. In contrast, the fermionic isotopes have an even number of protons and an odd number of neutrons, resulting in a nuclear spin ${ \bf I } = 5 / 2$ and ${ \bf I } = 7 / 2$ for Dy and $\mathrm { E r }$ , respectively. We note that other magnetic Lns, such as Tm, Eu or Ho, have only bosonic isotopes and those isotopes have a hyperfine structure.

Lanthanides’ atomic spectra offer a rich collection of $J \longrightarrow J + 1$ optical lines, including broad-, narrow- and ultra-narrow-linewidth transitions. Many of such transitions can be used for optical manipulation and laser cooling, and they are readily accessible with common lasers. As a rule of thumb, the linewidth of the transitions is larger for short-wavelength (i. e. high energy) transitions. The strongest line in $\mathrm { E r }$ (Dy) at 401 (421) nm, the intercombination line at 583 (626) nm, and the narrow line at 841 (741) nm are used in experiments for laser cooling, as discussed in the next section. The narrower resonances have also been used for spin manipulation or coupling, see Sec. VI. Furthermore, the spectra of the $J \longrightarrow J$ and $J \longrightarrow J - 1$ transitions are equally rich and relevant for optical manipulation schemes [223]. Among the rich spectra of Lns, an interest is also growing for the ultranarrow resonances of $\mathrm { H z }$ -level linewidth, see e.g. refs [224–227]. Finally, the orbital anisotropy of Lns also yields a dependence of the matter-light interaction on the atomic spin. This presents both challenges (how to obtain equal trapping of all spin states?) and advantages (realisation of spin-dependent potentials, spin-orbit coupling, etc.) for ultracold gas experiments; see also latter discussions.

# 2. Optical cooling, trapping, and evaporative cooling of open-shell Ln

Trapping and cooling of open-shell Ln atoms have been achieved using ZSs, MOTs, and ODTs, but without the use of magnetic trapping. The overall efficiency is similar to that of alkali-metals [193], though there are some key differences that we now describe.

# $a$ . Optical cooling and MOTs

The broadest laser cooling cycling transitions of Lns are open, meaning that there are a multitude of metastable states to which the excited state can decay through spontaneous emission. Repumping the population back to the cooling transition is not practically feasible. Fortunately, two solutions exist: a repumperless MOT on these broad transitions and a MOT using a closed transition with small or intermediate linewidth. We detail below the working principle of these two schemes.

# Broad-line MOTs

In 2006, McClelland et al. presented a repumperless Er MOT [169, 218]. Despite the open nature of the ${ \sim } 3 0$ MHz linewidth, 401-nm transition, neither the MOT nor the ZS required a repumper, and $1 0 ^ { 6 }$ atoms were confined. Subsequently, transverse cooling [170, 228, 229] and a MOT [170, 230] containing several $1 0 ^ { 8 }$ atoms were reported for Dy, both using a similarly wide transition at 421 nm. Likewise, MOTs of Ho [73], Tm [72, 231, 232] and Eu [74] have been formed. The surprising success of the repumperless MOT derives from two key properties of magnetic Lns atoms: i) They possess a surprisingly small branching ratio $( < 1 0 ^ { - 5 }$ ) of decay to the metastable states; and ii) the lifetime of these metastable states in the quadruple MT of the MOT is long. The former property allows a sufficient number of atoms to go through the ZS without decaying to metastable states. The latter property means that atoms in metastable states are not lost, but remain trapped in the MT of the MOT (due to the atoms’ large magnetic moment) until they eventually decay to the ground state and undergo cooling cycles again.

![](images/e0aec186ba964cd64927fbbb399e9d7b2d4915486b768b6dd47b8bfcfe84fc1b.jpg)  
FIG. 1: Energy spectrum of $\mathrm { E r }$ and Dy. The levels shown in red (black) have an even (odd) parity. Electric dipole transitions couple the ground state, which has an even parity, to energy levels of odd parity and with a total angular momentum within the interval $J = \left\lfloor 5 , 7 \right\rfloor$ for $\mathrm { E r }$ and $J = [ 7 , 9 ]$ for Dy. Both species feature broad transitions in the blue (401nm for $\mathrm { E r }$ and 421nm for Dy), intercombination lines at $5 8 3 \mathrm { n m }$ for $\mathrm { E r }$ and $6 2 6 \mathrm { n m }$ , and narrow cooling transitions at 631nm and 841nm for $\mathrm { E r }$ and 741nm for Dy. These transitions have been used in experiments to laser cool the atomic samples.

An unusual, anisotropic sub-Doppler cooling effect was observed inside these Er, Dy, and Tm MOTs [170, 230, 233–235]. The effect is a consequence of the fact that the Landé $g$ factors of the ground and excited states are nearly the same, yielding nearly zero differential Zeeman shift on the cooling transition. This allows $\sigma ^ { + } \sigma ^ { - }$ polarization-gradient cooling [193, 236] to exist even in a large magnetic field. The atoms are therefore exposed to both Doppler and sub-Doppler cooling mechanisms inside the MOT. The larger-population Dy blue-line MOTs exhibit a small core of sub-Doppler cooled atoms, as in the $\mathrm { E r }$ MOT, but this core is surrounded by a largerpopulation shell of hotter, Doppler-cooled atoms. Atoms beyond a certain distance from the MOT’s quadrupole MT center feel a large-enough magnetic field to disrupt the sub-Doppler cooling mechanism beyond this radius. The temperature of this core of colder, sub-Doppler cooled atoms is highly anisotropic, with the temperature of atoms along the quadrupole MT axis hotter than those in the quadrupole plane of symmetry, or vise-versa depending on the ratio of cooling laser intensity along these directions [234]. This unusual anisotropic sub-Doppler cooling effect is likely due to the countervailing tendency of atomic polarisation to lock its orientation to a direction favoured by the laser optical pumping versus its tendency, due to the large magnetic dipole moment of Dy, to align according to the local magnetic field of the MT [234].

# Multi-stage MOTs

While ZSs and MOTs on broad transitions can perform the initial stages of laser cooling and trapping of open-shell Lns, they cannot cool the atoms low enough to load ODTs. Further cooling may be provided by using so-called intercombination-line MOTs. These are formed using laser cooling lines on electric dipole semi-allowed (intercombination) transitions. Fortunately, all of these narrow transitions are closed, obviating the need for repumping lasers.

In one of the realised schemes, the atoms are cooled using, first, a broad-line MOT, and then, in a second stage, a colocated MOT on a very narrow transition <10 kHz. A similar scheme was also used for cooling strontium atoms [237]. The first narrow-line open-shell Ln MOT was demonstrated in Ref. [238] with $\mathrm { E r }$ , using such a scheme on the 8-kHz wide, 841-nm transition. This very narrow line, however, leads to an unusual requirement for stable MOT operation: The cooling lasers must be tuned to the blue (i.e., positive frequency detuning) side of the transition, rather than the red. This is because

Er’s large magnetic moment causes the magnetic Zeeman force to dominate the optical radiation forces, even in the small magnetic fields encountered near the MT centre. Blue detuning also optically pumps the atoms to the magnetically trappable weak-field-seeking states. Under conditions of blue detuning, the MOT forms below the quadrupole MT where gravitational, radiation, and magnetic Zeeman forces mutually balance. The 8- kHz-wide, 841-nm $\mathrm { E r }$ MOT provided ${ \sim } 2$ $\mu \mathrm { K }$ gases [238]. A similar blue-detuned MOT for Dy on its 1.8-kHz-wide, 741-nm transition was able to cool $1 0 ^ { 7 }$ Dy atoms loaded from the broad MOT to 2 $\mu .$ K [171, 239] and works for all high-abundance isotopes of Dy. More recently, a 841-nm $\mathrm { E r }$ MOT operating with red-detuning have been demonstrated [192]. This was made possible by its loading from an intermediate-linewidth MOT operating from the 583-nm transition, as in Ref. [240]; see below. This additional cooling stage enabled temperatures as low as $4 0 0 \mathrm { n K }$ to be reached and phase-space densities as high as 0.05.

# •Single-stage intermediate-linewidth MOTs

An alternative approach replaces the double-MOT scheme with a single MOT whose transition linewidth is intermediate, i.e., in the 100’s of kHz range. This is similar to the scheme employed for ytterbium atoms [241]. The narrow linewidth provides Doppler-limited cooling below 10’s of $\mu \mathrm { K }$ , sufficiently low to directly load an ODT, yet is broad enough to allow the capture of atoms from a Zeeman-slowed atomic beam. This intermediate-linewidth scheme was first developed for an open-shell Ln MOT in Ref. [240] using Er. This scheme has then become the most widely employed, and MOTs of all high-abundance Er [178, 183, 240] and Dy [176, 178, 184, 187, 189, 192, 242, 243] isotopes, both fermionic and bosonic, have been created in various labs. Double-species MOTs of Er and Dy have also been achieved using this scheme [178]. It has recently been employed in Tm [179, 180]. Typically, MOTs containing several $1 0 ^ { 7 }$ to $1 0 ^ { 9 }$ atoms with final temperatures of 6–13 $\mu \mathrm { K }$ are achieved. These low temperatures allow direct loading of the atoms into relatively lowpower ODTs. The intermediate-line MOT can also load narrow-line MOTs operated with red detuning, which enables rapid cooling to lower temperatures before loading an ODT [192]. While intermediate-line MOTs have been successfully loaded directly from Zeeman-slowed atomic beams [176, 178, 187, 189, 192, 240, 242, 243], recent schemes have enhanced the capture efficiency of the narrow-line MOT by using angled Zeeman slower beams on the broad 421-nm transition in between the output of the ZS and the position of the MOT [183, 184]. This provides a factor 20 gain in population in the final MOT.

The intercombination lines in $\mathrm { E r }$ , Dy and Tm are at wavelengths of 583 nm, $6 2 6 \mathrm { n m }$ and 530.7 nm with linewidths of 190 kHz, 136 kHz, and $3 2 0 ~ \mathrm { k H z }$ , respectively. These MOTs are operated at very large red detunings, intensities, and magnetic gradients [176, 178, 186, 189, 240, 242]. In this configuration, the atoms feel a radiative force only over a portion of the trap volume. The force is negligible at the centre, while the magnetic gradient brings the atoms back into resonance on an ellipsoidal shell whose radius is set by the competition of light detuning and Zeeman energy shift [244]. This yields a MOT capture volume that increases with the light detuning. Similar to the MOTs achieved on extremely narrow transition described above, the atoms are displaced below the trap centre and are in an unconventional bowl-shape due to gravitational effects. This enabled a single-beam narrow-line MOT in Er [238] due to magnetic trapping. A more practical scheme using only five MOT beams was demonstrated [178, 192], where the sixth beam coming from the top was unnecessary due to the MOT located below the zero of the magnetic field. Conveniently, in the intermediate-line MOTs, the atoms are spin-polarised into the lowest Zeeman sublevel, rather than the highest, as is the case for the blue-detuned narrow-line MOTs [171, 238]. The latter require an RF adiabatic rapid fast passage step to transfer atoms from the weakest to the strongest field-seeking states. References. [176, 179] additionally demonstrate that light-assisted collisions are the limiting factor to the performance of the intermediate-line MOT scheme for the bosonic isotopes. Such losses are minimised at large detuning. In all schemes, the fermionic MOTs have the lowest trap populations relative to natural abundance. This is thought to arise from complications due to inefficient optical pumping and loss channels arising from the existence of hyperfine structure in the fermionic isotopes [170, 230, 242, 245].

# b. Optical dipole trapping and cooling to quantum degeneracy

Despite the complex electronic structure of open-shell Lns, optical dipole trapping is in practice very similar to that of alkali-metal atoms; see Ref. [246]. Long-lived optically trapped quantum gases of Lns have been made at a variety of wavelengths. These in include: $1 5 6 0 ~ \mathrm { n m }$ , 1070 nm, 1064 nm, 741 nm, and 532 nm for Dy [171, 172, 215, 247, 248]; 1570 nm, 1070 nm, $1 0 6 4 ~ \mathrm { n m }$ , and 532 nm for Er [173, 174, 216]; and 532 nm for Tm [75, 180, 232]. A quasielectrostatic optical dipole trap of $\mathrm { E r }$ near $1 0 . 6 \ \mu \mathrm { m }$ has also been reported [186]. We will review the special features of optical trapping with Ln in Sec.II C. In the remainder of the present section, we will describe how the resulting conservative traps have been used to achieve quantum degenerate gases of both Dy and Er via standard evaporative cooling.

# BECs

Forced evaporative cooling in a crossed ODT— overlapping ODTs that create a “dimple” trap at their intersection—is quite efficient for open-shell Ln due to the contributions to the elastic cross-section provided by dipolar collisions; see Sec. III B. However, compared to the ODT evaporation of weakly dipolar species, care must be taken to ensure that the dipolar gas does not become mechanically unstable and collapse during the evaporation process; see Sec. V.

The first degenerate gas of an open-shell Ln was created in 2011 [171]: Nearly pure BECs of $^ \mathrm { 1 6 4 }$ Dy were observed with a population of ${ \sim } 1 0 ^ { 4 }$ atoms at a density of $1 0 ^ { 1 4 } ~ \mathrm { { c m } ^ { - 3 } }$ . Soon thereafter, BECs of $^ { 1 6 8 } \mathrm { E r }$ were made, with $2 \times 1 0 ^ { 5 }$ atoms [173, 245]. BECs of other isotopes of Dy, specifically $^ \mathrm { 1 6 2 }$ Dy with $1 0 ^ { 5 }$ atoms and $^ \mathrm { 1 6 0 }$ Dy with $1 0 ^ { 3 }$ atoms [249] and $^ { 1 6 6 } \mathrm { E r }$ with $1 0 ^ { 5 }$ atoms [250] were produced; see Sec. II E and table I for a summary. More recently, various quantum degenerate mixtures of $\mathrm { E r }$ and Dy with typically few $1 0 ^ { 4 }$ atoms in each component [188] were also achieved using the isotopes $^ { 1 6 6 } \mathrm { E r }$ , $^ { 1 6 8 } \mathrm { E r }$ and $^ { 1 7 0 } \mathrm { E r }$ (which was previously uncondensed), and $^ \mathrm { 1 6 2 }$ Dy and $^ \mathrm { 1 6 4 }$ Dy. In 2020, the first BEC of Tm was achieved [75].

The evaporation efficiency of Lns greatly depend on the choice of bias magnetic field applied $B$ . This is due to the complex scattering behaviour of the Lns tuned by the extremely dense spectra of FRs; see Secs. II D 2 and $\mathrm { ~ 1 1 E }$ . Both two-body (elastic) and three-body (inelastic) scattering rates strongly depend on $B$ . We note that, up to now, efficient evaporative cooling has been reported only at relatively low $B$ , from a few hundreds of mG to a few tens of G. Moreover, the orientation of the bias field can also play a role in determining the efficiency of evaporative cooling, in particular because it impacts the stability of the interacting system. To reduce the contribution of the attractive DDI, ODTs are typically cigar- or pancake-shaped during evaporation; see also Sec. IV A 4. We note that a particularly efficient evaporation scheme consists in changing the trap geometry toward more pancake shapes in the final stage of the scheme [188, 245, 250, 251].

# •DFGs

The first degenerate dipolar Fermi gas was created using a sympathetic cooling scheme. Fermionic $^ \mathrm { 1 6 1 }$ Dy was co-trapped with bosonic $^ \mathrm { 1 6 4 }$ Dy to provide sympathetic cooling using this dipolar mixture [172]. The resulting deeply degenerate $^ \mathrm { 1 6 1 }$ Dy quantum gas had a population of $1 0 ^ { 4 }$ atoms at $T / T _ { F } ~ = ~ 0 . 2$ [172]. As Sec. III B describes in more detail, the direct evaporative cooling of a spin-polarised gas of magnetic fermions is also possible thanks to long-range universal elastic dipolar scattering. In Ref. [172], such a direct evaporative cooling was also performed, yielding an assembly of a few thousand $^ \mathrm { 1 6 1 }$ Dy atoms cooled down to $T / T _ { F } ~ = ~ 0 . 7$ . The first deeply degenerate DFG of $\mathrm { E r }$ used this direct approach to reach degeneracy with a spin-polarised gas of $^ { 1 6 7 } \mathrm { E r }$ of ${ \sim } 7 \times 1 0 ^ { 4 }$ atoms at $T / T _ { F } \lesssim 0 . 2$ and densities exceeding $4 \times 1 0 ^ { 1 4 }$ $\mathrm { c m } ^ { - 3 }$ [174]. This work confirmed the efficacy of this cooling mechanism arising from universal elastic dipolar scattering. Similarly large dipolar DFGs of $^ \mathrm { 1 6 1 }$ Dy were created through the optimisation of the crossed ODT shape—i.e., a tighter trap should be used to evaporatively cool fermions—and evaporation procedure [252]. This direct-evaporation scheme is very attractive, as it involves a far simpler experimental procedure than sympathetic cooling. Moreover, the evaporative cooling efficiency was found to be as high as that of bosonic isotopes. More recently, quantum degenerate mixtures of the fermionic $^ \mathrm { 1 6 1 }$ Dy isotope with bosonic $^ \mathrm { 1 6 8 }$ Er [188] as well as with fermionic $^ { 4 0 }$ K [189] were produced, combining direct evaporative cooling and sympathetic cooling. Note that $^ { 1 6 7 } \mathrm { E r }$ DFGs could not be achieved in a 1064-nm ODT and a distinct setup must be implemented that uses a 1570-nm crossed-ODT. The $^ { 1 6 7 } \mathrm { E r }$ is rapidly lost from 1064-nm ODTs perhaps because of light-induced collisions related to the isotope’s hyperfine structure adding complexity to its electronic spectrum [174]. Finally, we highlight that the $B$ value plays a similarly important role in setting the evaporative cooling efficacy fermionic open-shell Lns as well. Indeed, for such polarised fermions, a large number of FRs also exist, with a far greater density than even for bosons due to the fermions’ hyperfine structure; see also Sec. II D 2.

# C. Atom-light interactions in magnetic atoms

Atom-light interactions are at the heart of cold-atom experiments. They provide exquisite control and diagnostic tools, and all the observations discussed in this review rely on them. Indeed, these interactions enable, e.g., atomic cooling (see e.g., Sec. II B 2 a), imaging of density distributions, trapping with conservative potentials (see e.g. Sec. II B 2 b), controlling internal atomic degrees–of– freedom (i.e., their spin) (see e.g. Secs.VI,VII C), and coupling of this spin to their external motion (see e.g. Sec.VI D 1). The interaction between atoms and light is generally described by the Hamiltonian term [253]

$$
\hat { V } _ { \mathrm { A L } } = \hat { D } . \hat { E } .
$$

The electric-dipole approximation has been applied in deriving this expression and is justified by the fact that the light wavelength is much larger than the size of the atom. Here, $\hat { D }$ is the atomic electric dipole operator, whose origin arises from the displacement operators of the electrons times the electric charge $- e$ , and $\hat { \boldsymbol E }$ is the electric field operator that accounts for all possible photon modes with wavevector $k$ and polarisation $s$ . The operator $\hat { D }$ of an atom is determined by its electronic ground state and electronic excited state spectrum. Magnetic atoms, whose electronic structure has been shown to be remarkable, are expected to present unusual lightmatter interaction properties compared to alkali atoms. In this section, we will partly review these particularities, focusing on the aspects most relevant for the manipulation of quantum gases, i.e., under the typical condition of a coherent laser field sufficiently far detuned from electronic excited states.

In presence of a (monochromatic) laser field, a semiclassical approximation may be used for $\hat { \boldsymbol E }$ : $\begin{array} { r l } { \hat { \boldsymbol E } } & { { } = } \end{array}$ $\boldsymbol { E } ( \hat { \boldsymbol { r } } , t ) = \boldsymbol { \mathcal { E } } _ { 0 } ( \hat { \boldsymbol { r } } )$ ( $\hat { \varepsilon } \exp ( - i \omega _ { 0 } t + \phi _ { 0 } ( \pmb { \hat { r } } ) ) + c . c . )$ with $\mathcal { E } _ { 0 }$ , $\omega _ { 0 }$ , $\phi _ { 0 }$ and $\hat { \varepsilon }$ the amplitude, frequency, phase and polarisation unit vector of the laser field. Within the semi-classical approximation, the atomic dipole operator is non-zero thanks to the charges’ displacement induced by the electric field. This results in the simplified form

$$
\hat { \boldsymbol D } ( \boldsymbol r , t ) = \alpha ( \omega _ { 0 } ) \boldsymbol E ( \hat { \boldsymbol r } , t ) .
$$

Here, $\alpha$ is the complex dynamical atomic polarisability at frequency $\omega _ { 0 }$ . It is a sum of all electronic transition contributions, which typically scale linearly with the transition linewidth (setting the electronic transition strength) and vary inversely to the detuning of $\omega _ { 0 }$ to the transition frequency [246, 253]. The real part of $\alpha$ relates to the (reactive) dipole force while its imaginary part relates to the (dissipative) radiation pressure force and to the photon-scattering rate. Practically, the former determines the AC Stark shifts induced by the light on the atomic levels’ energies and, thus, to the induced dipole trap depth. The latter limits the trap lifetime.

Because of the internal structure of the atoms, the atom-light coupling depends on the total angular momentum of the electronic state $\pmb { F }$ and on the light polarisation $\epsilon$ . This yields a (rank-2) tensor structure for the polarisability $\alpha$ . It is again a sum over all electronic transitions, but now accounting for the various electric dipole transition elements between the ground and excited states’ sublevels as well as their possible spatial anisotropy. The polarisability tensor $\alpha$ can be decomposed into a scalar $\alpha _ { s }$ , vector $\alpha _ { v }$ , and tensor $\alpha _ { t }$ contribution such that [221, 254, 255]

$$
\begin{array} { l } { { \displaystyle \alpha ( \omega _ { 0 } ) = \alpha _ { s } ( \omega _ { 0 } ) \overline { { \mathbf { \bar { 1 } } } } + \alpha _ { v } ( \omega _ { 0 } ) \frac { ( \epsilon ^ { * } \times \epsilon ) . F } { 2 F } + } } \\ { { \displaystyle \alpha _ { t } ( \omega _ { 0 } ) \left[ \frac { 3 ( \epsilon . F ) ( \epsilon ^ { * } . F ) + 3 ( \epsilon ^ { * } . F ) ( \epsilon . F ) - 2 F ^ { 2 } } { 2 F ( 2 F - 1 ) } \right] . } } \end{array}
$$

The scalar part is independent of the angular momentum operator, while the higher-rank contributions yield spindependent terms. In this respect, vector and tensor polarisabilities set the strength of Raman coupling between atomic Zeeman sublevels. They also provide tools for optical spin manipulation and spin-dependent trapping. Their contribution’s dependence on the light polarisation additionally induces an anisotropy of the atom-light coupling, varying with the relative angle between the quantisation axis (set by the magnetic field) and the light-beam polarisation vector.

A major difference in the atom-light interactions involving magnetic atoms versus, e.g., alkali atoms, lies in their large vectorial and tensorial polarisabilities. This arises from the large electronic spin of the magnetic atoms, which yields strong spin-orbit coupling in electronic states with $L \neq 0$ , both in ground and excited states. This strong spin-orbit coupling results in differences between the electric dipole matrix elements coupling between the different fine-structure levels of the ground and the electronically excited states, which ultimately leads to spin-dependent and anisotropic behaviour of the atom-light coupling. In the Cr case, the anisotropy comes from spin-orbit coupling in the excited states [256–258], while in the Ln case, it arises from the combined effect of spin-orbit coupling in both the ground and excited states [177, 212–216, 248, 259]. The existence of fine structure in both the excited and the ground state electronic configurations of Lns—and the large energy splitting within these fine structure manifolds—results in a different scaling of the vector and tensor polarisabilities versus that of the alkalies [158, 260]. That is, both the vector and tensor polarisabilities scale as $\propto \Delta _ { a } ^ { - 1 }$ , while in alkali metals the scaling is $\propto \Delta _ { a } ^ { - 2 }$ for all detunings $\Delta _ { a }$ greater than the hyperfine splitting, where $\Delta _ { a }$ is the (average) detuning of the light from the excited states.

The large vector and tensor polarisabilities of magnetic atoms have been investigated via different means. In Cr, spin-dependent optical trapping was indirectly revealed in the study of many-body spinor dynamics, both in bulk [258] and in lattices [261]. Spin-dependent quadratic light shifts, resulting from the tensor polarizability close to the 427.6 nm-transition (laser at 427.85 nm), were also used to produce controllable spin mixtures [257].

A detailed experimental investigation of the characteristics of atom-light coupling in Lns using the newly available ultracold samples was crucial for a proper understanding of these systems. Indeed, up to now, theoretical predictions for Ln atom-light interactions have been difficult and remain incomplete. This is due to the complexity of the many-body electronic structure of the atoms and the limited knowledge available. Much progress has recently been made in developing sophisticated numerical tools to analyse the electronic level structure of Dy [212, 214], Er [213], Ho [259], and Tm [262], see also Sec. II B 1. Recent measurements of $\mathrm { E r }$ , Dy, and Tm dynamic (total, scalar) polarisabilities based on trap frequencies measurements have resulted in close agreement between this theory and the experiments [177, 216, 262, 263]. In addition, thanks to a direct comparison with an alkali atom with a precisely known polarizability (potassium), unprecedented accuracy and precision on the Dy polarizability have been obtained in experiment, allowing theory test [177].

The unusually large vector and tensor polarisabilities of Lns (as compared to alkali atoms like Rb) have also been experimentally investigated. The large vector and tensor polarisability of Dy was first studied using a laser field close to the 741-nm transition [215]. Near this transition, a so-called “tune-out” wavelength was found, at which the total light shift vanishes. Kao et al. observed a strong dependence of the tune-out wavelength on the light polarisation angle, which is a consequence of the large tensor polarisability of Dy. This introduces a novel experimental knob with which to tune the wavelength where the AC polarisability vanishes. Becher $e t$ al. [216] probed the large tensor part of the polarisability of $\mathrm { E r }$ grund-state, by testing the dependence of the optical trap’s frequencies (thus its depth) on the light’s polarisation axis. A sizeable anisotropy effect (few percent) was observed at conventional wavelengths (1570 nm, 1064 nm, and 532 nm) far away from atomic transitions. The spin-dependent light shifts were later used to rapidly control the spin dynamics in an assembly of lattice-confined fermionic Er [264], see also Sec. VII B. A similar scheme employing the ellipticity of light polarisation was applied to gases of Tm atoms and enabled the measurement of both the tensor and vector parts of its ground-state polarisability at 532 nm [263].

The locations of other special wavelengths at which the ground and excited state polarizibilities match have been predicted in Dy [212]. These so-called “magic" wavelengths are of great utility to research involving atomic clocks and optical lattices for quantum simulation [265]. By making use of Dy’s large tensor polarisability at the conventional trapping wavelength of $1 0 7 0 \ \mathrm { n m }$ , the authors Ref. [248] developed an analogous “magic polarisation” scheme wherein the AC Stark shifts of the ground and excited states of a transition (here at 626 nm) are tuned to be identical. The authors then apply their findings to develop a Doppler cooling scheme on a trapped sample with improved efficiency. Large tensor light shifts close to the $6 2 6 \mathrm { n m }$ transition of Dy were also used to generate effective spin-coupling terms [181, 182]; see also Sec. VI D 2. Other important consequences of these large vector and tensor polarisabilities in Lns relate to increasing the strength of Raman coupling schemes and to the possibility of efficient spin-orbit coupling; see Sec. VI D 1.

The unconventional features of atom-light coupling in these magnetic atoms come into play in various ways in this review; see in particular Secs. VI and VII B. Experiments have only begun to explore the possibilities that are offered by the magnetic atoms’ electronic structure for the purpose of manipulating the properties of dipolar quantum gases.

# D. Feshbach resonances in magnetic atoms

Collisions in ultracold dilute gases are known to be well described within two-body scattering theory [10, 79, 266]. When the interparticle interaction potential is short ranged, as is the case for the van der Waals force, the scattering at ultralow temperatures is characterised by a single parameter, the scattering length $a$ [267]. In brief, $a$ describes the phase shift $\delta _ { 0 }$ between the incoming and outgoing waves describing the relative motion of two atoms colliding under the influence of the total interparticle interaction $V ( r )$ at vanishing energy, where $r$ is the atomic separation; see Sec. III A for details. This simple picture is modified when accounting for the internal spin degree of freedom of colliding atoms. This can cause $a$ to be spin-dependant. Moreover, magnetic fields can shift the relative energy of different spin collisional channels. In the presence of coupling between different channels, this induces resonant collisions at particular field values. These are called Fano-Feshbach resonances—Feshbach resonances (FRs) for short—and we now review their key properties and primary applications. We will then provide details particular to the case of magnetic atoms. See Refs [7, 10, 268, 269] for more information.

A collisional channel is defined by a set of bare internal states of the two free atoms associated with a given partial wave component of their relative motion. These partial waves are represented as spherical harmonics with quantum numbers $\ell$ and $m _ { \ell }$ for the norm orbital angular momentum and its projection, respectively; see Sec. III A for details. Each collisional channel corresponds, by projection of $V ( r )$ , to a distinct molecular (scattering) potential $V _ { \mathrm { c h } } ( r )$ . In the context of FRs, the different channels can be coupled by off-diagonal terms of the potential at finite $r$ . In addition, the asymptotic values of $V _ { \mathrm { c h } } ( r  \infty )$ , so-called dissociation thresholds, may be tuned relative to one another, e.g., via the Zeeman effect if the two channels have different magnetic moments. Note that for bosons (fermions) in the same spin states, only channels with even (odd) values of $\ell$ are allowed.

Two atoms collide in the entrance channel, defined by the internal states in which they are prepared, and typically $\ell \ = \ 0$ [270]. The initial state of the pair, also called scattering state, lies in the continuum of the associated scattering potential, with a small (kinetic) energy $E$ above the dissociation threshold $E _ { \mathrm { o } }$ . The entrance channel is thus an open channel for the collision, as the atoms can be infinitely far away in this channel. A FR in the collision of the two atoms occurs when a bound state of a different (closed) channel couples to the entrance channel. The closed channel has an energy $E _ { \mathrm { c l } }$ that can be tuned around $E$ [271, 272]. This second channel is closed because its dissociation threshold is higher than $E$ and the atoms can not reemerge from the collision in this channel; i.e., $| r | \to \infty$ . The coupling term between the two channels induces a mixing of the scattering and bound states, and the atoms, during their approach, can be temporarily captured in a quasi-bound state. This behaviour resonantly alters the scattering properties of the pair, resulting in a change in $a$ .

The FRs are a particularly convenient tool in ultracold atomic systems for changing the scattering length thanks to the ease with which one may tune the relative energy of the channels $E _ { \mathrm { c l } } - E _ { \mathrm { o } }$ , in particular using magnetic fields. These magnetic FR allow $a$ to effectively vary with the magnetic field $B$ around the resonance centre

$B _ { 0 }$ a s

$$
a ( B ) = a _ { \mathrm { b g } } \left( 1 - \frac { \Delta } { B - B _ { 0 } } \right) ,
$$

where $a _ { \mathrm { b g } }$ is the background value away from any resonance. That is, $a _ { \mathrm { b g } }$ is the scattering length of the single open channel. $\Delta$ is the resonance width and relates to strength of the coupling between the bound and scattering states [273].

We note that, besides magnetic FRs, optically induced FRs are also possible. These utilise an open channel involving the electronically excited state. Optical control of FRs open new prospects beyond magnetic tuning, as it allows for ultrafast and local control of the interparticle interactions. This idea has been theoretically proposed [274, 275] and experimentally realised in alkali [276–278], alkali-earth [279, 280] and non-magnetic Ln atoms [281, 282]. It has not yet been applied to magnetic atoms. Yet, the rich atomic spectra of magnetic Lns (see e.g. Sec. II C) make optical FRs promising candidates for controlling $a$ while minimising heating and atom loss associated with photo-association and light-induced inelastic collisions; see e.g. [283]. Finally, we note that magnetic FRs could also be controlled optically, using state-dependent light shifts. Such a tuning was demonstrated with alkali atoms [284–289]. This technique may also bear fruit in magnetic atomic systems thanks to the large spin-dependence of their light coupling.

In addition to $a$ tuning, the FR provides access to a weakly-bound dimer (i.e., molecule) state. This is the closed-channel bound state dressed by the open-channel scattering state. Close to the resonance, the dimer becomes extremely weakly bound and its binding energy and size conform to universal scaling laws, which are solely dictated by $a$ and are insensitive to short-range details. It is called a halo dimer because of its large spatial extent. This weakly-bound dimer state can be populated through a dynamical tuning of $E _ { \mathrm { c l } } - E _ { \mathrm { o } }$ via, e.g., a ramp of the $B$ -field. This leads to the formation of so-called Feshbach molecules [269, 290–292]. We note that such molecules can be further transferred to a more deeply bound state via coherent optical adiabatic transfer schemes [293].

In the case of alkali-metal atoms in their absolute ground state, the coupling between the channels involved in magnetic FRs is of hyperfine origin. In magnetic atoms, the coupling can be of a distinct origin due to the anisotropy of the interparticle interaction potential. This anisotropy couples channels of different $\ell$ and $m _ { \ell }$ and thus may yield FRs; see also Secs. I C 2, I C 3. We note that the bosonic isotopes of Cr, $\mathrm { E r }$ , and Dy do not possess hyperfine structure, unlike alkali atoms. Thus, in these atoms, the hyperfine FR mechanism is absent, and FRs arise from only interaction anisotropy. In contrast, their fermionic isotopes possess hyperfine structure, and thus both coupling mechanisms are present. Furthermore, we highlight that magnetic atoms have large total $F ^ { \dagger }$ in their ground state. This means that there are many more collision channels that can be coupled than in alkali-metal atoms. Finally, we note that the long-range character of the DDI also enables entrance channels of $\ell \neq 0$ , even for ultracold temperature, increasing once more the number of channels that must be accounted for in the collision problem. Next, we review the collisional properties of Cr and Ln atoms, respectively.

![](images/09fc0da97870c7a103baa3e95543cd6dac69ab2e0da4da696031c6ffc3c3435b.jpg)  
FIG. 2: Temperature variations of two FR line-shapes (a) around $B = 8 . 3 G$ in $^ { 5 2 } C r$ , adapted from Ref. [294] and $( b )$ around $\begin{array} { l } { B } \end{array} = \begin{array} { l } { 1 . 5 G } \end{array}$ in $^ { 1 6 8 } E r$ , adapted from Ref. [295] (Temperature values given in legend.) In (a), the line shape has been reinterpreted in terms of loss parameter, and the solid line results from an analytical modelling of the loss process with a $d$ -wave entrance channel. In (b), the solid lines result from coupled-channel calculations on the three-body process in such a channel.

The bosonic isotopes of Cr have a spherical orbital wave function in its ground state $^ { \prime \prime } S _ { 3 }$ ) and no nuclear spin. Thus, the short-range van der Waals scattering of two ground-state bosonic Cr atoms is isotropic and no interaction of hyperfine origin between collision channels arises. Consequently, a single anisotropic DDI potential explains the emergence of FRs in this case. The DDI couples channels with orbital angular momentum $\Delta \ell = 0 , 2$ , and the total spin can vary by $\Delta S = 0 , 2$ ; see also Secs $\therefore \quad , \quad$ . Thanks to its relative simplicity, the scattering features in this case are very well accounted for by multichannel scattering calculations.

The first observation of FRs between spin-polarised $^ { 5 2 } \mathrm { C r }$ atoms in their absolute ground state (leading to a total spin of the entrance channel $S ~ = ~ 6$ , $\begin{array} { r l } { m _ { S } } & { { } = } \end{array}$ $- 6 )$ revealed the existence of 14 FRs between 0 and 600 G [196, 296]. Coupled-channel calculations show that the relevant closed channels are those with $\ell = 2 , 4$ and with $S = 2 , 4$ and 6. This means that second and fourthorder mixing are relevant. In addition, it was shown that essentially a single closed-channel bound state contributes to each FR. In this way, all except one of the

FRs could be assigned. The DDI provides the necessary coupling terms, but only slightly affects the FR positions through the molecular potential $V _ { \mathrm { c h } } ( r )$ themselves. Finally, the background scattering length can also be theoretically estimated from the comprehensive coupled-channel calculations, giving $a _ { \mathrm { b g } } = 1 1 2 ( 1 4 ) a _ { 0 }$ .

Remarkably, two FRs, the ones with smallest $B _ { 0 }$ , are explained by a $d$ -wave entrance channel resonant with a $s$ -wave closed channel [196]. Such a $d$ -wave entrance channel is intrinsic to the DDI coupling mechanism. One of these two FRs was later experimentally characterised [294]. The corresponding atom loss feature is asymmetric in $B$ and shows an unconventional dependence with decreasing temperature, shifting to lower $B$ and with decreasing width and amplitude; see Fig. 2a. The atom losses are shown to occur via three-body recombination, but with a recombination coefficient depending linearly on the density $n$ , in contrast to the usual $n ^ { 2 }$ dependence of three-body processes. This unusual behaviour is attributed to the slow tunnelling through the centrifugal barrier in the collision channel, and the adiabatic elimination of the fast collision with a third colliding atom. A precise analysis of this resonance yields a more accurate estimate of the scattering length: $a _ { \mathrm { b g } } = 1 0 2 . 5 ( 4 ) a _ { 0 }$ [294].

Besides the scattering between atoms in their lowest spin states, the analysis of Feshbach spectra and their comparison to coupled-channel calculations also provides information about the strengths of the spin-dependent scattering. Generally speaking, scattering strengths depend on the total spin of the pair of atoms colliding, which is preserved during the collision in absence of the DDI. The total spin $\boldsymbol { S }$ of the pair defines a spin channel, corresponding to a given molecular potential and thus to a distinct scattering length $a _ { S }$ . The spin-polarised case of $\mathrm { C r }$ corresponds to $S = 6$ and the background scattering length mentioned above is actually that of $a _ { S = 6 }$ . In Ref. [196], additional spin channels were characterised, with $a _ { S = 4 } = 5 6 a _ { 0 }$ , $a _ { S = 2 } = - 7 a _ { 0 }$ [196]. Additional analysis of bulk spin relaxation dynamics resulted in a determination of $a _ { S = 0 } ~ = ~ 1 3 . 5 a _ { 0 }$ [197]; see also Sec. III. The large differences between these values provide evidence for the importance of spin-dependent scattering in Cr. Knowing this is important for investigating spinor physics with Cr; see Secs. VI–VII.

# 2. Feshbach resonances in magnetic Lns

The case of magnetic Ln atoms is more intricate than that of Cr because of their electronic structure is not spherically symmetric. This results in an anisotropy of the van der Waals interaction, which changes the shortrange physics [206, 207, 210]. Because both short- and long-range interaction potentials are anisotropic in Lns, they both induce coupling between molecular channels, which leads to FRs. Both anisotropic potentials were predicted to substantially contribute to the character, distribution, and prevalence of FRs in collisions among bosonic atoms [206]. A large number of scattering channels contribute to each resonance, making it hard for coupled-channel calculations based on partial-wave decomposition to converge. Indeed, in Ref. [206], $\ell$ up to 10 were considered, and later, this was extended up to 20 [297]. An analytical model estimates that $\ell$ ’s up to $\gtrsim 4 0$ must be considered to reproduce experimental observations [297]. Needless to say, no perturbative treatment can be safely applied.

First experimental observations of FRs in magnetic Lns were performed on $^ { 1 6 8 } \mathrm { E r }$ and revealed an unusually large number of FRs within a narrow magnetic field range [173]. Soon after, theory work of Ref. [206] predicted that the high Feshbach spectral density is a general feature of magnetic Ln atoms. Systematic highresolution trap-loss spectroscopy later extended the observations of dense FRs in two bosonic $\mathrm { E r }$ isotopes from 0 to 70 G [297]; see Fig. 3a. A statistical analysis of the Feshbach spectra revealed correlations between the resonance locations, with very similar characteristics for the two bosonic isotopes. Based on the formalism of random matrix theory, these correlations were quantified and found to be consistent with chaotic behaviour in the scattering of these atoms; see Fig. 3b. The fermionic case was also studied and shows a ten-fold larger density of FRs, increasing from 2.7 resonances per Gauss for the bosons to 25.7 resonances per Gauss for the fermions. This was attributed to the additional role of the hyperfine structure. A similarly high density of FRs was concurrently reported for four Dy isotopes, three bosonic and one fermionic, up to 6 G [298]. These measurements also revealed a much higher density for the fermionic isotopes as well as an intriguing temperature dependence of the Feshbach spectrum.

The chaotic behaviour of both $\mathrm { E r }$ and Dy was thoroughly analysed and compared in the collaborative work of Ref. [295]. Interestingly, even though Dy shows a higher density of FRs (4.3 resonances per Gauss), the degree of correlation in the resonance locations is similar for the two species, and in fact, slightly larger for $\mathrm { E r }$ . This work also introduced a new scheme for coupled-channel calculations, employing a basis comprised of $B \ = \ 0 \mathrm { G }$ Hamiltonian eigenstates. Such a basis is more amenable to non-central scattering potentials, allowing more rapid computational convergence. This theoretical analysis established the leading role played by the van der Waals anisotropy in the chaotic scattering behaviour: the DDI alone cannot account for the correlations. The slightly larger degree of correlation observed in Er FRs may be attributed to a larger short-range anisotropy.

The temperature dependence was further analysed in Ref. [295]. At a statistical level, spectra at higher temperature exhibit a larger density of resonances with the degree of correlation that is nearly unchanged. The temperature dependence of individual resonances reveals behaviour compatible with $d$ -wave entrance channel predictions, similar to the case in Cr [294]; see Fig. 2b. The weakening and disappearance of higher partial-wave entrance channels in the ultracold regime were proposed as an explanation for the variation of the FR density with temperature. A subsequent work using Ho atoms also revealed a dense FR spectrum as well as a similar temperature dependence [299]. In contrast to the $\mathrm { E r }$ system [295], the chaotic character of the Ho FR spectrum was observed to increase with $T$ , ranging from intermediate at $T$ $2 \mu \mathrm { K }$ to almost fully chaotic at $T$ $1 2 \mu \mathrm { K }$ . In the high-temperature regime, the shifts of Ho $d$ wave resonances deviate from a linear dependence on $T$ which is expected at low temperatures, as observed in Er [295].The authors speculate that this behaviour is responsible for the observed change in FR statistics.

![](images/9c45b05fe3717cf68bc8ec2be792566f6ec4d7ccdf434bf5f61245d12b6d2540.jpg)  
FIG. 3: (a) Trap loss spectroscopy measurements performed on a cold $\left( T = 3 3 0 n K \right.$ ) gas of $^ { 1 6 8 } E r$ polarised in its absolute ground state, measured after holding 400-ms at B. (b) Nearest-neighbour spacing distribution from spectrum (a) (dots). s is the spacing in $B$ , renormalised by the mean spacing (inverse of the resonance density). It is compared to the uncorrelated Poisson distribution (dashed line) and to the fully-correlated Wigner Dyson distribution (dashed dotted line) via a fit to the Brody distribution (solid line), measuring the degree of correlation. The short dashed line shows results from coupled channel calculation with ℓ up to 20. Figure adapted from Figs. 1a and 4a from Ref. [297]

Because of the complexity and non-perturbative character of the coupling between channels, the FRs cannot in general be assigned to a particular bound state. A few assignments were, however, assigned in the low magnetic field region of $\mathrm { E r }$ [76]. This was accomplished by comparing measurements of the molecular state binding energy with coupled channel calculations.

Broader FR resonance can be observed on top of the forest of narrow FR features in the Ln atoms. Such features were already observable in the early FR scans of Ref. [297], where, e.g., a 3.5 G-wide FR is found at $5 7 6$ for $^ { 1 6 8 } \mathrm { E r }$ ; see Fig. 3a. A detailed study of such features was performed in $^ \mathrm { 1 6 4 }$ Dy [77] up to $6 0 0 \mathrm { G }$ and revealed several more broad features. Two of these broad features were extensively characterised via spectroscopy of the molecular state binding energy. Universal properties were found that are characteristic of open-channeldominated $s$ -wave FRs. Particularly noticeable is the decoupling of the broad FR from the chaotic background of the narrow FRs, allowing one to observe the universal behaviour of the halo dimer binding energies over several Gauss to the low- $B$ side of the FRs; see Fig. 4. A similar study was later reported in $^ \mathrm { 1 6 2 }$ Dy [187]: two broad FRs with $s$ -wave character are found at magnetic fields in the

20–30 G range. Broad FRs are also observed in Ho [299].

$a$ . Scattering length measurements As is the case for other multi-electron atoms [10], ab initio calculations fail to predict the scattering lengths of Ln atoms. Instead, these must be experimentally measured. A common technique involves the observation of cross-rethermalisation: one observes the rethermalisation dynamics of a thermal sample after exciting it along one of its the three spatial directions [300]; the thermalization rate is proportional to the elastic cross section, which in turn is proportional to the square of the scattering length. The proportionality relies on a theory prediction for the average number of collisions necessary for thermalisation and depends on the particular partial waves and interaction involved in the collision [301]. Bohn et al.[302] calculated this for the anisotropic DDI, which was verified experimentally in Ref. [303] using spin-polarised fermionic $\mathrm { E r }$ . This theory allowed Tang et al. [304, 305] to extract scattering lengths from cross-rethermalisation measurements of two Dy isotopes [304, 305]. The theory-experiment comparison resulted in $a \ = \ 1 2 2 ( 1 0 ) a _ { 0 }$ for $^ \mathrm { 1 6 2 }$ Dy and $a = 9 2 ( 8 ) a _ { 0 }$ for $^ \mathrm { 1 6 4 }$ Dy at $B = 1 . 5 8 \mathrm { G }$ . This field is at least $0 . 1 \mathrm { G }$ away from any FR in either species. These $a$ - values, as well as their $B$ -dependence, were also measured in Ref. [306] using a different method involving a detailed analysis of the anisotropic expansion of thermal gases after release from their confining potentials., The analysis relied on the competition of the DDI and the contact interaction; see Sec. $\cdot$ for details. The results are consistent with the cross-rethermalisation experiments: $a = 1 5 4 ( 2 2 ) a _ { 0 }$ for $^ \mathrm { 1 6 2 }$ Dy and $a = 9 6 ( 2 2 ) a _ { 0 }$ for $^ \mathrm { 1 6 4 }$ Dy, but with larger error. A similar measurement near a 5 G FR in $^ \mathrm { 1 6 2 }$ Dy yielded a background scattering length of $a = 1 5 7 ( 2 4 ) a _ { 0 }$ , which is consistent with the lower-field measurement, but larger than that obtained with crossrethermalization [304, 305]. A third scheme relies on the universal scaling of the molecular binding energy close to broad FRs to extract scattering lengths in Dy. Such an analysis used a relatively high-field resonance in $^ \mathrm { 1 6 4 }$ Dy to obtain $a _ { \mathrm { b g } } = 9 1 ( 1 6 ) a _ { 0 }$ [77], which is in good agreement with the low- $B$ values of Refs. [304, 306]. A similar study in $^ \mathrm { 1 6 2 }$ Dy yielded $a _ { \mathrm { b g } } = 2 2 0 ( 5 0 ) a _ { 0 }$ [187]. This is consistent with the $a = 1 5 4 ( 2 2 ) a _ { 0 }$ measurement in Ref.[306], but larger than both the 5-G measurement in Ref.[306] and the $a = 1 2 2 ( 1 0 ) a _ { 0 }$ measurement of Ref. [304].

For $\mathrm { E r }$ , preliminary cross-rethermalisation measurements were first reported in Ref. [245] for the four bosonic isotopes in the low-field regime. A simpler analysis of the rethermalisation rates than used in Ref. [304] yielded $a _ { \mathrm { b g } } ~ = ~ 8 1 ( 1 0 ) a _ { 0 }$ for $^ { 1 6 4 } \mathrm { E r }$ , $a _ { \mathrm { b g } } ~ = ~ 7 2 ( 1 3 ) a _ { 0 }$ for $^ { 1 6 6 } \mathrm { E r }$ $a _ { \mathrm { b g } } ~ = ~ 2 0 0 ( 2 3 ) a _ { 0 }$ for $^ { 1 6 8 } \mathrm { E r }$ , and $a _ { \mathrm { b g } } ~ = ~ 2 2 1 ( 2 2 ) a _ { 0 }$ for $^ { 1 7 0 } \mathrm { E r }$ . In $^ { 1 7 0 } \mathrm { E r }$ , the background scattering length was first thought to be negative, but more recent measurements have questioned this [188]. These $\operatorname { E r } a _ { \mathrm { b g } }$ measurements were taken by averaging data obtained at different $B$ -values between $0 . 2 \mathrm { { G } }$ and $^ { 1 \mathrm { G } }$ , away from FRs. A more precise estimate was later developed to extract $a$ and its $B$ dependence by loading a quantum gas into a deep 3D lattice and performing lattice-modulation spectroscopy [307]. This probes the Mott-insulator excitation gap, which is related to the scattering length through the on-site interaction energy; see also Sec. VII B. This technique yielded $a = 1 3 7 ( 1 ) a _ { 0 }$ at $0 . 4 \mathrm { G }$ for $^ \mathrm { 1 6 8 }$ Er [307], and for $^ { 1 6 6 } \mathrm { E r }$ , it was used to make a sequence of measurements of $a$ versus $B$ from 0-to-2.5 G [250]. In this range, the data are well-described by overlapping FRs with a $B$ -dependent background scattering length $a _ { \mathrm { b g } } ( B ) =$ $6 2 ( 4 ) + k B$ , with $k = 5 . 8 ( 1 . 2 ) a _ { 0 } / \mathrm { G }$ .

In the case of Ho, recent experiments reported scattering length values using cross-rethermalisation. The first such measurement yielded a background value of $a _ { \mathrm { b g } } = 1 4 4 ( 3 8 ) a _ { 0 }$ [299], while a subsequent experiment reported $a _ { \mathrm { b g } } = 9 0 ( 1 1 ) a _ { 0 }$ via a more extensive set of measurements [75].

We note that a debate regarding the exact values of the scattering lengths in bosonic $\mathrm { E r }$ and Dy in the quantum degenerate regime has arisen in light of measurements of these parameters extracted from the many-body physics of the droplet and supersolid states; see also Sec. V. These differ from the two-body collision-based methods described above. Central to the debate is the appropriateness of the description of the many-body physics based on perturbative mean-field and local-density approximations, on the one hand, and on the other, regarding the relevance, in the regime of interest, of corrections beyond the Born approximation and the role of the momentum dependence in the two-body scattering description. That is, the many-body theory used to extract scattering lengths in such finite-size quantum systems could be as problematic as the use of ultracold thermal gases in the former collision-based measurements. Those questions are beyond the scope of the current section, but additional discussions may be found in Secs. V B and V $\cdot$ .

Concerning the scattering length itself, the most extended discussions focus on the $^ \mathrm { 1 6 4 }$ Dy case. Studies of single quantum droplets provide estimates of the background scattering length via a theory-experiment comparison of different many-body properties, namely the critical atom number for the existence of a self-bound droplet state and the frequencies of droplet’s elementary excitations [247, 308, 309]. These investigations yield values of $a _ { \mathrm { b g } } ~ = ~ 6 2 . 5 a _ { 0 }$ and $a _ { \mathrm { b g } } ~ = ~ 6 9 ( 4 ) a _ { 0 }$ at $B \approx 6 . 6 \mathrm { G }$ and $B = 0 . 8 \mathrm { G }$ , respectively. While they are mutually compatible, they are consistently lower than the measurement results in Refs. [77, 304, 306] obtained with thermal gases. Ferrier-Barbut et al. [308] speculate that the discrepancy could come from the different temperatures of the samples used in those two sets of experiments and related momentum dependence of the scattering [310]. Reference [309] extends the measurements of the critical atom number of a self-bound quantum droplet (see Sec. V C 5) and was able to extract the ratio between the background scattering lengths of the two dysprosium isotopes to be $a _ { \mathrm { b g , 1 6 2 } } / a _ { \mathrm { b g , 1 6 4 } } = 2 . 0 3 ( 6 )$ . Using $a _ { \mathrm { b g } } = 6 9 ( 4 ) a _ { 0 }$ for $^ \mathrm { 1 6 4 }$ Dy [308] yields a value of $a _ { \mathrm { b g } } = 1 4 0 ( 7 ) a _ { 0 }$ for the background scattering length of $^ \mathrm { 1 6 2 }$ Dy. This agrees with most of the values obtained from thermal samples within their uncertainty [187, 304, 306]. In the $\mathrm { E r }$ case, we note that sensitive probes based on collective excitations of single macro-droplets [250], supersolids [311], and roton excitations of dBECs [312, 313] show a good agreement between experiment and theory using the lattice-calibrated scattering lengths values.

Finally, we note that little information is available on Ln spin-dependent scattering, as opposed to the wellcharacterised Cr system. One exception is the case of the two lowest energy weak-field seeking spin states of fermionic $^ { 1 6 7 } \mathrm { E r }$ , whose scattering have been experimentally investigated in Ref. [314]; see also Sec. VI. Extensive loss spectroscopy measurements were performed in a limited $B ^ { - }$ -field range (up to $2 \mathrm { G }$ ) and for varying mixture compositions. This enabled the identification of both intra-spin FRs and inter-spin FRs; spin-polarised loss spectra have also been observed in $^ \mathrm { 1 6 1 }$ Dy for its lowest energy weak-field seeking spin states [252]. Lattice modulation spectroscopy also characterised the $B$ -to- $a$ conversion close to a relatively broad inter-spin FR. The background scattering for the interaction of the two lowest spin-states is $a _ { \mathrm { b g } } = 9 1 ( 8 ) a _ { 0 }$ . Theoretical investigations have also investigated spin-dependant resonances [208].

An important difference between Lns and Cr lies in the origin of spin-dependent scattering. In contrast to Cr, the dominant effect in Lns arises from their orbital anisotropy (i.e., $L \neq 0$ ; see also Sec. II B). This induces an interaction term that couples the angular momentum of each individual atom to the orbital momentum of the pair and results in sets of molecular potentials with very different character versus Cr atoms. More systematic studies, especially experimental, are needed to fully elucidate the spin-dependent collisional physics. A relevant open question relates to the density of the Feshbach spectra in Ln spin mixtures and in fermionic Ln isotopes. Regarding the latter, the density of FR spectra at high field in fermionic Dy seem to be spin-dependant [252]. Ericson fluctuations, known from resonances in nuclear physics, may provide an appropriate framework for explicating the field dependence of the overlapping loss spectra [315] observed in Ref. [252]. Interspecies scattering involving Ln atoms is also of recent interest [188, 189, 316, 317].

# 3. Feshbach molecules of magnetic atoms

Besides tuning of $a$ , FRs provide the ability to associate a pairs of free atoms into a loosely bound molecule [21, 269, 290–292]. A FR couples two states, the state of the two free particles scattering in the entrance channel and the bound state of the closed channel. The relative energy of the two states is tunable via the $B$ -field thanks to their different magnetic moments. The coupling of the two states yields an avoided crossing at $B = B _ { 0 }$ where their bare energies coincide. By ramping $B$ across the resonance (from $B > B _ { 0 }$ to $B < B _ { 0 }$ ), one can then drive the population of the molecular state by (adiabatically) following the low-energy state [290, 318– 322]. Alternative approaches use small-amplitude modulation of $B$ at a frequency resonant with the bound-state energy for $B \lesssim B _ { 0 }$ [323, 324], or even further away from the FR via radiofrequency coupling [325, 326]. Such protocols are commonly used in alkali metal experiments, with typical conversion efficiency of few tens–of–percents in the bosonic case and close to unity in the fermionic case. Note that these molecules are not in their internal ground-state, but in a highly excited (rovibrationnal) state. Close to the FR, the properties of the weaklybound molecule, referred to as a halo-dimer, follow a universal behaviour.

By producing Feshbach molecules of magnetic atoms, one creates ultracold gases of dipolar particles with even larger permanent dipole moments. Indeed, compared to the bare atoms, the mass $m$ of the molecule is doubled while the magnetic moment $\mu$ is also nearly doubled, resulting in a dipolar length $a _ { \mathrm { d d } } \propto m \mu ^ { 2 }$ eight times longer.

An experiment using $\mathrm { E r }$ has demonstrated and studied the production of an ultracold sample of $\mathrm { E r _ { 2 } }$ Feshbach molecules using $B$ -field ramps [76]. Pure molecular samples were produced by the resonant removal of the remaining free atoms. The gas contained about $2 \times 1 0 ^ { 4 } ~ \mathrm { E r _ { 2 } }$ at $3 0 0 \mathrm { n K }$ with typical densities of $\sim 8 \times 1 0 ^ { 1 1 } \mathrm { c m } ^ { - 3 }$ and lifetimes of $\sim 1 0 \mathrm { m s }$ . Ultracold samples of molecules in four different molecular states, associated with four different low-field FRs of $^ { 1 6 8 } \mathrm { E r }$ , were produced. The properties of the Feshbach molecules have been further measured, in particular the magnetic moment, which were found to be $\mu / \mu _ { \mathrm { B } } ~ > ~ 1 1$ for three of the four states. By contrast, the bare atomic value is $\mu / \mu _ { \mathrm { B } } \approx 7$ . The impact of the confinement geometry and relative dipole orientation on the scattering properties of the Feshbach molecules has also been investigated. In particular, a reduction of the relaxation rate in quasi-two dimensional geometry with out-of-plane dipole orientation was ob

served.

In the Cr case, the study of Feshbach molecules has focused on a single peculiar resonance with an $d$ -wave entrance channel [294, 327]. However, no ultracold sample has yet been produced. In this case, the molecular state is very short lived and studies have focused on the remarkable atom-loss behaviour associated with the special character of the resonance.

![](images/60702e75aa2e802c83b203fd8a247a12a4ee5526009591da244075faf879d52b.jpg)  
FIG. 4: Atom-loss spectrum (top) and measured molecular binding energy (bottom) of $^ \mathrm { 1 6 4 }$ Dy near a broad FR. The atom loss spectrum exhibits a very high density of narrow resonances and one broad feature. The binding energy of the weakly bound dimer displays a universal quadratic behaviour (dashed line). The very weak variation of the binding energy as a function of magnetic field shows that the dimer has a magnetic moment very close to that of two free atoms $\mu \approx 2 0 \mu _ { \mathrm { B } }$ . Data originally published in [77].

In the Dy case, studies have focused on the properties of the halo dimers close to the broad FRs found at relatively large $B$ in two bosonic isotopes [77, 187], see also Sec. II D 2. The corresponding magnetic moments range from $\mu \approx 1 8 \mu _ { \mathrm { B } }$ to $\mu \approx 2 0 \mu _ { \mathrm { B } }$ ; see Fig. 4. A striking observation is that these halo dimers decouple from the many bound states coming from the overlaid forest of narrow FRs. This makes the broad FRs very promising for the production of ultracold gases of highly magnetic molecules. They have not yet been investigated, but this constitutes an interesting prospect for future work.

# E. Comparison between the different systems

Table I summarises the electronic, isotopic, scatteringrelated properties as well as the characteristics of all the available degenerate quantum gases for all isotopes, both bosonic and fermionic, of the highly magnetic elements, Cr, $\mathrm { E r }$ and Dy. The background $\varepsilon _ { \mathrm { d d } }$ varies among the elements and isotopes; e.g., it is $\varepsilon _ { \mathrm { d d } } \sim 0 . 1 6$ for $\mathrm { C r }$ , varies

TABLE I: Summary of the main atomic properties, scattering properties, and available quantum gases of highly magnetic atoms made of Cr, $\mathrm { E r }$ or Dy. The electronic ground state is denoted “g.s." The exchange statistic—fermionic (f) or bosonic (b)—is listed under “stat." The natural abundance is under “abound. denotes.: $I$ is the nuclear spin quantum number. $\varepsilon _ { \mathrm { d d } }$ is the background value $a _ { \mathrm { d d } } / a _ { \mathrm { b g } }$ . “Degenerate gas" lists the properties of the most populous gas of that isotope produced, as reported in journal articles. For all these, the BEC’s are almost pure; i.e., the thermal fraction is small.

<html><body><table><tr><td></td><td></td><td></td><td>atomg.s.μm(uB)stat.:isotope abund.</td><td></td><td>T</td><td>add(ao)abg(ao)</td><td></td><td>edd</td><td>degenerate gas</td></tr><tr><td rowspan="3">Cr</td><td rowspan="3">S3</td><td rowspan="3">6</td><td>b:52Cr</td><td>83.79% 0</td><td>15.3</td><td></td><td>102.5(4)[162]</td><td></td><td>0.150(6BEC,5 × 104 [167,168]</td></tr><tr><td>f:53Cr</td><td>9.5% 3/2</td><td></td><td>15.6</td><td></td><td></td><td>DFG, 103, ~ 0.6[175]</td></tr><tr><td>b:50Cr</td><td>4.35%</td><td>0</td><td>14.7</td><td>40(15)[328]</td><td>0.37(14none</td><td></td></tr><tr><td rowspan="6">Er H6</td><td rowspan="6"></td><td>b:54Cr b:168Er</td><td>2.36% 26.8%</td><td>0 0</td><td>15.9 66.3</td><td>unknown 137(1) [307]</td><td></td><td>none 0.484(3BEC,1.5 × 10° [173, 192, 245]</td></tr><tr><td>7</td><td>b:160Er</td><td>33.6% 0</td><td>65.5</td><td>68（5）</td><td></td><td>at0.96(7BEC, 105 [250]</td></tr><tr><td>f:167Er</td><td>23%</td><td>7/2</td><td></td><td>B=1G [250]</td><td></td><td></td></tr><tr><td>b:170Er</td><td>15%</td><td>0</td><td>65.9 67</td><td>preliminary</td><td>0.30(3)BEC,104[188]</td><td>DFG: 4× 104， = 0.1[174, 192, 245]</td></tr><tr><td>b:104Er</td><td>1.6%</td><td>0</td><td>64.7</td><td>estimate 221(22) [245] preliminary</td><td>0.8(1)</td><td>none</td></tr><tr><td>b:162Er</td><td>0.14%</td><td>0</td><td>63.9</td><td>estimate 81(10) [245] unknown</td><td></td><td>none</td></tr><tr><td rowspan="6">Dy</td><td rowspan="6">518</td><td rowspan="6">10</td><td>b:164Dy</td><td>28.3%</td><td>0</td><td>130.7</td><td>disagreeing estimates: 69(4) [308, 309]1.4(1)</td><td>1.9(1) or</td><td>BEC,1.5 × 104 [171,185,251], 3.5 × 104 [329], with typically sizeable ther- mal fraction remaining.</td></tr><tr><td>b:162Dy</td><td>25.5%</td><td>0</td><td>129.2</td><td>or 92（8) [77, 304,306] most estimates</td><td>are1.06(9)</td><td>precise0.92(5)BEC,105[249],5 × 104[190, 330]</td></tr><tr><td>f163Dy</td><td>24.9%5/2</td><td></td><td></td><td>122(10) [304]- 157(4) [306]</td><td></td><td>none</td></tr><tr><td></td><td></td><td></td><td>130</td><td></td><td></td><td></td></tr><tr><td></td><td>2%</td><td></td><td>127</td><td>unknown</td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr></table></body></html>

between $0 . 9 ~ \lesssim ~ \varepsilon _ { \mathrm { d d } } ~ \lesssim ~ 1 . 9$ for Dy isotopes, and is between $0 . 3 \lesssim \varepsilon _ { \mathrm { d d } } \lesssim 1$ for $\mathrm { E r }$ isotopes. All isotopes exhibit FRs, which provide opportunities for tuning $\varepsilon _ { \mathrm { d d } }$ ; see Secs. II D, IV, and V.

With respect to degenerate gases, all three species offer relatively large BECs of roughly similar sizes. The maximum population of the BEC depends on the isotope, not only because of its natural abundance, but also because of its scattering properties. In particular, isotopes with a background value of $\varepsilon _ { \mathrm { d d } } \gtrsim 1$ , or $\varepsilon _ { \mathrm { d d } } < 0$ (i.e., with a negative scattering length), are more challenging to condense. They typically require a tuning of $a$ during the evaporation process by setting $B$ close to a FR to stabilise the quantum gas at the mean-field level. This is in particular the case for the most abundant isotope of Dy, $^ \mathrm { 1 6 4 }$ Dy, for which the BEC numbers are otherwise smaller than for the $^ \mathrm { 1 6 2 }$ Dy isotope and $\mathrm { E r }$ ’s most populous BEC. In fact, we point out that, due to the extreme density of FRs in the spectra of open-shell Lns, the choice of the

$B$ value at which the evaporative cooling scheme is performed is a crucial parameter to adjust for all isotopes of $\mathrm { E r }$ and Dy, and even more so for their fermionic isotopes. The population of the achieved quantum gases greatly depend on it. Large and cold degenerate Fermi gases of Dy and $\mathrm { E r }$ are also possible due to the ability to perform direct evaporative cooling. The quantum degeneracy of fermionic Cr has been achieved, but so far, is smaller and not as cold with respect to the Fermi temperature.

# III. Ultracold dipolar scattering

The notion of scattering in the ultracold regime has been briefly introduced in Secs. I and II. We will now extend our overview on ultracold collisional physics before describing the special features of the scattering induced by the DDI. Topics include the universal properties of elastic dipolar scattering (i.e., coming from spinconserving collisions; see Sec. III B); the special features of inelastic dipolar scattering (i.e., dipolar relaxation), including its local character and suppression via exploiting quantum statistics and confinement (Sec. III C); and finally the anisotropic character of (elastic) dipolar scattering (Sec. III D).

# A. Relevant aspects of scattering theory

Collisions among atoms in dilute ultracold gases are described within quantum scattering theory, which accounts for the long-distance behaviour of the wavefunction encompassing the relative motion of two colliding atoms, the so-called collisional wavefunction [10, 79, 266]. In brief, any incident wave is decomposed in plane waves of momentum $\boldsymbol { k }$ , whose scattering yields outgoing spherical waves of amplitude $f ( k , n )$ in the direction ${ \boldsymbol { n } } = { \boldsymbol { r } } / r$ . The scattering amplitude $f$ directly relates to the interaction potential $V ( r )$ and, within the first-order ’Born’ approximation, $f$ simply reduces to the Fourier transform of $V ( r )$ . The scattering cross section $\sigma$ then corresponds to the spherical integration of the square norm of $f$ over the scattering direction $\begin{array} { r } { \sigma ( { k } ) = \int | f ( { k } , n ) | ^ { 2 } d ^ { 2 } n } \end{array}$ .

# 1. Partial wave expansion

In the case of an isotropic potential $V ( \pmb { r } ) ~ = ~ V ( \pmb { r } )$ , expanding the collisional wavefunction in spherical harmonics is a very powerful tool as each of the resulting radial waves are decoupled from one another. These are indexed by $\it l$ (and $m _ { l }$ ), corresponding to the quantum numbers for the orbital angular momentum norm (and projection). For an isotropic potential, only spherical harmonics with projection $m _ { l } = 0$ contribute, while in the case of anisotropic interactions, $m _ { l } \neq 0$ harmonics may also play a role. Each spherical harmonic component of the expansion is an independent solution of the 1D Schrödinger equation, where the potential $V ( r )$ is augmented by a centrifugal term $U _ { \mathrm { c } , l } ( r ) = \hbar ^ { 2 } l ( l + 1 ) / m r ^ { 2 }$ . For the isotropic case, asymptotically, the outgoing wave differs by only a phase shift $\delta _ { l }$ from the incoming wave. Therefore, the general scattering amplitude $f$ decomposes into

$$
\begin{array} { l } { { \displaystyle f ( k , \theta ) = \frac { 1 } { 2 i k } \sum _ { l = 0 } ^ { \infty } ( 2 l + 1 ) ( e ^ { 2 i \delta _ { l } ( k ) } - 1 ) P _ { l } ( \cos \theta ) } } \\ { { \displaystyle ~ = \sum _ { l = 0 } ^ { \infty } f _ { l } ( k , \theta ) , } } \end{array}
$$

where $\theta$ describes the angle between $\boldsymbol { k }$ and $\mathbfit { r }$ and varies between $0$ and $\pi$ . Here, $P _ { l }$ denote the ordinary Legendre

polynomials. The scattering cross section then reads

$$
\begin{array} { l } { { \displaystyle \sigma ( k ) = \sum _ { l = 0 } ^ { \infty } \sigma _ { l } ( k ) , } } \\ { { \displaystyle \sigma _ { l } ( k ) = \frac { 4 \pi } { k ^ { 2 } } ( 2 l + 1 ) \sin ^ { 2 } [ \delta _ { l } ( k ) ] . } } \end{array}
$$

# 2. Ultracold limit and short-range interactions

For an interaction of short range $b$ , we can define the temperature below which the system is in the ultracold collisional regime as $k _ { B } T \ll \hbar ^ { 2 } / m b ^ { 2 }$ . In this regime, the centrifugal barrier at $r = b$ is much larger than the typical kinetic energy of the colliding particles such that they do not feel the interaction potential in ${ \mathit { l } } > 0$ harmonics (they are reflected at $r > b$ ). Therefore, only ${ \mathit { l } } = 0$ contributes to the scattering.

$a$ . Scattering length: In the ultracold limit, the scattering amplitude and the cross section tend to finite values given by the $k  0$ limit of their ${ \mathit { l } } = 0$ contributions: $f \approx f _ { 0 }  - a _ { \mathrm { s } }$ , and $\sigma \approx \sigma _ { 0 }  4 \pi a _ { \mathrm { s } } ^ { 2 }$ . This is for the case of distinguishable particles given by the sum over all $\it l$ in Eq. (26); see Sec. $\cdot$ for the role of quantum statistics in scattering. The $s$ -wave scattering length $a$ is then the only (non-universal) parameter describing the ultracold scattering physics and it relates to the $s$ -wave phase shift via $a = \mathrm { l i m } _ { k \to 0 } \delta _ { 0 } ( k ) / k$ . Hence, in the ultracold regime, the details of the short-range interaction are all represented by the value of a single parameter. Moreover, potentials yielding the same value of $a$ are interchangeable. It is therefore useful to employ a particularly simple form of the potential, the contact pseudo-potential Us(r) = gδ(r), with g = 4π\~2a [9, 10, 79, 91, 331] [332].

$b$ . Power-law potentials and the case of van der Waals interactions: The scaling of $\delta _ { l } ( k )$ can be deduced from the scattering potential form by solving the associated 1D Schrödinger equation. As introduced in Sec. I, in the case of a power-law interacting potential $V ( r ) _ { . } =$ $V _ { n } ( r ) ~ = ~ - C _ { n } / r ^ { n }$ , one finds that $\delta _ { l } ( k )$ scales as $k ^ { 2 l + 1 }$ if $l < ( n - 3 ) / 2$ and as $k ^ { n - 2 }$ otherwise [79, 80]. Therefore, the ultracold regime described above only holds for potentials decreasing sufficiently fast, as $n > 3$ .

Typically, this condition is satisfied by the dominant interaction between two atoms in a dilute gas, the van der Waals interaction, which is an $n \ = \ 6$ power law. This scaling arises from the virtual exchange of photons between two fluctuating electric dipoles: while on average the electric dipole of each atom is zero (in the absence of an electric field), a dipolar fluctuation of the electronic distribution of one atom can distort the other’s, leading to the product $r ^ { - 3 } { \cdot } r ^ { - 3 }$ for the interaction dependence. The ultracold limit is defined (in the absence of a direct DDI) by $k _ { B } T \sim \hbar ^ { 2 } / m b ^ { 2 }$ . Associating $b$ with the van der Waals length $r _ { \mathrm { v d W } } = ( m C _ { 6 } / \hbar ^ { 2 } ) ^ { 1 / 4 }$ , we find that the ultracold limit is typically reached for temperatures of hundreds of $\mu \mathrm { K }$ .

In the ultracold limit, the scattering cross section for partial waves $\mathit { l } = 0 , 1$ at low collision energy $E = \hbar ^ { 2 } k ^ { 2 } / m$ follows the so-called Wigner threshold law [333]:

$$
\sigma _ { l } ( E ) \propto k ^ { 4 l } \propto E ^ { 2 l } ,
$$

while for $l > 2$ , $\sigma _ { l } ( E ) \propto k ^ { 6 } \propto E ^ { 3 }$ . Only the ${ \mathit { l } } = 0$ cross section does not vanish in the $E  0$ limit. This is in contrast to the case of interacting polarised dipoles in which $n = 3$ . In this case, the above scaling laws—based on the assumption of a short-range potential—are not valid, and we will see (Sec. III B) that all partial waves contribute.

# 3. Role of quantum statistics

Quantum statistics plays a prominent role in the ultracold regime, as the wavefunction should be appropriately symmetrised for collisions among identical particles, i.e., atoms of the same isotope in the same spin state. Indeed, the total collisional wavefunction of any pair of atoms—which is comprised of the tensor product of wavefunctions describing both their spin and orbital degrees of freedom—must be symmetric (antisymmetric) under particle exchange for bosons (fermions). For example, if their spin state is identical, then their motional state must be symmetric (antisymmetric), and thus only even (odd) $\it l$ partial waves contribute to the partial wave decomposition of Eqs. (25) and (26). These expressions may be rewritten as:

$$
f ( k , \theta ) = \frac { 1 } { i k } \sum _ { l = 0 } ^ { \infty } \epsilon ( l ) ( 2 l + 1 ) ( e ^ { 2 i \delta _ { l } ( k ) } - 1 ) P _ { l } ( \cos \theta ) ,
$$

where $\theta$ now varies between $0$ and $\pi / 2$ and $\epsilon ( l )$ depends on the statistics of the particles. For bosons (fermions), $\epsilon ( l ) = 0$ for $\it l$ odd (even) and $^ { 1 }$ in the diametric case $\it l$ even (odd). Similarly:

$$
\begin{array} { l } { \displaystyle \sigma ( k ) = \sum _ { l = 0 } ^ { \infty } \sigma _ { l } ( k ) , } \\ { \displaystyle \sigma _ { l } ( k ) = \frac { 8 \pi } { k ^ { 2 } } \epsilon ( l ) ( 2 l + 1 ) \sin ^ { 2 } [ \delta _ { l } ( k ) ] . } \end{array}
$$

For van der Waals interactions, the Wigner threshold law, Eq. (28), implies that the cross section for the lowest partial wave accessible to fermions, $\textit { l } = \textit { 1 }$ , vanishes as $E ^ { 2 }$ , while for bosons it tends toward a constant $8 \pi a ^ { 2 }$ . One key consequence lies in the fact that while ultracold bosonic gases can be evaporatively cooled to degeneracy via short-range elastic thermalizing collisions, identical fermions cannot.

# B. Universal elastic dipolar scattering

The above cross sections for van der Waals interactions may be said to be non-universal, in that they depend on a parameter $a$ that cannot be calculated from fundamental constants and fixed parameters of the system alone (like mass or quantum numbers). Indeed, $a$ is calculable ab initio within state-of-the-art methods only for light systems consisting of few electrons, such as hydrogen and helium [334, 335]. Accurately predicting the scattering length for more complex systems is very challenging. In contrast, we will see that it is possible to derive the dipolar cross section from first principles. This is due to the long-range nature of $V _ { \mathrm { d d } }$ , which often allows one to neglect the short-range part of the interaction potential. The longer-range character of the DDI ( $n = 3$ ) also leads to a different Wigner threshold law; namely, one that exhibits a constant, non-zero cross section even for identical fermions.

In contrast to the form of the $\delta _ { l } ( k )$ scaling presented above, for $n = 3$ , $\delta _ { l } ( k ) \sim k$ for all partial waves such that they all contribute to the scattering cross section even in the low-energy limit. Specifically, one can write $\delta _ { l } ( k ) \approx A k ^ { 2 l + 1 } + B k$ , where $A$ is the strength of the short-range part of the potential and $B$ is the strength of the long-range dipolar portion beyond the centrifugal barrier. $A$ and $B$ may be calculated under the first-order Born approximation [336] [302, 337–340]. This yields the total cross sections $\sigma _ { l }$ even ( $o _ { l }$ odd) for collision in even (odd) partial waves:

$$
\begin{array} { l } { { \displaystyle \sigma _ { l \mathrm { \ e v e n } } = 4 \pi a ^ { 2 } + \frac { 1 6 \pi } { 4 5 } D ^ { 2 } , } } \\ { { \displaystyle \sigma _ { l \mathrm { \ o d d } } = \frac { 1 6 \pi } { 1 5 } D ^ { 2 } , } } \end{array}
$$

with $D = S ^ { 2 } d ^ { 2 } m / \hbar ^ { 2 } = 3 a _ { d d }$ and $a d d$ as defined in Eq. (6). For indistinguishable bosons (fermions) $\sigma = 2 \cdot \sigma _ { l }$ even ( $\sigma = 2 \sigma _ { l \mathrm { ~ o d d } }$ ), while for distinguishable particles $\sigma =$ $\sigma _ { l \mathrm { \ e v e n } } + \sigma _ { l }$ odd.

Regardless of the exchange statistics of the atoms or the value of $a$ , the cross sections of dipolar atoms are finite and energy independent as $k  0$ . Since $D$ contains only fundamental constants and known quantum numbers, we may consider its contribution to the cross section universal—i.e., not depending on the details of short-range physics [340]. However, this statement ignores the effects of molecular potentials at certain values of magnetic field, as pointed out in Refs. [162, 337] and later discussed in Sec. III C 1. In addition, as the dipole strength is increased, corrections beyond the first-order Born approximation can cause $D$ to differ from its universal value [341].

An important consequence of the dipolar Wigner threshold law is the fact that identical dipolar fermions can evaporatively cool themselves even at low temperatures. This effect was used to cool spin-polarised fermionic polar molecules of KRb, using forced evaporation in an optical dipole trap, to $T \approx 2 T _ { F }$ [342]— most recently $T \approx 0 . 6 T _ { F }$ was achieved in a similar system [43]. Subsequently, a Fermi gas of identical, spinpolarised $^ \mathrm { 1 6 1 }$ Dy atoms was evaporated to $T / T _ { F } \sim 0 . 7$ with ${ \sim } 3 { \times } 1 0 ^ { 3 }$ atoms remaining [172]. The deeply degenerate regime was then reached with identical fermions of $^ { 1 6 7 } \mathrm { E r }$ [174], achieving $T / T _ { F } \approx 0 . 1$ with several times $1 0 ^ { 4 }$ atoms remaining. Similar temperatures and trap populations have also been reached with $^ \mathrm { 1 6 1 }$ Dy [252].

In Ref. [174], the spin purity of the sample was demonstrated and the elastic cross section was measured via cross-dimensional rethermalisation measurements [300]; see also Sec. III D 1. The extracted elastic cross-section at small $T / T _ { \mathrm { F } }$ was in good agreement with the universal value of Eq. (33) without adjustable parameters. Moreover, this study showed that the evaporation efficiency is among the highest achieved in an ultracold gas experiment. This stems from the Pauli suppression of inelastic processes for single-spin fermionic assemblies. Together, these studies demonstrated the efficacy of universal elastic dipolar scattering for degenerate Fermi gas production. This is a far simpler technique than sympathetic cooling with spin or species mixtures [343].

# C. Universal inelastic dipolar scattering: Dipolar relaxation

A large dipole moment enhances not only elastic dipolar scattering but also the inelastic rate; see also Sec. I C 3. While rapid elastic scattering is useful for efficient evaporative cooling, inelastic scattering—dipolar relaxation in this case—usually leads to gas heating and population loss. Inelastic dipolar scattering arises from the anisotropy of the interaction and causes atoms to change their spin state. In the presence of a finite external magnetic field, the degeneracy between the sublevels of the ground state hyperfine manifold is lifted via the Zeeman effect. In magnetic fields inducing Zeeman splittings larger than $k _ { B } T$ , atoms in metastable spin states relax to lower-energy, stronger-field-seeking Zeeman substates. The Zeeman energy is released into the orbital motion of the collision pair, conserving total orbital momentum by increasing the atoms’ kinetic energy. Atoms in magnetic traps whose spins have flipped to strongfield seeking states are lost. Lost too are atoms confined in traps—magnetic or otherwise—that are shallower than the released Zeeman energy. Otherwise, the relaxed atoms may remain confined but the change in their motional state leads to an overall heating after rethermalisation via elastic collisions. We note that for Zeeman splittings similar to or smaller than $k _ { B } T$ , the reverse process called dipolar promotion is allowed. This was used for demagnetisation cooling of a chromium gas; see Sec. VI C 3 a for details. For Zeeman splittings similar to the harmonic trap excitation energy $\hbar \omega$ , the change in the motional state of the colliding atoms is spectroscopically resolvable. This constitutes an atomic equivalent of the Einstein-de-Haas effect; see Sec. VI C for details and Ref. [17].

Only atoms in their lowest-energy spin state—i.e., the maximally stretched strong-field-seeking state—are immune to inelastic dipolar scattering (and spin exchange) [10]. In this section, we will show that dipolar relaxation can be seen as a short-range process for a largeenough magnetic field. As a direct consequence, we will describe how confinement can be used to control dipolar relaxation. We will also see that exchange statistics plays a role in these inelastic scattering processes. In particular, in Fermi gases, dipolar relaxation is suppressed for certain spin configurations.

# 1. Inelastic cross sections

The DDI in Eq. (2) admits non-zero matrix elements between pairs of atoms with differing spin and orbital angular momentum. The relevant selection rules are $\Delta m _ { F } ^ { 2 } = 0 , \pm 1$ for each of the two atoms $i = 1 , 2$ and $\Delta l = 0 , \pm 2$ for their orbital motion. To conserve total angular momentum, $\begin{array} { r } { \Delta m _ { l } + \sum _ { i = 1 , 2 } \Delta m _ { F } ^ { \ i } = 0 } \\ { . } \end{array}$ must be satisfied. The cross sections may be calculated in a firstorder Born approximation treatment [86, 162][344]. The appropriate expression, neglecting all other interatomic potentials [162], but including direct and exchange terms, is

$$
\begin{array} { l } { { \displaystyle \sigma = \left( \frac { m } { 4 \pi \hbar ^ { 2 } } \right) ^ { 2 } \frac { 1 } { k _ { \mathrm { i } } k _ { \mathrm { f } } } \left[ \int | \widetilde { V _ { \mathrm { d d } } } ( k _ { \mathrm { i } } - k ^ { \prime } ) | ^ { 2 } \delta ( | k ^ { \prime } | - k _ { \mathrm { f } } ) \mathrm { d } k ^ { \prime } \right. } } \\ { { \displaystyle + \left. \tilde { \epsilon } \int \widetilde { V _ { \mathrm { d d } } } ( k _ { \mathrm { i } } - k ^ { \prime } ) \widetilde { V _ { \mathrm { d d } } } ^ { * } ( - k _ { \mathrm { i } } - k ^ { \prime } ) \delta ( | k ^ { \prime } | - k _ { \mathrm { f } } ) \mathrm { d } k ^ { \prime } \right] , \displaystyle ( \tilde { \lambda } ^ { \prime } \mathrm { d } k ^ { \prime } ) } } \end{array}
$$

where $\tilde { V _ { \mathrm { d d } } } ( k )$ is the Fourier-transformed matrix elements of Eq. (2) and $\tilde { \epsilon } = [ 1 , 0 , - 1 ]$ for identical bosons, distinguishable particles, and identical fermions, respectively [17, 86]. The $k _ { \mathrm { i } }$ and $k _ { \mathrm { f } }$ are the initial and final relative wavevectors, respectively.

The cross sections for a collision channel starting with a two-body stretched spin-state $\begin{array} { r } { | F , m _ { F } = + F ; F , m _ { F } = } \end{array}$ $+ F \rangle$ and ending in either the same state ( $\Delta m _ { l } = 0$ ) or a single ( $\Delta m _ { l } = 1$ ) or double ( $\Delta m _ { l } = 2$ ) spin-flipped state form a hierarchy in powers of the spin $F ^ { ' }$ [86, 162]:

$$
\begin{array} { l } { { \displaystyle \sigma _ { 0 } = \frac { 1 6 \pi } { 4 5 } F ^ { 4 } \left( \frac { \mu _ { 0 } ( g _ { F } \mu _ { B } ) ^ { 2 } m } { 4 \pi \hbar ^ { 2 } } \right) ^ { 2 } [ 1 + \tilde { \epsilon } h \left( 1 \right) ] } , }  \\ { { \displaystyle \sigma _ { 1 } = \frac { 8 \pi } { 1 5 } F ^ { 3 } \left( \frac { \mu _ { 0 } ( g _ { F } \mu _ { B } ) ^ { 2 } m } { 4 \pi \hbar ^ { 2 } } \right) ^ { 2 } [ 1 + \tilde { \epsilon } h \left( \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } \right) ] \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } } , }  \\ { { \displaystyle \sigma _ { 2 } = \frac { 8 \pi } { 1 5 } F ^ { 2 } \left( \frac { \mu _ { 0 } ( g _ { F } \mu _ { B } ) ^ { 2 } m } { 4 \pi \hbar ^ { 2 } } \right) ^ { 2 } [ 1 + \tilde { \epsilon } h \left( \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } \right) ] \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } } . }  \end{array}
$$

In these expressions, $\sigma _ { 0 }$ is the elastic cross section discussed in the previous section; $\sigma _ { 1 }$ and $\sigma _ { 2 }$ are the cross sections for single spin-flip and double spin-flip dipolar relaxation processes, respectively. The kinematic terms $\begin{array} { r } { \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } = \sqrt { 1 + \frac { m \Delta E _ { \Delta m _ { l } } } { \hbar ^ { 2 } k _ { i } ^ { 2 } } } } \end{array}$ m∆E∆ml\~2k2 are dictated by the energy conservation condition and depend on the number $\Delta m _ { l }$ of spin flips involved in the collision. This is because $\Delta E _ { \Delta m _ { l } }$ depends on the change in kinetic energy of the atomic pair. Typically $\Delta E _ { \Delta m _ { l } } = \Delta m _ { l } \Delta E$ , where the Zeeman energy splitting $\Delta E \propto B$ . The value of $h \left( x \right)$ , defined on $( 1 , \infty )$ , monotonically increases from $h \left( 1 \right) = - 1 / 2$ to $h ( x  \infty ) = 1 - 4 / x ^ { 2 }$ [86, 162, 340].

The inelastic cross sections in Eqs. 36 and 37 contain only fundamental constants, atomic quantum numbers, and kinematic variables. Therefore, just like the elastic dipolar collisions, one may consider inelastic dipolar scattering a universal process in the first-order Born approximation limit. We note that Ref. [162] extended the cross section calculation to consider the effect of molecular potentials, and in particular, that of the short-range van der Waals interaction. The authors demonstrate theoretically and experimentally the effect of a finite scattering length on the dipolar relaxation cross section. While Eqs. (36-37) are good approximations at low magnetic field for which $k _ { \mathrm { f } } a \ll 1$ , the effect of the molecular potential becomes important when $B$ is such that $k _ { \mathrm { f } } a \gtrsim 1$ . This leads to deviations from universal behaviour (see below).

# 2. Inelastic cross section measurements

Experiments typically do not give direct access to the cross section, but rather to collisional rates. In a gas at thermal equilibrium, the dipolar relaxation collisional rate is deduced from the above cross section via $\beta _ { d r } = 2 \langle ( \sigma _ { 1 } + \sigma _ { 2 } ) v _ { \mathrm { r e l } } \rangle _ { \mathrm { t h } }$ , where $v _ { \mathrm { r e l } } = 2 \hbar k _ { i } / m$ describes the initial relative velocity between a pair of particle and $\langle . \rangle _ { \mathrm { t h } }$ defines a thermal average over the gas. This collisional rate has two contributions, one from collisions involving single spin-flipsrespectively. The latter is $\beta _ { d r } ^ { ( 1 , 2 ) } = 2 \langle \sigma _ { 1 , 2 } v _ { \mathrm { r e l } } \rangle _ { \mathrm { t h } }$ spin-flips.

and density achievable in magnetically trapped gases of highly magnetic atoms. In contrast, optical traps enable the trapping of all Zeeman sublevels, and in particular of the lowest of these states, thus providing immunity to dipolar relaxation and opening the way to reaching higher gas phase-space densities. Additional dipolar relaxation data for Cr [162] and Dy [165] at lower temperatures (100’s of nK) were performed using optical trapping [349]. In optical traps, because of limited trap depth, the particles involved in dipolar relaxation are typically lost (except at very low magnetic field, see Sec. VI for details) and loss spectroscopy enables the characterisation of the collision rate. These additional experimental results also agreed well with predictions using the first-order Born approximation. Because the first-order Born approximation is valid for only weakly interacting systems (stronger interactions cause higher-order terms to be non-negligible), these findings imply that the atoms’ DDI are not so strong as to invalidate this convenient approximation. To conclude, the first-order Born approximation should hold for dipolar collisions among any element (Dy being the most magnetic stable element of the periodic table) as long as the atomic density remains on a similar scale as investigated in these works. Such densities are typical of repulsive three-dimensional gases.

We note that the magnitude of $\sigma _ { 1 }$ for Dy at $B = 0$ can be up to $1 0 0 \times$ -larger than that of the alkali metal caesium. In addition, Ref. [165] pointed out that, while the ratio of $\sigma _ { 1 } / \sigma _ { 2 } = F ^ { - 1 } \ll 1$ for the stretched states of large-spin atoms, i.e., those with $| m _ { F } | \approx F$ , these same atoms exhibit large ratios of $\sigma _ { 2 } / \sigma _ { 1 }$ for states near $m _ { F } = 0$ . Indeed, $\sigma _ { 2 }$ for these states can be larger than $\sigma _ { 1 }$ for the stretched states: One cannot avoid dipolar relaxation simply by employing spin states near $m _ { F } = 0$ .

Following earlier studies of weakly magnetic atoms [345–347], dipolar relaxation was quantitatively studied in bosonic Cr [86, 348]. In these studies, $\mathrm { ^ { 5 2 } C r }$ was magnetically trapped in the highest energy (i.e., low-field-seeking) Zeeman sublevel $| S , m _ { s } \rangle = | 3 , 3 \rangle$ Dipolar relaxation in Cr takes the atoms initially in the state $\left| S , m _ { s } ; S , m _ { s } \right. = | 3 , 3 ; 3 , 3 \rangle$ to $| 3 , 3 ; 3 , 2 \rangle _ { S }$ $( | 3 , 2 ; 3 , 2 \rangle$ ) via a single (double) spin flip, where $\boldsymbol { S }$ denotes the symmetrised total wave function. The spin-flipped atoms may be lost from the trap or, if not, heat the gas due to their increased kinetic energy. The single and double spin-flip processes were characterised by studying both the rate of population loss from $| S , m _ { s } \rangle \ = \ | 3 , 3 \rangle$ and the rate of temperature increase in the gas. The overall dipolar relaxation rate was found to be four orders–of–magnitude larger than in weakly magnetic alkali-metal atoms [86]. Moreover, the data were in reasonable agreement with cross section predictions based on the first-order Born approximation given above, i.e., Eqs.(36) and (37).

Dipolar relaxation processes limit the temperature

# 3. Interaction range for dipolar relaxation

While the elastic dipolar interaction is long-ranged, Ref. [162] shows that the dipolar relaxation processes are intrinsically short-ranged, despite the same $1 / r ^ { 3 }$ scaling. This effect stems from the reduced overlap between the incoming and outgoing waves due to the increase in kinetic energy. Specifically, while the integral overlap of Eq. (34) for $\sigma _ { 0 }$ involves incoming and outgoing waves oscillating at the same frequency ( $k _ { \mathrm { i } }$ ), for inelastic collisions, the incoming and outgoing wavefunctions oscillate at different frequencies and become spatially mismatched at long distance, averaging to zero. Assuming a vanishingly small collision energy (low $T$ ), the range for this effective cancellation of the overlap, $R _ { \mathrm { d r } }$ , scales as $1 / k _ { \mathrm { f } }$ . This is set by the release of Zeeman energy in the spin relaxation. Hence, the range of dipolar relaxation decreases with $B$ following:

$$
R _ { \mathrm { d r } } ( B ) \approx { \frac { \hbar } { \sqrt { m g _ { F } \mu _ { \mathrm { B } } B } } } .
$$

In terms of partial-wave decomposition, dipolar relaxation occurs at the interparticle distance $R _ { \mathrm { d r } }$ that matches the distance at which the energy released in dipolar relaxation $\Delta E = g _ { F } \mu _ { B } B$ is compensated for by the centrifugal energy of the output channel. This simple statement assumes that the input channel is $\mathit { l } \mathit { \Theta } = 0$ , which is usually the case at low $T$ . (To satisfy the $\delta l = 2$ selection rule, the output channel is $l = 2$ .)

The localised character of dipolar relaxation has been revealed in the interplay between dipolar relaxation process and other interatomic (molecular) potentials in Ref. [162]. This results in variations of the relaxation rate with $B$ that deviate from that expected from the firstorder Born approximation when neglecting the effect of molecular potentials; specifically, the rate can dip far below this expectation at finite $B$ . This strong reduction of dipolar relaxation is shown to arise from a node in the initial wavefunction, preventing the presence of pairs of atoms at an inter-particle distance corresponding to the distance $R _ { \mathrm { d r } }$ at which dipolar relaxation occurs. This provides a factor of twenty reduction in the relaxation rate versus the rate predicted by the first-order Born approximation. This reduction relies on a non-universal molecular potential configuration of $\mathrm { ^ { 5 2 } C r }$ and it cannot be directly extended to the other highly magnetic atoms due in particular to the complexity of their Feshbach resonance spectrum.

# 4. Quantum statistics and dipolar relaxation: Bose enhancement and Fermi suppression.

Now that we have discussed the short-range nature of dipolar relaxation, we pivot to a discussion of how this fact combines with quantum statistics to affect relaxation rates. As with the short-ranged van der Waals interaction (see Sec. III A 3), one might expect a suppression of collisions between identical fermions due to quantum statistics. Indeed, this is the case, because identical fermions cannot surmount the centrifugal barrier of the lowest quantum statistically allowed partial wave ${ \mathit { l } } = 1$ : since identical fermions cannot closely approach, the short-ranged inelastic DDI does not lead to dipolar relaxation of their spin. Conversely, we will show below that the relaxation rate is enhanced for identical bosons, since they can collide on the barrierless $\mathit { l } \ = \ 0$ partial wave.

The dependence of the relaxation rate on quantum statistics is manifest in the form of the terms containing the ratios of incoming and outgoing momenta in Eqs. (36) and (37). At high $B$ and low $T$ , the kinematic terms diverge as $\langle \frac { k _ { \mathrm { f } } } { k _ { \mathrm { i } } } \rangle _ { \mathrm { t h } } \propto \sqrt { B / T }$ , where the th denotes a thermal average. In this limit, $\sigma _ { 1 }$ vanishes as $4 \sqrt { T / B }$ for indistinguishable fermions ( $\tilde { \epsilon } ~ = ~ - 1$ ), while it increases as $2 \sqrt { B / T }$ for indistinguishable bosons ( $\tilde { \epsilon } ~ = ~ + 1$ ) and is $\sqrt { B / T }$ for distinguishable particles ( $\dot { \epsilon } = 0$ ). The relative suppression ratio in this limit becomes $\sigma _ { 1 } ^ { \mathrm { f e r m i o n s } } / \sigma _ { 1 } ^ { \mathrm { b o s o n s } } \propto 2 T / B$ . This scaling exhibits two important facts: i) Dipolar relaxation rates grow worse for identical bosons versus $B$ , e.g., $\sigma _ { 1 }$ for bosonic Dy is $1 0 ^ { 3 }$ times larger than Cs’s at only a 1-G field; ii) $\sigma _ { 1 , 2 }$ can be suppressed for identical fermions, e.g., dipolar relaxation in fermionic Dy is only 10 $\times$ -worse than Cs’s at a few G, as experimentally demonstrated in Ref. [165]. It is remarkable, and counterintuitive, that the more exothermic the fermionic dipolar relaxation would be, the less likely they are to occur. This constitutes another striking example of the role quantum statistics plays in ultracold collisions.

![](images/307c3d3591f317631ffb1d29155e15108481ba7984eaede84120051544bce3a7.jpg)  
FIG. 5: Dipolar relaxation for bosonic $^ \mathrm { 1 6 2 }$ Dy ( $m _ { F } = + 8$ and fermionic $ { ^ { 1 6 1 } } \mathrm { D y }$ $m _ { F } = + 2 1 / 2$ ). Two-body collisional loss rates for $ { ^ { 1 6 2 } } \mathrm { D y }$ (squares) and $_ { 1 6 1 }$ Dy (triangles). Curves are calculated collisional loss rates using Eq. (36) at $T \approx 4 0 0 ~ \mathrm { n K }$ with no free parameters. Adapted from Ref. [165].

Figure 5 shows measured dipolar relaxation rates for spin polarised bosonic and fermionic Dy. Reference [165] also shows the fermionic suppression of dipolar relaxation of spin mixtures for processes in which the output state of the fermions consists of identical spins [162]. This corresponds to the time-reversed, state-changing process of indistinguishable fermions colliding. Importantly, the stability of a spin mixture in the lowest-two Zeeman states opens interesting prospects for the study of manybody spin physics. In particular, one could explore how the DDI impacts the BEC–to–BCS crossover (see also Sec. IV B) [14]. The stability of these states was also exploited for the long-lived implementation of artificial spin-orbit coupling in Dy gases; see Sec. VI D 1.

# 5. Control of dipolar relaxation via confinement

Confinement of atoms in lower dimensions can also suppress dipolar relaxation rates through the phase-space reduction of outgoing scattering channels. That is, the relaxation rate can be lowered via the interplay between the range of the dipolar relaxation process and the length scales of the confinement potential. Following Eq. (38), when the magnetic field $B$ is small, dipolar relaxation takes place at large inter-particle distances. Dipolar relaxation thus strongly depends on the trapping geometry, provided the size of the cloud is comparable to $R _ { D R }$ . This phenomenon was demonstrated in [162–164] for the case of 1D, 2D, and 3D optical lattices. In Ref. [162], a 1D optical lattice was shown to reduce dipolar relaxation in Cr by a factor of seven compared to a 3D trap when $\Delta E$ was smaller than the gap to first transverse excited state. The dipolar relaxation rate was further suppressed—by three orders–of–magnitude—in a 2D optical lattice of $\mathrm { ^ { 5 2 } C r }$ [163]. This was achieved below the threshold $B$ -field determined by this gap condition for $\Delta E$ . Interband transitions mediated by dipolar relaxation were observed above this threshold, as illustrated in Fig. 6. In the specific case of a deep 3D optical lattice [164], it was observed that dipolar relaxation becomes a resonant process as a function of $B$ due to the quantisation of kinetic energy in the 3D-band structure. We see that by adjusting confinement and the magnetic field, dipolar relaxation can be either eliminated (e.g., to study spinor physics at constant magnetisation), or be used to couple different lattice bands. This then realises an intrinsic nonlinear spin-orbit coupling in the lattice [164, 350].

Modifications to dipolar relaxation rates were also demonstrated in Ref. [162] using RF fields. While only an increase in relaxation rates was experimentally demonstrated, the work showed that RF-dressing might serve as a valuable tool to control dipolar relaxation.

![](images/41304554689e7cdc66d696a28fa391c0d0a2556371381f2506f190bbdeb97c4e.jpg)  
FIG. 6: Control of dipolar relaxation in reduced dimensions. The false colour absorption image is a band mapping of the atom population trapped in a 2D optical lattice. (a) Integrated population profile along $z$ yields populations in the different Brillouin zones (BZ). Below the threshold magnetic field for dipolar relaxation, only the first BZ is populated (grey profile with the sharper peak). Above the threshold, the first transverse excited band (second BZ) is populated (red profile with the wider peak). (b) Integrated population profile along $y$ shows the (1D) velocity distribution in the sites of the 2D lattice. Above threshold, vibrational de-excitation of atoms from excited bands create a non-Gaussian distribution. (c) Fraction of atoms detected in the first excited band as a function of the Larmor frequency after a 25-ms duration allowed for dipolar relaxation. The lattice depth is $2 5 E _ { r }$ which sets a threshold Larmor frequency of $1 2 0 \mathrm { k H z }$ . Below threshold, dipolar relaxation is reduced by three orders of magnitude. Adapted from [163].

# 6. Dipolar relaxation and spinor physics

Section VI will describe in more detail why the large spin of the highly magnetic atoms presents attractive prospects for the construction of exotic spinor states and many-body phases. Dipolar relaxation can play a positive role in this regard: magnetisation-changing collisions open the door to the exploration of spinor physics under conditions of free magnetisation. For example, controlling the field at the mG level makes the Zeeman energy $\Delta E$ comparable to thermal excitations of $\sim k _ { \mathrm { B } } 1 0 0$ nK. This induces spontaneous, incoherent demagnetisation from the absolute ground state. Further control of the field down to the 100- $\mu$ G level allows $\Delta E$ to be of the order of spin-dependent interactions. This would enable the observation of spinor phases driven by contact interactions under free magnetisation. This degree of control has already been achieved in current ultracold atoms experiments [351]. With even better control, possible experimentally, one can enter the regime where dipolar relaxation is relevant from the many-body point of view. For example, if $R _ { \mathrm { d r } } \ > \ d$ , where $\bar { d } = n ^ { - 1 / 3 }$ is the average particle distance, then many-body effects may arise. Interesting vortex structures may appear due to the Einstein-de-Haas effect since the orbital angular momentum is increased from spin relaxation [352–354]. Strongly rotating and interacting Fermi gases approaching a Laughlin state may appear [355].

In general, however, dipolar relaxation has unfortunate consequences for the study of many-body spinor physics in fields larger than those considered above or outside of 2D or 3D lattices where it can be strongly suppressed. High densities are needed to enhance the interaction energy, but fast dipolar relaxation can render systems with metastable spin states too fragile to observe in (near)equilibrium situations. Indeed, dipolar relaxation for all metastable spin states in bosons is particularly severe, and only a few metastable spin configurations for fermions are sufficiently long-lived [165]. For example, long-lived mixtures of $| F , - ( F - 1 ) ; F , - F \rangle$ were achieved in fermionic Dy and $\mathrm { E r }$ [165, 314] (see Sec. VI B 4) and the same set of states was used to generate spin-orbit coupling in fermionic Dy [252]; see Sec. VI D 1. The study of out-of-equilibrium dynamics is also possible for time

![](images/862370993a969a0f2b76aa8c9dbbffc00938efb775fb7df13fc72f1b1e3fd9f2.jpg)  
FIG. 7: a) Total dipolar cross section $\sigma =$ $\begin{array} { r l } { \int \frac { d \sigma } { d \Omega } ( { \boldsymbol { k } } , { \boldsymbol { k } } ^ { \prime } ) d \Omega _ { \boldsymbol { k } ^ { \prime } } } \end{array}$ in units of the dipolar length $a _ { \mathrm { d } } = a _ { \mathrm { d d } } / 3$ versus the angle $\eta$ between the incident scattering direction $\hat { k }$ and the polarisation direction $\hat { \epsilon }$ . The curves are for distinguishable particles (solid black), identical fermions (dashed blue), and identical bosons (dotted red). b) 3D plots of $\sigma$ as a function of $\hat { k }$ with $\hat { \epsilon }$ set to the vertical axis. Reproduced from Ref. [302].

scales up to the dipolar relaxation time scale [258, 356];   
see Sec. VI B 3.

# D. Anisotropic scattering

We now return to the discussion of elastic dipolar scattering and explore manifestations of the anisotropic nature of the DDI on scattering into different directions in space. This 3D scattering is characterised by the dipolar differential cross section $\textstyle { \frac { d { \boldsymbol { \sigma } } } { d \Omega } }$ . From the scattering theory reviewed in Sec. III A, we see that the differential cross section directly relates to the scattering amplitude $\frac { d \sigma } { d \Omega } ( k , n ) \ = \ | f ( k , n ) | ^ { 2 }$ . The expressions dσB/FdΩ , including both the contact interaction and DDI, for identical bosons and fermions in the first-order Born approximation are, respectively:

$$
\begin{array} { l } { \displaystyle \frac { d \sigma _ { \mathrm { B } } } { d \Omega } ( \boldsymbol { k } , \boldsymbol { k } ^ { \prime } ) = \frac { D ^ { 2 } } { 8 } [ \frac { 4 } { 3 } - \frac { 2 a } { 3 a _ { \mathrm { d d d } } }  } \\ { \displaystyle - \frac { 2 ( \hat { \boldsymbol { k } } . \hat { \varepsilon } ) ^ { 2 } + 2 ( \hat { \boldsymbol { k } } ^ { \prime } . \hat { \varepsilon } ) ^ { 2 } - 4 ( \hat { \boldsymbol { k } } . \hat { \varepsilon } ) ( \hat { \boldsymbol { k } } ^ { \prime } . \hat { \varepsilon } ) ( \hat { \boldsymbol { k } } . \hat { \boldsymbol { k } } ^ { \prime } ) } { 1 - ( \hat { \boldsymbol { k } } . \hat { \boldsymbol { k } } ^ { \prime } ) ^ { 2 } } ] ^ { 2 } , } \end{array}
$$

$$
\begin{array} { l } { \displaystyle \frac { d \sigma _ { \mathrm { F } } } { d \Omega } ( { \boldsymbol { k } , \boldsymbol { k } ^ { \prime } } ) = } \\ { \displaystyle \frac { D ^ { 2 } } { 8 } \left[ \frac { 4 ( \hat { \boldsymbol { k } } . \hat { \varepsilon } ) ( \hat { \boldsymbol { k } } ^ { \prime } . \hat { \varepsilon } ) - 2 \left[ ( \hat { \boldsymbol { k } } . \hat { \varepsilon } ) ^ { 2 } + ( \hat { \boldsymbol { k } } ^ { \prime } . \hat { \varepsilon } ) ^ { 2 } \right] ( \hat { \boldsymbol { k } } . \hat { \boldsymbol { k } } ^ { \prime } ) } { 1 - ( \hat { \boldsymbol { k } } . \hat { \boldsymbol { k } } ^ { \prime } ) ^ { 2 } } \right] ^ { 2 } } \end{array}
$$

where $\boldsymbol { k }$ and $k ^ { \prime }$ denote the relative momenta before and after the collision, with directions $\begin{array} { r } { \hat { k } ~ = ~ \frac { k } { | k | } } \end{array}$ and $\begin{array} { r } { \hat { k } ^ { ' } = \frac { k ^ { \prime } } { | k ^ { \prime } | } } \end{array}$ [302, 357]. The dipole moments are aligned along the $B$ -field direction $\hat { \boldsymbol { \varepsilon } }$ . These are nontrivial functions of the relative orientations of the three directions in the problem, the incident and scattered wavevectors and the polarisation direction of the dipoles. The total dipolar cross sections are found by integrating these expressions over $d \Omega _ { \hat { k } ^ { ' } }$ and are shown in Fig. 7. For a general angle $\eta$ between $\hat { k }$ and $\hat { \epsilon }$ , these are

$$
\begin{array} { l } { { \displaystyle \sigma _ { B } \big ( \hat { \mathbf { p } } _ { \mathrm { r e l } } \big ) = D ^ { 2 } \frac { \pi } { 9 } \big [ 7 2 a ^ { 2 } - 2 4 a \big ( 1 - 3 \cos ^ { 2 } \eta \big ) } } \\ { { \displaystyle \qquad + 1 1 - 3 0 \cos ^ { 2 } \eta + 2 7 \cos ^ { 4 } \eta \big ] } } \\ { { \displaystyle \sigma _ { F } \big ( \hat { \mathbf { p } } _ { \mathrm { r e l } } \big ) = D ^ { 2 } \frac { \pi } { 3 } \left[ 3 + 1 8 \cos ^ { 2 } \eta - 1 3 \cos ^ { 4 } \eta \right] . } } \end{array}
$$

Note that the results of Eqs. 32 and 33 correspond to angle-averaged versions of the above expressions.

# 1. Anisotropy of rethermalisation

The anisotropy of the differential cross section may reveal itself in the thermalisation dynamics, and in particular, via the thermalisation rate as a function of the angle $\lambda$ between $\hat { \varepsilon }$ and the axis along which energy is imparted. This can be studied in cross-dimensional rethermalisation experiments. Cross-dimensional rethermalisation (relaxation) is a method for measuring the total elastic cross section wherein the gas is brought out of thermal equilibrium by heating it along one or two of three directions [300]. One then observes the time for the temperature in the third direction to equilibrate. The time constant $\tau$ for this typically exponential relaxation process may be related to the cross section via $\tau = \alpha / n v \sigma$ , where $n$ is the average number density, $v$ is the mean relative speed, and $\sigma$ is the elastic cross section. The anisotropy of the differential cross section appears through the parameter $\alpha$ , which is the number of collisions, on average, for rethermalisation. For $s$ -wave ( $p$ -wave) collisions, $\alpha = 2 . 5$ ( $2 5 / 6 \approx 4 . 1 7$ ) [301]. However, for dipolar particles, $\alpha$ becomes angle dependent due to the anisotropic differential cross section [302]. Its value is plotted in Fig. 8(a,b) versus the angle $\lambda$ between the axis along which energy is imparted and $\hat { \varepsilon }$ . We see that $\alpha$ can change by more than a factor two versus angle for fermions, while sightly less than two for bosons. The control of $\lambda$ is therefore an important tool for optimising, e.g., evaporative cooling efficiency: rethermalisation of fermions (bosons) is far more efficient at $4 5 ^ { \circ }$ ( $9 0 ^ { \circ }$ ) than at $0 ^ { \circ }$ or $9 0 ^ { \circ }$ ( $0 ^ { \circ }$ ).

The large anisotropy in the rethermalisation of dipolar gases was experimentally demonstrated in ultracold gases of fermionic $^ { 1 6 7 } \mathrm { E r }$ [303]. For fermionic atoms, $\sigma$ is simply given by the universal formula Eq. (33) so that a measurement of $\tau$ directly provides $\alpha$ . Figure $8 ( \mathrm { c } )$ shows measurements of $\alpha$ in agreement with the dependence predicted in Ref. [302]. The authors also reported the reduction in rethermalisation rate due to Pauli-suppression of scattering once $T$ was sufficiently lower than $T _ { F }$ (see Sec. III B and Eqs.32 and 33). Unlike $\alpha$ , the suppression factor was observed to be independent of $\lambda$ , implying that the occupation of the final density of states leading to Pauli-blocking is mostly unaffected by the anisotropy of the DDI.

Cross-dimensional rethermalisation experiments in ultracold gases where also performed in bosonic isotopes of $^ \mathrm { 1 6 4 }$ Dy, $^ \mathrm { 1 6 2 }$ Dy [304] and of $^ { 1 6 4 } \mathrm { E r }$ , $^ { 1 6 6 } \mathrm { E r }$ , $^ { 1 6 8 } \mathrm { E r }$ and $^ { 1 7 0 } \mathrm { E r }$ [76]. These studies measured the unknown values of the scattering lengths $a$ of these atoms by using either the theoretically predicted $\alpha$ or by using more extensive dynamics simulations to convert the measured $\tau$ into values of $a$ ; see Eq. (32) and Sec. II D $2$ a for more details. In Ref. [304], the authors used a thorough theoretical analysis informed by data from different values of the angle $\lambda$ to extract $a$ . This study confirmed the anisotropic behaviour as well as provided evidence of hydrodynamical effects in the rethermalisation dynamics [357].

![](images/668c290ecb3c945121bf72ffcf8d1ee49cf865b03ac1aa697a9946000aa642fa.jpg)  
FIG. 8: (a,b) Upper panels: Number of collisions per rethermalisation, $\alpha$ , versus the angle between the quantization axis $\hat { \epsilon }$ and the trap axis along which rethermalisation occurs, $\lambda$ . Lower panels: 3D plots of $d \sigma / d \Omega$ as a function of the scattering direction $\hat { k } ^ { \prime }$ , for different values of $\eta$ . $\eta$ is the angle between $\hat { k }$ , set to the vertical $z$ axis, and the polarisation direction $\epsilon$ in the $x z$ -plane. Plots are for a) identical bosons and b) identical fermions. Reproduced from Ref. [302]. c) Comparison between theory and measurement of $\alpha$ for ultracold dipolar fermions of $^ { 1 6 7 } \mathrm { E r }$ . Reproduced from Ref. [303].

These hydrodynamic effects were manifest as modifications of the mechanical oscillations of the gas after the gas was kicked out of thermal equilibrium. It was observed that the large magnetic dipole moment of Dy provides a sufficiently large elastic collision cross section for the gas to lie near the hydrodynamic collisional regime. These effects were predicted in Ref. [357], where it was shown that the relaxation no longer follows a simple exponential in the hydrodynamic regime when the collisional rate is similar to the trapping frequencies, as observed in Ref. [304]. Nevertheless, cross sections were able to be extracted from the data through close comparison to Monte Carlo simulations. Section II D 2 a describes the scattering length measurements obtained as a result. Hydrodynamic behaviour arising from the DDI has also been observed in the expansion aspect ratio of Dy thermal gases [306]; see also Sec. IV A 2 b.

# 2. Anisotropic scattering halos

The anisotropy of the differential cross sections may be directly visualised by observing the shape of scattering “halos” of atoms from two gases that have undergone a head-on collision. Reference [166] describes such an experiment: One creates two dipolar BECs of $^ \mathrm { 1 6 2 }$ Dy counter-propagating at momentum $\pm 2 \hbar k _ { R }$ using Bragg diffraction. This energy is much larger than the internal momentum distribution width of the individual BEC. When the BECs propagate through one another, atoms scatter away from the forward and backward directions of the BECs’ motion. A halo rapidly expands from the centre-of-mass position, as shown in the data of Fig. 9. The BECs are sufficiently dilute that atoms scatter at most one time. The shape of the halo therefore reveals information about the two-body differential cross section.

The data visually reveal a novel regime of quantum scattering. Rather than exhibiting halos with shapes dominated by a single partial wave—e.g., the spherically symmetric halos from the $s$ -wave scattering of ultracold identical bosons [358–361]—anisotropic shapes are manifest. This is a consequence of the superposition of a large number of partial waves due to high-order angular momentum coupling through the elastic DDI. Moreover, the particular halo shape strongly depends on $\eta$ , as expected from Eq. (39). The shapes of the halos in the data agree with Monte Carlo simulations based on Eq. (39) and described in Ref. [357].

# IV. Fully polarised repulsive bulk dipolar gases

In this chapter, we will consider dipolar quantum gases of atoms fully polarised in the lowest Zeeman state. We will cover only harmonically trapped gases in the absence of a three dimensional lattice; see Sec. VII for dipolar lattice systems. Most of the experimental activity has been focused on dipolar bosonic gases and in particular dBECs (Sec. IV A). Nevertheless, we will also include the relevant results on dipolar DFGs (Sec. IV B) as well as results on dipolar gases in lower dimensions, in particular in 1D (Sec. VII A).

![](images/a6066359e53eb2cb516c0a3a1746fce761492d8995e5e88f0e7abb48bbf4bb32.jpg)  
FIG. 9: 2D images of the scattering halos from the collision of two BECs of $^ \mathrm { 1 6 2 }$ Dy that are counter-propagating along the horizontal direction of the images. Left column are simulations, while the right column are experimental data. Dipoles are aligned using a $B$ -field oriented: a) along the vertical direction, b) out of the page, and c) along the horizontal direction, as indicated by the arrows. Adapted from Ref. [166].

# A. Weakly interacting three-dimensional dipolar Bose gases

A majority of the phenomena arising from the DDI that have been observed in bulk BECs, in particular in the regime where the overall interactions are effectively repulsive, are well accounted for by a mean-field (MF) description of the interactions. After a short description of the MF theory of dipolar Bose gases in Sec. IV A 1, this section will focus on experimental observations of related phenomena. These observations can be understood as hydrodynamic measurements, as they concern the linear response from the equilibrium state of the quantum fluid; e.g., its time evolution in a trap or in free space as well as its elementary collective excitations. These aspects will be reviewed in Secs. IV A 2 and $\cdot$ . Beside modifying the speed of sound and giving it a directional dependence, the DDI profoundly affects the structure of the elementary excitation spectra of trapped BECs by the interplay of long-range anisotropic interactions with the trap geometry. In particular, a dispersion relation showing a local minimum in energy, i.e., a roton mode, was predicted and observed, as discussed in Sec. IV A 3. Furthermore, the DDI influences the stability of BECs in traps. Due to the anisotropy of the DDI, the effective sign of the MF interaction depends on the density distribution, which, in turn, is not only determined by the trap geometry but also by the DDI. This interplay results in a non-trivial stability diagram as a function of $a$ and of the anisotropy of the trapping potential, as well as instability behaviours which also connects to the underlying modifications of the excitations spectrum of the BEC mentioned above. This will be reviewed in Sec. IV A 4. The stability analysis and related stabilised states of dipolar Bose gases beyond a MF treatment is the subject of Sec. V.

# 1. The mean-field description

# $a$ . Interaction potential in dilute gases

As introduced in Sec. I D 1, polarised dipolar bosons in an ultracold dilute ensemble can be considered to be interacting via a potential of the form:

$$
V _ { \mathrm { i n t } } ( \pmb { r } ) = \frac { 4 \pi \hbar ^ { 2 } a } { m } \delta ( \pmb { r } ) + \frac { 3 \hbar ^ { 2 } a _ { \mathrm { d d } } } { m } \frac { 1 - 3 \cos ^ { 2 } \theta } { r ^ { 3 } } .
$$

Again, $a$ is the $s$ -wave scattering, while $\begin{array} { r l } { a _ { \mathrm { d d } } } & { { } = } \end{array}$ $\mu _ { 0 } m \mu ^ { 2 } / 1 2 \pi \hbar ^ { 2 }$ is the dipolar scattering length. The interparticle separation vector is $\mathbfit { r }$ , with norm $r$ and angle $\theta$ with respect to the dipole orientation. In the following, we will assume a polarising magnetic field aligned along the $z$ -axis, and a harmonic trap with frequencies $\omega _ { x , y , z }$ . Unless otherwise specified, we also consider that the trap has a cylindrical symmetry along $z$ such that $\omega _ { x } = \omega _ { y } = \omega _ { \rho }$ , and

$$
V _ { \mathrm { t r } } = \frac { m } { 2 } \left( \omega _ { \rho } ^ { 2 } \rho ^ { 2 } + \omega _ { z } ^ { 2 } z ^ { 2 } \right) .
$$

The trap aspect ratio is

$$
\begin{array} { r } { \lambda = \omega _ { z } / \omega _ { \rho } . } \end{array}
$$

The validity of Eq. 43 as an effective pseudo-potential written as a simple sum of a contact pseudo-potential $g \delta ( \pmb { r } )$ (or its more rigorous, regularised version [91]) and the DDI potential Eq. (11) has long been debated [9, 17]. This expression for the potential results from the firstorder Born approximation applied to a molecular potential of the dipole-dipole type dominating at long distance plus a van der Waals potential dominating at short range [92, 93, 340, 362–364]. While it is a good approximation for weak dipoles and away from scattering resonances, modifications may be necessary for systems with large $\varepsilon _ { \mathrm { d d } }$ . In particular, the $s$ -wave scattering length may depend on $d$ [92, 93, 365], requiring a renormalisation of the dipolar length in Eq. 43 [341, 366]. In the case of the most magnetic of the atoms, Dy, with $\varepsilon _ { \mathrm { d d } } \sim 0 . 5 - 2$ , corrections to $a _ { \mathrm { d d } }$ were predicted to be of $1 0 \%$ at temperature of $1 0 0 \mathrm { n K }$ and only 2% at $1 0 \mathrm { n K }$ [367].

# $b$ . Mean-field approximation

The MF approximation, which underlies common approaches to describe the properties of bulk BECs, consists of replacing the field operator by its mean value, $\psi ( { \pmb r } , t )$ . The approximation assumes that the BEC mode is macroscopically occupied [11, 88–90]. This effectively ignores fluctuations of the bosonic field around its mean value. In the absence of the DDI, the corrections to this approximation scale as $\sqrt { n a ^ { 3 } }$ . In the presence of the DDI, one naively expects the MF approximation to be valid when $\sqrt { n a ^ { 3 } }$ , $\sqrt { n a _ { \mathrm { d d } } ) ^ { 3 } } \ll 1$ . A proper treatment of fluctuations around MF values, outlined in Sec. V, leads to a more restrictive condition: $\sqrt { n a ^ { 3 } } \ll 1 , \varepsilon _ { \mathrm { d d } } \lesssim 1$ . Note that the length $a _ { \mathrm { d d } }$ is defined such that $a = a _ { \mathrm { d d } }$ ( $\varepsilon _ { \mathrm { d d } } = 1$ ) marks the limit of the mechanical stability of a homogeneous isotropic dBEC, and other authors sometimes call $3 a _ { \mathrm { d d } }$ the dipolar length (which arises from a consideration of the two-body problem [340]); see Sec.I C 4.

Considering a gas of $N$ atoms interacting via Eq. (43), the MF approximation results (at zero temperature) in a nonlocal Gross-Pitaevskii equation (GPE) given in Eq. (9) and reprinted here:

$$
i \hbar { \frac { \partial \psi } { \partial t } } ( { \pmb r } , t ) = \left[ - \frac { \hbar ^ { 2 } } { 2 m } \nabla ^ { 2 } + V _ { \mathrm { t r } } ( { \pmb r } ) + g | \psi | ^ { 2 } + \Phi _ { \mathrm { d d } } ( { \pmb r } ) \right] ( \hbar \mathbf { \mu }
$$

with $\begin{array} { l l l } { g } & { = } & { 4 \pi \hbar ^ { 2 } a / m } \end{array}$ and $\begin{array} { r c l } { \Phi _ { \mathrm { d d } } ( { \pmb r } ) } & { = } & { \int d { \pmb r } ^ { \prime } U _ { \mathrm { d d } } ( { \pmb r } ^ { \prime } \ - \ } \end{array}$ $r ) | \psi ( r ^ { \prime } ) | ^ { 2 }$ ; see also Eq. (10). The corresponding energy functional is

$$
\begin{array} { r } { E [ \psi ] = \displaystyle \int \left[ - \frac { \hbar ^ { 2 } } { 2 m } | \nabla \psi | ^ { 2 } + V _ { \mathrm { t r } } ( \pmb { r } ) | \psi | ^ { 2 } \right. } \\ { \displaystyle \left. + \frac { g } { 2 } | \psi | ^ { 4 } + \frac { 1 } { 2 } | \psi | ^ { 2 } \Phi _ { \mathrm { d d } } ( \pmb { r } ) \right] d r , } \end{array}
$$

which can be minimised to obtain the equilibrium ground state of the BEC [14, 15, 17, 368]. In these equations, the DDI yields a nonlocal contribution $\Phi _ { \mathrm { d d } } ( \pmb { r } )$ , whose sign depends on the shape of the density distribution. We note that various analyses demonstrated the applicability of the nonlocal GPE in accurately describing the properties of trapped dipolar gases [366, 369].

# 2. Magnetostriction

# $a$ . Magnetostriction of dBECs

When placed in a cylindrical harmonic trap, a nondipolar gas ( $\varepsilon _ { \mathrm { d d } } = 0$ ) assumes the geometry of the trap. A dipolar system behaves differently because of the presence of $\Phi _ { \mathrm { d d } }$ in Eq. (9). Specifically, the dipole term $\Phi _ { \mathrm { d d } } ( \pmb { r } )$ has a saddle-shape, tending to elongate the distribution along the magnetic field. That is, to minimise its energy, the dBEC elongates along the dipolar axis due to the attractive part of the DDI. This effect is called magnetostriction and is of course not unique to quantum gases as it has been known since Joule discovered the effect in iron [370]. Note that the magneto- or electrostrictive effects deform a system solely due to the presence of a homogeneous field which breaks rotational symmetry. The forces responsible are due only to the interactions between the particles because the external field has no gradient.

# • Application of the Thomas-Fermi approximation:

Rather than numerically solving Eq. (9), magnetostriction can be analysed by the use of the Thomas-Fermi (TF) approximation, valid for high atom numbers and sufficiently large total interaction strength [11]. This allows one to neglect the kinetic energy term in Eq. (9). For $\varepsilon _ { \mathrm { d d } } = 0$ (i.e., a nondipolar BEC), one can easily show that the density of a BEC acquires an inverted parabolic shape with a so-called TF radius that scales as $R _ { i } \propto 1 / \omega _ { i }$ , $i = x , y , z$ [9]. In the dipolar case, Refs. [371, 372] showed that a dBEC retains the parabolic shape in this (TF) limit. However, its aspect ratio

$$
\begin{array} { r } { \kappa = R _ { \rho } / R _ { z } , } \end{array}
$$

defined by the ratio of the TF radii perpendicular ( $R _ { \rho }$ ) to the radius along ( $R _ { z }$ ) the dipole direction, no longer reflects the aspect ratio of the trap. This is due to the contribution of $\Phi _ { \mathrm { d d } }$ to the mean energy in Eq. (47), which one can calculate analytically:

$$
E _ { \mathrm { d d } } = - \frac { 4 } { 7 } \varepsilon _ { \mathrm { d d } } g \frac { n _ { 0 } N } { 2 } f _ { \mathrm { d i p } } ( \kappa ) ,
$$

where $n _ { 0 }$ is the density at the trap centre. The function $f _ { \mathrm { d i p } } ( \kappa )$ encompasses the anisotropy of the interaction energy, it is a decreasing function of $\kappa$ [373]. The complete expression is [374]

$$
f _ { \mathrm { d i p } } ( \kappa ) = \frac { 1 + 2 \kappa ^ { 2 } } { 1 - \kappa ^ { 2 } } - \frac { 3 \kappa ^ { 2 } { \mathrm { a r c t a n h } } \sqrt { 1 - \kappa ^ { 2 } } } { ( 1 - \kappa ^ { 2 } ) ^ { 3 / 2 } } .
$$

Note that an angular integration of the DDI over an isotropic distribution is zero, leading to $f _ { \mathrm { d i p } } ( 1 ) = 0$ . $f$ dip is bounded by two limits: fully collinear dipoles (attractive DDI) $\begin{array} { r } { \operatorname* { l i m } _ { \kappa \to 0 } f _ { \mathrm { d i p } } = 1 } \end{array}$ , while side-by-side dipoles (repulsive DDI) yield $\begin{array} { r } { \operatorname* { l i m } _ { \kappa \to \infty } f _ { \mathrm { d i p } } = - 2 } \end{array}$ . Thus, one readily sees that $E _ { \mathrm { d d } }$ is reduced by lowering $\kappa$ . In the TF approximation, minimising $E$ leads to a transcendental equation for $\kappa$ [93, 372, 374]:

$$
\lambda = \kappa \left( \frac { 1 + 2 \varepsilon _ { \mathrm { d d } } - \frac { 3 \varepsilon _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa ) } { 1 - \kappa ^ { 2 } } } { 1 - \varepsilon _ { \mathrm { d d } } + \frac { \kappa ^ { 2 } } { 2 } \frac { 3 \varepsilon _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa ) } { 1 - \kappa ^ { 2 } } } \right) ^ { 1 / 2 } .
$$

The solution of this equation for a given $\lambda$ thus gives the degree of magnetostriction. A solution exists for any $\lambda$ provided that $\varepsilon _ { \mathrm { d d } } \leqslant 1$ . The absence of a MF solution will be discussed at the end of this section, and for now we assume there exists one.

We note that assuming a 3D Gaussian shape for the dBEC is another common approximation [92, 93, 97, 372, 375]. This approximation will be later reviewed in Sec. IV A 4 a. Interestingly, and despite the difference in the approximations, such a Gaussian variational ansatz for $\psi$ yields the same equation as Eq. (51) for the aspect ratio. We note that both the TF and the Gaussian approximations can describe a regular BEC wavefunction with only maximal density at the trap centre. They fail in describing more complex phenomena that can occur in dBECs, e.g., when operating close to the MF instability threshold; see Secs. IV A 4 c and V D. In this paragraph, we focus on the shape of stable dBECs.

# • In-situ measurements:

We now describe the distortion of the gas shape inside the trap. Quantitative in-situ measurements of magnetostriction have only recently been possible: The first insitu images of dipolar BECs were reported in Ref.[185] and in-situ magnetostriction images first presented in Ref. [376]. An example is shown in Fig. 10.

FIG. 10: In situ imaging of magnetostriction of a $^ \mathrm { 1 6 2 }$ Dy dBEC. The atoms are held in a pancake-shaped trap, nearly isotropic in the plane. The field is out of plane in the left image, and in-plane for the right image, while the trap is kept unchanged. Adapted from Ref. [376].

# • Magnetostriction in the TOF dynamics of BECs:

Observing the (hydrodynamic) expansion of the gas trap release is a common way to reveal BEC physics [377, 378], and in particular the impact of interactions on quantum gases. The hydrodynamic equations for the expansion of a (nondipolar) BEC were first presented in Ref. [379], showing inversion of ellipticity during TOF.

Solutions to the hydrodynamic equations for dipolar gases can also be found [371, 372, 380]. The effect of the DDI is the same as in trap: energetics favour a distortion in the expansion that aligns the dipoles head-to-tail.

![](images/221e2c9bee38c6c36b638a32b6a56b03fb0ea585ac0862b8ba6e5fba85d86cd0.jpg)  
FIG. 11: Aspect ratio of an expanding $^ { 5 2 } \mathrm { C r }$ BEC, measured $2 \mathrm { m s }$ after its release from a trap, as a function of $\varepsilon _ { \mathrm { d d } }$ . $\varepsilon _ { \mathrm { d d } }$ was controlled using a a FR centred about $B _ { 0 }$ . Blue (red) dots: data with $B < B _ { 0 }$ $\mathbf { \Delta } B > B _ { 0 }$ ). Dashed line: background $\varepsilon _ { \mathrm { d d } }$ . Solid line: prediction from Eq. (49) without adjustable parameters. Shaded area: uncertainties in $\omega _ { \rho , z }$ . Inset, same data as a function of $B - B _ { 0 }$ . From [383].

The first observation of magnetostriction in a gas was observed in the hydrodynamic expansion of a $^ { 5 2 } \mathrm { C r }$ BEC [381]. This was manifest as a dependence of the inversion of ellipticity on the magnetic field direction. Comparing the experimental dynamics with solutions to the hydrodynamic equations, a value for $\varepsilon _ { \mathrm { d d } }$ for $\mathrm { ^ { 5 2 } C r }$ away from FRs was extracted [382]. The value agrees with most precise values of the background scattering length $a _ { \mathrm { b g } }$ obtained more recently [162]; see Sec. II D. Using a FR to lower $a$ —and thus to enhance dipolar effects into the $\varepsilon _ { \mathrm { d d } } > 1$ regime—magnetostriction in situ and in TOF was strong enough so that a complete suppression of ellipticity inversion was observed [383]. The variation of the aspect ratio of an expanding cloud with $\varepsilon _ { \mathrm { d d } }$ can be seen in Fig. 11.

![](images/3784f77db5d1ef3f954a89bf24bb1dabaf1cdddf0d523b7644052a7a3fbd5785.jpg)

# $b$ . Magnetostriction and TOF dynamics of ultracold, non-condensed gases

Observation of magnetostriction in gases requires low temperatures and high densities. Otherwise, thermal energies are orders-of-magnitude larger than the DDI. As mentioned above, the use of dBECs enabled the observation of magnetostriction both in TOF and in situ. Magnetostriction effects could also be observed in ultracold, but non-degenerate thermal gases of sufficiently strong dipolar atoms.

![](images/27e6b32c69afd27542f79e10a60a75bd6edcadd536a0a1b3e2d3df2719f8374d.jpg)  
FIG. 12: The anisotropic aspect ratio of dipolar thermal gases after $1 6 ~ \mathrm { m s }$ of TOF. Aspect ratio for (a) $ { ^ { 1 6 2 } } \mathrm { D y }$ and (b) 164Dy. Red (blue) is for magnetic field along $\hat { z }$ and $\hat { y }$ . The solid (dashed) curves are the full (partial, MF-only) theory developed in Ref. [306]. The Bose-condensation temperature is marked by the vertical grey line. From Ref. [306].

The dimensionless parameter relevant for DDI corrections to the ideal gas law is obtained is obtained by comparing the mean dipolar energy to the mean kinetic energy: $\eta = E _ { \mathrm { d i p } } / E _ { \mathrm { k } }$ . For a non-degenerate gas, $E _ { \mathrm { d i p } } \sim$ $S ^ { 2 } d ^ { 2 } n$ and $E _ { \mathrm { k } } \sim k _ { \mathrm { B } } T$ , such that $\eta \propto ( n \lambda _ { \mathrm { t h } } ^ { 3 } ) \times \left( k _ { \mathrm { t h } } a _ { \mathrm { d d } } \right)$ , with $k _ { \mathrm { t h } } = 2 \pi / \lambda _ { \mathrm { t h } } = \sqrt { m k _ { \mathrm { B } } T } / \hbar$ the thermal wavenumber, and $\lambda _ { \mathrm { t h } }$ the thermal wavelength. To maximise $\eta$ in a thermal gas, we may choose Dy, which provides a $a _ { \mathrm { d d } } = 1 3 1 a _ { 0 }$ ; see Sec. II). At typical experimental densities for a gas with a temperature just above its BEC $T _ { c }$ , $\eta$ remains $\ll 1$ . Thus, at best, the DDI only weakly modifies the TOF expansion dynamics. Nevertheless, DDI effects on time-of flight dynamics have been observed, as we now discuss.

Tang et al. [306] theoretically and experimentally studied the anisotropic expansion of a thermal dipolar Bose gases of $_ \mathrm { 1 6 4 }$ Dy and $^ \mathrm { 1 6 2 }$ Dy just above their degeneracy temperature. Each gas, after TOF expansion, exhibits an aspect ratio that depends on the polarisation angle of the dipoles, as had already been noted in dBECs [17]; see Fig. 12. The DDI strength of Dy is sufficient to cause the magnetostriction of even a dilute thermal gas. To predict the experimental aspect ratios versus temperature and dipolar angle, the authors developed a theory of the expansion that accounts for the Hartree-Fock MF interactions, Bose-enhanced scattering, and hydrodynamic effects that partially cross-dimensionally rethermalise the gas during the expansion. By doing so, the authors were able to quantitatively match the theory to the data. The theory fits provided a method to extract the gas temperature and is a relatively simple method for determining the scattering length of the gas, even near a FR; see Sec. II D 2 a for the results of the $a$ measurements using this technique, which are compatible with previous measurements. Moreover, the momentum distribution deformation scales with the ratio $\eta = \left( n \lambda _ { \mathrm { t h } } ^ { 3 } \right) \times \left( k _ { \mathrm { t h } } a _ { \mathrm { d d } } \right)$ , as expected, and arises primarily from the two-body collisions and the direct Hartree contribution to the MF energy.

A similar effect arises in degenerate Fermi gases, although with a few fundamental differences. The kinetic energy is dominated by the Fermi energy, so the distortion in momentum space is smaller. This Fermi surface deformation stems from the exchange contribution to the mean interaction energy, which does not vanish in the degenerate Fermi many-body state due to the Pauli exclusion principle; see Sec. I D 2 and the discussion in Sec. IV B.

# 3. Elementary excitations of dBECs

In the previous section, we were concerned with the influence of the DDI at equilibrium: i.e., the magnetostrictive effect on the gas wavefunction in real space, and its consequences on the free-space expansion dynamics, which allows observations of momentum-space magnetostriction. In contrast, elementary excitations around equilibrium provide a window into dynamical behaviour of the dipolar quantum gases. Due to the sensitivity of spectroscopic measurements, experimental studies of DDI effects on elementary excitations even at low $\varepsilon _ { \mathrm { d d } }$ are possible. Besides, stringent modifications of the excitation spectrum at $\varepsilon _ { \mathrm { d d } } \sim 1$ were also evidenced.

$a$ . Elementary excitations in a (homogeneous) dBEC: from phonons to free-particles.

# • Continuous Bogoliubov spectrum:

Elementary excitations of BECs were introduced in Sec. I D $\cdot$ in the uniform BEC case. In presence of DDI, the well-known Bogoliubov spectrum, obtained by linearising the GPE around the ground state, with its linear phonon branch followed by the quadratic free-particle dependence, is modified. By combining Eqs. (8) and (16), the spectrum of a uniform 3D dBEC of density $n$ is [375]

$$
\hbar \omega ( k ) = \sqrt { \frac { \hbar ^ { 2 } k ^ { 2 } } { 2 m } \left( \frac { \hbar ^ { 2 } k ^ { 2 } } { 2 m } + 2 g n \left( 1 + \varepsilon _ { \mathrm { d d } } ( 3 \cos ^ { 2 } \theta _ { k } - 1 ) \right) \right) } ,
$$

where $\theta _ { k }$ is the angle between the direction of excitation propagation and the dipole orientation. The sound velocity for BECs with only contact interactions ( $\varepsilon _ { \mathrm { d d } } = 0$ ) is $c _ { 0 } = \sqrt { g n / m }$ and acquires an angular dependence in presence of the DDI, $c ( \theta _ { k } ) = c _ { 0 } \sqrt { 1 + \varepsilon _ { \mathrm { d d } } ( 3 \cos ^ { 2 } \theta _ { k } - 1 ) }$ . Excitations propagating along the dipoles’ direction ( $\theta _ { k } = 0$ ) have the highest sound velocity (i.e., they are stiff modes), while those propagating in the perpendicular plane ( $\theta _ { k } = \pi / 2$ ) have the lowest velocity (i.e., they are softer modes). This anisotropy of the dispersion relation is one of the main feature of dBECs with respect to collective excitations and has important physical consequences; namely, the anisotropic superfluid critical velocity (see below) and a mechanical instability with anisotropic nature manifest for gases with $\varepsilon _ { \mathrm { d d } } \geq 1$ ; see

# Sec.IV A 4.

# • Bragg spectroscopy:

Using the standard method of two-photon Bragg spectroscopy (see, e.g., Refs [384–388]) on a dBEC of $^ { 5 2 } \mathrm { C r }$ , Bismut et al. [389] probed the dispersion relation of such a trapped dBEC away from FRs. In practice, the finite size of the trapped samples sets a lower limit on the momentum at which one can probe and compare against Eq. (52) (which holds in the homogeneous case). This limit comes from the fact that the BEC smallest size ( $R _ { \mathrm { T F } \operatorname* { m i n } { \it \Omega } }$ ) must be larger than the excitation wavelength: $k R _ { \mathrm { T F } \operatorname* { m i n } { \mathrm { ~ \gg ~ } } 1 }$ . In this limit, the local density approximation can be used, allowing one to take into account the BEC’s inhomogeneity. Bismut et al. observed a Bragg dispersion peak that depends on the relative orientation between the Bragg momentum and the magnetic field angle, in very good agreement with theory; see Fig. 13. At low momentum, a departure from the homogeneous expectation was observed. Numerical simulations taking finite-size effects into account reproduce the evolution of the measured dispersion relation and its anisotropy.

![](images/0be2dcfdc92e6ce2d7ac4532f1507d243eeed5114abaec921c3ecb1bd03a8fde.jpg)  
FIG. 13: Bragg excitation spectra of a $^ { 5 2 } \mathrm { C r }$ BEC, with the magnetic field in two perpendicular directions. Lines are fit to the data. From [389].

# •Critical superfluid velocity measurement:

The DDI effect on the dBEC’s excitation spectrum implies other changes to the BEC’s physical behaviour. A prime example lies in the change to the superfluid critical velocity. The famous Landau’s criterion relates the critical velocity for an impurity moving in the direction $\hat { v }$ in an (infinite and uniform) superfluid to its dispersion relation: $v _ { \mathrm { c } } = \operatorname* { m i n } _ { k } \left( { \frac { \omega _ { k } } { \hat { \boldsymbol { v } } \cdot \boldsymbol { k } } } \right)$ [101, 390]. In the homogeneous case discussed above, Eq. (52) implies that the critical velocity becomes anisotropic in a dBEC, depending on whether the excitation is applied along or perpendicular to the dipole orientation [390, 391]. We note that the critical velocity does not generally match the speed of sound, even in the homogeneous case. This is because the dissipating excitations can occur in a different direction than the impurity’s motion [390]. The critical velocity is thus systematically smaller than the speed of sound in the direction of motion. For anisotropic confinement, as discussed in Sec. IV A 3 c, the critical velocity should also be affected by the existence of low-energy high-momentum modes, such as the roton mode [391, 392].

Superfluid velocity measurements were performed on a $^ \mathrm { 1 6 2 }$ Dy dBEC using a local light defect driven linearly along one axis [393]. These showed that the anisotropy of the critical velocity as well as of the heating rate above the critical velocity are in excellent agreement with dynamical simulations based on the GPE; see Fig. 14. Large corrections compared to the homogeneous predictions are observed and mainly attributed to inhomogeneous density effects, as corroborated by numerical simulations of the GPE.

![](images/962c770b8a5d6e21f15c434aa93d6160d853fd095ed931489b9458c7b4e389fe.jpg)  
FIG. 14: Temperature of the $^ \mathrm { 1 6 2 }$ Dy dBEC after applying a stirring protocol. The stirring beam is moved along $x$ (red squares) or $y$ (blue circles). The dipoles are polarised along $x$ . The trap is cylindrically symmetric in $x$ and either (c) elongated or (b) made narrow in this direction; see insets with example of in situ images. A piecewise linear fit (dashed lines) quantifies the anisotropy of the critical velocities (arrows) with respect to the dipole orientation. For both trap geometries, the velocity, $v _ { \perp }$ , for a perpendicular excitation is small than for a parallel one, $v _ { | | }$ , with $v _ { \perp } = 0 . 1 6 ( 2 ) \mathrm { m m / s }$ (0.12(3)mm/s) and $v _ { | | } = 0 . 3 6 ( 3 ) \mathrm { m m / s }$ $( 0 . 2 6 ( 4 ) \mathrm { m m / s } )$ ) in b (c). Numerical simulations of the GPE (solid lines) show excellent agreement with the experiment. Adapted from [376].

# $b$ . Low-lying collective modes of trapped dBECs and oscillation measurements

For a trapped gas, if one lowers the excitation momentum down to the regime where the corresponding wavelength is on the order of the cloud size, then one reaches the regime of low-lying excitations where the spectrum is discrete and momentum is not a good quantum number. The low-lying modes are typically surface modes, implying an (out-of-phase) oscillation of radii in different directions. These modes typically have a compressional character, yielding a density (and thus interaction) dependence. Signatures of the DDI in these systems have been theoretically studied [93, 97, 371, 394, 395]. MF methods to extract the collective modes nature and frequency rely on expanding the energy functional Eq. (47), or corresponding hydrodynamic equations, around the stationary solution. This can be done semi-analytically by either applying the TF approximation or using the Gaussian ansatz; see Secs. IV A 2 and $\mathrm { ~ N ~ A ~ 4 ~ } \mathrm { ~ }$ a.

Experimentally, Bismut et al. [396] studied the influence of the DDI on such modes with a $^ { 5 2 } \mathrm { C r }$ BEC. They investigated the second-lowest-lying mode, a quadrupole mode in a non-axisymmetric trap. The experimental results demonstrate that the collective mode frequency is dependent on the relative orientation of the dipoles with the trap axes, and that the frequency shift is dependent on the trap geometry, see Fig. 15. The experiment is in good agreement with a TF approximation theory, which neglects the kinetic energy of the atoms. When lowering the atom number below a few thousand, the frequency shift is clearly reduced, demonstrating the importance of quantum pressure for very small samples. Quantum pressure can be taken into account by either performing full numerical simulations of the GPE, or by using a Gaussian variational ansatz for the BEC wavefunction.

![](images/3317fd7508ab32d50af38aef4f160ddde86042c55f136d2134b4f7ac1ee3aa6d.jpg)  
FIG. 15: Time evolution of the aspect ratio of a dBEC oscillating due to the excitation of a low-lying surface collective mode (taken after TOF expansion). The two different colours show the time evolution for two different angles of the $B$ field, showing the dependence of the frequency of the collective modes on the dipoles direction due to the DDI. From [396].

# c. Spectrum of elementary excitations in trapped dBEC, roton mode.

As highlighted in Eq. (16), the DDI contributes to the continuous excitation spectrum via an effective coupling strength $\widetilde { V _ { \mathrm { d d } } } ( k )$ , which adds to the constant contact contribution $g$ . As observed in Eq. (52), in the 3D homogeneous case, the DDI contribution, simply given by its Fourier transform (Eq. (8)), yields an orientationdependence, but no $k$ -norm dependence. When combining the DDI with an anisotropic confinement, even more striking behaviours of the dBEC’s excitation spectrum arise. Here, a $k$ -norm dependence may arise from the interplay of the DDI with the trap’s natural length scales. This $k$ dependence yields qualitative differences in the dispersion relation compared to that of a nondipolar BEC and of a uniform dBEC. In this section, we keep the notation of $\widetilde { V _ { \mathrm { d d } } } ( k )$ for the DDI effective coupling strength, which determines the excitation dispersion relation, even if the gas in non-uniform and this differs from the Fourier transform of Eq. (8).

A particularly interesting case is when the dispersion relation $\epsilon ( k )$ of a dBEC becomes non-monotonic, presenting a local maximum (maxon) followed by a local minimum (roton). Such a qualitative change in the dispersion relation underlies important new physical behaviour. To get a first insight into such changes, it is interesting to highlight that such dispersion relation resembles the celebrated dispersion relation of superfluid helium [101–103]. Here, roton excitation were first speculated to explain the exotic macroscopic properties of this superfluid [101, 102, 397], long before their observation [103]. Thanks to its low energy, the roton excitation strongly influences the response of the superfluid to small excitations. Furthermore, because of its large momentum, the roton underlies the tendency of the fluid to crystallise (at the wavelength corresponding to its inverse momentum) [398–400] (although one should note that the phase transition to solid helium is not due to Roton softening).

# • Roton excitation spectrum in anisotropic semi-infinite dBECs:

In 2003, a dispersion relation presented a roton minimum was predicted to occur in anisotropically trapped weakly interacting dipolar gases, first in the context of light-induced DDI by O’Dell et al. [98] and, shortly after, in that of magnetic or electric dipolar system by Santos et al. [99]. These seminal works consider semi-infinite trapping geometries, i.e., infinite along one ( $\omega _ { z } = 0$ ) [98] or two ( $\omega _ { \rho } = 0$ ) [99] directions of space, and harmonically confined along the others. This treatment allows to account for anisotropy effects while facilitating theoretical treatment, yielding semi-analytical expressions of $\widetilde { V _ { \mathrm { d d } } } ( k )$ within the TF approximation, and providing an intuitive picture of the effect.

The occurrence of a roton minimum arises from $\widetilde { V _ { \mathrm { d d } } } ( k )$ becoming attractive at large $k$ . In the quasi-infinite geometries of Refs. [98, 99], the confinement acts to limit the attractive contribution of the DDI: The attraction dominates over the repulsive contribution only if the momenta (along an unconfined direction) have a norm larger than the inverse characteristic confinement length $\ell _ { z }$ . In this way, for excitations along the unconfined directions, $k \ll 1 / \ell _ { z }$ yields $\widetilde { V _ { \mathrm { d d } } } ( k ) > 0$ , while, for $k \gtrsim 1 / \ell _ { z }$ , $\widetilde { V _ { \mathrm { d d } } } ( k ) < 0$ . Therefore, the DDI stiffens the dispersion relation in the phononic regime while it bends it down for large $k$ . Because of the additional contribution of kinetic term $\frac { \hbar ^ { 2 } k ^ { 2 } } { 2 m }$ which ultimately dominates at very large $k$ , the effect of $\widetilde { V _ { \mathrm { d d } } } ( k ) < 0$ is the strongest at $k \sim 1 / \ell _ { z }$ and, for weak enough $s$ -wave coupling strength $g$ , a minimum arises at $k _ { \mathrm { r o t } } \sim 1 / \ell _ { z }$ , matching a roton mode. Here the roton wavelength is typically set by the confinement along the direction of attractive DDI. Furthermore, the roton energy $\Delta$ can be lowered by increasing the density or increasing $\varepsilon _ { \mathrm { d d } }$ . When $\Delta \ : = \ : 0$ , Ref. [99] finds $k _ { \mathrm { r o t } } = \sqrt { 2 } / \ell _ { z }$ , independent of the density and the interaction parameters $g$ , $\varepsilon _ { \mathrm { d d } }$ .

# • Roton excitation spectrum in anisotropic fully trapped dBECs:

Numerous subsequent theoretical works describe the roton in dipolar gases confined in finite geometries (Eq. (44) with $\lambda \gg 1$ ). They study how the roton spectrum of the infinitely elongated geometries described above survive in the fully trapped case and how the steady state and dynamical behaviour of dBECs are affected [100, 113–115, 392, 401–411]. In the case where the trap is tightly confining along the dipoles and sufficiently anisotropic (e.g., $\lambda \gg 1$ ), a roton-like spectrum arises for large enough $\varepsilon _ { \mathrm { d d } }$ . The relevant range of $\varepsilon _ { \mathrm { d d } }$ depends on the exact trap geometry. While, in the inhomogeneous case, the momentum is not longer a good quantum number, the rotonic properties of the spectrum are most directly revealed by the behaviour of the dynamic structure factor. This factor $S ( k , \omega )$ conveniently describes the system’s response to a Bragg excitation at momentum $k$ and frequency $\omega$ [402]. Furthermore, in harmonically trapped geometries, the elementary mode contributing to the roton minimum in the dynamic structure factor has an amplitude that vanishes away from the dBEC centre [403]. This confinement effect can be understood, within the local density approximation, as the roton energy decreasing with increasing density. This translates into a finger-like feature in the (discrete) dispersion relation [408]. Other signatures of the existence of the roton mode in finite dBECs include anomalously large density fluctuations at the roton wavelength in an equilibrium gas [404, 407, 409], strong correlation emerging from an interaction quench [411], and peculiar structures in the collapse dynamics [114, 115]; see also Sec. IV A 4 c.

When the trap anisotropy is reduced (e.g., $\lambda \gtrsim 1$ ) and $R _ { \perp } \gtrsim R _ { z }$ , the existence of a roton feature, occurring at large $k$ compared to $1 / R _ { \perp }$ , becomes progressively lost. Indeed, the argument of a finite $k$ scale for the activation of the attractions starts to break down. Yet the interplay between DDI and geometry persists, now including also finite-size effects. This yields other interesting features in the excitation spectrum, in particular the so-called angular roton mode that has a momentum $k \sim 1 / R _ { \perp }$ , but a non-zero angular momentum [113, 412]; see also discussion in Sec. IV A 4 c. Finally, we note that while most of the theoretical work has focused on cylindrically symmetric geometries about the dipole axis, extensions to transversely anisotropic geometries have also been discussed [401].

# • Experimental measurements of the roton spectrum:

The roton mode has remained elusive in Cr experiments due to the weak dipolar character of this species. That weakness makes the $a$ -range of existence of a potential roton minimum very narrow, as well introduces strong three-body losses when tuning within this small $a$ – see also Sec. V. This leads to a fast change of the BEC’s properties, including its excitation spectrum.

![](images/76e29ec6db6090cd4e6d4df7c5e30a546cf2f9ca8dcc6a15106059f49e8c40cd.jpg)  
FIG. 16: Roton excitation spectrum measured with a $^ { 1 6 6 } \mathrm { E r }$ dBEC of cigar shape (cigar along $y$ , dipoles along $z$ ). (a) Measured dispersion relation (dots) compared to predicted response for the Bragg measurement (colorcode) at $a = 5 2 . 5 a _ { 0 }$ [theory at $5 1 . 6 a _ { 0 } ]$ . (b) Measured $\epsilon ( k _ { \mathrm { r o t } } )$ vs. scattering length (circles) and corresponding theory prediction. The shadings show the calculations over the prediction interval of $a$ . The dashed line shows the power-law fit to the experiment. Inset: zoom-in around the instability threshold comparing $\epsilon ( k _ { \mathrm { r o t } } )$ (circles) to $\epsilon ( k _ { \operatorname* { m a x } } )$ of the maxon [local maximum] (triangles), respectively with the power-law fit and a guide to the eye (dashed lines). The region where $0 \leq \epsilon ( k _ { \mathrm { r o t } } ) \leq \epsilon ( k _ { \mathrm { m a x } } )$ is highlighted with a white background. Adapted from [313].

The roton mode was experimentally observed in a $^ { 1 6 6 } \mathrm { E r }$ BEC [312, 313] using a cigar-shaped trap geometry with the dipoles aligned along a tightly confining direction. This geometry, simplifying experimental observations, differs from most of the early theoretical works on roton excitations, which rely on cylindrical symmetry around the dipole axis. The observation of Ref. [312], relying on instability dynamics, will be described in Sec. IV A 4 c.

In Ref. [313], Petter et al. [313] reported on roton spectrum measurements based on Bragg spectroscopy, similar to $\mathrm { S e c . }$ a. The scattering length was tuned close to instability and the excited momentum, along the trap axis, varied from $k \ll 1 / \ell _ { z }$ to $k \sim 2 / \ell _ { z }$ , thus probing the full phonon-maxon-roton dispersion relation; see Fig. 16(a). When increasing $\varepsilon _ { \mathrm { d d } }$ , a preferential softening of $\epsilon ( k )$ at large $k$ is observed, finally forming a minimum at $k = k _ { \mathrm { r o t } } \sim 1 . 3 / \ell _ { z }$ ; see Fig. 16(a). The minimum is observed only in a narrow range of scattering lengths and the roton gap shows a fast decrease with $\varepsilon _ { \mathrm { d d } }$ toward instability ( $\epsilon ( k _ { \mathrm { r o t } } ) \approx 0$ ), see Fig. 16(b). The Bragg measurements also proved, through the increase of the Bragg response, the enhancement of density-density correlations at $k _ { \mathrm { r o t } }$ as the roton instability is approached, indicative of the system tendency to crystallise. More recently, experiments performed on Dy BECs revealed roton excitations by a direct analysis of the in-situ density fluctuations [413], following early theoretical studies [404, 407, 409]. Fluctuation analysis provides access to the static structure factor. It also allowed to identify the two degenerate roton modes, which correspond to symmetric and antisymmetric density patterns to the trap centre. The study of roton excitations via the induced density fluctuations was extended beyond the cigar-shaped case, to oblate systems, in an independent set of experiments [414]. Here the the distinct softenings of several radial and angular rotons were revealed. As introduced in the previous paragraph, radial rotons correspond to the standard situation of a mode of large radial momentum $\langle k \rangle$ and radial symmetry, angular rotons distinctly have low $\langle k \rangle$ but large angular momentum and show azimuthal patterns [408, 412] and reveal as such in the density fluctuations.

# 4. Mean-field stability of dBECs

Beyond the properties of the ground state and its collective excitations in a stable regime, the DDI also impacts the very stability of the state, in particular making it geometry dependent. In this section, we review in detail the effect of the DDI on the stability of the quantum gases: first, how the DDI makes stability depends on the trap geometry; second, how it affects the stability of a cloud via long-range interactions between neighbouring clouds; and finally how the DDI introduces, beyond the global stability condition, a distinct (local) collapse mechanism in some special geometries. We will see how the later case relates to the softening of excited modes distinct from the lowest lying ones, arising from the interplay of DDI and either anisotropic geometries or, additionally, finite-size effects.

# $a$ . Global mechanical stability for a single BEC

Three-dimensional, homogeneous BECs under contact interactions are mechanically stable for positive compressibility [415] $\chi = \textstyle { \frac { 1 } { n m c _ { 0 } ^ { 2 } } } > 0$ (where $c _ { 0 }$ is the speed of sound; see Sec. IV A 3 a), they are thus unstable for $a ~ < ~ 0$ [11, 110]. Finite-sized [416] and harmonically trapped [3, 106] BECs can be stabilised by quantum pressure for small negative scattering length. As dBECs experience competing interactions, their mechanical stability criterion is more complex. Even at positive scattering length, this mechanical instability occurs for $\varepsilon _ { \mathrm { d d } } = 1$ a s the sound velocity perpendicular to the dipole orientation then cancels, $c ^ { 2 } | _ { \theta _ { k } = \pi / 2 } = 0$ ; see Sec. IV A 3. However, this holds for only infinite, homogeneous, and isotropic BECs. Because of the anisotropic character of the DDI, the anisotropy of real samples must be considered to understand their stability.

# • Stability within the TF approximation:

Global mechanical collapse can be alternatively understood from an energy argument. The energy density of MF interactions, when attractive, scales like $E _ { \mathrm { M F } } \sim - n ^ { 2 }$ and is thus minimised for infinite density. Using the TF approximation and neglecting the kinetic energy contribution, $E _ { \mathrm { M F } } < 0$ leads to a singularity of the ground state density, thus giving an instabibility. From Eq. (49), the sign of the MF dipolar energy of a cylindrical dBEC depends on the cloud aspect ratio $\kappa$ . Taking into account both interactions, one can show that the total MF interaction energy scales like

$$
E _ { \mathrm { M F } } \sim g n _ { 0 } N \big ( 1 - \varepsilon _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa ) \big ) .
$$

Imposing an attractive MF interaction, $E _ { \mathrm { M F } } < 0$ , leads to the instability condition $a < a _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa )$ . Solving for $\kappa ( \lambda )$ through (48) leads to a stability diagram as a function of $a$ and $\lambda$ . Intuitively, for very prolate traps, $\lambda \ll 1$ and the dipoles are aligned head-to-tails $\kappa \ll 1$ while the DDI is mostly attractive ( $f _ { \mathrm { d i p } } ( \boldsymbol { \kappa } ) \approx 1 $ ). Thus, $a$ must surpass $a _ { \mathrm { d d } }$ for stability. For the opposite case of very oblate traps ( $\lambda \gg 1$ ), dipoles repel each other twice more strongly $f _ { \mathrm { d i p } } ( \kappa ) \approx - 2$ , and $a$ must be large and negative to reach an effective attractive MF energy, $a < - 2 a _ { \mathrm { d d } }$ . This simple reasoning that considers only the MF interaction leads to a prediction that well describes experimental observations [417]; see Fig. 17(a).

# • The Gaussian ansatz for a BEC near collapse:

However, near collapse, kinetic energy effects also play a role, especially for low atom numbers. One must depart from the TF approximation, keeping all terms in Eq. (47). The variational Gaussian ansatz provides a semi-analytical approach

$$
\psi ( r ) = \frac { N } { \pi ^ { 3 / 4 } \bar { \sigma } ^ { 3 } } e ^ { - \sum _ { j = ( x , y , z ) } \frac { i ^ { 2 } } { 2 \sigma _ { j } ^ { 2 } } } ,
$$

inserted into Eq. (47), the energy is minimised with respect to the variational parameters $\sigma _ { x , y , z }$ , describing the BEC sizes along the trap axes $x , y , z$ . Here, $\bar { \sigma } = ( \sigma _ { x } \sigma _ { y } \sigma _ { z } ) ^ { 1 / 3 }$ . Once the integral is carried out, the different contributions read:

$$
E _ { \mathrm { k } } = N { \frac { \hbar ^ { 2 } } { 4 m } } \sum _ { i } { \frac { 1 } { \sigma _ { i } ^ { 2 } } }
$$

![](images/2062a635a6e2cef47b1cb83fb1ef8cb1a9ea4775dddb60a007271e3383e5fda2.jpg)  
FIG. 17: Stability diagram of a $^ { 5 2 } \mathrm { C r }$ dBEC in a cylindrical trap of aspect ratio $\lambda$ versus $a$ . (a) Taken from [417]. The thin grey line is the result of the condition $a < a _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa )$ , while the green line is the result of the Gaussian ansatz analysis. The red line is for $\varepsilon _ { \mathrm { d d } } = 0$ . In the large N limit this diagram is universal, i.e., it also holds for electric dipoles. (b) Same data as (a), now compared to either a Gaussian ansatz (dashed line) or a numerical solution, minimising Eq. (49) (solid line). From [412]

for the kinetic energy,

$$
E _ { \mathrm { t r a p } } = N \frac { m } { 4 } \sum _ { i } \omega _ { i } ^ { 2 } \sigma _ { i } ^ { 2 }
$$

for the external trapping energy, and the MF interaction energy reads

$$
E _ { \mathrm { M F } } = N ^ { 2 } \frac { g } { 2 ( 2 \pi ) ^ { 3 / 2 } \bar { \sigma } ^ { 3 } } ( 1 - \varepsilon _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa _ { x } , \kappa _ { y } ) )
$$

where we allowed non-axisymmetric traps. The expression for the generalised $f _ { \mathrm { d i p } }$ function in terms of the two aspect ratios $\kappa _ { x , y } = \sigma _ { x , y } / \sigma _ { z }$ was first worked out in [418]. One can then minimise the total energy $E =$ $E _ { \mathrm { k } } + E _ { \mathrm { t r a p } } + E _ { \mathrm { M F } }$ to find the ground-state size $\sigma _ { x , y , z }$ . In general, for $\varepsilon _ { \mathrm { d d } } > 1$ , there is always a global singularity with $\kappa _ { x , y } \ll 1$ and $E \to - \infty$ , but a local metastable minimum exists as well and sets the stability condition. While they coincide for very large $N$ , at finite $N$ the stability diagram from the Gaussian ansatz differs from the one derived using a TF approximation, see, e.g., Fig. 17(a).

At low trap aspect ratios $\lambda \ll 1$ , the kinetic energy acts to stabilise the gas against collapse, as in the contact case. However, for $\lambda \gg 1$ the effect is opposite, kinetic energy increases the smallest size, which adds a little attraction via dipolar effects and destabilises the gas.

# First measurements of the instability threshold:

The instability threshold was studied in $\mathrm { ^ { 5 2 } C r }$ BECs of about 25,000 atoms in tunable traps [417]: When quenching $a$ downward using a magnetic FR, the authors observed an abrupt and quick disappearance below a critical value, $a _ { \mathrm { c r i t } }$ , of the BEC peak in TOF images. The experimental values of $a _ { \mathrm { c r i t } }$ as a function of $\lambda$ were found to agree well with the Gaussian ansatz predictions; see Fig. 17. For the first time, the stability and thus the very existence of a BEC was ensured solely by dipolar interactions, and a purely dipolar BEC with $a = 0$ was obtained [417].

# $b$ . Stability of dBEC assemblies

Consider a stack of pancake-shaped BECs, realised with a one-dimensional optical lattice. The DDI being long-range, the total energy of a given layer contains contributions from interactions with neighbouring layers. Since the stability of the system is ensured by the existence of an energy minimum, nearest-neighbour interaction can modify the stability diagram. Indeed, the first observation of nearest-neighbour dipolar effects was reported in [419] via dephasing of Bloch oscillations in a potassium optical lattice interferometer. Fattori et al. then calculated the inter-site interaction using a Gaussian ansatz for an individual layer. The contribution is attractive if the dipoles are aligned with the lattice direction. This negative contribution modifies the energy landscape and can suppress the local minimum, destabilising the gas. This can be understood in the following way: The neighbouring layers attract the atoms resulting in an effective repulsive potential along this axis. The pull is stronger at the radial centre where the neighbouring density is highest leading to a stronger effective radial trapping. The total effect is destabilising the BEC. The instability threshold in scattering length is thus higher. Müller et al. [420] have observed this effect with a $^ { 5 2 } \mathrm { C r }$ gas in a one-dimensional optical lattice, obtained with a retro-reflected 1064 nm beam. The difference in critical scattering length with respect to a theory neglecting the neighbouring layers was as high as $8 a _ { 0 }$ , in agreement with expectations; see Fig. 18.

All arguments given above consider the stability of a dBEC at equilibrium inside a trapping potential (harmonic or optical lattice). The in-situ density distribution determines the MF stability. However, even for a stable in-trap density, it is possible that the release from an optical lattice into free-space modifies the distribution in a way that makes it mostly attractive and then induces collapse. This deconfinement-induced collapse has been observed experimentally in Ref. [421]. Experiments were performed in an optical-lattice along the dipoles axis.

![](images/8ed082dd6fd02eaa2b876441f6ed4ff949c130fdf8b1a16b1ef5dbd1f794bdb3.jpg)  
FIG. 18: Stability diagram of a dBEC in an optical lattice as a function of lattice depth and scattering length. The experimental data is compared with theory including (excluding) the influence of neighbouring traps as full (dot-dashed) lines. Red lines correspond to a full numerical solution of the GPE (Eq. (9)), while blue lines correspond to a Gaussian variational ansatz for the onsite density distribution. From S. Müller, PhD thesis, Stuttgart University.

They showed that, for large lattice depths, no losses were observable in-trap. However the release from the trap leads to a collapse visible in the d-wave shape of the density distribution, see also Sec. V. Simulations of the GPE confirmed that no atomic losses were expected in trap, but were induced by the deconfinement and following collapse.

# c. Modulational instabilities

# • Modulational instabilities predicted from DDI:

The stability criterion developed above, based on the existence of a local minimum in the energy landscape as a function of the BEC widths $( \sigma _ { x , y , z } )$ , is only partial. It allows only shape-conserving perturbations to the BEC profile. However, other perturbations containing local density modulations are not taken into account by this criterion. The existence of instabilities driven by higher lying modes in dBECs was first noted in the seminal paper [99] predicting a roton-type dispersion relation in anisotropic semi-infinite dBECs, see Sec. IV A 3 c and ref. [100]. Tuning the parameters of the dBEC (i.e., its scattering length and trapping geometry) can lead to a softening of this roton minimum ( $\omega$ reaching zero and becoming imaginary). Then, the dBEC becomes unstable and, in the early dynamics, its population gets transferred to the roton mode leading to the onset of density waves and, hence, a type of modulational instability.

The combined effect of axial trapping and DDI is also present in finite-size dBECs, as long as a tighter confinement is applied along the dipoles; see also Sec. IV A 3 c. This mechanism was also shown to favour local density modulations in the equilibrium profile of the dBEC itself, i.e., as a result of finite-size effects [113, 422, 423].

In this case, an instability can be triggered when $\varepsilon _ { \mathrm { d d } } > 1$ . It differs from a global instability in that several local attractors gather the atomic density leading to an ensemble of local collapses [114, 115, 412]. This kind of instability can be seen as the softening ( $\omega ^ { 2 } ~ < ~ 0$ ) of a mode that is not one of the lowest-lying surface and monopole modes: one quantum number is not the lowest possible one, for instance the momentum $\langle k \rangle$ or the angular momentum $m$ [408, 412]. Yet, due to confinement, this mode still belongs to the discrete part of the spectrum where the wavenumber is not a good quantum number : $\langle k \rangle \times R _ { \perp } \lesssim 1$ where $R _ { \perp }$ is the typical size of the BEC in the plane perpendicular to the magnetic field and $\langle k \rangle$ is calculated for the given mode. In particular, in narrow regions of the $( \lambda , N )$ -space, BECs with biconcave shapes have been predicted by minimising the energy functional of the GPE (i.e., in the MF regime) and their collapse are driven by angular roton [115, 412, 414, 422, 423]. The softening of this intermediate-low-lying modes also yields a type of modulational instability.

We note that, in ultracold atom experiments, modulational types of instability were first predicted for contact interacting gases [424] and investigated in this case [425, 426]. These modulational instabilities are in fact of a different nature to the one described above for dBECs. Indeed, in the contact case, the lowest lying mode is always soft at the instability (imaginary $\omega$ ). The modulational instability here arises when other modes are also unstable and have a larger growth rate. The mode with the highest growth rate has a finite $k$ , which is then favoured rather than global collapse [427, 428].

# • Experimental evidence for local collapse:

In dBECs, the role played by local collapse was first noted by an extensive theoretical analysis of the data from Ref. [417] by Wilson et al. [412], going beyond the Gaussian ansatz (Eqs. (54)-(57)) and solving exactly the GPE (Eq. (9)). Their predictions, showing a better agreement with the measured stability threshold at large trap anisotropy with $\lambda \gtrsim 3$ (Fig. 17(b)), implies the occurrence of local collapse. Yet the instability mechanism was not experimentally resolvable and later studies of the collapse dynamics also let modulational instabilities remain elusive, see Sec. V A [429].

More recently, the impact of such instabilities was experimentally studied on finite-size anisotropicallytrapped dBECs of $^ \mathrm { 1 6 4 }$ Dy, either in pancake traps [185] or in cigar shaped ones [430, 431] with a tight confinement along the dipoles. Here, after quenching $a$ down, remarkable long-lived in-situ density structures were observed. The observed density structures have been attributed to the occurrence of a modulational instability following the quench [185]. Because of the limited system size of the original pancake-shaped geometry in Ref. [185], the instability is expected to be driven by an angular mode with $\langle k \rangle \times R _ { \mathrm { B E C } } \sim 1$ and $m > 1$ [432], as also experimentally evidenced in a recent set of experiment [414]. Following their first observation, the authors of the above-cited experimental works characterised the absence or existence of a modulational instability as a function of the trap geometry via its signature on the final density distribution; i.e., the observation of single or multiple droplets long after the quench [433]. They identify a critical trap aspect ratio $\lambda = 1 . 8 7 ( 1 4 )$ (compared to the dipole orientation, $z$ ) above which the modulational instability exists; see also Sec. V C 1. The instability itself was not experimentally investigated in these works as they focused on the long-time behaviour, which results from a subsequent intricate non-linear dynamics loosing track of the unstable mode driving the collapse. The authors found that these final density distributions were surprisingly stable, which revealed an unpredicted stabilisation mechanism. This discovery set the ground for a new paradigm of quantum fluids, which will be discussed in the next Section V.

![](images/9d62c7ccdc19fb418c558199c0d54f53479764c76cee47b20c565239ee6a2dce.jpg)  
FIG. 19: Roton mode in a $^ { 1 6 6 } \mathrm { E r }$ dBEC of cigar shape (cigar along $y$ , dipoles along $z$ ). (a) Average momentum distribution showing the appearance of two side peaks at finite $k _ { y }$ (along the cigar elongation) after a quench to lower $a$ . (b) Extracted $k _ { \mathrm { r o t } }$ for different traps, as a function of $1 / \ell _ { z }$ , $\ell _ { z }$ the confinement length along the dipoles. Data (dots) are compared to a semi-analytical theory (dotted line) and numerical simulations of the GPE (dashed line). (c) Imaginary roton gap, $\Delta$ , versus $a$ , extracted from the growth rate of the momentum-peak population and comparison to the results of the semianalytical theory (solid line). The inset show the same data but as a function of the time after the $a$ -quench. [312].

# • Experimental investigation of the roton instability:

As introduced in Sec. IV A 3 c, Ref. [312] first observed the roton excitation by probing the instability dynamics of a large, cigar-shaped dBEC of $^ { 1 6 6 } \mathrm { E r }$ with transverse magnetisation. Chomaz et al. performed a fast interaction quench and studied the short-time evolution of dBEC. The authors reported the transient appearance of remarkable structure in the momentum distribution of the dBEC with a high-amplitude central peak framed along the cigar-long axis by two lower-amplitude symmetric side peaks, see Fig. 19(a). Based on a Bogoliubov picture relevant for the short-time dynamics, this was interpreted as the coherent population of finitemomentum excitation modes thanks to its privileged dynamical softening to imaginary energies, indicative of an unstable roton mode. By further studying the peak position and the time evolution of its population, the authors demonstrated the characteristic scalings $k _ { \mathrm { r o t } } \sim 1 / \ell _ { z }$ and $\omega _ { \mathrm { r o t } } \propto ( a - a ^ { * } ) ^ { 1 / 2 }$ for the unstable regime ( $a < a ^ { * }$ ); see Fig. 19(b-c). These observations are in agreement with theory predictions based on an analytical model as well as on GPE simulations.

![](images/2332226a9a6d978a3a68aaad7287e5f2282ddafd25745c49a522e47ce262ce88.jpg)  
B. Dipolar quantum-degenerate Fermi gases   
FIG. 20: Anisotropy $\Delta = 1 - \mathrm { A R }$ (AR is the cloud aspect ratio) of the time-of flight distribution of a degenerate Fermi gas of $^ { 1 6 7 } \mathrm { E r }$ versus the parameter $\eta = E _ { \mathrm { d i p } } / E _ { \mathrm { F } }$ . Data (dots) are compared to the predicted Fermi surface deformation (dashed line) as well as the prediction accounting for the interaction effects during the TOF. From [434].

Degenerate Fermi gases of polarised dipolar fermions constitute an interesting system in which identical fermions directly interact. Alkali-metal polarised fermions are usually non-interacting, as, away from FRs, the short-range interactions can be neglected due to the Pauli exclusion principle; see III A. Because of universal dipolar scattering (see Sec. III B), dipolar fermions do interact and thus offer a unique possibility to explore physics combining the effects of Fermi statistics and interactions. In particular, this system offers new prospects for the creation of novel Fermi liquids [435, 436], anisotropic superfluids [437], interlayer superfluids in optical lattices [438–440], or topological $p _ { x } + i p _ { y }$ phases [441]. Interesting prospects relate to higher-orbital BCS pairing. This is permitted in dipolar DFGs (dDFGs) thanks to the partially attractive character of the DDI. Such a high-orbital BCS transition would induce exotic superfluid behaviour. However, it requires a very low temperature to be observed [14, 16], beyond current possibility; see Sec. II.

In dDFGs, the DDI competes with the Fermi energy, $\begin{array} { r } { E _ { \mathrm { F } } \ = \ \frac { \hbar ^ { 2 } k _ { \mathrm { F } } ^ { 2 } } { 2 m } } \end{array}$ . The figure of merit is given by the ratio $n S ^ { 2 } d ^ { 2 } / E _ { \mathrm { F } }$ , corresponding to the ratio $\eta = E _ { \mathrm { d i p } } / E _ { \mathrm { k } }$ also used when considering thermal gases in Sec. IV A 2 b. For small values, $\eta$ can be rewritten, using the density scaling of the ideal Fermi gas as a function of the characteristic dipolar length and the Fermi momentum, $\eta = A k _ { \mathrm { F } } a _ { \mathrm { d d } }$ , where $A$ is a numerical coefficient. In the homogeneous case, $A = 1 / \pi ^ { 2 }$ . In experimental systems of magnetic atoms, $k _ { \mathrm { { F } } }$ is a few tens of $\mu \mathrm { m } ^ { - 1 }$ and $a _ { \mathrm { d d } }$ up to a few tens of nm, so $\eta$ is typically of the order of a few percent. This small value makes the observation of many-body dipolar phenomena more involved in a dDFG as compared to a dBEC, due to the large kinetic energy stored in the system (similar to the thermal case).

On the other hand, the small $\eta$ -value enables a semiclassical (Hartree-Fock) treatment of the physics of the dDFG. Within the Hartree-Fock theory, introduced in Sec. I D 2, the DDI contributes to the total mean energy of the system via two terms: the Hartree direct term, which is the usual MF term, and the Fock exchange interaction, which comes from the required antisymmetrisation of the wave-function.

# Fermi surface deformation:

Similar to the Bose case presented in Sec. IV A, the first effect of the DDI lies in a deformation of the ground state compared to the non-interacting case (magnetostriction). For a DFG, this deformation has a different flavour than for Bose gases, because of the predominant role played by the Fock term, which, it should be highlighted, has a pure quantum origin: While the Hartree term dominates the ground-state distortion in position space as in the bosonic case, it is now the exchange term which gives a dominant contribution to its distortion in momentum space; that is to say, a distortion of the Fermi sea itself. This effect has been extensively studied theoretically [123, 124, 442– 446].

The deformation of the Fermi sea under the effect of the DDI has been experimentally observed in an $\mathrm { E r }$ DFG via TOF expansion [434]. The experiment was performed in a harmonic trap in which no well-defined Fermi surface exists, but interactions do deform the Fermi sea momentum distribution. In addition, interaction effects during the expansion weakly break the one-to-one correspondence between momentum and TOF distributions. Collisions during TOF increase the deformation, but still the bulk of the TOF distribution deformation stems from the momentum distribution; see Fig. 20.

The TOF aspect ratio of the cloud is observed to rotate with the quantisation axis of the dipoles and its value is in agreement with theory. A linear dependence of the deduced Fermi-surface-deformation amplitude on $\eta$ has been verified experimentally as shown in Fig. 20. Additionally, the effect has been seen to disappear at higher temperature $k _ { \mathrm { B } } T / E _ { \mathrm { F } } ~ \gtrsim ~ 1$ . Complementary measurements and theory have been later reported in Ref. [446]. Here, the Fermi-surface-deformation amplitude could be reconstructed from the observed TOF aspect ratio for an arbitrary gas geometry. It was also shown that the Fermi surface deformation does not always rigidly rotate with the dipoles’ orientation but can also change in amplitude under the effect of the trap anisotropy. Yet such an effect remained elusive in the $\mathrm { E r }$ system due to the too weak DDI and moderate achievable trap anisotropies in the DFG regime.

Observation of many-body physics in spin-polarised DFGs has been for now limited to the above described Fermi surface deformation. However, many other interesting aspects may arise, even without reaching more degenerate samples. Following similar trends as for the bosonic case, one can mention the effect of the DDI on the excitation spectrum and in combination with (highly) anisotropic confinement [14]. Other directions includes the special character of impurity physics in dDFGs, the physics of multilayered or multitube systems, etc.

# V. Dipolar collapse and quantum stabilised states of Bose gases

In Sec. IV A 4, we discussed the instabilities of dBECs. In the framework of MF theory, they lead to singularities in the density ( $\textit { n } \to \infty$ ) and thus in the energy $| E | \to \infty$ for the many-body ground-state. This unphysical conclusion comes from the fact that the simple theory framework developed in Sec.IV (see also Sec. I D $\cdot$ ) breaks down at high density. When the density is increased, two effects should be additionally taken into account.

• First, at high density the approximation neglecting few-body collisions beyond binary ones breaks down. At the next order, three-body collisions should be considered. Their inelastic contribution leads in particular to atomic losses at high density [384, 447, 448]. Thus density is not locally conserved and obeys the equation $\begin{array} { r l } { \partial _ { t } n + \nabla \cdot ( n \vec { v } ) \ = } \end{array}$ $- L _ { 3 } n ^ { 3 }$ , where $L _ { 3 }$ is the recombination loss constant. One can effectively add a non-conservative term in the GPE which reproduces the above equa

tion, this term reads

$$
i \hbar \partial _ { t } \psi | _ { \mathrm { 3 b } } = - i \frac \hbar 2 L _ { 3 } | \psi | ^ { 4 } \psi .
$$

We also note that three-body interactions can additionally lead to a conservative term and, very early on, its effect has been theoretically considered, yielding the prediction of a liquid phase [449, 450]. Despite the fact that this mechanism has regained recent theoretical interest in the case of dBEC [451– 453], it has remained elusive in current experimental setups [431]. Conservative three-body interactions will then be neglected in the following.

• Second, strong enough interactions yield corrections to the population (so-called quantum depletion) and to the energy of the BEC mode. This can be described within Bogoliubov theory, where one still considers only two-body interactions and assumes a macroscopic, yet not complete, occupation of the condensate mode (i.e. single-particle ground state). Expanding to second order in powers of the non-condensed population (i.e. population in the single-particle excited states) yields a quadratic Hamiltonian approximating the manybody one, which can be diagonalised [11, 88]. At this order, the ground state energy is given by the zero-point energy of the elementary excitations that diagonalize the quadratic Hamiltonian, which correspond to elementary excitations. This groundstate energy is shifted compared to the MF energy that matches that of a pure condensate (zero population in excited single-particle states). The correction to the MF results are thus referred to as quantum fluctuations effects, i.e. coming from the fluctuations of the vacuum of the excitations.

The resulting modification to the equation of state for a non-dipolar BEC was first calculated by Lee, Huang and Yang in 1957 [116, 117]. The energy of a homogeneous repulsive Bose gas then reads $E =$ $\textstyle { \frac { g } { 2 } } { \frac { N _ { 0 } ^ { 2 } } { V } } ( 1 + { \frac { 1 2 8 } { 1 5 { \sqrt { \pi } } } } { \sqrt { n _ { 0 } a ^ { 3 } } } )$ where $N _ { 0 }$ ( $n _ { 0 } = N _ { 0 } / V$ ) is the number (density) of atoms in the BEC occupying a volume $V$ . The first term of the sum is the usual MF energy, the second one corresponds to the firstorder beyond-MF (BMF) correction, so-called LeeHuang-Yang (LHY) correction. The strength of the LHY correction is set by the gas parameter $n _ { 0 } a ^ { 3 }$ .

Adding the DDI modifies the spectrum of the elementary excitations, see Sec. IV A 3, Eq. (52), and thus should modify their zero-point energy. This was calculated in [454–456], giving

$$
E = \frac { g } { 2 } \frac { N _ { 0 } ^ { 2 } } { V } \left( 1 + \frac { 1 2 8 } { 1 5 \sqrt { \pi } } \sqrt { n _ { 0 } a ^ { 3 } } Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) \right) ,
$$

where the function $\begin{array} { r l r } { Q _ { l } ( x ) } & { { } = } & { \int d \theta \sin \theta ( 1 \ + } \end{array}$ $x ( 3 \cos ^ { 2 } \theta - 1 ) ) ^ { l / 2 }$ results from angular averaging of Eq. (52). Since the dispersion relation becomes imaginary at some angles for $\varepsilon _ { \mathrm { d d } } > 1$ , so does $Q _ { 5 }$ . Therefore the energy (59) is formally defined only for $\varepsilon _ { \mathrm { d d } } \leqslant 1$ . However, the imaginary part of $Q _ { 5 }$ remains very low for $\varepsilon _ { \mathrm { d d } } \lesssim 3$ . Then, one might ignore it and use Eq. (59) for $\varepsilon _ { \mathrm { d d } } \gtrsim 1$ without a complete breakdown of the theory.

In addition to this energy correction, the computation of the many-body ground state (total density $n$ ) within Bogoliubov theory, also gives access to the corresponding quantum depletion density $\delta n = n - n _ { 0 }$ . For a homogeneous dBEC, one finds $\begin{array} { r } { \delta n / n _ { 0 } = \frac { 8 } { 3 \sqrt { \pi } } \sqrt { n _ { 0 } a ^ { 3 } } Q _ { 3 } ( \varepsilon _ { \mathrm { d d } } ) } \end{array}$ [454–456], recovering $\begin{array} { r } { \delta n / n _ { 0 } = \frac { 8 } { 3 \sqrt { \pi } } \sqrt { n _ { 0 } a ^ { 3 } } } \end{array}$ in the contact interacting case [116, 117]. One sees that the main assumption behind the Bogoliubov theory, namely a dominant population of the zero-momentum state, holds for small gas parameters $\sqrt { n _ { 0 } a ^ { 3 } } \ll 1$ . In the dipolar case, a similar discussion on the $\varepsilon _ { \mathrm { d d } }$ -range takes place as for the energy correction. This justifies aposteriori the validity regime given in Sec. IV for the MF theory, namely $n a ^ { 3 } \ll 1$ and $\varepsilon _ { \mathrm { d d } } \leqslant 1$ .

The above results hold true only for infinite, isotropic, homogeneous BECs. The connection to experimental systems is done through two further approximations to estimate Eq. (59). First, one might neglect the quantum depletion assuming that all the atoms are in the BEC $\mathit { n } _ { 0 } ~ = ~ \mathit { n }$ . One can therefore write an equation only for the BEC density and ignore its coupling to other modes. This approximation is mostly valid for experimental conditions so far where $\delta n / n _ { 0 }$ is below a few percents. Second, one might use the local-density approximation (LDA) for the calculation of the equation of state. This assumes that the density varies sufficiently slowly to calculate locally, for a given density $n$ , the energy shift. The derivation of Eq. (59) involves an integral over all momenta $k$ , which is dominated by the contribution at $k \simeq \xi ^ { - 1 }$ where $\xi$ is the healing length [11]. Typically, $\xi$ relates to the sound velocity $c _ { 0 }$ via $\xi = h m / c _ { 0 }$ . For dBECs, following Eq. (52) (see Sec. IV A 3), one can only define an ’angle dependent’ healing length and this diverges for $\varepsilon _ { \mathrm { d d } } = 1$ along the dipole orientation. At first sight, thus, the LDA is never applicable for $\varepsilon _ { \mathrm { d d } } \geqslant 1$ . We will see below that the use of the LDA can still be justified for typical experimental samples at $\varepsilon _ { \mathrm { d d } } \gtrsim 1$ , see Sec. V B. Thus, within both approximations, the local energy shift can be calculated, and identically the chemical potential shift $\begin{array} { r } { \mu _ { \mathrm { B M F } } = \frac { \partial E _ { \mathrm { B M F } } } { \partial N } = \frac { 3 2 } { 3 \sqrt { \pi } } g n \sqrt { n a ^ { 3 } } Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) } \end{array}$ 323√π gn √na3Q5(εdd). To solve the equation of motion for a non-homogeneous system, one can then extend the GPE by this extra chemical potential [432, 457, 458]:

$$
i \hbar \partial _ { t } \psi | _ { \mathrm { B M F } } = \frac { 3 2 } { 3 \sqrt { \pi } } g a ^ { 3 / 2 } Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) | \psi | ^ { 3 } \psi .
$$

Now that we have effective terms to be added to the GPE for three-body recombination (Eq. (58)) and BMF (Eq. (60)) effects, we can compare their magnitudes to the MF chemical potential (see Eqs. (9)-(10)) to know which one comes first when the density increases significantly following an instability. To that end, one must know $a _ { \mathrm { d d } }$ , $a$ and $L _ { 3 }$ . $a _ { \mathrm { d d } }$ is fixed for a chemical species, see Sec. II E. Since the collapse occurs for $\varepsilon _ { \mathrm { d d } } \geq 1$ with the exact value depending on the particular trap geometry, we will fix a typical value of $\varepsilon _ { \mathrm { d d } } = 1 . 5$ , which further fixes $a$ to the values $a = 1 0 a _ { 0 } \ : ( ^ { 5 2 } \mathrm { C r } )$ , $4 4 a _ { 0 }$ $^ { \mathrm { 7 6 6 } } \mathrm { E r } )$ , $8 7 a _ { 0 }$ ( $^ \mathrm { 1 6 4 }$ Dy). The parameter $L _ { 3 }$ must be measured experimentally. In Figure 21 one can see the absolute values of three different contributions as a function of density[459] for the three dipolar atoms $\mathrm { ^ { 5 2 } C r }$ , $^ { 1 6 6 } \mathrm { E r }$ and $^ \mathrm { 1 6 4 }$ Dy. The values of $L _ { 3 }$ are extracted from Refs. [250, 383, 430]. For the above given values of $a$ , set using Feshbach tuning via the FRs specified in the refs mentioned above, we have $L _ { 3 } \simeq 2 \times 1 0 ^ { - 4 0 }$ for $^ { 5 2 } \mathrm { C r } , \simeq 8 \times 1 0 ^ { - 4 1 }$ for $^ { 1 6 6 } \mathrm { E r }$ , and $\simeq 5 \times 1 0 ^ { - 4 1 }$ for $_ \mathrm { 1 6 4 }$ Dy. Note that $L _ { 3 }$ depends on the fewbody-physics details and thus can vary with the specific FR used to tune $a$ . In Figure 21, one observes different hierarchies of mechanisms depending on the atomic species.

In the case of Cr, the weakness of $a _ { \mathrm { d d } }$ leads to a weak $a$ beyond instability and thus weak MF and BMF effects. As a consequence the three-body losses will have a much stronger effect and the BMF effect can be safely ignored from the dynamics. In this case, the instability leads to a so-called d-wave collapse, that we review in Sec. V A.

For Dy and Er, the BMF can be at par with the MF effects before the three-body losses destroy the sample. This leads to an entirely different dynamics, as well as new ground states, stabilised beyond the MF instability. We focus on this physics in Secs. V C-V D, see also Ref. [460].

![](images/c8fa7584c120d333190ecc878ad1ef1ca890c5aa670db6279c21293ba4afcfff.jpg)  
FIG. 21: Absolute value $| \mu |$ of the different non-linear terms of the extended Gross-Pitaevskii equation, assuming homogeneous density, and $\varepsilon _ { \mathrm { d d } } = 1 . 5$ . The (attractive) mean field dominates at low density. For $^ { 5 2 } \mathrm { C r }$ three-body losses (Eq. (58)) first become stronger, while for $^ { 1 6 6 } \mathrm { E r }$ and $^ \mathrm { 1 6 4 }$ Dy, BMF effects (Eq. (60)) first take over.

# A. Dipolar collapse

We focus here on the case of $\mathrm { ^ { 5 2 } C r }$ where the BMF effects are negligible (see above). A collapse occurs once the instability threshold is crossed. Experiments have focused on crossing the instability line (Fig. 17) by lowering $a$ . Once a collapse occurs, the density increases until the three-body losses become dominant over MF attraction (Fig. 21 top). This leads to a strong density depletion at the density maximum. Then, the MF attraction is reduced, down to a point where the kinetic energy, which is itself increased by the strong localisation of the wavefunction close to the collapse centre, becomes stronger. At that point, the remnant BEC fraction is strongly expelled, the BEC ’explodes’. This can be seen as a reflection of the wavefunction at the collapse centre. The explosion dynamics is thus expected to reflect the symmetry of the collapse. Being induced by the DDI, the collapse is not isotropic. The dipolar energy is minimised by decreasing the gas aspect ratio $\kappa _ { x , y }$ (see Eqs. (53) and (57)), and so one might expect that the BEC collapses radially, i.e. shrinks and later explodes in the directions transverse to the dipole orientation. An interplay with the initial anisotropy of the cloud is also expected.

The first experiments probing the collapse dynamics of a $\mathrm { ^ { 5 2 } C r }$ dBEC were performed starting from a nearly isotropic BEC [461]. The collapse was induced by a fast quench of $a$ down to an unstable value. Imaged after time-of-flight, the expanding cloud displays a strong anisotropy, see Fig. 22(a). As the collapse is induced in the radial direction, the relevant timescale for the collapse, $\tau$ , is set by the largest radial trapping frequency, $\tau = \mathrm { m i n } [ 1 / \nu _ { x } , 1 / \nu _ { y } ]$ . Strong atom losses are observed to occur at the initial time of the collapse (fraction of $\tau$ ), before the wavefunction is reflected away, see Fig. 22(b). A cloverleaf-like pattern is observed in the time-of-flight images after holding 0.2 to $0 . 5 \tau$ . This pattern, reminiscent of the d-wave symmetry of the DDI, gave the name $d$ - wave collapse. The density distribution is then observed to refocus after holding $\tau$ . This is because of the presence of the harmonic trap. The observed dynamics is very well reproduced by simulations of the GPE (Eq. (9)) additionally including the three-body loss term (Eq. (58)). The lost fraction of condensed atoms depends on the in-trap wait time after the collapse start, also very well described by the GPE simulation results, see Fig. 22 (a-b).

![](images/17f6a7cbe440da6e45b729734fd3a201e8e2fb8d69158d6bf92db849576073da.jpg)  
FIG. 22: Collapse dynamics of a $\mathrm { C r }$ BEC, (a-b) in a trap $( \nu _ { x } , \nu _ { y } , \nu _ { z } ) = ( 6 6 0 , 4 0 0 , 5 3 0 ) \mathrm { H z }$ for which the initial BEC is nearly isotropic, adapted from [461] and (c-d) in a trap $( \nu _ { x } , \nu _ { y } , \nu _ { z } ) = ( 6 5 0 , 5 2 0 , 4 0 0 ) \mathrm { H z }$ for which the initial BEC is prolate, adapted from [429]. Dipoles are oriented along $z$ . (a) and (c), time-of-flight absorption images in the $y z$ plane (upper rows) and corresponding simulated column density distributions (lower rows) for different hold time after the quench of $a$ (values given above). Time of flight is $\mathrm { 8 { m s } }$ . The initial scattering length is around $3 0 \mathrm { - } 3 5 a _ { 0 }$ while the final around $5 \substack { - 8 a _ { 0 } }$ , well below $a _ { \mathrm { c r i t } }$ . The in-trap inset shows the initial BEC aspect ratio $\kappa _ { y }$ . (b-d) measured (dot) and simulated atom number as a function of the hold time after the quench, $t _ { \mathrm { h o l d } }$ , in unit of $\tau = \tau _ { x } = 1 / \nu _ { x } = 1 . 5 \mathrm { m s }$ . All simulations rely on a GPE including three-body loss effects, i.e. Eq. (9) plus Eq. (58).

The fact that the expanding cloud remains condensed was investigated by collapsing several independent BECs in different sites of an optical lattice [429]. Following the collapse, the expanding clouds overlapped, exhibiting very clear interference fringes at long time. This proved the local coherence of the individuals expanding clouds, and thus that condensation was not fully destroyed by the collapse.

In anisotropic traps, not only the DDI but also the trap geometry impacts the collapse symmetry. In this way, very different patterns of the expanding BEC can be generated, evidencing the rich interplay between trap geometry and DDI in dBECs. This effect has been extensively studied in Ref. [429], where the authors studied different cases from very prolate to very oblate geometry. They also investigated the cross-over from a prolate geometry to the symmetric one of Ref. [461], as shown in Fig.22(a,c). While the two traps considered here have very similar frequencies within a simple permutation $\nu _ { y } ~  ~ \nu _ { z }$ , they display significantly different dynamical behavior. This ultimately demonstrates the role of the anisotropic DDI in the collapse dynamics.

# B. Theoretical description of dipolar quantum stabilised states

# 1. Simple description of dipolar quantum stabilisation

The phenomenology of MF unstable, strongly dipolar BECs of $\mathrm { E r }$ and Dy is fundamentally modified by the BMF effects. These effects can affect not only the dynamics of the BEC when driven to an unstable regime but also modify its stability itself, as it introduces a stabilisation mechanism. Indeed, the LHY correction of Eq. (60) provides an additional conservative potential, which acts as an effective higher-order (in three-dimension, effective $5 / 2$ -body interaction) interaction term in the GPE and which remains repulsive within its whole validity range [462]. This higher-order repulsive term has a density dependence of a higher power than MF (2-body interaction). In the attractive mean field regime, it thus could be thought to stabilise a high-density state for which BMF repulsion compensates MF attraction.

Let’s first consider the simplest case of single-peaked ground state — standard BEC in the MF stable regime and later called "droplet" in the MF unstable regime. Using a gaussian ansatz for its wave function $\psi$ (see also Eqs. (54)-(57)), one can calculate the MF and BMF contributions to the ground-state energy per particle and single-out the key ingredients that lead to stability:

$$
\begin{array} { r l } & { \frac { E _ { \mathrm { M F } } } { N } \quad = \frac { 1 } { 2 ^ { 3 / 2 } } \frac { g } { 2 } n _ { \mathrm { c } } \left( 1 - f _ { \mathrm { d i p } } ( \boldsymbol { \kappa } ) \boldsymbol { \varepsilon } _ { \mathrm { d d } } \right) } \\ & { \frac { E _ { \mathrm { B M F } } } { N } = \left( \frac { 2 } { 5 } \right) ^ { 3 / 2 } \frac { g } { 2 } n _ { \mathrm { c } } \frac { 1 2 8 } { 1 5 \sqrt { \pi } } \sqrt { n _ { \mathrm { c } } a ^ { 3 } } Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) } \end{array}
$$

where $n _ { \mathrm { c } }$ is the central density. For $f _ { \mathrm { d i p } } ( \kappa ) \varepsilon _ { \mathrm { d d } } > 1$ $E _ { \mathrm { M F } } ~ < ~ 0 $ while $E _ { \mathrm { B M F } } ~ > ~ 0$ . $E _ { \mathrm { B M F } }$ has a stronger dependency in the density by a power $n _ { \mathrm { c } } ^ { 1 / 2 }$ compared to $E _ { \mathrm { M F } }$ , therefore, by increasing $n _ { \mathrm { c } }$ , the ground-state energy can be minimized at a finite value, corresponding to a finite density. This stabilisation mechanism, relying on the mere effect of quantum fluctuation, is what we coin dipolar quantum stabilisation.

# 2. Simple description of ultra-dilute liquid state.

Remarkably, in presence of MF attraction, the singlepeaked state considered above can be stabilised even in the absence of trapping, by competing MF attraction and the BMF repulsion, the equilibrium between these two forces fixing the peak density $n _ { \mathrm { c } }$ (MF attraction dominates at low density, and BMF repulsion at high density).

Such a stabilisation mechanism is reminiscent of a liquid phase of matter. In ordinary liquids, the weak attraction on large distance (e.g. of van der Waals or covalent types) is counterbalanced by a strongly repulsive core arising from the electromagnetic forces and the Pauli exclusion between the atoms’ (or molecules’) electron cloud. This stabilises the liquid at a large density at which the repulsion becomes effective $n _ { \mathrm { c } } a _ { 0 } ^ { 3 } \sim 1$ . The stabilisation resulting from competing MF and BMF effects in strongly dipolar gases can similarly be seen as resulting in a liquid state.

Considering for now such an untrapped system, and neglecting kinetic energy, the equilibrium peak density can be estimated by imposing $\begin{array} { r } { \frac { \partial E } { \partial n _ { \mathrm { c } } } = 0 } \end{array}$ , with $E = E _ { \mathrm { M F } } +$ $E _ { \mathrm { B M F } }$ . One gets

$$
n _ { \mathrm { c } } \sim \frac { 1 } { a ^ { 3 } } \left( \frac { f _ { \mathrm { d i p } } ( \kappa ) \varepsilon _ { \mathrm { d d } } - 1 } { Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) } \right) ^ { 2 } .
$$

We note that Eq. (63) also provides a good estimate of the peak density in a trapped stabilised state, as long as one can neglect contributions of the kinetic and external trapping energies.

Interestingly, from Eq. (63) one can read-off that a stabilisation of the density occurs before reaching the dense regime $n _ { \mathrm { c } } a ^ { 3 } \sim 1$ , thus forming "ultradilute" liquid states. Two main effects enable to maintain the diluteness: The equilibrium density is reduced by the fact that there are two competing MF interactions, resulting in an effective MF attraction of much smaller amplitude than each of the two contributions (numerator in Eq. (63)). Second there is an amplified BMF contribution that leads to a further reduction of the density (denominator in Eq. (63)) [463].

The relatively low stabilising density resulting from these two ingredients protects the sample against an immediate destruction by three-body recombination. The dipolar collapse observed with Cr is thus prevented. Instead the BEC is stabilised via the effect of its quantum fluctuations, resulting in a distinct phase of liquidlike properties, the clouds formed are thus named quantum (dipolar) droplets. These droplets are denser than the MF-stable gaseous BEC, yet much more dilute than ordinary liquid (by $\approx ~ 8$ orders of magnitude). They offer a distinct paradigm of quantum fluid where the BMF effects are predominant yet tractable, see e.g. Secs. V B,V C 4.

We note that these exact same ingredients are present in another experimental system, namely mixtures of contact-interacting BECs with repulsive intra- and attractive inter-species interactions [464–466]. The stabilisation mechanism of bosonic mixtures was in fact proposed prior to the observations on dipolar BECs by D. Petrov [467]. For more information on these systems, see Ref. [460].

Finally, we note that, despite the fact that we have for now neglected trapping effects in this first description, they may also play a crucial role in the newly stabilised quantum states. In the case of dipolar atoms, this effect is not only quantitative (energy shifts) but also qualitative. Indeed, the interplay between trap anisotropy and DDI yields new features already in the MF-stable BEC, as reviewed in Secs. IV A 3 c,IV A 4 c. These new features in the excitation spectrum, that affect the MF instability, when combined with quantum stabilisation, may yield new ground states. This effects will be the focus of Sec. V D.

# 3. Toward a quantitative theory description: extended Gross-Pitaevskii equation.

Following the experimental observation of quantum droplets that we will more thoroughly describe in Sec. V C 2, several theory works [432, 457, 468] developed the framework based on an extension of the GPE (eGPE) to include the first order BMF effects. As introduced at the beginning of this chapter V, this consists in extending Eq. (9) with the term Eq. (60) (and potentially Eq. (58)). This perturbative approach is justified because the sample remains dilute with $n a _ { s } \ll 1$ . Here the BMF correction comes into play not because the gas parameter becomes large but rather because the overall MF terms are tuned small while both contact and dipolar interaction remains individually large. Then the BEC quantum depletion remains limited.

We note that the theory model relies on the use of the LDA for the LHY term. This approximation is justified if the dominant contribution to the LHY term have momentum larger than the inverse size of the ground state. Physically, the LHY correction, which corresponds to the zero point motion of the elementary excitations (see above), are dominated by contributions of the hard modes, i.e. the most energetic ones. Crucially, when decreasing $a$ (as to drive the MF-instability), the modes whose excitation occurs perpendicular to the dipoles get softer (and lead to the instability) while the one along the dipole get harder. The latter will then dominate the LHY correction. Remarkably, the BEC close to instability and the quantum stabilised states get very extended in the direction of the dipole, under the effect of magnetostriction (see Sec. IV A 2). Therefore, the LDA may remain a surprisingly good approximation in this regime, and even beyond the instability threshold.

Quantitatively, Wächtler et Santos [432] show that, using an anisotropic momentum cutoff, with an anisotropy matching the anisotropy of the droplet itself, at $1 \%$ of the inverse of the droplet extent, one still recovers most of the BMF effects (80%). This proves that the LDA is a good qualitative, and even quantitative, approximation, as long as the droplet remain elongated enough. The contribution of the long-wavelength modes may lead to small corrections, yet the authors note that this would mainly modify the prefactor of the LHY correction while the scaling should remain that of Eq. (60). This domination of the LHY correction by hard modes which makes relevant the use of the LDA even in small sized quantumstabilised states is also found in quantum droplets of bosonic mixtures as originally proposed by Petrov [467], see also Refs. [460, 464–466].

The relevance of eGPE framework was later quantitatively studied both in theory and experiments. Results from the eGPE and quantum Monte-Carlo (QMC) simulations of dipoles with hard-sphere repulsion were compared in Ref. [458] and found to be in good quantitative agreement. In experiment, the degree of agreement was found to vary depending on the exact settings, in particular on the gas geometry and on the density, see e.g. Refs. [190, 247, 250, 308, 312, 313, 329, 330] and later discussions. Typical discrepancies could be simply accounted by shifting the scattering length value by a few, and up to a few tens, of percents. More recently, a quantitative study compared eGPE theory, diffusive QMC simulations using finite-range interactions, and experiments [309]. A good agreement of the QMC results and the experiments was found, whereas the eGPE results are systematically shifted. Boettcher et al elaborate on the eGPE mismatch and show that it may be accounted by a more sophisticated description of the scattering, in particular by accounting for the effects of finite collision energy on the scattering properties, due to the finite temperature of the samples. Such effects are known to result in an effective renormalisation of the dipolar length [341], see also Sec. III A. By including such corrections in the eGPE yields a better agreement with the experimental data. Note that corrected eGPE and QMC constitutes two complementary theories that are able to describe experimental observations by accounting for different effects. The corrected eGPE accounts for temperature effects on the scattering properties but only includes quantum fluctuations at a perturbative and approximate level. QMC fully accounts for the quantum fluctuations, yet neglects thermal effects. The two theories account for different effects, and suggest that different sources of corrections with respect to the standard eGPE theory may be relevant. A full theoretical modelling, accounting for the different effects at once, and revealing their repsective role, is yet missing.

focus on the generation of self-modulated states in dipolar gases with anisotropic confinement. We will particularly focus on the global coherence and superfluid properties of the modulated states, and discuss the existence of a so-called supersolid phase, where solid and superfluid orders coexists, see Sec. V D.

![](images/aee54488ebbeda8269c405212c2b9e98434643fc0753f2e6e2ed49cb26971114.jpg)  
1. single droplet ground state in an external trap, eGPE phase diagram   
FIG. 23: Eigen-state phase diagram of a dipolar BEC of $N = 1 0 0 0 0$ atoms in a cylindrical harmonic trap of aspect ratio $\lambda = \omega _ { z } / \omega _ { r }$ . This diagram is obtained applying a gaussian ansatz to the energy functional 47, for a fixed value of $N a _ { \mathrm { d d } } / a _ { \mathrm { h o } } \simeq 7 9$ , this corresponds for Dy $\mathrm { E r } $ ) to a mean trap frequency of 80 Hz (312 Hz). The colouring shows the ground-state density in logarithmic scale and arbitrary units.

# C. Dipolar Quantum droplets

We now divide the discussion of quantum-stabilised states and their observations in two sections. In the present section, we will discuss the regime where the underlying ground state present no self-modulation, i.e it has only one density peak and forms either a standard BEC (repulsive MF) or a droplet state (attractive MF). In experiments, the droplets could there be produced either in assemblies of independent droplets, forming then a metastable state, or individually. We will more specifically focus on the latter case, which allows for a detailed characterisation of the state’s properties, in presence and in absence of external trapping. In a second part, we will

Following the seminal work establishing a theory description of the quantum-stabilisation mechanism, theoretical works tackle the question of the ground-state phase diagram of a dipolar gas and in the presence of the newly discovered stabilising term [457, 468].

The presence of an anisotropic harmonic trap with aspect ratio $\lambda = \omega _ { z } / \omega _ { r }$ (see also Eq. (44)) was considered, yet cylindrical symmetry around the dipoles direction $_ z$ was assumed. Mean trap frequencies and atom numbers following the experimentally relevant values were considered. In these works, only single-peaked ground states were predicted (i.e. no droplet assemblies, see Sec. V D 1). When decreasing $a$ at fixed atom number and trap geometry, the ground state was found to change from a low-density phase, matching a standard MF-stabilised BEC, to a high-density phase, stabilised by the LHY term, forming a “quantum droplet". The low-density BEC has a geometry roughly following that of the trap, while the droplet state is not. In particular, the droplet is always elongated in the direction of the dipoles, which is why it is sometimes called "filament". For traps elongated along the dipoles ( $\lambda \gtrsim 1$ ), the ground state smoothly evolves from the low-density MF-repulsive BEC to the high-density MF-attractive quantum-droplet phase when decreasing $a$ . This smooth crossover can be apprehended as the trap elongation along the dipole direction enables the two states to have similar geometries (elongated along the dipoles), so that one can continuously evolve into the other, while the BMF term suppresses the dipolar collapse described in Sec. V A. In the opposite case of large $\lambda$ , a discontiuous transition between the two states is found, with an intermediate region of bistability, where the two states form local energy minima. This bistability can be apprehended from the following argument: In such traps, a low-density state can be stabilised even for $\varepsilon _ { \mathrm { d d } } > 1$ as the trap asymmetry forces the dipoles to lie side-by-side enhancing the MF DDI repulsion. This is exactly how Cr BECs have been stabilised at low $a$ , as described in Sec. IV A 4, and the addition of the BMF term only weakly modifies this behaviour. On the other hand, the BMF term stabilises an other solution which is elongated along the dipoles and where MF DDI is attractive. The bistability occurs as there is an intermediate regime of $a$ where both solutions are local energy minima, while in the absence of the BMF term (as relevant for Cr) in this region the MF repulsive BEC is metastable.

The theoretical phase diagram is represented in figure 23. The exact position of the boundaries and critical point depend on the exact experimental parameters (number of atoms, mean trap frequency, ...). The crossover and the bi-stable region are separated at a critical aspect ratio $\lambda _ { \mathrm { c } }$ , typically $\lambda _ { \mathrm { c } } \approx 1 . 5 - 2$ . In the remainder of this section, we review the extensive experimental exploration of this phase diagram.

We note that the description given above does not give a full picture of the dipolar gas phase diagram in presence of quantum stabilisation. This description encompasses the behaviour in a low-atom-number regime. For larger atom numbers (and/or tighter traps), distinct ground states may arise, and in particular spontaneous density modulation may occur, or, in other words, ground states bearing several droplets may be found. This regime, achieved more recently in experiments, will be the topic of Sec. V D.

# 2. First observations of droplet states: metastable droplet assemblies and the quest for the stabilisation mechanism

The first evidence for the absence of dipolar collapse and the existence of a stabilisation mechanism was reported by Kadau et al. [185] on $^ \mathrm { 1 6 4 }$ Dy, before any of the theoretical development described in Secs. V B-V C 1. Starting from a pancake-shaped BEC of $^ \mathrm { 1 6 4 }$ Dy atoms in a trap with aspect ratio $\lambda \simeq 3$ , $a$ was lowered down to the mean field unstable regime. In this geometry, we note that a modulational instability is expected, see Sec. $\mathrm { 1 V ~ A 4 c }$ . Below the instability threshold, ordered droplet ensembles were observed in the in-situ radial density distribution of the cloud, as can be seen in Fig. 24. Contrary to the expectations at the time, these droplets were observed to have very long lifetimes of several hundreds of ms, simply limited by atom loss due to threebody recombination.

As shown in the early theory works [432, 457], the observation of multiple droplets arises from a crossing of the boundary between the BEC region and the bi-stable region of the phase diagram. In this regime, a continuum of metastable states, with different numbers of droplets, is expected to exist. These works suggest that, following the fast change of the interaction strength, the system ends up in one of these metastable states, explaining the observed long lifetime of the crystal as well as the shotto-shot variability of the structures. Experimentally, the system’s bistability was evidenced via the hysteresis in the appearance and disappearance of the droplet ensembles when varying $a$ down and back up, thus supporting the theoretical picture. As observed after a long hold time, the arrangement of the droplets was found to result from the repulsion between the corresponding macroscopic dipoles (see also Refs.[430, 431]).

![](images/9dd8d7fac110c2dd157dfd029092842eb0780d9700c15630d04784919b50a0f4.jpg)  
FIG. 24: Ordered droplet ensembles observed in the MFunstable region of the phase diagram. The magnetic field points put of the plane. Adapted from [185].

A following set of experiments [430] showed that the droplets have an elongated shape along the dipoles with an axial length of a few micrometers and a radial size estimated to half a $\mu \mathrm { { I I I } }$ or less (this lies below the imaging resolution). Furthermore, matter-wave interference fringes observed from several expanding droplets proved them to be individually superfluid. They were observed to have extremely low expansion velocities when released into a waveguide. In Ref. [430], Ferrier-Barbut et al., inspired from the work of Petrov [467] on BEC mixtures, proposed that BMF effects act as a stabilisation mechanism. By comparing additional expansion and lifetime measurements to a model following the lines given in Sec. V $\cdot$ (neglecting kinetic and trapping effects), they validate this idea and invalidate a possible mechanism based on three-body forces proposed in Refs. [451–453], see also the earlier works of Refs. [449, 450]. In particular, the lifetime $\tau$ of the sample, being set by the three-body loss processes, gives information on the sample’s density via $\tau = L _ { 3 } \langle n ^ { 2 } \rangle$ (see Eq. (58)). The estimated density scaling of density as a function of $a$ deduced from measuring $\tau$ as a function of $a$ was found to reasonably agree with the simple density scaling of Eq. (63), and disagree with the scaling expected from three-body forces stabilisation.

In this setup, the bistability, yielding excited metastable states of multiple droplets after an interaction quench, prevents the formation of a large single droplet in the ground state. This feature has limited the study of the properties of the liquid-like state. Shortly after, it was found out, in particular thanks to the theory development described in Sec. V C 1, that this issue can be resolved by taking advantage of the "crossover region" of the phase diagram, i.e. changing the trap geometry, as we will now discussed.

# 3. Crossover from a Bose-Einstein condensate to a large quantum droplet.

Following the first droplet observations [185, 430, 431] and the resulting theoretical development [457, 468], Chomaz et al. tested the universality of the stabilisation effect (which relies on the sole quantum-mechanical nature of the fluid, provided that the interactions are strong enough), by realising the first quantum droplet of a distinct chemical species, using $^ { 1 6 6 } \mathrm { E r }$ [250]. They also used a complementary geometry to the previous Dy observations, using a cigar-shaped trap with $\lambda \ll 1$ , and thus they observed a smooth crossover from a BEC to a single large droplet of $\mathrm { E r }$ atoms containing all the condensed atoms. Because the created droplet is isolated, the authors could study its properties such as its elementary excitation, and its expansion dynamics, see Fig. 25. The authors performed a systematic comparison of the measurements with the eGPE predictions (Eq. (9) including also Eqs.(60)-(58), see Sec. V B) using independently measured values of $a$ and $L _ { 3 }$ . The quantitative agreement reached confirmed the stabilisation scenario and validated the eGPE framework in this setting. We note again, that quantum droplets have later been observed in mixtures of contact-interacting BECs [464, 466] following Petrov’s initial proposal, establishing the quantumstabilisation mechanism as universal even across different interaction types, provided that competing interactions lead to a balance of MF and BMF contributions.

![](images/bece26ae1453a5b00c4f00aa95528478efd71ea08ddfb5111ff4ecd892ddd648.jpg)  
FIG. 25: Examples of properties of a $^ { 1 6 6 } \mathrm { E r }$ dBEC in the crossover from a BEC to a single macrodroplet reported in [250]. Here $a$ is varied in $1 0 \mathrm { m s }$ to its final value, in abscissa. (a) mean expansion velocity measured in 16 to $2 8 \mathrm { m s }$ free-expansion after $5 \mathrm { m s }$ holding in trap. The insets show measured distributions in the plane transverse to the dipole orientation for 28 ms of free-expansion, and also evidence the absence of collapse dynamics in the low $a$ -regime. (b) The axial mode of the dBEC, whose character is illustrated in inset, is excited by transiently decreasing the confinement frequency along the dipole, $\nu _ { | | }$ , and the mode frequency, $\nu _ { \mathrm { a x } }$ , measured by recording the time-evolution of the cloud size along the dipole. In (a) and (b), the data (squares) are compared to simulations from real time evolution of the eGPE including (red solid line) or not (orange dashed line) the LHY correction (Eq. (60)). In (b), $\nu _ { \mathrm { a x } }$ cannot be reliably extracted for quenches to $a \leq 5 6 a _ { 0 }$ , nor from the experiment (open squares) neither from the eGPE theory (open circles, thin line).

Finally, the two regimes of bi-stability and crossover where experimentally connected in [433], where similar experiments were performed using $^ \mathrm { 1 6 4 }$ Dy in traps of variable aspect ratio $\lambda$ . The formation of a single droplet resulting from lowering $a$ in the crossover was observed for small $\lambda$ up to a critical aspect ratio $\lambda _ { \mathrm { c } }$ which marked the onset of a modulational instability as in [185]. The experimental value of $\lambda _ { \mathrm { c } }$ is in agreement with the expected critical aspect ratio marking the separation between the crossover and bi-stable regions.

# 4. Droplet properties and their signature in the collective modes

Following the first experimental observations, several works investigated the specific properties of the droplet states properties.

Theoretically, it is interesting to highlight that, while the trap plays a role in the phase diagram and the transition between the different phases (see Sec. V C 1), it plays a much lesser role on the properties of the single droplet state itself, at least for large enough atom number and $\varepsilon _ { \mathrm { d d } }$ . By studying full ground-state solution from the eGPE, Refs. [431, 457, 468] show for instance a very weak dependence of the droplet density on the trapping potential. At very low atom number (i.e. on the order of a few thousand), the one-body kinetic energy is non-negligible, and its interplay with the interaction energies leads to a dependence of the central density on $N$ . However, at high atom number, the interaction energies fully dominate. Following the simple description of Sec. V B 2, the density then reaches a saturation value independent of $N$ , given only by the balance of MF and BMF energies. This marks the low compressibility typical of a liquid phase, and which stems here from the high energy cost of increasing density due to the BMF term. While early experiments have mostly explored the low atom regime, first measurements showing the onset of this density saturation have been recently reported in Ref. [460].

Besides its evidence via density saturation, the low compressibility of the dipolar quantum droplets has been revealed in different sets of measurements, in particular focusing on the collective modes. First investigations were preformed by Chomaz et al., studying a particular collective mode, with compressional character, of a quantum gas of $^ { 1 6 6 } \mathrm { E r }$ in the BEC-droplet crossover [250]. As the scattering length is lowered through the crossover, a steep increase in the mode mode frequency was observed, changing by $5 0 \%$ when varying $a$ by less than $2 0 \%$ while the trap frequency remained constant, see Fig. 25. This shows that the compressibility quickly drops when going from the BEC to the droplet phase.

In addition to being weakly compressible, a dipolar quantum droplet is anisotropic. This stems of course from the anisotropy of the DDI with respect to the external magnetic field axis. The consequence of this external breaking of rotational invariance is the existence of a collective mode, deemed the scissors mode. It corresponds to a rigid-body angular oscillation around the magnetic field direction. This scissors mode has been observed first in atomic nuclei [469–471] and in contactinteracting BECs in anisotropic traps [472, 473]. In the presence of the DDI, the rotational symmetry is broken even in isotropic traps. This was showed to result in a scissors mode for MF dipolar BECs in Ref. [474]. This mode is well-defined only for angular oscillations in the $x z$ -plane with an amplitude lower than $\theta _ { \mathrm { m a x } } =$ $( \langle z ^ { 2 } \rangle - \langle x ^ { 2 } \rangle ) / ( \langle z ^ { 2 } \rangle + \langle x ^ { 2 } \rangle )$ where $z$ is the field direction [472]. It is thus very challenging to observe with dipolar MF BECs, but was observed in dipolar quantum droplets of $^ \mathrm { 1 6 4 }$ Dy thanks to their considerable anisotropy [308]. In conclusion, studies of the collective modes of the liquid state are a sensitive probe for its properties [475] and will likely be pushed further.

# 5. Self-bound droplets and liquid-gas phase diagram

The possibility of creating a single large quantum droplet by tuning the trap aspect ratio, as described in Sec. V C 3, was key in the demonstration of the self-bound liquid nature of this phase. A quantum droplet living in equilibrium between the repulsive BMF and the attractive MF interactions, the question of the necessity of the trap for the existence of this phase then arises. Two theory papers demonstrated indeed the existence of a selfbound state in the absence of a trap, characterised by a non-vanishing peak density in infinite volume [468, 476]. This defines a liquid state, existing from the mere balance between high-density repulsion and low-density attraction. However, this liquid is in essence quantum, which provides it with macroscopic new properties. First, it remains phase-coherent within a droplet. Second, the self-binding potential resulting from MF attraction from other atoms within the droplet must counter-act kinetic energy. As a consequence if the volume is too small, kinetic energy prevents the existence of a bound state. This yields a phase diagram as a function of atom number and scattering length, with a single line separating the self-bound state from a gas at low atom number and high scattering length, see Fig. 26. The scattering length dependence of the atom number value on the separation line is sharp. Indeed, using scaling arguments, one can show that the minimal atom number for the existence of the self-bound state scales as $N _ { \mathrm { c } } \sim ( 1 - \varepsilon _ { \mathrm { d d } } f _ { \mathrm { d i p } } ( \kappa ) ) ^ { - 2 / 5 }$ First indications of a self-bound behaviour were already evidenced in the early work [430] through the absence of expansion in a waveguide and record-low expansion velocities in free space. Yet, the self-bound character could not be observed because of the limited atom number. Because of the large loss rate occurring in $\mathrm { E r }$ droplet (see Fig. 21), the evidences of the self-bound behaviour of the macro-droplet of Ref. [250] was partial, limited by the state lifetime. Here, only a slowing down of the expansion dynamics was observed. An unambiguous self-bound behaviour was then observed on $^ \mathrm { 1 6 4 }$ Dy in Ref. [247]. Here a single droplet was created using an axially elongated dBEC [477] of 3000 Dy atoms and cruising the crossover to the single droplet state, similarly to Ref. [250]. The trap was then smoothly released while the atoms were levitated against gravity using a magnetic-field gradient (see Fig. 27). Unexpanded droplets were observed up to $9 0 \mathrm { m s }$ of levitation. Using the atom loss as a probe, the liquid-to-gas transition was mapped out in the $( a , N )$ - space. This phase-diagram was later expanded to larger atom number by using samples of $^ \mathrm { 1 6 2 }$ Dy atoms [309], see

![](images/75f9667336f8f8836aa82475dc22ebca143f41cf10e8cd9af5858032f6980199.jpg)  
FIG. 26: Measured self-bound liquid to gas phase diagram of Dy atoms. The theory curve results from simulations of the eGPE. Data are shown for both $^ \mathrm { 1 6 4 }$ Dy and $^ \mathrm { 1 6 2 }$ Dy. For $^ \mathrm { 1 6 4 }$ Dy, the background scattering length had to be adapted from the literature value $( 9 2 ( 8 ) a _ { 0 }$ , green circles) to a lower value $6 9 ( 4 ) a _ { 0 }$ , red diamonds), see also discussion in Secs. V B and V C 4. The horizontal error bars are systematic errors coming from uncertainties on FRs positions and widths. Adapted from Refs. [247, 309].

![](images/5505e3917500f22e63eec1a2032c9b85c2bc45c264c32ceacdc005042dda9f63.jpg)  
Fig. 26. The experimental points of the two isotopes match well together and agree with eGPE predictions, at the expenses of a substantial renormalisation of the background scattering length of the $^ \mathrm { 1 6 4 }$ Dy isotope, by a factor of $3 / 4$ . The need of such an important change of $a _ { \mathrm { b g } }$ rose questions about the validity of the eGPE treatment in particular in the low-atom-number and large- $\varepsilon _ { \mathrm { d d } }$ regimes(see also the discussion in Sec. V B), or again of the methods employed to extract $a _ { \mathrm { b g } }$ (see Sec. II D), in particular in the Dy case.   
FIG. 27: Single self-bound droplets without a trapping potential can be produced by preshaping the droplet in an appropriate trap which is then switched off. The droplet stays bound and floating in the chamber until eventually the losses reduce the atom number below a critical value where no bound states exist any more. That manifests the transition to a gaseous phase where the atoms expand like a gas. Adapted from Ref. [247].

To conclude, the self-bound liquid-gas phase diagram, being simply due to the quantum mechanical nature of the system, is not restricted to the dipolar case. It may in fact be generally expected in quantum gases where two interactions of different origin compete, and as such it has been observed in Bose-Bose mixtures [464, 466]. It is interesting to note that in lower dimensions this phase diagram is completely modified. This has been the topics of several theoretical works, both for dipolar and mixtures systems, see e.g. [478, 479].

# D. Dipolar Supersolids

In Section V C, we have reviewed how the quantumstabilisation mechanism discovered in 2016 (see Sec. V B), may yield new ground states beyond the MF instability. There the ground state were limited to single droplet, as relevant for the early experiment, due to the small atom numbers and shallow traps (independent on the trap geometry, see Sec. V C 1). Here we review how the same stabilisation mechanism yield to formation of selfmodulated and in particular supersolid ground state, as well as their experimental investigations.

# 1. Preliminary works

Supersolidity is a paradoxical phase of matter in which the antithetical properties of crystal arrangement and of superfluid flow coexist. It has been suggested more than half a century ago as a paradigmatic manifestation of a state in which two continuous symmetries of distinct nature are simultaneously broken [480–482]. Originally predicted in quantum solids with mobile bosonic vacancies [483–485], the search for supersolidity has spread in many different fields of physics. Observation of supersolidity in helium was claimed [486] but the claim was withdrawn by the same authors a few years later [487] and the quest for supersolidity in helium is still open [482, 488]. The possibility of supersolid states in quantum gases were theoretically proposed long ago, see Refs. [489–499]; this possibility linking back to the seminal work from E. Gross [481] on assemblies of bosons with momentum-dependent interactions, see also Ref. [399, 500].

Besides the supersolids made from dipolar quantum fluids alternative approaches to supersolidity with ultracold atoms include miscible two-component BECs with SOC as well as optically pumped superfluids in a cavity that mediated interactions via the scattered light [501, 502]. All concepts have in common a momentumdependent interaction that leads to a minimum at finite momentum in the dispersion relation on the superfluid side of the phase transition. This is called the roton minimum. In both the dipolar supersolid and the SOC systems, two branches of the excitation spectrum exist on the supersolid side of the phase transition. They correspond to the Goldstone modes of the two double symmetry-breaking processes, the breaking of the translational symmetry and the breaking of the U(1) phase invariance of the condensate. More recently, a continuous U(1) translational symmetry was created in system of multimode cavity light coupled to a BEC. The breaking of this symmetry resulted in a supersolid with transverse vibrations exhibiting a Goldstone dispersion of phonon excitations [503]. We will now focus the discussion on the simultaneous quest for a supersolid supporting crystal phonon excitations like a real solid in a dipolar gas only.

This authentic supersolid behaviour can be expected if the simultaneous breaking of the two symmetries arise from the intrinsic interactions between the particles. As already highlighted by E. Gross, the relevant platforms for observing supersolidity are quantum gases with interparticle interactions yielding large-momentum attraction [399, 481]. Practical examples are Rydberg-dressed potentials, spontaneous or light-induced dipole-dipole interactions in confined geometries [490–499]. In these settings, a roton-type excitation is induced in the superfluid’ excitation spectrum by the large- $k$ attraction (see also Sec. IV A 3 c). Its full softening may indicate the transition to a density-modulated state as the roton signals an intrinsically favoured length scale and has been seen as a precursor of crystallisation [399, 500]. The observation of a roton mode in dBECs confined in cigar-shaped geometries [312, 313] was key to point promising grounds to observe supersolidity [499], see also Sec. IV A 3 c.

A recurrent hindrance to the interaction-driven formation of supersolid in quantum gases lies in the predicted MF collapse of the gas at the roton instability, see Secs IV A 4 c,V A and Refs. [504, 505]. Protocols to stabilise the gases beyond its instability thanks to the engineering of higher-order (three-body) interaction potentials have been proposed [498]. However, these protocols have not been implemented in experiments so far. The discovered BMF stabilisation mechanism provides the key ingredient for an intrinsic stabilisation.

In 2017, theoretical works based on the eGPE [506, 507] demonstrated that not only a single droplet (as described in Sec. V C 1) but also assemblies of multiple droplets, or in other words density-modulated states, could constitute the ground state of dipolar quantum gases. This was found for both pancake and cigar geometries, by simply using tighter trap and/or larger atoms numbers than in the previous works of Ref. [457, 468, 475]. Similar observations were also achieved via quantum Monte Carlo simulations with large densities [508, 509]. Starting from the picture of a single droplet state, the physical argument to the formation of multiple-droplet ground-states can be formulated as follow: The liquid phase has a weak compressibility that yields a sharp increase in energy at high density, see also Sec. V C 4. If one compresses an (isotropic) liquid in one or two directions, it then deforms to keep a constant density at the small cost of increasing its surface energy. Yet for the dipolar quantum liquid, the DDI dictates an anisotropy, and deformation costs a high amount of (dipolar) energy. Therefore, when a dipolar quantum droplet is compressed along its long axis, it might be energetically favourable to split it in several droplets (of smaller radial sizes), recovering thus an anisotropy closer to the one naturally imposed by the DDI. Ground states can thus form spontaneous density modulation. Calculations with periodic boundary conditions along one direction were also performed, see Ref. [506], proving that a continuous translation symmetry can indeed be broken (at the thermodynamic limit). These predictions indicate possibilities for quantum-stabilised dipolar “crystallised" ground states and in particular open the doors for quantum-stabilised dipolar supersolids.

The work of Ref. [506] also experimentally produced spontaneously density-modulated states in cigar-shaped Dy gases that show close features to the expected ground states yet global phase coherence was found to be absent. The lack of phase coherence was interpreted based on a Josephson-Junction formalism, which describes the maintenance of a phase relation via tunnelling processes between the individual droplets, and its preclusion via quantum or thermal fluctuations. In this experimental realisation, the tunnelling rate between the individual droplets, or in other words, the wave-function overlap between them, was not enough to lock the droplets in phase. The authors of Refs. [506, 507] also showed that assemblies of droplets with sizeable wave-function overlap were theoretically possible by either increasing the trap frequencies or the atom numbers compared to the current experimental configurations.

# 2. First experimental evidences of supersolid behaviors

At the end of 2018, the progressive understanding of the many key features of Bose gases of highly magnetic atoms combined in an acute picture. These features include the discovery of the BMF stabilisation in such gases (see Sec. V C 2), the observation of the roton mode and its softening in cigar-shaped clouds (see Sec. IV A 3 c-IV A 4 c), the possibility of densitymodulated ground states, matching an assembly of quantum-stabilised droplets (see Sec. V D 1), and the need of making the droplets more extensively overlap in order to maintain the global phase coherence in such assemblies (see Sec. V D 1). Building on this knowledge, a set of experiments [190, 329, 330] observed hallmarks of supersolid behaviours in cigar-shaped gases of $^ \mathrm { 1 6 2 }$ Dy, $^ { 1 6 6 } \mathrm { E r }$ , as well as $^ \mathrm { 1 6 4 }$ Dy atoms. Accompanying theoretical works [329, 330, 499, 511, 512] related these observations to an underlying supersolid ground state of the gas, see Sec. V D 3.

The three experimental works proved two hallmarks of supersolidity in experiments, namely the simultaneous occurrence of a spontaneously formed density modulation and of a global phase coherence. Density modulation was revealed by the occurrence of modulated patterns in the gas absorption images, either in situ [330] or in time of flight. Here the density patterns form from the self interference of the gas via free expansion of the in situ modulation. The global coherence was demonstrated by a statistical analysis of multiple repetitions of this self-interference TOF patterns. Global coherence is here marked by the stability of the interference patterns, differentiating supersolids from an incoherent array of droplets. Global coherence was mostly quantified through an analysis of the complex values of the Fourier transform of the TOF density profiles, see Fig. 28. We note that the coexistence of density modulation and phase coherence does not prove the superfluidity of the state, which can be demonstrated only by probing dynamic-related properties of the state, see Sec. V D 4.

![](images/918591dd2740c14b4572b7417d3bdbc571e122d93744d055cfdeb56c10728997.jpg)  
FIG. 28: Examples of statistical analysis of the selfinterference patterns of dipolar quantum gases showing hallmarks of supersolidity (a,c) (or normal solidity (b,d)), i.e., density modulations with (or without) global coherence. (a), (b) Norm of the Fourier transform of the integrated density profiles from the individual TOF images (grey lines) and the norm of their complex average (thick, blue or red, line) in the supersolid case and the insulating array of droplets case. The existence of side peaks in the norm of the complex average evidence coherence in between density peaks (see inset). Adapted from ref. [330]. (c),(d) Representation in the complex plane of the values of the Fourier transform of the TOF profiles at the position of the first side peak (see a). The limited spread of the phases $\Phi$ evidences global phase coherence. Adapted from Ref. [510].

All three experiments used relatively shallow cigarshaped traps with transverse magnetisation, similar to Ref. [312]. The spontaneous density modulation occurred only along one axis, the long axis of trap. The coexistence of density modulation and phase coherence was observed in narrow ranges of scattering length values, of a few $a _ { 0 }$ wide, and survives a few tens [190, 329, 330] up to a few hundreds of ms [329] in these first experiments, later extended up to few seconds [513]. Building on this long lifetime, Ref. [329] additionally established a different route than standard interaction tuning towards supersolid states, which is based on direct evaporative cooling starting from a thermal state, see also [513].

In all three works, the states with supersolid properties could be achieved by ramping down the scattering length starting from a stable BEC, using a slower ramp and a finer tuning of $a$ than Ref. [312]. In the earlier works of Refs. [431, 506] observing droplet assemblies in cigar shaped traps, the rougher tuning of $a$ as well as the lower initial BEC atom numbers are also thought to have prevented the observation of supersolid properties (see also Secs. V C 2, V D 1). Finally, in the seminal work of Ref. [185], a distinct pancake-shaped geometry as well as smaller initial BEC atom numbers were used. Several following theoretical as well as experimental works indicates that the use of a cigar-shaped geometry was crucial for more easily achieving supersolid states in experiment. In this geometry, the MF instability is driven by the softening of a single (doubly-degenerate) roton mode dictating the dominant wavelength of the density fluctuations [312, 313, 413]. In contrast, the pancake case is more complex, with several radial and angular rotons, corresponding to different structures of density fluctuations, simultaneously softening [414, 514]. Furthermore, in the cigar-shaped case, it is expected that the transition to a supersolid state can occur continuously, with the supersolid modulation directly connecting to the softened roton mode, see e.g. [515].

# 3. eGPE phase diagram beyond the single-droplet regime: droplet assemblies and supersolid states.

Following the observations of the roton mode population in Ref. [312] and shortly preceding the works of Refs. [190, 329, 330], Rocuzzo and Ancilotto [499] theoretically explored the phase diagram of an $\mathrm { E r }$ quantum gas in an infinite cigar-shaped geometry with periodic boundary conditions. They relied on the eGPE framework developed in the context of the quantum droplet studies (see Sec. V B) and calculated the ground state as a function of $a$ . In this setting, they demonstrated the existence of a supersolid phase (SSP) in an intermediate range of $a$ , separating an array of insulating droplet (ID) at low $a$ and a regular BEC at large $a$ . Both the SSP and the ID are density modulated ground states stabilised by quantum fluctuations, similar to the single-droplet phase described in Sec. V C 1. The SSP distinguishes itself by bearing a density modulation of finite contrast. In addition, Rocuzzo and Ancilotto directly computed, via dynamical simulation, the superfluid density of the density-modulated states, thus rigorously establishing the connection between the occurrence of non-fully-contrasted density modulation and non-zero superfluid fraction. This work proved the relevance of the SSP in cigar geometries, beyond finite-size effects, see also Ref. [515].

![](images/cb6036b5fae904be5987a5cccfdd32eab5ea4ffa6c3254123694b49eef184f0d.jpg)  
FIG. 29: Phase diagrams, calculated in [329] (a) and [330] (e) for the relevant experiments using $\mathrm { E r }$ , Dy respectively. (b-e) ((g-i)) corresponding insitu axial density profile for $N = 5 \times 1 0 ^ { 4 }$ ( $N = 3 . 5 \times 1 0 ^ { 4 }$ ). Besides the BEC and single-droplet phases, identified in Fig. 26, densitymodulated ID and SSP ground states are found. The SSP is identified by a non-fully contrasted density modulation. It is sandwiched in a narrow $a$ -range in between a regular BEC and a crystal of independent droplets (ID).

Together with their experimental results, both Refs. [329, 330] reported on eGPE calculations of the ground-state phase diagrams in the finite experimental geometries, see Fig. 29(a,f). The ground states were calculated as a function of the atom number $N$ and the scattering length $a$ for a given trap and atomic species. At low $N$ , a transition occurs from the regular BEC to the single-droplet phase when decreasing $a$ , as described in Sec. V C 1, see also Refs. [329, 457, 468]. In contrast, for large-enough atom numbers, three different regimes could be identified similar to the infinite case results of Ref. [499]: When decreasing $a$ , the regular BEC state transitions first to a density-modulated state of finite contrast, identifying a SSP, and then to a densitymodulated state of contrast almost unity, forming an ID array, see Fig. 29(b-e,g-i). We note that the atom number for the occurrence of density-modulated states versus single-droplet depends on the atomic species (being smaller for Dy than for $\mathrm { E r }$ ), and on the trap, both on its overall tightness and on its shape. The exploration of the most favourable parameters for supersolidity as well as achieving such a phase in different settings are interesting directions that are currently under investigation,

see e.g. Sec. V D 5.

Based on the eGPE framework, Refs. [190, 330, 516] also reported on simulations of the real-time evolution induced by the finite scattering-length ramp used to reach the various BEC/SSP/ID states in the experiments. These show that in the SSP regime, the dynamical state has strong similarities with the expected ground state and shows limited phase fluctuations. In contrast, when decreasing the scattering length lower, to an ID regime, the dynamical state deviates from the groundstate expectation and show large phase fluctuations.

# 4. Toward probing the dynamical response and superfluidity of dipolar supersolids

Besides the study of the static properties of the state, as the hallmarks reported in the first studies (see Sec. V D 2), a huge interest is drawn by the special dynamical properties associated to supersolidity. Indeed, such a dynamics intrinsically connects to the superfluid character of the supersolid and would characterise the related rigidity of its phase. The study of the dynamical properties covers a wide range of phenomena and concepts, spanning from the study of the spectrum of elementary excitations, to that of transport properties, or of the response to an external rotation for instance. Supersolidity brings exotic characteristics to these different features.

![](images/fe5e2b1ea97587cf257b1e9481ffd0010ffa072dd001e499d98e6ea5874eb231.jpg)  
FIG. 30: Observed response frequencies for quadrupoletype excitations in the BEC-SSP-ID phase diagram, from (a) an Er sample, taken from [311], and (b) a Dy sample, from [191]. Theory predictions from (a) Bogoliubov theory, (b) real-time simulations, based on eGPE theory are shown. In (a) all the elementary excitations, $\it l$ , are shown and the colour highlight their expected response $R _ { l }$ to the performed trap excitations.

The first of these aspects to be explored in dipolar gas experiments concerns the properties of the spectrum of elementary excitations of a supersolid at low momenta. Here, not one but two branches of low-energy (gapless) “phonons" modes [483, 499, 517–520] are expected, the different branches bearing excitations of different characters. Following Goldstone’s idea [521], the number of gapless branch connects to the number of spontaneously broken symmetries – two in the case of the supersolid: one branch holds phonons of the crystal and relate to a broken translational symmetry, while the other branch holds phonon of the superfluid (phase phonons) and relate to a broken gauge symmetry. The phase branch corresponds to the branch of lower velocity, and, when evolving through the BEC-SSP-ID phase diagram, it is observed to soften and its weight in the response to decrease, up to vanishing in the ID case. On the contrary the crystal branch slightly harden. These properties of the supersolid excitation spectrum were theoretically investigated in various systems [517– 520]. The excitation spectrum behaviour in dipolar supersolids was further theoretically investigated in various works [311, 499, 516, 522].

Several experiments show signatures of these two branches [191, 311, 413, 523]. Due to the finite system size, the phonon branches are here discretised (see also Sec. IV A 3), and the experiments probe the response of some specific low-lying modes of the trapped dipolar supersolid states. In Refs. [191, 311], the evolution of the BEC’s lowest-lying quadrupole mode within the BEC-IDSSP phase diagram is probed, see Fig. 30. In the BEC regime, the system responds at a single and roughly constant frequency, and when reaching the SSP regime, several frequencies are observed in the system’s response. Furthermore, these frequencies are found to organise in two branches as a function of $a$ . One branch is softening and one is hardening when decreasing $a$ . These properties are indicative of the emergence of modes of dominant phase and crystal characters, respectively. Ref. [191] identifies the different modes via their distinct signatures in the time-evolution of the gas’s self-interference patterns. Ref. [311] identifies resonant frequencies via an unbiased principal component analysis of the selfinterference patterns and observes a mixed character in the associated principal component structures. The different modes’ characters between Refs. [191, 311] may be attributed to the different numbers of density peaks in the underlying supersolid states. Distinctly, Guo et al. [523] probe the lowest lying mode of the trapped supersolid, which has a frequency lying below the dipole mode and is a Goldstone mode of phase character, see Fig. 31. The frequency of the mode itself is not probed due to its low value, instead signatures of a spontaneous population of the low-energy excited mode are observed via a statistical analysis of the in situ density patterns. A peculiar feature of this mode is that the motion it induces preserves the centre of mass position thanks to superfluid flow. This implies a correlation between the array’s displacement and the population imbalance between the density peaks, see Fig. 31. By repeatedly producing and imaging steady-state samples, Ref. [523] evidenced such correlations in the limited $a$ range where the state is supersolid. The presence of such correlations points to the existence of the phase Goldstone mode and implies an underlying superfluid flow. An interesting point to note is that the emergence of this Goldstone mode in the excitation spectrum connects to the softening of the antisymmetric roton mode from the BEC [523], see also Sec. $\mathrm { ~ N ~ A 3 c }$ . In contrast, the symmetric roton mode connects to an amplitude mode, also called Higgs mode, which sharply hardens when moving away from the SSP-BEC transition in the SSP [522]. More recently, a detailed study of the in situ density fluctuations in the SSP also revealed the existence of density and crystal phonons [413], see also Sec. IV A 3 c.

![](images/5a3d98f9885b44f45cf30e0bf8f00405fe522b9106498eb408c1b6d398bdf540.jpg)  
FIG. 31: Dynamics induced by the lowest lying Goldstone mode of a supersolid (top) and observed correlation between displacement and imbalance in the in situ density patterns of experimental realisations of Dy supersolids at $9 7 . 6 a _ { 0 }$ (bottom). Adapted from Ref. [523]

Besides the study of low-lying excitations, investigation of higher energy modes of supersolids have been recently undertaken. This includes studies of the response to rotational excitations [524], or to large-momentum excitations [516]. Rotation excitations in Ref. [524] probe a scissor-type excitation, similar to that described in Sec. V C 4 for droplet states. Here the observed scissormode frequency decreases at the transition from BEC to modulated states. This indicates an increase of the state’s momenta of inertia. It is however not straightforward to relate this behaviour to the superfluid fraction of the state. Ref. [516] probes the scattering of quasifree particles via Bragg excitations (see also Sec. IV A 3) along the BEC-SSP-ID phase diagram. Here a decrease in the response amplitude is observed when crossing from BEC to modulated states. From impulse-approximation theory, this decrease probes a reduction of the population of the zero-momentum state. The observed decrease surpasses expectations obtained from the eGPE steady states. This was related to coherent phase evolution, induced by the dynamical crossing of the quantum phase transition [525].

Besides studies of specific excited modes, the supersolid’s dynamical properties have also been unveiled in the time evolution induced by parameter quenches or ramps. This includes interaction quenches [510] and evaporative cooling ramps [513]. Ref. [510] probes the dephasing and rephasing dynamics of the gas’ global coherence when dynamically crossing the ID-SSP transition. The observed dynamic was understood by comparing to a simple Josephson-Junction-Array model where the Josephson tunnelling amplitude was quenched, while dissipation is empirically introduced, using a Langevin formalism. This model shows a good qualitative agreement with experiments, while quantitative discrepancies are attributed to the inherently soft nature of the supersolid’s crystal and the effects brought in by the possible excitation of the crystal’s phonons. Studying the formation dynamics of supersolids via direct evaporative cooling (ramp of optical dipole traps), Ref. [513] shows that density modulation appears before global phase coherence, but after local phase coherence, is established. Reference [513] also studies the subsequent decay process of the supersolids, occurring spontaneously under the effect of three-body recombination. In this decay, in contrast to the formation dynamics, global coherence is observed to survive longer than density modulation, while the temperature remains roughly constant. Furthermore, in this process, the strength of the density modulation, for a fixed value of the number of locally coherent atoms, is observed to depend on the temperature, being weaker when colder, see also ref. [526].

The various dynamical studies performed up to now provide valuable insights into the supersolid state special behaviours, including direct and indirect signatures of the existence of phase and crystal phonons (near $k = 0$ ) and their mixing, of superfluid flow and transport, or of coherent and incoherent phase dynamics in the experimentally produced states. Interesting prospects include direct measurements of the superfluid properties, and in particular of the superfluid density of supersolids, and the creation of vortices in the supersolid rotation, see e.g. [527, 528].

# 5. Supersolids with richer crystalline patterns and two-dimensional character

As discussed in Sec. V D 2, the first observations of supersolidity in dipolar gases have been conducted in elongated and relatively shallow, cigar-shaped traps, resulting in supersolids in which (i) the breaking of the translational invariance occurs only along one dimension, (ii) the number of density modulations found in the finite experimental system is small (typically a handful) and thus finite size effects might be important. Yet, dipolar supersolid states with larger and/or more complex crystalline structures, and in particular where crystallisation occurs in two directions of space have attracted intense interest. Theoretically, a series of works have focused on the phase-diagram and excitation spectra of two-dimensional supersolids in isotropic and anisotropic traps [529–533], on the possibility of creating vortex excitations [527, 528, 534], and on the emergence of exotic crystalline structures [514, 529, 530]. Very recently, twodimensional supersolidity has been observed in experiments with Dy atoms, using anisotropic traps [531]. As a function of the anisotropy of the trap in the directions perpendicular to the atomic dipoles, experiments have demonstrated evaporative phase transitions to ground states of various supersolid patterns from a linear chain, to a zig-zag crystalline structures [531], and finally to a hexagonal structures in circular traps [532]. In a related effort, two-dimensional angular roton modes, analogous to the linear roton mode in elongated traps [99, 312, 313], has been observed in radially extended traps [414], see also Sec. IV A 3 c for more details. By further tuning the interplay between trapping configurations, interaction parameters, and atom numbers, even more exotic ground states are expected to appear, such as honeycombs, ring and labyrinth-like supersolid phases [514, 529, 530]. With the considerable interest that the discovery of dipolar supersolids have generated, we expect a quick development of the field and a blossom of works probing the various intriguing properties of this phase as well as exploring its possibility in different settings.

# VI. Spin physics with highly magnetic atoms

In the previous Secs. IV and V, we presented the many-body physics arising in quantum gases of magnetic atoms fully polarised in their lowest Zeeman state, under the influence of the elastic DDI between the aligned atomic dipoles. In the following, we discuss the physics of ultracold gases of magnetic atoms when the spin degrees of freedom are free and taken into account. Of course, short-range interactions among atoms can also be spin-sensitive, see Secs.VI A 6,II D: magnetism is typically driven by the interplay of spin-dependent long-range dipolar forces and spin-dependent short-range forces. This interplay intrinsically takes on a very different flavor if the atoms are free to move and collide, or if the experiment is performed with atoms confined in an optical lattice wherein the spins are localised at each node of a 3D array. In the latter case, the system realises spinlattice models, where spins interact both at a distance, directly through DDI, and by short-range interactions via second-order processes in tunnelling. These so-called super-exchange interactions will be reviewed in Sec. VII, while the current section focuses on the situation without a lattice potential.

After introducing a few important concepts of the spin physics with ultracold gases, including that which is unique to highly magnetic atoms in Sec. VI A, we will review the experimental achievements revealing the impact of the DDI on spinor physics and on two-component Fermi mixtures; see Secs. VI B and VI C. The latter two situations can be distinguished by whether dipolar relaxation can be neglected, resulting in a system in which the total magnetisation is conserved in the sample; see Sec. VI B, or whether the demagnetisation is a key mechanism of the physics at play, yielding gases with free magnetisation and an intrinsic spin-orbit coupling; see Sec. VI C. Finally, we will discuss the engineering of spindependent Hamiltonians using light fields and the unique contributions provided by magnetic atoms in this respect; in Sec. VI D. We will examine the engineering an artificial spin-orbit coupling, realising a special class of artificial gauge fields, and the engineering of spin-spin interactions that yield entangled quantum spin states.

# A. Introduction to spinor physics

# 1. Magnetic atoms: a large composite spin

Unlike electrons, atoms possess a composite spin that may be large compared to electrons’ $S = 1 / 2$ . This enriches spinor physics. For alkali atoms, the total spin arises from the coupling of the spin- $1 / 2$ electron to its orbital angular momentum $L$ and the nuclear spin $I$ . This large spin allows for the study of a new type of quantum fluid, involving the interplay between magnetism and superfluidity [95]. The study of degenerate quantum gases with a large spin degree of freedom $s > 1 / 2$ initially focused on bosonic atoms, i.e., Bose spinor gases [94]. Experiments explored the spinor physics of $F = 1$ Na atoms and $F = 1$ and 2 Rb atoms [95]. More recently, these studies were extended to spinor fermions using the $F = 9 / 2$ state of fermionic K [535].

Strongly magnetic atoms such as Cr and Lns are multielectron systems, which can possess an even larger total spin in the ground state than alkalis. For example, bosonic Cr atoms have an electronic spin $S = 3$ in the ground state ( $L = 0$ ), while bosonic Dy and $\mathrm { E r }$ atoms have $L = 6$ , $S = 2$ and $L = 5$ , $S = 2$ respectively. Including the hyperfine structure for the Fermi isotopes, one can reach, for example, $F = 2 1 / 2$ using $^ \mathrm { 1 6 1 }$ Dy atoms. Besides the richer physics at the many-body level, such largespin atoms have also attracted attention for studying highly non-classical behaviours involving quantum coherence and entanglement, either at the many, few, or even single-particle levels [181, 182, 536]. These prospects may have important implications and applications for quantum information processing, sensing, or metrology purposes. In particular, we note that a single magnetic atom provides the realisation of large spin states (length $F ^ { \dagger }$ ) in an Hilbert space of relatively moderate size $( 2 F + 1 )$ and increasing linearly with the spin size. In contrast, a spin of similar length realised by a set of spin- $1 / 2$ particles lives in an Hilbert space whose size increases exponentially with the spin length. The reduction of the Hilbert space offered by magnetic atoms is beneficial to temper the effect of decoherence in the system.

We note that, in atomic gases, research has also explored small-spin systems, e.g., those involving only two spin states to form an (effective) spin- $1 / 2$ system. Such a system can be accessed either by considering a hyperfine level of $F = 1 / 2$ (as for fermionic Li and K [378, 537– 540]) or by isolating two states of a larger- $F$ level; see e.g. [541, 542]. For magnetic atoms, however, isolation is complicated by the spin-changing DDI; see also Sec. III C. Nevertheless, as we have seen in $\mathrm { S e c . 1 l l } \mathrm { C 4 }$ , thanks to the quantum statistics, some subspaces can be effectively preserved in spin mixtures of ultracold fermions on long time scales because decay rates are strongly suppressed [165]. This is in particular the case for the subspace formed by the two lowest spin states of a fermionic magnetic atom. This feature has been used in experiments to study effective spin- $1 / 2$ dipolar systems under the effect of an artificial spin orbit coupling [252] and in bulk [314].

# 2. Spin-dependent one-body Hamiltonian for spinor gases

In order to study pristine spinor physics, i.e., to isolate the effects arising solely from spin-dependent interactions, it is convenient to first consider a spin-independent one-body Hamiltonian (typically the sum of a kinetic term and external potential; see Eq. (9)). Using a spinspace generated from the hyperfine level of an atomic species, the kinetic part of the Hamiltonian is spin independent. Then one need only consider the conservative trap confining the atoms. This potential should be independent of the magnetic sublevels. For alkali atoms, this is typically obtained by using optical dipole traps created by far-off-resonant focused laser beams, in which case the AC-Stark shift is approximately independent of the magnetic sublevel [246]. As discussed in Sec. II C, the situation of magnetic atoms differs. Both for Cr and for Lns, the large electronic spin/angular momentum results in large vector and tensor parts of the atomic polarisability. This yields a significant dependence of the light shifts on the magnetic sublevel, even when using light far away of optical transitions. Typically, this is not negligible in experiments exploring dipolar magnetism. It is then expected that spinor phases will be driven by an interplay between spin-dependent interactions, the Zeeman effect, and the tensor light-shift.

# 3. Spin-dependent interactions for large-spin atoms

To study of spin physics with large-spin atoms it is important to recall that the interaction between the atoms can depend on the spin channel $\boldsymbol { S }$ of the collision. Here, $\boldsymbol { S }$ describes the total spin of two atoms and is preserved during the collision in the absence of a DDI, see Secs. II D and III.

Quantum statistics plays a major role in selecting which molecular potentials should be taken into account. Generally speaking, regardless of the statistics of the particles involved, $S + l$ must be even, where $\it l$ is the relative angular momentum; see also Sec. III A. For short-range interactions, $s -$ wave scattering dominates at low collision energy. Under these circumstances, only even $\boldsymbol { S }$ need to be considered, both for bosons and fermions.

The different molecular potentials have identical multipole expansion parameters at long distance where only electrostatic interactions contribute. However, at short distance, where electronic orbitals may overlap, quantum statistics also plays a pivotal role. This is because the molecular potentials associated with different spin channels are often quite different. Therefore, different spin channels $\boldsymbol { S }$ typically correspond to different scattering lengths $a _ { \mathcal { S } }$ . This is clearly true in the case of Cr because of the large electronic spin of the atom. This leads to seven very different molecular potentials, as calculated in Ref. [543] and confirmed by experiments [162, 196]. Scattering lengths are also (most likely) spin dependent in Lns. Because the outermost electronic shell has zero spin (identical to the case in Yb), all molecular potentials have a similar shape even at short distances. However, slight differences between the molecular potentials (due to, e.g., orbital anisotropy of unfilled submerged $f$ -shell) are most likely sufficient to lead to spin-dependent contact interactions [207]. As highlighted in Sec. II D, scattering properties of Ln are extremely difficult to predict, while, on the experimental side, spin-dependent scattering lengths have remained unexplored in these atoms; see also Sec. II D.

In gases of large-spin magnetic atoms, there is, in addition to spin-dependent contact interactions, the DDI that must be taken into account. Dipolar interactions are not only spin-dependent, but they also induce direct spin-orbit coupling (SOC); see Eqs. 3-5. Indeed, when including the spin degree-of-freedom, the DDI leads to two extra terms in the Hamiltonian. These are in addition to the bare (yet also spin-dependent) elastic term Eq. (3) that we have considered up till now. The first term is the so-called spin-exchange term of Eq. (4): it changes the spins of atoms at long distances while conserving the total longitudinal magnetisation of the pair of particles. The second term is the relaxation term of Eq. (5). This leads to a change in magnetisation and converts spin angular momentum into orbital angular momentum to conserve the total angular momentum in the system, thus providing a form of SOC. Due to this peculiar SOC, and to the long-range coupling between spins, large-spin systems thus allow the exploration of magnetism beyond paradigms inherited from solid-state physics in addition to beyond what could be achieved with ultracold atomic gases up till now. Experiments can be performed both with bosonic and fermionic isotopes (see Sec. II), greatly enhancing the scope for new magnetic behaviour.

# 4. Mean-field spinor physics with spin-dependent contact interactions

Because of the spin-dependence of the contact interactions described above, the Hamiltonian of a spinor gas depends on the spin $s$ of the interacting particles even in the absence of a DDI. The Hamiltonian becomes increasingly complicated for increasing $s$ [94]. It is useful to examine the simplest case for what can be considered as a large-spin system, i.e., one beyond the spin- $1 / 2$ case. This is the case of $s = 1$ atoms. In this case, only two spin channels exist for the short-range interactions, ${ \cal { S } } \ = \ 0$ and $S \ = \ 2$ , with the corresponding scattering lengths $a _ { S = 0 }$ and $a _ { S = 2 }$ . In the Hamiltonian, given by Eq. (13) within the mean-field picture, the difference between the two scattering lengths is the key ingredient for spinor physics, giving rise to a so-called $c _ { 1 }$ -interaction term with $c _ { 1 } \propto \left( a _ { 2 } - a _ { 0 } \right)$ .

This spin-dependent interaction term for example results in spin-exchange dynamics that is experimentally apparent by monitoring the evolution of the population in the different Zeeman states as a function of time. The spin-exchange processes correspond to the Forster-like exchange of a spin excitation $m _ { s } = 0 , m _ { s } = 0 )  ( m _ { s } =$ $- 1 , m _ { s } = 1$ ) and are driven in the mean-field picture at a rate:

$$
\Gamma _ { \mathrm { e x c } } \propto \frac { 4 \pi \hbar ^ { 2 } } { m } n ( a _ { S = 2 } - a _ { S = 0 } ) .
$$

Spin dynamics has been widely studied in the community for both Bose and Fermi quantum degenerate and thermal gases [95, 535, 544–551]. More generally, the study of excitations within a spinor condensate is expected to be very rich, with a number of possible topological excitations observable, such as line defects, point defects, skyrmions [552], and knots [94].

Most importantly, spin-exchange processes associated with contact interactions conserve the total longitudinal magnetisation of the pair of particles. This conservation stems from the isotropy of contact interactions. A very important practical consequence is that the linear Zeeman effect is gauged-out and does not contribute to the dynamics or to the phase diagram. Spinor phases are rather determined by the interplay between spin-dependent contact interactions and the quadratic Zeeman effect [95], leading to quantum phase transitions [546–548]. At low magnetic fields, where the quadratic Zeeman effect may be neglected, the spinor ground state strongly depends on interactions. For $s = 1$ , when $a _ { 2 } < a _ { 0 }$ , the BEC is ferromagnetic (favouring collisions in the $S = 2$ channel), while the predicted ground state when $a _ { 0 } ~ < ~ a _ { 2 }$ is polar [553, 554]. On the other hand, a large positive quadratic Zeeman effect favours the polar state. As the spin increases, the wealth of possible phases makes spinor quantum gases a promising area of research [94], including for the study of non-Abelian spinors [157].

# 5. Beyond-mean-field spinor physics with spin-dependent contact interactions

One of the important features of spinor gases is that quantum correlations can naturally occur, allowing quantum fluctuations to play an important role. For example, spin-exchange dynamics vanish at the mean-field level when a spinor condensate is prepared in the initial state $m _ { s } ~ = ~ 0$ . Quantum fluctuations then drive the onset of spin dynamics, with analogies to parametric amplification [551, 555, 556]. Atomic quantum optical effects lead to the generation of entanglement [557], which may have important applications for atom-based squeezing and atom interferometry [558].

Quantum fluctuations can also play a key role in determining the nature of the many-body ground state. A formal mapping to quantum optics was proposed by Law et al. [559], who showed that the ground state differs from mean-field predictions [553, 554], at least for mesoscopic systems. Depending on the sign of the spin-dependent interactions, the ground state is strongly degenerate (with spontaneous symmetry breaking likely), or a condensate of spin-singlet pairs. So-called ‘fragmented BECs’ have also been studied by Ho and Yip [560], and were very recently experimentally produced in Ref. [561].

While most of the experiments have been performed with bosonic atoms, large-spin fermions are also a promising direction for research on large-spin systems. First studies have been performed in Hamburg [535, 550]. These large-spin Fermi systems possess increased spin fluctuations due to the large spin [562], new SU(N) symmetries for purely nuclear spins, as it is the case for Yb and Sr [563–567], BCS pairing with a non-singlet character [568], and greater than two-particle clustering [569].

# 6. How are dipolar interactions expected to impact spinor physics?

The impact of dipolar interactions on spinor gases crucially depends on whether the dipolar field is larger or smaller than the external magnetic field. For a large magnetic field, magnetisation-changing collisions merely lead to atomic losses, and therefore, within the dipolerelaxation-limited lifetime, the experiment is essentially performed at constant magnetisation. That is, it evolves under terms that conserve the longitudinal magnetisation in the dipolar Hamiltonian.

Because they are spin-dependent, the DDIs modify the properties of spinor gases when they are not negligible compared to spin-dependent contact interactions. To judge a priori the impact of the DDI, one needs to compare the dipolar length $a _ { \mathrm { d d } }$ to differences between scattering lengths [17]. As a consequence, dipolar effects can be prominent even for the case of alkali metal atoms, such as Na or Rb for which spin-dependent contact interactions are much weaker than spin-independent interactions. For example, the long-range and anisotropic nature of the DDI introduces a nonlocal nonlinearity that can modify spin textures, as experimentally investigated using alkali atoms [570, 571]. As we will see, dipolar interactions also impact spin dynamics.

The modifications introduced by the DDI on spinor physics are even more pronounced when the magnetic field is not large compared to the dipolar field. Then, the magnetisation-changing terms in the dipolar Hamiltonian cannot be neglected. Unlike contact interactions, the DDI, by allowing changes in magnetisation, yields an intrinsic SOC which breaks rotational symmetry; see Sec. VI A 3. It thus modifies the classification of the possible spinor phases. The exact nature of the dipolar spinor ground state phases at low magnetic field, which may depend on the trapping geometry and other spindependent forces, is still a matter of theoretical investigation; see for example [572] for the $s = 1$ dipolar system in the single mode approximation and Refs. [157, 158].

Spin-orbit coupling associated with the DDI corresponds to the exchange between orbital angular momentum and spin angular momentum. The DDI can, for example, trigger the demagnetisation of a sample, leading to spontaneous rotation, analogous to the Einstein-deHaas effect [350, 352–354, 573, 574]. Furthermore, because of magnetisation-changing processes, the dipolar spinor gas is sensitive to magnetic field, which provides new ways to study phase transitions driven by the interplay between spin-dependent interactions and the linear Zeeman effect [351]. For example, it is expected that a ferromagnetic spinor dipolar condensate may display spontaneous circulation in the ground state at low magnetic fields [575].

In the following, we will describe the experiments that address the role the DDI has played in spinor physics, distinguishing between the cases where magnetisation is conserved from those where it is free to evolve.

# B. Effects of dipolar interactions on spinor physics at constant magnetisation

If the time-scales of dipolar relaxation are large compared to the other relevant timescales in the system (see III C), one can study spinor physics under the effect of the DDI but at constant magnetisation. Here, the effect of the DDI arises from the elastic term of DDI, Eq. (3), and the spin-exchange term, Eq. (4). The intrinsic spin-orbit coupling introduced above is neglected for now. The spindependent elastic DDI term impacts the spinor physics because of its long-range and anisotropic nature.

# 1. Dipolar-induced spin textures in BECs

One of the prominent features of the DDI, associated with its non-trivial momentum dependence shown in Eqs. (8), is a tendency to develop spatial structures. This has already been discussed in the spin-polarised case in

Secs. IV A 3 c, IV A 4 c, and V. In the context of spinor dipolar gases, this tendency translates into the possibility of developing various spin-textures [94], i.e., inhomogeneous distributions of the spin vector.

The influence of the DDI on spin domains of Bose quantum gases was experimentally studied both in Berkeley [570] (for a Rb $F = 1$ BEC with ferromagnetic contact interactions) and in Tokyo [571] (for a Rb $F = 2$ BEC whose contact interactions disfavour ferromagnetism). In both experiments, spin domains were created using a well-defined magnetic field gradient. In Ref. [570], the spin textures decayed toward a spatially modulated structure of spin domains. The crucial role of the DDI was demonstrated by eliminating the DDI by a sequence of rf pulses, in which case the authors observed a suppression of the formation of the short-range domains. In Ref. [571], the spin textures observed after propagation within the magnetic field gradient are compared to numerical simulations of the Gross-Pitaevskii equation. This reveals that the observed spatial modulation of the longitudinal magnetisation is due to the spin precession in the effective magnetic field produced by the DDI. Both these results demonstrate that the DDI has considerable effect, even on spinor condensates of weakly dipolar alkali metal atoms.

# 2. Gapped magnon excitations of BECs

Phonon excitations have been studied in the context of scalar BECs through, e.g., Bragg excitation spectra [385– 389, 576]; see also Sec. IV A 3 for the dipolar case. Moreover, there exists, in spinor BECs, spinfull excitations that also behave like quasiparticles. Surprisingly, these excitations remain relatively unexplored experimentally. One of the first investigations was performed at Berkeley on a ferromagnetic Rb BEC [577]. Magnon excitations were precisely studied and shown to consist of a standing-wave of spin-excited atoms above a ferromagnetic BEC. While the Goldstone theorem predicts that a ferromagnetic state has gapless excitations (for symmetric interactions), a gap was measured and ascribed to the presence of a weak DDI that breaks rotational symmetry. Perhaps related to this feature, the authors also observed a larger effective mass than expected by mean-field and beyond-mean-field theories involving only $s$ -wave interactions. Although these effects remain small due to the weakness of the DDI in alkali atoms, they provide qualitative departures from the paradigms of magnetism in the presence of symmetric short-range interactions. This constitutes but one illustration of the possibilities dipolar spinor gases offer.

In the case of Cr, trapped magnon excitations were created by applying, on a polarised BEC, magnetic field gradients perpendicular to the magnetic field axis [261]. In that experiment, the wavelength of the excitation is not small compared to the cloud’s size. The magnons that are created are quantised in energy, and manifest themselves as collective modes that couple the spin and the orbital degrees of freedom. The lowest energy mode, whose frequency is set by the zero-point energy of the BEC, consists of a sinusoidal oscillation of the local spin around its original axis, with an oscillation amplitude that linearly depends on the spatial coordinates. The observations are in excellent agreement with hydrodynamic equations. In the regime the experiment was performed, the observed spin mode has a universal character, independent of the atomic spin and spin-dependent contact interactions, and is therefore rather insensitive to the DDI. It was nevertheless predicted that dipolar interactions could alter such a mode, provided that the atomic sample has a size larger than a natural wavelength set by the DDI [261].

# 3. Out-of-equilibrium spin dynamics at constant magnetisation

Strong dipolar effects have been observed in the spin dynamics of magnetic atoms even on time scales short compared to the dipolar relaxation processes. Studies where performed on $S = 3 ^ { 5 2 } \mathrm { C r }$ atoms, initially polarised in the lowest energy spin state $m _ { s } = - 3$ , and after homogeneously quenching a BEC into a spin-excited state. This was first performed using an engineered tensor light shift to promote all atoms into a well-defined Zeeman state $m _ { s } = - 2$ [356]. In a latter experiment, the spin excitation was performed by simply rotating the spins using a rf pulse [258].

In both cases, out-of-equilibrium spin dynamics was monitored by means of a Stern-Gerlach procedure to measure the population of atoms in the different Zeeman states as a function of time. It was found that spin dynamics was driven by an interplay between spindependent contact interactions and DDI. Spin-dependent contact interaction played the dominant role in the spin dynamics because they are relatively strong in the case of $\mathrm { ^ { 5 2 } C r }$ atoms.

In the case where the atomic spins are tilted compared to the magnetic field by an rf pulse, it was nevertheless demonstrated that initial spin dynamics were entirely triggered by the DDI. This is a consequence of the ${ \mathrm { S U } } ( 2 )$ - symmetric nature of contact interactions, which cannot trigger dynamics after a simple rotation of the atomic spin initially in a stretched (ferromagnetic) state. Therefore, the onset of spin dynamics after rotation of the spins seen in Ref. [258] is a purely dipolar effect. Finally, in the specific case where the spins were tilted by $\pi / 2$ compared to the magnetic field, it was found that the spin dynamics vanishes. The mean-field theory provides a natural explanation for this phenomenon, as the torque associated with the inhomogeneous magnetic field carried by the atoms vanishes when the magnetisation of each atom vanishes [578].

In the $\pi / 2$ rotation case, spin-dynamics could be recovered by applying a magnetic field gradient providing the necessary spin-orbit coupling to trigger dynamics. It was then discovered that spin dynamics develops while preserving the local spin length of the condensate [258]. This protection of the initial ferromagnetic character of the gas was attributed to an energy gap provided by sufficiently large spin-dependent contact interactions. This dynamical protection of ferromagnetism is the reason why trapped magnon excitations could be observed in the Cr experiments and described using the hydrodynamic equation of a ferrofluid, indicating that the Cr BEC behaves like a genuine ferrofluid; see Section VI B 2 and [261].

It should be noted that the protection of ferromagnetism in the $\mathrm { ^ { 5 2 } C r }$ condensates is tied to the relatively small strength of the DDI compared to spin-dependent contact interactions; it is likely that similar experiments performed (for example with Ln atoms) in the regime where dipolar interactions overwhelm spin-dependent contact interactions may lead to qualitatively different behaviour, since the DDI does not preserve the spin length. As we will see in Sec. VII, working in optical lattices is another way to investigate a purely dipolar spin system. In this case, the collective spin length is indeed reduced during dynamics [579].

# 4. Effective spin-1/2 mixture of dipolar fermions

Beyond the case of BEC described above, recent work has been dedicated to the study of spinor systems of dipolar fermions [165, 252, 314]. This system is of great interest for the study of how the DDI affects superfluid pairing and the celebrated crossover from delocalised Cooper pairs in the BCS regime to a BEC of molecules [14, 128]. By choosing specific spin mixtures, spinor gases of constant magnetisation can be studied over long time scales, even for highly magnetic species of $\mathrm { E r }$ and Dy. This is due to the quantum statistical suppression of dipolar relaxation [165]; see also $\mathrm { S e c . }$ . This feature has been recently used to realise a long-lived spin- $1 / 2$ spinorbit-coupled degenerate dipolar Fermi gas [252]. This experiment will be discussed in Sec. VI D 1.

A spin- $1 / 2$ degenerate Fermi mixture of strongly magnetic atoms $^ { 1 6 7 } \mathrm { E r }$ was created [314], and the collisional behaviour of this mixture experimentally investigated. This experiment used a deep 3D optical lattice as a tool during the preparaiton of the mixtures, which serves to inhibit collisional losses induced by large magnetic field sweeps and the crossing of numerous FRs: A quantumdegenerate spin-polarised sample is first loaded into a deep 3D optical lattice at low magnetic field, such that double occupancy are precluded and fermions are spatial separated. The magnetic field can there be ramped up to a value where quadratic Zeeman shifts are significant, allowing spin state preparation using using rf sweeps, and later be ramped down to the low-field region, where the physics of the spin mixture is studied. To do so, the 3D lattice is slowly ramped down and the Fermi mixture loaded back into a 3D trap. As already observed for the spin-polarized case – see Sec. II D) – the collisional properties of the spin mixtures as a function of the bias magnetic field amplitude, $B$ , is marked by a large number of intra- and inter-spin FRs. Baier et al. [314] mapped the FR spectra for $B$ in the $[ 0 , 2 ] \mathrm { G }$ range via loss spectroscopy. Many narrow and overlapping features are obserrved. A comparatively broad and isolated interspin FR is also identified. Baier et al. used this resonance to reach the strongly-interacting regime. Here, a large collisional stability of the balanced spin-mixture at $T / T _ { F } \approx 0 . 3$ is observed, in particular on the repulsive side of the FR. This paves the way toward study of BEC-BCS physics in such systems.

# C. Spinor physics with free magnetisation

Besides the studies at constant magnetisation described above, the DDI introduces fundamental new features due to the presence of magnetisation-changing collisions; see Eq. (5). In this context, the linear Zeeman effect can impact out-of-equilibrium physics and phase diagrams. In particular, magnetisation-changing collisions can free the total magnetisation of a gas, so that the system now becomes sensitive to the linear Zeeman effect. Different regimes may be reached depending on the ratio of the Larmor precession energy to other energy scales. A rather complex phenomenology unfolds, depending on the Larmor frequency $g _ { J } \mu _ { B } B / h$ compared to the following energy scales; note that typical values are indicated on the right column for the specific case of $\mathrm { ^ { 5 2 } C r }$ atoms and $g J$ is the Landé factor:

<html><body><table><tr><td>Physical process Trap depth</td><td>Energy scale</td></tr><tr><td>Thermal excitations kbT/h = 2.5 kHz Spin-dependent interactions Fermi energy</td><td>Uo/h = 500 kHz ∈F/h=2.5kHz Texc/h = 250 Hz</td></tr><tr><td>Trap frequency</td><td>WL/2π=250Hz</td></tr><tr><td>DDI</td><td>Vdd/h= 25 Hz</td></tr></table></body></html>

$\Gamma _ { \mathrm { e x c } }$ was defined in Eq. (64).

• $g _ { J } \mu _ { B } B > U _ { 0 }$ . Dipolar relaxation leads to (spinsensitive) losses.   
• $U _ { 0 } > g _ { J } \mu _ { B } B$ . Dipolar relaxation does not lead to losses, but introduces heating. If $g _ { J } \mu _ { B } B \gg k _ { B } T$ , most of the atoms are polarised in the lowest energy state at equilibrium.   
• $g _ { J } \mu _ { B } B \approx k _ { B } T \gg \Gamma _ { \mathrm { e x c } }$ . The thermal gas is spontaneously depolarised, populating a few Zeeman sublevels at equilibrium. For bosons, Bose-stimulation insures that the BEC remains polarised in the lowest energy state. However, for Fermi gases, the DFG may be depolarised if $g _ { J } \mu _ { B } B < \epsilon _ { F }$ .

• $g _ { J } \mu _ { B } B < \Gamma _ { \mathrm { e x c } }$ . A demagnetised spinor BEC may be produced provided spin-dependent contact interactions do not favour a polarised BEC in the lowest energy state.

• When $g _ { J } \mu _ { B } B \approx \hbar \omega _ { L }$ , the released energy due to dipolar relaxation corresponds to one unit of excitation in the trap. This is favourable for measuring the change in angular momentum associated with dipolar relaxation; this is a quantum gas analogue of the Einstein-de-Haas effect.

• Reaching $g _ { J } \mu _ { B } B ~ \leq ~ V _ { d d }$ would be very interesting as the dipolar field then overcomes the ambient magnetic field. The (inhomogeneous) dipolar field itself sets the lowest-energy spin-textures.

# 1. Thermodynamics of a Bose gas with free magnetisation

Thermodynamics of a Bose gas with a spin degree of freedom is derived by including the single-particle magnetic energy in the Bose occupation factor. For noninteracting particles,

$$
f _ { k , m _ { s } } = \frac { 1 } { \exp \left[ \left( \epsilon _ { k , m _ { s } } - \mu \right) / k _ { \mathrm { B } } T \right] - 1 } ,
$$

where $\mu$ is the chemical potential, and $\epsilon _ { k , m _ { s } }$ is the singleparticle energy of the (trapped) states labeled by the index $k$ , in the Zeeman state $m _ { s }$ . When magnetisation is free (case of dipolar particles) $\epsilon _ { k , m _ { s } }$ includes the linear Zeeman effect, whereas when magnetisation is fixed (as for example of Rb and Na atoms), the linear Zeeman effect is gauged out and $\epsilon _ { k , m _ { s } }$ includes only the quadratic Zeeman effect.

For the generic case of a $F = 1$ spinor Bose gas interacting solely via contact interactions (and thus at constant magnetisation and without the quadratic Zeeman effect), the phase diagram has been worked out by Isoshima et al. [580] as a function of the temperature $T$ and the magnetisation $M$ . Two phase transitions were predicted. The first transition, at a critical temperature $T _ { 1 } ( M )$ separates the normal phase, and a phase where a condensate forms in the (most populated) stretched state. Below a second critical temperature $T _ { 2 } ( M )$ , all other spin components condense simultaneously (see Fig. 32).

First investigations of spinor physics with free magnetisation were performed using cold Cr atoms in an optical dipole trap. It was observed that the spin degrees of freedom equilibrated to the gas mechanical temperature [581]. At high temperature, the population of the different Zeeman states followed a distribution close to the Boltzmann distribution. The spin temperature was equal to the mechanical temperature, and thermal equilibrium between spin and orbital degrees of freedom was ascribed to magnetisation-changing dipolar collisions. Below the critical temperature for BEC, a spontaneous accumulation into the Zeeman state of lowest energy was observed. This led to a bimodal spin distribution, arising from BEC and the spontaneous accumulation of the atoms in the lowest-energy spin state.

![](images/6e2f1cb922a6a44afe9c504486be6654774b28997d3d13e1d569b3f221eb772e.jpg)  
FIG. 32: Measured and predicted phase diagram of a spin 3 Cr BEC. Three phases are observed: (A) thermal gas; (B) polarised BEC in stretched state; (C) spin-full (depolarised) BEC. The histograms show typical experimental population distributions. Black triangles are the measured $T _ { 1 }$ . Solid lines shows the predictions of $T _ { 1 , 2 }$ in the non-interacting case. Dashed lines show typical evolution predicted by theories with no interactions when the temperature is lowered at a given magnetic field $B$ , for two different regimes depending on whether magnetisation is fixed (left curve) or free (right curve). Adapted from [581].

By varying the temperature and the magnetic field, it was possible to map out the corresponding critical line $T _ { 1 } ( M )$ (see Fig. 32). However, the second predicted phase transition at $T _ { 2 } ( M )$ could not be studied. Indeed, when magnetisation is free, Bose stimulation towards the single-particle lowest-energy state insures that the BEC is only produced in this polarised state [581]. The second transition was recently observed in the case of sodium atoms with negligible DDI by Frapolli et al. [582]. The authors also studied the impact of spin-dependent interactions on the double-condensation scenario.

In a later study, it was possible to reach a multicomponent phase with Cr atoms by applying rapid, forced evaporative cooling to a depolarised gas, thus performing the experiment fast compared to the time scale for magnetisation-changing collisions. However, the spinor BECs were very small due an interplay between Bose condensation and spin dynamics [583]. This result pointed out the difficulty of fully thermalising the spin degrees of freedom. This is a prominent effect to be taken into account for very large spin systems such as Dy and $\mathrm { E r }$ where all spin states must be saturated for a stable multicomponent BEC to be produced.

The connection between magnetic order and superfluid order and the BEC transition is an intriguing question that remains largely unexplored. While these orders are intrinsically connected due to Bose stimulation, it was predicted that strong spin-dependent interactions induce spin ordering at a finite $T$ above the BEC transition [584]. In low dimensions, the connection between magnetic order and superfluidity promises to be especially interesting. In particular, in the 2D polarised case, superfluidity does not arise from condensation but by the pairing of vortices with opposite circulation through the Berezinskii-Kosterlitz-Thouless mechanism. This gives rise to a topological order [82, 585–587]. The case of a depolarised gas promises new scenarios for superfluidity, due to the existence of topological excitations such as half-quantum vortices that include the spin degree of freedom [588].

We note that the case of fermions will drastically differ from the scenario described above due to the presence of the additional energy scale provided by the Fermi energy. One consequence is that spontaneous demagnetisation of a noninteracting Fermi sea is expected provided the Larmor energy is smaller than the Fermi energy (Pauli paramagnetism). How interactions modify this picture is an open question and connected to Stoner instability.

# 2. Spontaneous demagnetisation of a BEC

One of the fascinating avenues of research for dipolar spinor physics is the investigation of the zerotemperature phase diagram at low magnetic fields when the Larmor energy is comparable to spin-dependent interactions. For the experiments performed with alkalis, spin-dependent contact interactions are extremely small compared to the linear Zeeman effect. In addition, the gas magnetisation remains constant for all practical purposes because contact interactions are isotropic, and anisotropic DDIs between alkali atoms are small. Consequently, the true ground state of these system, with free magnetisation at extremely low magnetic fields, has never been experimentally investigated.

Quantum gases made of strongly magnetic atoms, on the other hand, offer the new possibility of free magnetisation introduced by the DDI. Moreover, spin-dependent contact interactions provide an energy scale that corresponds to a magnetic field in the few 100- $\mu$ G range for Cr atoms (compared to 10 $\mu$ G for alkalis). It therefore becomes possible to investigate phase transitions driven by the competition between the Zeeman effect and spindependent interactions. For example, the phase diagram of Cr atoms has been calculated (ignoring the DDI) by [353, 589], and is expected to display a number of transitions separating ferromagnetic, cyclic, polar, and biaxial nematic phases as a function of the magnetic field.

![](images/d48b22c4415a06f3f382562389c99d0b5f9c7c92f59c8f241769221d0c438faf.jpg)  
FIG. 33: Absorption images of a $\mathrm { C r }$ BEC held in a magnetic field of (a) $\mathrm { 1 m G }$ , (b) $0 . 5 ~ \mathrm { m G }$ , (c) $\mathrm { 0 . 2 5 ~ m G }$ , and (d) 0 mG $\pm 1 0 0 \mu \mathrm { G }$ . These were obtained after Stern-Gerlach separation of the seven Zeeman components. The BEC spontaneously depolarises when the field is lowered below a critical value. Figure adapted from [351].

The phase diagram of Ln atoms is unknown to the best of our knowledge, though some have speculated [157]. We note that the case of Lns may be quite different, because contact interactions themselves contain an anisotropy associated with the large electronic angular momentum in the ground state.

The exploration of the spinor phase diagram at very low magnetic field was started with a Cr BEC in the $B \sim 1 0 0 \mu$ G regime [351]. While the BEC remains polarised in the lowest energy single-particle state for large enough magnetic fields, it was then shown that a dipolar BEC spontaneously depolarises when the Zeeman energy is quenched below a (density-dependent) critical value (see Fig. 33). It was furthermore shown that, while the DDI was presumably too small to significantly modify the observed phases, the dynamics of depolarisation was driven by dipolar interactions.

A number of open questions remain after the first results described in [351]. One interesting question concerns the possibility of characterising the excitations that may be produced when the phase transition is crossed. As magnetisation is dynamically modified, the sample should start rotating, in the spirit of the Einstein–deHaas effect. Such rotation could not be observed. However, simulations indicate that the threshold for demagnetisation could originate in the resonant dynamics associated with this exchange between spin and orbital momentum [590].

Furthermore, the impact of the DDI on the phases at low field also remains unexplored. Note that it would be especially interesting to study the regime where the Zeeman energy is smaller than the mean-field energy associated with the dipolar field, which could provide a scenario for symmetry breaking and modify the possible quantum phases [572]. The requirements in terms of magnetic field, below 50 $\mu$ G, are demanding, yet within reach of state-of-the-art experiments [591].

a. Demagnetisation cooling The coupling between the spin degree of freedom and the orbital degree of freedom due to the DDI also presents the possibility of exchanging Zeeman energy and mechanical energy for cooling purposes. This strategy, first suggested in Ref. [592], is based on the depolarisation of a gas of trapped atoms. Similar to adiabatic demagnetisation cooling, the coupling between the internal spin reservoir of the gas and the external kinetic reservoir via dipolar relaxation reduces the temperature of the gas. Although a single dipolar relaxation event per atom is insufficient to significantly cool the sample, it was suggested that optical pumping can bring the atoms back into the initial state, cool the spin reservoir, and begin a repeat of the cooling process.

Demagnetisation cooling of a gas of ultracold $^ { 5 2 } \mathrm { C r }$ atoms was demonstrated soon after by Fattori et al. [593]. Demagnetisation was driven by inelastic dipolar collisions, and optical pumping was used to magnetise the system and drive continuous demagnetisation cooling. An increase of the phase space density by one order–of– magnitude was demonstrated, with nearly no atom loss. In Ref. [201], demagnetisation cooling of a Cr gas was further studied in a deep optical dipole trap, which allowed the exploration of a large temperature range and could access high densities up to $5 . 1 0 ^ { 1 9 } \mathrm { ~ m ^ { - 3 } }$ . An increase of two orders in phase space density was shown, up to $1 0 ^ { - 2 }$ . For Cr atoms, inelastic collisions between one ground state atom and one atom optically excited by the repumping laser was shown to be the main process limiting the increase in phase space density.

Nevertheless, demagnetisation cooling offers a realistic potential for reaching degeneracy by optical cooling only. In particular, dysprosium or erbium atoms are good candidates, due to smaller recoil energy (larger mass), and the existence of narrow lines for optical repumping. In addition, the use of spin-changing collisions for cooling purposes may even be used for non-dipolar particles using spin-exchange contact interactions [594].

$b$ . Purification of a BEC by spin-filtering Another closely related cooling scheme, which is efficient below quantum degeneracy, has been demonstrated by Naylor et al. [595]. This scheme also relies on redistributing population between different spin states, with free magnetisation. The key idea is that only non-condensed atoms may populate spin-excited states since Bose thermodynamics enforce a fully polarised condensate; see Section $\cdot$ . Therefore, expelling spin-excited atoms from the trap provides a way to engineer losses specific to noncondensed atoms, thus cooling and purifying the condensate.

The scheme, experimentally demonstrated using $^ { 5 2 } \mathrm { C r }$ atoms, starts with a partially condensed Bose gas polarised in the lowest energy spin state. Demagnetisation of the thermal component is triggered by lowering the magnetic field, such that the Larmor energy is comparable to the thermal energy. Then, the spin-excited thermal components produced by magnetisation-changing collisions are filtered out by a magnetic field gradient. It was found that when the initial BEC fraction is high enough, this scheme ends up with a polarised BEC in the lowest energy state with an increased BEC fraction. This provides a thermodynamic cycle that, in principle, decreases the entropy by a factor of up to $( 2 s + 1 ) ^ { 3 / 4 }$ (where $s$ is the atomic spin), and could also be in principle repeated. The obtained reduction in entropy was typically a factor of 2 for one cycle in the Cr experiment.

In the experiment, technical limitations arose from the difficulty to control the magnetic field at very low values. This limitation is directly related to the fact that dipolar gases are sensitive to the linear Zeeman effect. It was suggested in Ref. [595] that the purification of a BEC by spin-filtering could be extended to non-dipolar species by using spin-dependent contact interactions and spin-exchange interactions. Both the dipolar and the non-dipolar cooling schemes were theoretically explored in [596]. A related cooling scheme was demonstrated with Rb atoms [597].

Note that, despite their highly magnetic character, such cooling techniques could be difficult to apply to Lns, because the Feshbach spectrum of these atoms might be too dense at low field, below typically 10 mG. Up to now, these techniques haven not yet been reported using Ln species.

Both approaches described here are ways to use the spin degrees of freedom to efficiently store and remove entropy from a gas. We point out that ideas using the spin degrees of freedom have already been developed in the context of lattice-based large-spin Fermi gases [566], mixtures of Bose gases [598], and Bose and Fermi gases [599]. Alternatively, it has also been suggested that the spin degrees of freedom, and/or spin-changing collisions, may be employed for thermometry purposes down to extremely low temperatures. Such temperatures are typically impossible to measure in BECs with usual thermometric techniques [597, 600].

# D. Light-induced spin-dependent Hamiltonians in dipolar gases

Apart from their large DDI, the large spin and rich electronic properties of highly magnetic atoms open interesting directions to explore spin-light coupling; see Secs. II B 1,II C. The wide variety of transition linewidths allow spin manipulation with reduced heating and the strong vector and tensor parts of the atomic polarisability allow the strong coupling of the electron’s angular momentum to light; as detailed in Sec. II C. These higherrank polarisabilities are intrinsically stronger in magnetic atoms due to their larger $L$ and $S$ values. In addition, in the case of Lns, $L S$ coupling occurs in the electronic ground state itself. This is in contrast to the case of alkali atoms for which spin-dependent coupling to light occurs only through the mediation of the excited electronic levels. This yields a different scaling of the vector and tensor polarisabilities with the detuning of the laser to the atomic transition, $\Delta _ { a }$ : scaling as $\propto \Delta _ { a } ^ { - 1 }$ and $\propto \Delta _ { a } ^ { - 2 }$ in Lns and alkali-metals, respectively [158, 260]. This makes Lns promising candidates with which to implement spindependent Hamiltonian tailored by light. Indeed, even if such synthetic spin-dependent Hamiltonian have been realised with alkali-atoms, they have been subjected to strong heating associated with incoherent light scattering. As a result, some of the most interesting regimes could not be reached with long-lived gases.

![](images/bfaa35c7267e66cb0f0e2828231deaa6fbe25b4a62bde0458d18a60a3f7e869d.jpg)  
FIG. 34: Comparison of demagnetisation cooling and spin filtering. (a) Demagnetisation cooling. Spinchanging collisions transfer kinetic energy of the most energetic atoms to magnetic energy, allowing a net cooling of the remaining atoms. Optical pumping can bring back spin-excited atoms to the initial spin state, enabling continuous cooling with no atom loss (graph). (b) Spin filtering. In presence of a condensed Bose gas, spin-changing collisions affect only thermal atoms that can then be selectively removed. This removal of entropy results in the cooling of the remaining gas and an increase of the condensed fraction (graph).

# 1. Synthetic spin-orbit coupling in gases of magnetic atoms

# a. Synthetic spin-orbit coupling and artificial gauge fields.

The coupling of a particle’s momentum and spin underlies many important phenomena in quantum systems, and in particular in electronic, solid-state systems [601]. For example, topologically nontrivial materials often require the coupling of the electron spin to momentum [602, 603]. Here, SOC typically arises from the movement of electrons through the crystal electric field. The effect of a magnetic field on charged particles also yields intriguing phenomena, the most famous of them being the quantum Hall effect [604]. This effect has its roots in the special form of the Lorentz force, which, at a quantum level, yields a kinetic term of the form:

$$
\hat { H } _ { k } = \frac { [ \hat { \mathbf { p } } - \hat { A } ( \hat { \mathbf { r } } ) ] ^ { 2 } } { 2 m } ,
$$

where $\hat { \bf p }$ is the canonical momentum and $\hat { \mathcal { A } } ( \hat { \bf r } )$ is the vector potential or gauge potential. Even more exotic behaviour, such as the fractional quantum Hall states [605], Laughlin liquids [606], and topological superconductors harbouring Majorana excitations [152] can arise if $\hat { \mathcal { A } } ( \hat { \bf r } )$ is not just a classical vector (i.e., three complex numbers), but a set of three operators $\hat { A } _ { x } ( \hat { \mathbf { r } } )$ , $\hat { A } _ { y } ( \hat { \mathbf { r } } )$ , and $\hat { A } _ { z } ( \hat { \bf r } )$ that do not commute. This yields a non-Abelian field.

Interestingly, ultracold atoms enable the combination of SOC and gauge potentials by the engineering of a realisation of Eq. (66). This mimics the effect of a Lorentz force on neutral matter while, additionally, the set of operators ${ \hat { A } } _ { i }$ connect to the atomic spin operators. If realised in high dimensions (i.e., greater than one), nonAbelian gauge fields may then be synthesised. This technique relies on laser-field dressing [161]. In the following, we will review this SOC protocol and discuss its extension to magnetic atoms. We note that several other strategies, not connected to SOC, have been developed over time to realise artificial gauge fields on neutral atoms, e.g., by engineering trap rotations [607].

As introduced in Sec. I C 3, and reviewed in detail in the above Sec. VI C, the DDI provides intrinsic SOC through the dipolar relaxation terms of Eq. (5). However, this is not generally the sort of SOC that results in the physics of artificial gauge fields mentioned above. It gives rise to an interaction term that does not conform to that of Eq. (66). (See Ref. [355] for a method that does.) In contrast, light-induced SOC schemes applied to ultracold quantum gases do realise a Hamiltonian term of the form of Eq. (66). The basic idea can be formulated as follows: Light fields are applied to couple Zeeman sublevels via a two-photon Raman transition. Recoil momentum is transferred as the optically coupled spin flips. The adiabatic evolution of these dressed states as the atom moves in the Raman field creates a synthetic gauge field [608]. This field provides SOC when these states form a (near) degenerate manifold. The general form of the SOC Hamiltonian under the 1D Raman coupling along the direction $\hat { x }$ of two Zeeman ground states is

$$
\hat { H } ( \mathbf { p } ) = \frac { [ \mathbf { p } - \hbar \mathbf { k } \hat { \sigma } _ { z } ] ^ { 2 } } { 2 m } + \frac { \hbar \Omega } { 2 } \hat { \sigma } _ { x } + \frac { \hbar \Delta } { 2 } \hat { \sigma } _ { z } ,
$$

where $\hat { \sigma } _ { x , y , z }$ are the Pauli spin matrices. $\Omega$ and $\Delta$ are the two-photon Raman Rabi frequency and detuning, respectively. The form of this coupling is the sum of Rashba $( k _ { z } \sigma _ { z } + k _ { y } \sigma _ { y } )$ and Dresselhaus $\left( k _ { z } \sigma _ { z } - k _ { y } \sigma _ { y } \right)$ SOC with equal weights. The resulting dispersion relation is of the form of a double well centred at $k = 0$ , as is typical of SOC systems. That is, the momentum of spin up atoms is oriented in the opposite direction from that of spin down atoms. In the 1D case described by Eq. (67), $\hat { A } _ { z } = \hbar \mathbf { k } \hat { \sigma } _ { z }$ and $\hat { A } _ { x , y } = 0$ , which does not describe a non-Abelian coupling because the single component of $\hat { A }$ commutes with itself. Generalisations to 2D and 3D with a truly non-Abelian gauge potential have been proposed [161] and realised in the case of 2D SOC [609, 610].

# $b$ . Spin-orbit-coupling in quantum gases: limitations and prospects

Spin-orbit coupling in BECs [148, 611] and DFGs [610, 612, 613] of alkali-metals have been achieved. However, heating due to spontaneous emission is severe. This arises because Raman coupling is not very efficient compared to spontaneous light emission due to the generally weaker tensor versus scalar polarizability. The optimal ratio of Raman coupling to spontaneous emission occurs at a Raman-laser detuning approximately equal to the fine-structure splitting [614]: alkali’s small fine structure splitting implies a large spontaneous emission rate if sufficiently strong coupling strengths are to be achieved. The heating from spontaneous emission leads to loss of quantum degeneracy and atomic population and the short lifetimes severely hamper the study of quantum many-body phenomena.

We note that lattices of fermionic alkaline-earth atoms [615–617] have also been used in SOC experiments. However, optical lattice confinement and inelastic collisions [618–620] among atoms limit the future ability to explore a wide variety of many-body phenomena.

By contrast, Ref, [158] suggested that fermionic openshell Ln atoms like Dy and $\mathrm { E r }$ might better serve due to their large orbital angular momentum and narrowline transitions. Spontaneous emission can be eliminated while still producing large Raman coupling even without lattice confinement or narrow lines because their ground-state orbital angular momentum is $L > 0$ . This is due to the fact that the vector and tensor polarizabilities that factor into the Raman coupling scale as the inverse atomic detuning $\Delta _ { a } ^ { - 1 }$ of the Raman lasers from the atomic transitions in these systems, as opposed to the faster $\Delta _ { a } ^ { - 2 }$ scaling in alkali-metals once $\Delta _ { a }$ exceeds the fine-structure splitting [260, 621]. Thus, in open-shell Lns, one can always choose a detuning that provides a large Raman coupling $\Omega$ while minimising heating from incoherent scattering [158]. The realisation of long-lived SOC Fermi gases would open new avenues to experimentally study topological matter not easily realisable in the solid state [148, 160, 161, 622, 623]. For example, one could create and study topological superfluids and exotic quantum liquids [148–155] in a well-controlled manner.

# c. Spin-orbit-coupling in assemblies of magnetic atoms

Burdick et al. [252] first reported the realisation of SOC in degenerate Fermi gases of Ln atoms using Dy. The SOC was induced using Raman light near the 741- nm transition. Its 1.8-kHz width reduces spontaneous emission rates below the background lifetime of the gas with only modest $\sim$ GHz detuning, which is large compared to the hyperfine splittings, but smaller than the fine-structure; see Refs. [215, 239]. The lifetime of SOC gases was then limited, not by spontaneous emission, but rather by dipolar relaxation.

Due to the suppression of inelastic dipolar scattering (see Sec. III C 4 for details), relatively long-lived SOC Fermi gases could be realised while working at a bias field of a few tens of G. Such magnetic fields were required, not only because the suppression effect scales as $\sqrt { B }$ , but also because the isolation of an effective pseudospin $1 / 2$ requires a large the quadratic Zeeman shift obtainable only at large $B$ . However, as discussed in Sec. II D, the extreme density of FRs in fermionic Lns, increasing with $B$ , complicates the situation, and Ref. [252] even reported the overlapping of resonances at these fields. Nevertheless, a field region at 33.846(5) G was found that allowed fermionic spin mixtures to live enough to allow spinorbit coupled $^ \mathrm { 1 6 1 }$ Dy gases to be created with a lifetime of ${ \sim } 4 0 0$ ms at a Raman coupling strength of $\hbar \Omega = 1 E _ { R }$ ; see Fig. 35(b). At this field, quadratic Zeeman shifts ensures that the Raman fields couple only the $m _ { F } = - 2 1 / 2$ and $m _ { F } = - 1 9 / 2$ states, providing maximum fermionic suppression of dipolar relaxation; see Fig. 35(a). Note that by contrast, the lifetimes of SOC $^ { 4 0 }$ K and $_ 6$ Li were lower by ${ \sim } 1 0$ and 100, respectively [610, 612, 613]. Moreover, the SOC $^ \mathrm { 1 6 1 }$ Dy lifetime is similar to that of free-space bosonic SOC alkali gases [611] and ${ \sim } 1 0 \times$ longer than that achieved in a bosonic lattice system [624].

Reference [252] also reported that Raman-coupled bosonic Dy has a short lifetime of less than 10 ms at low $B$ field. This is just as short as $_ 6$ Li, demonstrating the importance of fermionic statistics in preventing fast relaxation. Finally, the effect of dipolar interactions on Rabi oscillations was observable, highlighting the interacting dipolar character of the fermionic SOC system.

# $d$ . Dipolar relaxation of Raman-dressed spins

The physics of dipolar relaxation of Raman-dressed spins differs from the scenario of equilibrium gases described in Sec. III C. While one might suppose that atoms colliding in dressed spins are identical—the spins are just rotated on the Bloch sphere—and should therefore enjoy the full suppression of identical fermions (see Sec. III C 4), this is not the case for SOC fermions. Since spin is locked to momentum, atoms colliding with different momenta along the 1D SOC axis no longer behave as identical particles (they have different spin states) [252].

Although dipolar relaxation along the 1D-coupling axis proceeds unhindered, not all is lost: dipolar relaxation remains suppressed for collisions with momenta aligned primarily along axes transverse to the SOC coupling. A simulation of these effects shows that in terms of relaxation rate, the gas neither behaves as identical fermions enjoying full dipolar relaxation suppression, nor as distinguishable particles, but roughly halfway in between [252].

![](images/6a1c01f2a1232787df557266246b49b5443bbde19deaf5d635e4ee0fc3320b42.jpg)  
FIG. 35: Spin-orbit-coupling of fermionic $^ \mathrm { 1 6 1 }$ Dy. (a) Coupling scheme for $^ \mathrm { 1 6 1 }$ Dy at a magnetic field high enough that the lowest two Zeeman states are isolated by the quadratic Zeeman shift. $\delta$ is the two-photon Raman detuning and $\omega _ { Z }$ is the Zeeman splitting. (b) Momentum distribution after removing the coupling and separating the spin states with a magnetic field gradient. (c) Quasimomentum dispersion curve for the spin-orbitcoupled cloud in (b). The solid horizontal line indicates the Fermi energy. (d) Experimental lifetimes for a gas of $1 \times 1 0 ^ { 4 }$ $^ \mathrm { 1 6 1 }$ Dy atoms with $T / T _ { F } = 0 . 4$ . Adapted from Ref. [252].

Reference [628] reported on the realisation of the equivalent of a quantum Hall system, i.e., that dictated by Eq. (66), with $\hat { A } _ { x } ( \hat { \mathbf { r } } ) = e B \hat { y }$ , $\hat { A } _ { y } ( \hat { \mathbf { r } } ) = 0$ , using Ln atoms. This achievement relied on SOC in one spatial dimension ( $x$ ), using light near the 626-nm transition, and the coupling all the spin states of bosonic Dy, where the large electronic spin $J = 8$ of Dy was interpreted as a synthetic dimension $( y )$ , i.e., $\hat { J } _ { z }  \hat { y }$ . The SOC Hamiltonian, similar to (67), can then be interpreted as the Hall equivalent formulated above [155]. Similar work has been performed using non-magnetic atoms, yet bulk properties remained elusive due to the narrowness of the synthetic dimension used [615, 617, 629, 630]

In this work, Chalopin et al. demonstrated that their system shows distinct sectors with respectively bulk and edge behaviours in the ground band. This demonstrates the relevance of large spin Lns systems to realise quantum many-body systems with non-trivial topology. The observed behaviour in each sector of the ground band are reminiscent of Landau-level physics: In the bulk, dynamics is suppressed due to the flatness of the band. In contrast, the edge modes exhibit a ballistic dispersion, yet with a motion allowed in one direction only, i.e., showing chirality. The authors also characterised the elementary excitations above the ground band and directly observe cyclotrons orbits, in the bulk, and skipping orbits at the edges. The cyclotron gap is roughly constant over the bulk sector and the corresponding frequency is large ( $\approx$ 40KHz) compared to both the decay rate (see above) and the temperature scale. Finally, the Hall response of the ground band was measured, by applying a potential difference in the synthetic dimension. The response shows a characteristically nearly quantised behaviour, with a Chern number of nearly one in bulk and a vanishing mobility in the edge sectors. This is suggests the topological protection of the edge states. While the limited lifetime of the bosonic system due to dipolar relaxation may hamper the exploration of some many-body physics, this results helps to establish Ln SOC systems as promising platforms for the realisation of synthetic topological quantum many-body states.

# 2. Synthetic spin-dependent interactions in gases of magnetic atoms and generation of entangled quantum states

Dipolar relaxation remains a nuisance when coupling more than two spin states together, since such spin states are not protected. In Ref. [165], the lifetime of SOC Dy gases at low fields, around 1 G, were observed to be of around 10 ms, for bosons as for fermions. Thus, SOC in dipolar gases are limited to high fields, setting limitations on the realisation of certain exotic many-body states [158, 625–627].

e. Realisation of a synthetic quantum Hall system using magnetic atoms

In recent works using ultracold bosonic gases of $^ \mathrm { 1 6 2 }$ Dy and $^ \mathrm { 1 6 4 }$ Dy, a spin-dependent Hamiltonian was generated using laser light close to the 626-nm atomic line [181, 182]. The laser field has a linear polarisation along $x$ while the magnetic field points along $z$ . The resulting atom-light interaction yields an effective coupling term $\hbar \omega \hat { J } _ { x } ^ { 2 }$ , with $\hat { J }$ being the total atomic angular momentum. This scheme, similar to that previously investigated with a large ensemble of room temperature Cs atoms [536], realises a so-called one-axis twisting Hamiltonian [156], which has also been investigated in many other systems [631–634]. Typical coupling strengths $\omega$ are on the MHz scale and can be made to greatly exceed the kHz-scale Larmor precession frequency as well as the dipolar relaxation rate.

Highly non-classical spin states could be generated under the effect of this coupling term [156]. Reference [181] experimentally demonstrates the creation of Schrödinger cat states resulting from the coherent superposition of the two stretched spin states $\mid \pm J \rangle$ . In contrast to ensembles of $s ~ = ~ 1 / 2$ particles, for which entanglement can only be generated between different atoms of the ensemble, here the non-classical states arise because of the entanglement between electrons within each individual atom [536]. This possibility is a key feature provided by large-spin systems. These states appear in the time evolution of the atomic spin (at the single particle level) after a quarter of coupling period, $T = 2 \pi / \omega$ . Furthermore, several revivals of the cat state spaced by $T / 2$ as well as a repolarisation into the Fock states $| J \rangle$ and $| - J \rangle$ at intermediate times (half integer multiples of $T$ ) occur during the time evolution. Coherence is seen to decay under the effect of classical $B$ -field noise, to which the cat state is more sensitive than a classical (coherent) state. Nevertheless, the cat state’s lifetime reaches up $6 0 \mu \mathrm { s }$ . Focusing on a similar dynamics but shorter time scales (set by $\tau = 1 / \left( \sqrt { 2 J } \omega \right) )$ , Ref. [182] probes the formation of non-Gaussian “oversqueezed” states.

# VII. Magnetic atoms in strongly confined geometries: low-dimensional gases and lattice systems

Up to now, we have discussed bulk dipolar effects, i.e., that which happens in assemblies of atoms free to move and collide in space, both in the fully polarised case (Secs. IV and V) and considering additionally the spin degree of freedom (see Sec. VI). A complementary trend has developed in the community, loading atoms in strongly confined geometries, either using tight anisotropic traps or periodic potentials made by light standing waves (so called optical lattices) [7, 8, 129, 635, 636]. This has proven to be a new platform to achieve the strongly interacting regime and investigate interesting open questions in quantum many-body physics [7, 8, 128, 129, 636–638]. In this section, we discuss the new physics arising from loading highly magnetic atoms in strongly confined geometries, focusing on the experimental achievements to date. In a first part we discuss the case of dipolar gases effectively constrained to a one-dimensional (1D) space, using a two dimensional optical lattice. In this case, the atomic motion remain free in the direction transverse to the lattice, realising an array of 1D gases. In a second part (Sec. VII B), we discuss the new physics brought by the long-range and anisotropic dipolar interactions in a spin-polarised sample in 3D periodic potentials. In this case, the atomic motion occurs in direction in which the external potential is a lattice, realising Hubbard-like models. In the third part (Sec. VII C), we still consider 3D periodic potential but additional allow for an internal spin degree of freedom, relating to the very broad topic of quantum magnetism.

# A. One-dimensional dipolar gases

By using tight traps in one or two directions of space, the motion of ultracold atomic gases is constrained, reducing the dimensionality of the system. Such systems have been studied in contact-interacting gases [82, 127]. In this section, we focus on 1D gases of magnetic atoms and describe the new behaviour resulting from strong DDIs.

The physics of interacting quantum particles in dimensions higher than 1D is often reducible to an effective description of non-interacting quasiparticles composed of the original particles “dressed” by their interactions. The excitations of such a system are nearly single-particlelike. That is, as we have seen in Sec. IV A, MF and Bogoliubov treatments are often adequate for bosons, while high-dimensional fermionic systems are accurately described by the celebrated MF Fermi liquid theory of Landau [639, 640]; see Sec. IV B.

Many-body quantum physics in 1D is far more strange. Particles, being constrained to move on a line, cannot avoid each other, and so all excitations are collective in nature. Moreover, quantum fluctuations play a large role in determining how the system may organise; e.g., strong fluctuations prevent the establishment of long-range order [125]. Fermi liquid theory is no longer applicable in 1D. Instead, Tomonaga-Luttinger liquid theory captures the low-energy physics of both interacting fermions and bosons [127]. For example, it describes the strange phenomenon of the spin-charge separation of excitations: excitations fractionalise into spinons that carry spin but no charge, and holons that carry charge without spin [127].

The role of quantum statistics also changes in 1D. Because particles can no longer exchange their positions without undergoing a collision, strongly interacting fermions behave like bosons and vice-versa, at least for some local observables like the density distribution. Indeed, the Lieb-Liniger model for contact interacting bosons,

$$
H _ { L L M } = - \sum _ { \mathrm { a t o m s } } \frac { \hbar ^ { 2 } } { 2 m } \frac { \partial ^ { 2 } } { \partial x ^ { 2 } } + \sum _ { \mathrm { p a i r s } } g _ { \mathrm { 1 D } } \delta ( x ) ,
$$

describes how the physics of bosons map onto that of free fermions in the limit of infinitely strong interactions ( $g _ { 1 \mathrm { D } }  \infty$ ) [641]. The coupling strength $g _ { \mathrm { 1 D } }$ is approximately related to the 3D scattering length $a$ through $g _ { \mathrm { 1 D } } = 2 \hbar ^ { 2 } a / m a _ { \perp } ^ { 2 }$ , where $a _ { \perp } = \sqrt { \hbar / m \omega _ { \perp } }$ and $\hbar \omega _ { \perp }$ is the excitation energy of the tightly confined directions perpendicular to the 1D axis [642]. For the system to be considered within the 1D regime, $\hbar \omega _ { \perp }$ should be much larger than the chemical potential of the gas $\mu$

The bosonic wavefunction describing the system in the $g _ { 1 \mathrm { D } }  \infty$ limit, referred to as a Tonks-Girardeau (TG) gas, is equal to the absolute value of a fermionic wavefunction [140, 641]. The ‘fermionised’ bosons repel each other strongly enough that their two-body correlation function $g ^ { ( 2 ) } ( 0 )$ vanishes just like that of identical fermions—repulsion in 1D mimics the effect of the Pauli exclusion principle. The TG regime is reached when the Lieb-Liniger parameter,

$$
\gamma \equiv m g _ { \mathrm { 1 D } } / n _ { \mathrm { 1 D } } \hbar ^ { 2 } ,
$$

is much greater than one; $n _ { \mathrm { 1 D } }$ is the 1D density. Intuitively, $\gamma$ compares the mean interparticle distance $1 / n _ { \mathrm { 1 D } }$ to the length scale $\hbar ^ { 2 } / m g _ { \mathrm { 1 D } }$ over which the repulsive interaction ‘bends’ the wavefunction. In this high- $\gamma$ regime, the density-density correlation $g ^ { ( 2 ) } ( x = 0 )  0$ , i.e., the quasiparticles antibunch, as expected from their fermionlike character.

There exist even more exotic states, such as the superTonks-Girardeau (sTG) gas. These highly excited states are characterised by stronger-than-ideal Fermi gas correlations. Such gases can be accessed by quenching $g _ { \mathrm { 1 D } }$ from $+ \infty$ to $- \infty$ , as has been observed in Cs and Dy [142–144, 643–645]; see Sec. VII A 3.

Many aspects of 1D fermionic systems have been explored in the condensed matter setting [646], and bosonic 1D gases have been realised and studied both near and below the TG limit using ultracold atomic gases confined in arrays of 1D optical potentials using 2D optical lattices or in magnetostatic potentials from atom chips [140, 641, 647–652]. Several characteristic properties have been observed, including antibunching [653, 654]; unusual transport [655]; quantum integrability (i.e., the existence of an extensive number of integrals of motion) [656]; long-lived metastability of a sTG gas [143]; pinning quantum phase transitions [657]; unusual excitation spectra [658, 659]; velocity of sound [660]; and rapidity (i.e., quasiparticle momentum) distributions [661]. One-dimensional Fermi gases have also been created with excitation spectra consistent with Luttinger liquid theory [567, 662].

Dipolar interactions enrich the physics accessible with 1D gases. Theoretical results have primarily focused on purely dipolar quantum gases, in which the only interaction comes from the DDI [138, 139, 663–667]. Various effects of the DDI have been predicted, in particular including increased correlations of akin to sTG gases, or even crystallisation in the ground state.

# 1. The effective quasi-1D DDI and realisation of 1D dipolar gases

In a quasi-1D geometry, the external motion of the atoms is effectively frozen in two directions when $\hbar \omega _ { \perp } \gg$ $k _ { \mathrm { B } } , \mu$ . The effective form of the DDI in quasi-1D geometries can be derived from the 3D expression, Eq. (1), by integrating out the transverse degrees of freedom, as shown in Refs. [137–139]. Under a single-mode approximation, this yields

![](images/1596044989913bbaa7421a893560d1ee50d0426ade6892dfb53cfd8fdeae7e23.jpg)  
FIG. 36: Red line is the 1D DDI, while dashed line is the 3D DDI. The 1D DDI approaches the 3D curve at large normalised distance $u = x / a _ { \perp }$ . Unlike the 3D divergence at short range, the 1D DDI assumes a finite value. Figure reproduced from Ref. [668].

$$
U ^ { \mathrm { 1 D } } ( u ) = V ( \theta ) \left[ V ^ { \mathrm { 1 D } } ( u ) - \frac { 8 } { 3 } \delta ( u ) \right] ,
$$

where

$$
V ( \theta ) = \frac { \mu _ { 0 } \mu ^ { 2 } } { 4 \pi } \frac { 1 - 3 \cos ^ { 2 } \theta } { 4 a _ { \perp } ^ { 3 } } ,
$$

and

$$
V ^ { \mathrm { 1 D } } ( u ) = - 2 | u | + \sqrt { 2 \pi } ( 1 + u ^ { 2 } ) e ^ { u ^ { 2 } / 2 } \mathrm { e r f c } ( | u | / \sqrt { 2 } ) .
$$

Here, $u = x / a _ { \perp }$ , and $\operatorname { e r f c } ( u )$ is the complementary error function. There are two contributions to the shortrange part of the 1D DDI. The first is the $\delta$ -function term. It comes from the point limit of an extended dipole [669] and has an opposite sign to $V ^ { \mathrm { 1 D } } ( u )$ . The second contribution is an effective delta-function term that arises from the fact that $V ^ { \mathrm { 1 D } } ( u )$ becomes more sharply peaked as $a _ { \perp }$ shrinks [138, 139]. At distances $| x | \gg a _ { \perp }$ , $V ^ { \mathrm { 1 D } } ( u )  {  } 4 / | u | ^ { 3 }$ . This $x ^ { - 3 }$ long-range potential is just like the DDI in 3D, but with diminished magnitude at ranges on the order of $a \perp$ . Within a distance set by $a _ { \perp }$ , the DDI ceases to seem 1D to atoms that approach near each other. The underlying 3D spatial nature is manifest and a small attractive (repulsive) contribution to the DDI emerges from the part of their wavefunctions that extend transversely by $a _ { \perp }$ , even if the long-range interaction along the 1D axis is repulsive (attractive) [138, 139].

The DDI in 1D thus has both long and short-range components [138, 139, 663]. The chemical potential remains intensive in 1D, which is indicative of a short-range interacting system. However, like a long-range interacting system, there is no asymptotic phase shift (scattering length) that can be defined for two-body collisions in 1D [663]. Away from collisional resonances, the shortrange part of the DDI can add to the van der Waals contact pseudopotential to yield a total hard-core contact interaction strength $g _ { \mathrm { 1 D } }$ , as considered in Refs. [141, 670]. In addition to the FR-tunability of the van der Waals contact interaction (discussed in previous sections), the 1D DDI provides wide tunability in the properties of 1D many-body systems because both the short and longrange parts of the DDI in 1D can be set to a positive or negative sign, or made to completely vanish at the magic angle $\theta _ { m } = 5 4 . 7 ^ { \circ }$ .

Dipolar 1D gases have been created by loading BECs of either $^ { 5 2 } \mathrm { C r }$ or $^ \mathrm { 1 6 2 }$ Dy into 2D optical lattices creating arrays of 1D tubes [141, 163]. In this geometry, the DDI affects different aspects of the interactions: 1) the dependence of $g _ { \mathrm { 1 D } } ( \theta )$ on the short-range component of the 1D DDI; 2) the intratube long-range DDI; and 3) the mutual long-range DDI of atoms in nearby tubes. The intertube DDI does not change the dimensionality of the system, but rather is a multichannel effect that couples different flavors of 1D quasiparticles [141]; i.e., coupled 1D systems remain 1D because the phase space degrees of freedom are still 1D when there is no transport between tubes.

The first experimental work with 1D dipolar gases used Cr and explored magnetisation-changing collisions and their suppression in 2D optical lattices [163]; see Fig. 6 and Sec. III C 5 for more details. The first experiments with strongly interacting gases entering the fermionised $\gamma > 1$ regime used Dy with ${ \sim } 5 0$ Dy atoms per tube [141].

# 2. Thermalization in a dipolar quantum Newton’s cradle

Tang et al. [141] investigated the thermalization of a near-integrable quantum system. The Lieb-Liniger model is an example of a quantum integrable Hamiltonian, in which there exists an extensive number of conserved quantities, resulting in regular, non-chaotic, nonthermalizing dynamics for any value of $g _ { \mathrm { 1 D } }$ [140, 641]. This is due to the 1D geometrical constraint imposed on interactions: Two-body interactions permit nondiffractive scattering between nearest neighbours only, leaving the set of incoming momenta unchanged with respect to the set of outgoing momenta [671]. As a result, the scattering matrix obeys the Yang-Baxter equation, a sufficient condition for integrability [641, 671–673], since the binary collisions are unable to alter the distribution functions. Therefore, an empirical ‘smoking gun’ for integrability would be the persistence of an out-ofequilibrium momentum distribution beyond the intrinsic dynamical time scale.

The group of David Weiss at Penn State University observed this persistent non-equilibrium momentum distribution in 1D gases of contact-interacting Rb atoms, thereby experimentally establishing the integrability of the Lieb-Liniger model. Their experiment relied on quantum quenches using what they called a ‘quantum Newton’s cradle’ [656]: Atoms in 1D traps were set in motion using a Bragg diffraction pulse as a system quench. The atoms oscillated in counterpropagating packets and collided twice each period under the strong-coupling condition of $\gamma \gg 1$ . This is akin to the desktop Newton’s cradle toy, except that instead of the metal spheres reflecting upon each collision, the Rb atoms could also pass through one another as a manifestation of the quantum nature of the system. Rather than rapidly come to a steady state (i.e., a stationary Gaussian momentum distribution), the packets were observed to oscillate many times (far longer than what one would expect in a 3D gas) before the onset of heating from spontaneous emission. Thus, the Weiss group established that a strongly interacting integrable quantum system could be studied in the laboratory. Although both longitudinal confinement and transverse (virtual) motional excitation break integrability, these detrimental effects are suppressed in the $\gamma \gg 1$ regime [674–676].

Tang et al. [141] used the magnetic DDI in a 1D Dy gas as the controllable interaction with which to break integrability in a dipolar version of the quantum Newton’s cradle experiment. It is known from classical physics that magnetic spheres cause the motion of a toy Newton’s cradle to be chaotic due to the long-range interaction; the long-range DDI should likewise break integrability in the quantum systems, since it allows for “diffractive” collisions among atoms. Indeed, the DDI allows for “diffractive” collisions among atoms: i.e., in addition to two colliding atoms swapping their momentum, as in the case of contact collisions (which are non-diffractive), their momentum may also be imparted to a third particle. This violates the Yang-Baxter condition, and hence breaks integrability. Since the DDI strength falls off slowly in space, the probability for a diffractive interaction is not suppressed by the usual need for three particles to be at the same place at once. Furthermore, by simply controlling $\theta$ , the strength of the integrability-breaking perturbation can be tuned. Figure 37 depicts the dipolar quantum Newton’s cradle.

The dipolar quantum Newton’s cradle opens new avenues to explore how quantum thermalization arises upon the introduction of a perturbation that lifts integrability. For example, theoretical consensus is lacking regarding whether relaxation involves two distinct timescales or three for strongly interacting quantum near-integrable systems (i.e., first prethermalization, then a prethermal plateau of a near steady-state prethermal state, and finally a decay to the thermal state) [677–682]. More generally, thermalisation of a near-integrable system is an old question with a celebrated answer in the realm of classical physics [683]. In the 1950’s, Kolmogorov, Arnold, and Moser developed what became known as KAM theory, establishing that chaos, and hence thermalization, sets in as a smooth crossover as the strength of a nonlinear, integrability-breaking perturbation is increased [684]. In the quantum realm, it has long been wondered whether any meaningful analogue to KAM theory exists, and a general theory for quantum thermalization in near-integrable systems is lacking despite much work [652, 677, 678, 680–682, 685–694].

![](images/930987a188b43c27ac4cd9bc486c9652560229896d48560cad0a7adafca219da.jpg)  
FIG. 37: a) An array of 1D tubes for Dy atoms is created by a 2D optical lattice. b) Cartoon of dipolar quantum Newton’s cradle. Dipolar Dy atoms are made to collide within the 1D tubes (only one in the is array shown). The dipolar interaction is controlled by an external magnetic field making an angle $\theta$ with respect to the 1D axis along $\hat { y }$ . This provides a knob with which to control this integrability-breaking interaction.

In their experiment to investigate this issue, Tang et al. [141] observed relaxation and thermalization dynamics in the time evolution of the momentum distribution of the kicked 1D gas. The distance to a thermal distribution is quantified and is observed to undergo two distinct exponential decay regimes. The first evolution is a prethermalization (dephasing) decay, and the second consists of the relaxation from the prethermal state towards a Gaussian thermal distribution determined by the Gibbs ensemble.

Tang et al. found that the thermalization rate in this second step obeys a simple scaling expression that depends only on $\theta$ without any free parameters. The expression accounts for the DDI perturbation using Fermi’s golden rule formula, multiplied by the cross section for short-range interactions to occur. This describes the dominant integrability-breaking diffractive interaction term: that of two atoms scattering via the contact interaction while simultaneously interacting with a third atom at long range via the DDI. It is remarkable that such a simple description appropriately describes the thermalization dynamics of such a strongly interacting system near an integrable point.

The experiment was supported by an exact diagonalization calculation of a two-rung XXZ quantum magnetism model [695] with long-range hopping serving as the perturbation. Similar two-stage thermalization dynamics was observed despite the microscopic dissimilarity of the systems.

Future work could attempt to understand how generally applicable is this simple, Fermi golden rule-like expression for a wider variety of quantum quench experiments. One could also explore how more sophisticated descriptions based on, e.g., adaptations of generalised hydrodynamics, may better describe the dipolar 1D nearintegrable system. More generally, this work sets the stage for a wide array of inquiries into the physics of strongly interacting quantum systems near integrability. In the next section, we describe one such investigation, that of quantum many-body prethermal ‘scar’ states, enabled by the realisation of dipole-stabilised excited 1D

quantum gases.

As mentioned above, the TG state is one in which 1D bosons with a divergently repulsive coupling strength behave like fermions. The two-body wavefunction vanishes when the atomic positions coincide, and so possesses exclusion correlations as if it were an ideal Fermi gas. A quantum quench of the TG gas prepares an eigenstate of the attractive Lieb-Liniger model, the so-called superTG gas mentioned above in Sec. VII A. The TG and sTG state wavefunctions and energies are smoothly connected as a function of $g _ { \mathrm { 1 D } }$ , so while the effective model exhibits a discontinuity, the system remains adiabatic throughout the parameter quench. The result is a highly excited sTG state wherein the 1D bosons that attractively interact at short range behave as if they were ground-state fermions repulsively interacting at long range. That is to say, the bosons develop even stronger exclusion correlations than the ideal Fermi gas. The two-body wavefunction node inherited from the quench from the TG state extends into a pair of nodes separated by the length $a _ { \mathrm { 1 D } }$ , effectively introducing a rigid exclusion zone similar to the classical hard rod model. Moreover, its excited-state many-body wavefunction exhibits many more nodes than the TG wavefunction, which enhances the stiffness of the sTG gas [142, 696].

Such metastable attractive gases typically collapse into bound states (cf. the ‘Bose-nova’ implosion of strongly attractive BECs in 3D [106]). By contrast, however, the strong antibunching correlations in the sTG gas wavefunction prevent atoms from approaching each other close enough to bind into cluster-like states. The sTG gas is expected to never collapse, despite the multitude of bound states of lower energy. The deeper reason for this surprising metastability lies in the aforementioned integrability of the Lieb-Liniger model, for any $g _ { 1 D }$ value. That is, the sTG state is also a solution to the Bethe ansatz equations of the Lieb-Liniger model [645].

Experimentally, however, the sTG gas does collapse for attractive interactions weaker than those in the unitary $g _ { 1 \mathrm { D } }  - \infty$ regime, as first observed in the nondipolar Cs system [143]. While the system remains effectively integrable in the unitary regime, since the interaction term dominates all others in the perturbed Lieb-Liniger Hamiltonian, the system can collapse when the interactions become sufficiently weak outside the unitary regime. That is, the breaking of the integrability of the Lieb-Liniger model becomes manifest once the system is no longer unitary near the resonance. Experimental imperfections such as the longitudinal harmonic trap and the virtual excitation of the higher motional bands of the transverse 2D optical lattice forming the array of 1D traps all break integrability, if only weakly [144, 674–676]. These yield nonzero matrix elements coupling the initial state and molecular/cluster-like bound states in the near-integrable system that enable the collapse of the sTG state at finite negative $g _ { \mathrm { 1 D } }$ coupling strength.

This may be understood in analogy to the classical 1D gas of hard rods of length $a _ { \mathrm { 1 D } }$ . The rod length $a _ { \mathrm { 1 D } }$ extends an exclusion zone that prevents rods from overlapping. When more rods $N$ are stuffed into a box of length L than can fit end-to-end (i.e., when $N a _ { \mathrm { 1 D } } > L$ ), then the system “collapses” by kinking the rods out of 1D alignment. In the quantum system, $a _ { \mathrm { 1 D } }$ is the 1D scattering length definable through $g _ { \mathrm { 1 D } } = 2 \hbar ^ { 2 } a / m a _ { \perp } ^ { 2 } =$ $- 2 \hbar ^ { 2 } / m a _ { \mathrm { 1 D } }$ . Both $g _ { \mathrm { 1 D } }$ and $a _ { \mathrm { 1 D } }$ ⊥are tunable using a confinement induced resonance (CIR) [642]. These arise in quasi-1D traps due to the open-channel-like role of higher-energy transverse motional states of the trap and were first observed in Cs [697]. The CIR provides tunability through the dependence of $a$ on $B$ -field near a 3D FR:

$$
g _ { \mathrm { 1 D } } ( B ) = \frac { 2 \hbar ^ { 2 } a ( B ) } { m a _ { \perp } ^ { 2 } } \frac { 1 } { 1 - C a ( B ) / a _ { \perp } } ,
$$

where $u _ { \perp }$ is the transverse oscillator length and $C \approx$ 1.46 [642].

Kao et al. [144] explored the effect of DDIs on the stability of the sTG gas. An array of 1D Dy gases were quenched into the sTG state under various angles $\theta$ with respect to the 1D axis. CIRs were found near a broad 3D FRs in $^ \mathrm { 1 6 2 }$ Dy, allowing $g _ { \mathrm { 1 D } }$ to be tuned from $0 ^ { + } ~ \to ~ + \infty ~ \to ~ - \infty ~ \to ~ 0 ^ { - }$ by increasing the magnetic field. Note that unlike theory predictions [137, 698–700], molecular binding energy measurements of the CIRs employed in Ref. [144] showed that they did not exhibit a dependence on $\theta$ , neither in the repulsive ( $\theta = 9 0 ^ { \circ }$ ), attractive ( $\theta = 0 ^ { \circ }$ ), nor non-dipolar $\theta = \theta _ { m }$ configurations. The state of the system was revealed through gas stiffness measurements obtained from the observations of the square of the ratio of the breathing–to–dipole oscillation frequencies. This quantity $R$ is greater than four in an sTG gas, but dives toward zero when a gas collapses into bound states due to diverging compressibility. Figure 38 contrasts the repulsive and attractive DDI cases.

Intuitively, one might expect that a repulsive DDI would inhibit the sTG gas from collapsing, by adding a repulsive energy barrier between atoms, at least until the contact interaction becomes too weak. Conversely, an attractive DDI might cause the sTG to collapse at a more strongly negative $g _ { \mathrm { 1 D } }$ than in a nondipolar gas. However, this intuitive picture is confused by the fact that the DDI breaks integrability, see Sec. VII A 2, leading to collapse through eigenstate mixing with cluster states.

Reference [144] indeed found that the repulsive DDI stabilises the excited gas, and surprisingly, does so regardless of how close to zero the negative $g _ { \mathrm { 1 D } }$ is tuned. That is, the DDI does not simply expand the region of sTG gas stability by a small margin, but prevents collapse for all attractive contact interactions. By contrast, an attractive DDI hastened the collapse, as expected, while collapse in the nondipolar case occurred at a coupling strength similar to that found in Cs.

![](images/5fbd63efab590159b4eae6b09922e8f902cb913bd61991b544030578fa4f5d21.jpg)  
FIG. 38: Comparison of excited state stiffness $R$ versus coupling parameter A2 ∝ g−21D showing a) increased instability due to an attractive DDI in contrast to b) the complete stabilisation of the excited gas due to the repulsive DDI. $A$ is a normalised form of the coupling constant [701], $a _ { \parallel }$ is the longitudinal oscillator length in the 1D trap, and $N$ is the average number of atoms per tube. The regime of collapse is indicated in panel (a), while the unitary, scar, and weakly interacting regimes are roughly sketched in panel (b). Figure adapted from Ref. [144].

The reason for the dramatic influence of DDI on the stability of the excited states, despite being too weak to affect the phase diagram of the ground state, remains unclear, pending future studies. This experimental discovery nevertheless provides access to a brand-new nearintegrable system where prethermal scar-like states can be explored. We note that stable gases with $R < 4$ were also observed, suggesting that gas-like few-body cluster states had been formed as predicted in Ref. [644]. In the next section, we discuss how the stabilisation enabled a novel state-preparation scheme that exploits a quantum holonomy inherent to the Lieb-Liniger Hamiltonian.

# 4. Quantum holonomy, topological pumping, and strongly correlated prethermal states

Systems with a quantum holonomy possess the property that eigenstates can change after a cyclic, adiabatic variation of Hamiltonian parameters: while the Hamiltonian stays the same, the resulting eigenstate differs [702]. The Lieb-Liniger Hamiltonian harbours one such exotic quantum holonomy [703]. It is realised by cycling $g _ { \mathrm { 1 D } }$ through $0 ^ { + }  + \infty  - \infty  0 ^ { - }$ , resulting in different eigenstates of higher energy upon the return to the same $g _ { 1 D }$ value.

![](images/f4d51e69eacb2a1991bc6e2e041c8c6626cc4bdcab6dc56ac0d0bce49bfbc766.jpg)  
FIG. 39: The hierarchy of energy eigenstates accessible via topological pumping using the quantum holonomy point at $g _ { 1 \mathrm { D } } = \pm \infty$ . Two complete quantum holonomy cycles are shown verses energy per particle $E / N$ . The Bethe ansatz solutions for the repulsive (attractive) LL model are shown in dotted (solid) curves, along with the associated data on the repulsive (attractive) branches in black circles (blue squares). The intermediate coupling region associated with scars is shaded (starting above the ground-state repulsive branch). To the left and right are the weakly interacting and effectively integrable unitary regimes, respectively. Figure adapted from Ref. [144].

Such holonomies provide a topological means with which to pump a system into higher energy states. A simple, single-particle example of an energy pump arises in the case of a 1D infinite square well: Periodically imposing a delta function potential between the infinite barriers pumps the ground state wavefunction to higher energy eigenstates [704, 705]. Topological pumping in space has been known at least since Archimedes discovered the use of a screw to move water up an incline. Rotating Archimedes’ screw by $2 \pi$ returns it to the same configuration, but the water within the screw advances by one screw site. Similarly, the Thouless charge pump translates an electron one lattice site due to topological properties of the system [706], inducing quantised transport in an insulator; such spatial quantum topological pumps have been demonstrated using quantum gases in special optical lattices [707, 708].

The many-body quantum holonomy of the Lieb-Liniger Hamiltonian was realised in Ref. [144] using Dy 1D gases by scanning $B$ through a sequence of CIRs. This enabled the first topological pumping of a quantum many-body gas up a hierarchy of extensively higher energy eigenstates because the gas was stabilised by the repulsive DDI; see Sec. VII A 3. Figure 39 shows this hierarchical ladder.

In the very strongly interacting $g _ { \mathrm { 1 D } } ~  ~ \pm \infty$ regime of the energy eigenstate spectrum, the system is effectively integrable because the large contact interaction overwhelms all integrability-breaking terms in Hamiltonian. By contrast, in the opposite, weakly interacting regime, the system is effectively single-body (meanfield). It is thus only in the intermediate-coupling regime where the topological pump prepares a hierarchy of exotic, ergodicity-avoiding prethermal states in a system that remains many-body and correlated but also effectively not integrable because of non-negligible contributions from the trap and the DDI. Surprisingly, despite the lack of perfect integrability, its energy density follows the solutions to the Bethe ansatz equations throughout the coupling regimes, within experimental uncertainty.

These particular excited states resemble the atypical, nonergodic quantum many-body scar states that fail to immediately thermalize [145]. Their name derives from the regular patterns (scars) traced by special wavefunctions through the otherwise ergodic phasespace of single-particle chaotic quantum systems [709]. Until very recently, it was believed that long-lived farfrom-equilibrium states of quantum many-body system only exist in integrable and many-body localised systems [710, 711]. The discovery of “quantum many-body scars" in a Rydberg-atom lattice [25, 712] showed that such far-from-equilibrium states can be long-lived outside these limits, and thus potentially serve as long-lived quantum memories [145].

The novel scars exhibited by the dipolar-stabilised excited 1D gas are the first observed in a continuous, rather than lattice-based system. The fact that scars might form near integrability was first pointed out in Refs. [678, 713], and their observation in the 1D dipolar system makes this connection experimentally explicit. Measurements of stiffness and energy–per–atom versus time show that the states do not heat; rather, they persist far longer than the collective-oscillation time scale in a prethermal state [144]: entropy rather than energy increases while the gas weakly thermalizes.

The dipolar-stabilised 1D gas results mark an advance in our understanding of the exciting and highly active topic of quantum nonequilibrium many-body dynamics: not only do they provide a new way of creating a class of interesting nonequilibrium states that are relatively unexplored from both theoretical and experimental points of view, but they also draw a rich new correspondence between quantum scars, topological pumping, and nearintegrability. In addition to preserving quantum manybody correlations, these scars may play a role in the quantum simulation of exotic fermionic many-body systems, since Feynman’s ‘no-node’ theorem does not apply to the wavefunctions of excited bosonic states [714, 715].

# B. Spinless dipoles in lattices.

Even in absence of a spin degree of freedom, because of its long-range and anisotropic character, the DDI drastically affects the physics of lattice-confined atomic assemblies, both its static properties and in its dynamics. In the first part, we describe assemblies of spinpolarised dipolar particles, loaded in three-dimension optical lattice potentials, and the status of their experimental achievements with highly magnetic atoms.

# 1. Extended Hubbard Hamiltonian and consequences

Assemblies of spinless interacting particles, confined in deep lattices (tight-binding regime), are typically well described via Hubbard models of the form:

$$
H = - \sum _ { i \neq j } t _ { i , j } \hat { a } _ { i } ^ { \dagger } \hat { a } _ { j } + \frac { 1 } { 2 } \sum _ { i , j } U _ { i , j , k , l } \hat { a } _ { j } ^ { \dagger } \hat { a } _ { l } ^ { \dagger } \hat { a } _ { k } \hat { a } _ { i }
$$

Here, ${ \hat { a } } _ { i }$ is the (Wannier) destruction operator for a particle at site $_ i$ , and we note the number operator $\hat { n } _ { i } = \hat { a } _ { i } ^ { \dagger } \hat { a } _ { i }$ . We first keep the discussion general, and the operators $\hat { a } _ { i } ^ { \dagger }$ , ${ \hat { a } } _ { j }$ abide either the canonical commutation or anticommutation relations for bosonic or fermionic particles, respectively. In ultracold atomic systems, the Hubbard model is derived by writing the Hamiltonian of the particles moving in the periodic external potential of the lattice in the basis of the associated Wannier wavefunctions $\{ w _ { i } \} _ { i }$ , lattice sites in the lowest band and restricting the motion to this lowest band [8, 128, 129, 635, 636, 716]. The $t _ { i , j }$ coefficients correspond to the energies from the single-particle kinetic and external (lattice) potential terms for a particle initially at site $i$ and moving to site $j$ . They are thus denoted hopping or tunnelling coefficients. Due to the weak overlap between Wannier functions at different sites in the tight-binding regime, hopping is generally restricted to the nearestneighbour hopping, $\textit { j } = i + \boldsymbol { u } _ { \alpha }$ , $\mathbf { \Delta } \mathbf { u } _ { \alpha }$ denoting the lattice unit cell vector in direction $\alpha = x , y , z$ . The $U _ { i , j , k , l }$ describe interparticle interaction energies for two particles located at sites $i$ and $k$ initially and, after the interaction, at sites $j$ and $\it { \Delta } l$ . Explicitly, those coefficients write $\begin{array} { r } { U _ { i , j , k , l } = \int \mathrm { d } r \mathrm { d } r ^ { \prime } w _ { j } ^ { * } ( r ) w _ { l } ^ { * } ( r ^ { \prime } ) U ( r - r ^ { \prime } ) w _ { k } ( r ^ { \prime } ) w _ { i } ( r ) } \end{array}$ with $U ( r )$ , the interparticle interaction potential. Because interaction potentials usually decay with distance, the largest interaction contribution for bosonic assembly is the on-site interaction ( $i = j = k = l$ ) yielding a term $U \hat { n } _ { i } ( \hat { n } _ { i } - 1 )$ , with $U = U _ { i , i , i , i }$ . We note that the on-site term cancel for fermions due to the Pauli exclusion principle and the single-band assumption, precluding multiple occupancy at one lattice site. Off-site interactions terms may also arise. In deep lattices (i.e., additionally accounting for the weak overlap between Wannier functions), the largest contribution of off-site interactions are those involving no particle motion, i.e., $i = j \neq k = l$ between two particles located at cite $i$ and $k$ respectively, yielding the coefficients $V _ { i , k } = V i , i , k , k$ .

In the case of contact-interacting assemblies, off-site interactions vanish with the Wannier functions overlap. Therefore, the standard Hubbard model for bosonic spinpolarised contact-interacting samples in a cubic lattice (spacing $d$ ) has only two parameters: the tunnelling rate $t = t _ { i , i + u _ { \alpha } }$ , independent on the bond direction $\alpha$ , and the onsite interaction $U$ [635]. This yields the so-called Bose-Hubbard model:

$$
H = - t \sum _ { \langle i , j \rangle } \hat { a } _ { i } ^ { \dag } \hat { a } _ { j } + \frac { U } { 2 } \sum _ { i } \hat { n } _ { i } ( \hat { n } _ { i } - 1 ) ,
$$

with $\left. i , j \right.$ denoting nearest neighbours sites. For the spinless fermionic case, in absence of long-range interactions, the standard Hubbard model only yields tunnelling terms, which intimately interplay with Pauli exclusion principle. We note that, in the contactinteracting fermionic case, two spin components are usually considered, which also yields a two-parameter (tunnelling/on-site interaction) model called the FermiHubbard model [716]. This is:

$$
H = - t \sum _ { \langle i , j \rangle , \sigma } \hat { a } _ { i , \sigma } ^ { \dagger } \hat { a } _ { j , \sigma } + \frac { U } { 2 } \sum _ { \substack { i , \sigma \neq \sigma ^ { \prime } } } \hat { n } _ { i , \sigma } \hat { n } _ { i , \sigma ^ { \prime } } ,
$$

with $\hat { a } _ { i , \sigma }$ ( $\hat { n } _ { i , \sigma }$ ) being the fermionic destruction (number) operator for particle of spin $\sigma$ at site $_ i$ . This expression matches the original model heuristically introduced by Hubbard in the context of condensed matter systems, where strongly correlated electrons move in the ionic crystal. In this context, Hubbard models have been powerful in predicting or explaining quantum phases of matter [118, 717, 718].

Atomic systems offer direct and convenient control of the Hubbard model parameters. In particular, for contact-interacting particles (spinless bosons or spin- $1 / 2$ fermions) on a cubic lattice created by standing-wave of light (e.g., retroreflection of a laser beam) [7, 636], $t$ and $U$ intrinsically depend on the light intensity. The light intensity indeed sets the depth of the periodic lattice potential, $V _ { \mathrm { { L } } }$ . Consequently, it controls both the external potential in the Hamiltonian (coming in the expression of $t$ ) and the extension of the Wannier wavefunction, at the basis of the Hubbard derivation. Defining $s = V _ { \mathrm { L } } / E _ { \mathrm { r } }$ to be the ratio of the lattice depth to the recoil energy, $E _ { \mathrm { r } } = \hbar ^ { 2 } k _ { \mathrm { L } } / 2 m$ ( $m$ is the atomic mass and $k _ { \mathrm { L } } = 2 \pi / d$ the reciprocal lattice constant), $t$ is found to vary as $t \propto s ^ { 3 / 4 } \exp \left( - 2 s ^ { 1 / 2 } \right)$ and $U$ as $s ^ { 3 / 4 }$ at large lattice depths [7]. Therefore, the ratio $t / U \propto \exp \left( - 2 s ^ { 1 / 2 } \right)$ decreases for increasing lattice depths. Furthermore, $U$ is proportional to the scattering length and can be additionally controlled thanks to Feshbach resonances [269]. Relying on these control knots, ultracold-gas experiments have revealed and explored the spectacular effects related to the dynamics and thermodynamics of Hubbard models. For instance, the transitions from superfluid or metallic phases to strongly interacting insulating ones, called Mott phases, arising from the competition between $U$ and $t$ , have been observed both in bosonic and in fermionic systems [8, 128, 636–638, 719–722].

In the reminder of this section, we only consider spinless atoms. In the case of highly magnetic atoms, the long-range and ansiotropic DDI gives rise to additional interaction terms in the Hubbard model, following the general form of Eq. (74). Additionally, the DDI introduces dependencies in the coefficient values related to the orientation of the dipoles defined by the angles $( \theta , \phi )$ compared both to the on-site Wannier function anisotropy or to the lattice geometry [14, 147, 723, 724]. For simplicity, we first consider the case of dipolar bosons. In the tight binding regime, the relevant extended Bose-Hubbard model can be written as [147]

$$
\begin{array} { l } { \displaystyle { H = - \sum _ { \langle i , j \rangle } t _ { i , j } \hat { a } _ { i } ^ { \dagger } \hat { a } _ { j } + \frac { U _ { \mathrm { c } } + U _ { \mathrm { d d } } ( \theta , \phi ) } { 2 } \sum _ { i } \hat { n } _ { i } ( \hat { n } _ { i } - 1 ) } } \\ { \displaystyle { + \frac { 1 } { 2 } \sum _ { \langle i , j \rangle / u _ { \alpha } = i - j } V _ { \alpha } ( \theta , \phi ) \hat { n } _ { i } \hat { n } _ { j } } } \\ { \displaystyle { + \frac { 1 } { 2 } \sum _ { \langle i , j \rangle / u _ { \alpha } = i - j } \Delta t _ { i , j } \hat { a } _ { j } ^ { \dagger } \hat { a } _ { i } ( \hat { n } _ { j } + \hat { n } _ { i } - 1 ) , \qquad ( \hat { \bf { z } } _ { i } ^ { \dagger } \hat { a } _ { j } + \hat { \bf { z } } _ { i } ) } } \end{array}
$$

which includes the terms with contributions up to first order in the Wannier wavefunction overlap. The dominant effect of the DDI is the on-site dipolar-interaction term $U _ { \mathrm { d d } } ( \theta , \phi )$ , which adds to the contact-interaction one, $U _ { \mathrm { c } }$ , and which depends on the Wannier function anisotropy compared to the dipole orientation due to the DDI anisotropy. For an isotropic Wannier function, $U _ { \mathrm { d d } }$ cancels. Because of the long-range character of the DDI, off-site terms also contribute. These are: (i) a nearestneighbour interaction (NNI) $V _ { \alpha }$ between two atoms localised on neighbouring sites $i$ and $i + { \pmb u } _ { \alpha }$ ; (ii) a densityinduced tunnelling (DIT) term of strength $\Delta t _ { \alpha }$ , arising from the interaction between one atom localised at site $i$ or $i + { \pmb u } _ { \alpha }$ and one delocalized between $i$ and the neighbouring site $i + { \pmb u } _ { \alpha }$ . Remarkably, at zero order in the wavefunction overlap, the NNI does not cancel, but becomes independent of the lattice depth, its strength is approximately given by $V _ { \alpha } = U _ { \mathrm { { d d } } } ( d \boldsymbol { u } _ { \alpha } )$ with $U _ { \mathrm { d d } }$ given in Eq. (11). In contrast, the DIT only exists at first order in the Wannier overlap between sites. Additionally, due to the DDI anisotropy, $V _ { \alpha }$ depends on the dipole orientation, mainly compared to the direction $\mathbf { \Delta } \mathbf { u } _ { \alpha }$ of the lattice bond on which the interaction occurs. $\Delta t _ { \alpha }$ also depend on $( \theta , \phi )$ both via the bond direction and the Wannier wave function anisotropy.

The competition between the additional terms appearing in Eq. (77) (i.e., $V _ { \alpha }$ and $\Delta t _ { \alpha }$ ) and the conventional ones (i.e., $U$ and $t$ ) are expected to yield new physics. Such extended Hubbard models have been extensively studied theoretically, in various lattice geometries and dimensionalities, for various parameters strengths and lattice filling $n$ , as well as for different particle statistics (fermions or bosons) [147]. Rich phase diagrams, including unconventional quantum phases supporting strong and exotic correlations, have been predicted. The most studied case is the one of bosons in a 1D or 2D square lattice [725–737]. Here, chargedensity waves, i.e., insulating phases with modulated density, have been predicted for strong enough NNI, $V _ { \alpha }$ [725, 728, 729, 731, 734, 737, 738]. Depending on the filling and on the dipole orientation, star, stripe or chequerboard spatial patterns have been predicted [730]. The transition from superfluid to density-wave states can occur directly without an intermediate “supersolid" $\eta$ (or “lattice-supersolid" $\boldsymbol { \eta }$ ) phase [728, 729, 731, 734, 737], i.e., a superfluid with a spatial density modulation different from the lattice itself [739]. Yet, under some conditions (typically low filling $n < 0 . 5$ and finite $U > t$ ), a lattice-supersolid phase has also been predicted in simulations [725, 726, 732, 734, 735, 737]. It is in particular expected to be stabilised by doping (adding holes or particles) of the density-wave state away from the rational fillings. At incommensurate fillings and large enough $V _ { \alpha }$ , phase separation into a pure solid and a homogeneous superfluid has also been predicted to occur [725]. Phase separation is favoured by large $U$ , yet it is destabilised, contrarily to the supersolid, by considering the next order of extension of the DDI, and may ultimately disappear when one consider the full range of the DDI. In 1D, an Haldane-like phase has also raised high interest [727, 732– 734, 737]. This insulating phase occurs at unit filling for $U \sim V > t$ ; it does not break the translation symmetry but stands out by its special correlations. Compared to the Mott insulator phase, the particle-hole fluctuations indeed appear with an alternating order. These unconventional phases have critical temperatures typically scaling with $V _ { \alpha } / k _ { \mathrm { B } }$ .

For spinless fermions, a similar expression Eq. (77) can also be derived, yet because of the Pauli exclusion principle, the second and fourth terms of the sum in Eq. (77) cancels, only retaining the tunnelling and NNI terms. Theoretically, this case is also of interest, yet turns out to be more complicated to treat than the boson one [14, 147, 740–746]. Few studies have shown that various kinds of charge-density-wave and supersolid phases also forms in dipolar fermions lattice systems in 2D [740–743, 745] and 3D [744]. Additionally, $p$ -wave superfluidity may arise. The interplay between lattice and dipole-induced Fermi surface deformation has also been predicted to yield a topological phase transition, of a Lifshiftz type [746]. Of even larger interest has been a case recovering a situation closer to the bosonic model, with (effective) spin-1/2 fermions as for the conventional Hubbard model; see Eq. (76). This particular case will not be discussed further here, interested readers can consult e.g. refs. [14, 147].

![](images/3bc5225de22cb697c989d67e0b7753b139377eb88ac6980a98ffe6a423cd86dc.jpg)  
FIG. 40: Measurement of the extended Bose-Hubbard model from a spin-polarised $^ { 1 6 8 } \mathrm { E r }$ BEC loaded in a 3D anisotropic lattice [307]. (a) illustrates the lattice and atomic dipoles geometry. (b) illustrates the different term of the Hamiltonian. (c-d) shows the measurement revealing the NNI term via its effect on the particle hole excitation energy. (c) exemplifies the principle of the differential measurement, comparing the resonance position from the modulation in two different excitation directions using the same overall configuration. The shift between $y$ (red) and $x$ excitation is attributed to the loss of one distinct NNI unit $V _ { y }$ or $V _ { x }$ as illustrated in the insets. (d) summarise all the differential measurement performed with the dipole oriented along $y$ (green) or along $x$ (orange) and the comparison to the theory prediction (dotted line). Adapted from [307]

tical system, see Fig.40(c). Based on Eq. (77), the excitation gap depends on on the excitation direction compared to the dipole orientation by the contribution of $- V _ { \alpha } ( \theta , \phi )$ . The differential measurement shows that $V _ { \alpha }$ is tunable from $- h$ $3 0 \mathrm { H z }$ to $h$ $6 0 \mathrm { H z }$ , in the 266-nmspacing directions, in agreement theoretical expectations, see Fig.40(d). The DIT was evidenced by the observed shift of the superfluid-to-Mott-insulator transition, which cannot be entirely explained by a theory accounting for the effect of the on-site DDI but is when accounting for DIT additionally [747].

The predicted exotic phases of the extended Hubbard model have not yet been observable in the experiment. We note that the strength of the NNI, being mainly set by the simple magnetic moment $\mu$ and by the lattice spacing, cannot be easily increased in the experiment. Its relative weakness in systems made of magnetic atoms impose stringent restrictions on the temperature below which the phases of interest would become observable as well as on the time needed for their spontaneous emergence or their (adiabatic) preparation. Such regimes are on the edge of the experimental possibilities to-date. To mitigate these constraints, interesting approaches consist in designing optical lattices with small (sub-wavelength) spacings, thus increasing the NNI coefficient [748–754]. Finally, preparation and detection schemes at the singleatom level [638, 755, 756] are a direction of broad interest which would ease the observation of exotic phases as well as many others effects of interests, e.g. the influence of the DDI on the correlations or the dynamics of impurities. Beyond the case of spin-polarised bosons in rectangular lattices, very important prospects relate to the case of the distinct fermionic statistics, as well as to the change of the lattice geometry and the investigation of frustration or disorder effects.

# 2. Experimental status

Up to now, one experiment has reported on dipolar effects in quantum gases of spin-polarised highly-magnetic atoms confined in a deep lattice potential [307]. It is based on $^ \mathrm { 1 6 8 }$ Er BEC loaded in a 3D optical lattice of parallelepipedic unit cell with spacings (266, 266, 532) nm, see Fig.40(a). This work demonstrates the relevance of the extended Hubbard model (Eq. (77)) for magnetic bosons, see Fig.40(b). By varying both the lattice depths independently in each spatial direction and the dipole orientation, Baier et al. [307] reveal the impact of the DDI in the lattice system — that is on the excitation spectrum, in particular affecting the gap of the Mott-insulator phase, and on the phase diagram itself, in particular shifting the superfluid-to-Mott-insulator transition. Baier $e t$ al. [307] additionally quantified the various terms of the extended Hubbard model (Eq. (77)). They measured the dipolar on-site interaction contribution , $U _ { \mathrm { d d } }$ , by varying the Wannier wavefunction anisotropy and the dipole orientation. They also observed the two leading long-range interaction terms, i.e. the NNI and DIT. The strength of the NNI was isolated and quantified thanks to a differential measurement of the particle-hole excitation gap, comparing two excitation directions in an otherwise iden

# C. Exploration of spin lattice models and quantum magnetism

# 1. Introduction

Beyond the spin-polarised case, magnetic atoms in optical lattices make it possible to explore quantum magnetism. For this reason, these are exciting system that may realise an analogue quantum simulator of canonical open problems associated with quantum many-body physics [7, 8, 14, 129, 147, 638].

In typical experiments with ultracold atoms interacting at short range, a spin degree of freedom can be included by, e.g., populating different Zeeman sublevels in the ground-state hyperfine manifold, see also Sec. VI A 1. In this case, the system is well described by a spinfull Hubbard model: Extending the case of Eqs. (75),(76), it

takes the general form:

$$
H = - t \sum _ { \langle i , j \rangle , m } \hat { a } _ { i , m } ^ { \dagger } \hat { a } _ { j , m } + \frac { 1 } { 2 } \sum _ { i , k , l , m , n } U _ { k , l , m , n } \hat { a } _ { i , l } ^ { \dagger } \hat { a } _ { i , n } ^ { \dagger } \hat { a } _ { i , m } \hat { a } _ { i , k } ,
$$

where $\hat { a } _ { i , m }$ is the destruction operator of an atom of spin $m$ at site $_ i$ and $U _ { k , l , m , n }$ is the on-site spin-dependent interaction that one can deduce from the $a _ { S }$ scattering lengths; see also Secs. II D and III. Here, we assume a spin and direction independent tunnelling rate $t$ . If $t$ remains weak compared to the on-site interactions, tunnelling processes between two adjacent occupied lattice sites are energetically forbidden and they contribute as only a second-order virtual process. In such a process, an atom tunnels to an occupied site where spin-dependent onsite interaction may lead to a change of the individual spin of the atoms before the atom tunnels back to its original (unoccupied) site. In the case where there is one particle per lattice site, this results in an effective lattice model with spin-spin nearest-neighbour interaction. In the case of effective spin- $1 / 2$ systems (or larger spin with $\mathrm { S U } ( N )$ -symmetric interactions), with interpsin onsite interaction strength $U$ , the system is well described by the Heisenberg Hamiltonian,

$$
H _ { \mathrm { e x } } = \frac { J _ { \mathrm { e x } } } { 2 } \sum _ { \langle i , j \rangle } \left[ \hat { S } _ { i } ^ { z } . \hat { S } _ { j } ^ { z } + \frac { 1 } { 2 } \left( \hat { S } _ { i } ^ { + } . \hat { S } _ { j } ^ { - } + \hat { S } _ { i } ^ { - } . \hat { S } _ { j } ^ { + } \right) \right] ,
$$

with $J _ { \mathrm { e x } } = \pm 4 t ^ { 2 } / U$ [757–759], where $^ +$ holds for fermions, and $-$ for bosons. $\hat { S } _ { i } ^ { ( - , + , z ) }$ are the spin operators on site i and defined as Sˆ(−,+,z)i $\begin{array} { r } { \sum _ { m , m ^ { \prime } } S _ { m , m ^ { \prime } } ^ { ( - , + , z ) } \hat { a } _ { i , m } ^ { \dagger } \hat { a } _ { i , m ^ { \prime } } } \end{array}$ , with $\hat { a } _ { i , m }$ t e Wannier operator annihilating a particle on site $i$ state $m$ and $S _ { m , m ^ { \prime } } ^ { ( - , + , z ) }$ the usual spin matrices elements $\langle m | { \hat { S } } ^ { ( - , + , z ) } | m ^ { \prime } \rangle$ . In the case of a spin $1 / 2$ system, they are the Pauli matrices. This effective interaction, known as super-exchange, is the direct analogue of the exchange interaction between strongly interacting electrons, which arises from the interplay between tunnelling and Coulomb blockade [118]. For the goal of gaining a deeper understanding of condensed matter phenomena, physics arising from the super-exchange interaction in atomic assemblies has been widely studied, both in bosonic [541, 760–763] and in fermionic [764–770] assemblies; see also Ref. [638] for a review. In the case discussed here of atoms interacting at short range, the resulting Heisenberg Hamiltonian is limited to isotropic (XXX) interactions between nearest neighbours, which conserve the total longitudinal magnetisation.

In the case of particles interacting via the DDI, the situation is qualitatively different. This is because the DDI introduces a direct coupling between spins which, in contrast to super-exchange interactions, is longranged (not limited to nearest-neighbour interactions), and anisotropic (following the intrinsic anisotropy of the dipolar forces). In addition, as a direct consequence of the anisotropy, the total longitudinal magnetisation is not conserved. The associated two-body interaction potential is given in Eq. (2) and leads, by projection on the Wannier basis (see also Sec. VII B), to on- and direct off-site interactions terms comprising similar elastic, exchange and relaxation processes in the lattice Hamiltonian.

When tunnelling is absent, as is the case in very deep lattices, it becomes possible to study spin lattice models due to the mere DDI, i.e., without the addition of super-exchange effects. In practice, for magnetic atoms, the DDI can noticeably exceed super-exchange interactions even when $t$ is not negligible, which eases the requirements for investigating equilibrium versus out-ofequilibrium quantum dipolar magnetism. In addition, compared to the situation governed by a Heisenberg Hamiltonian, it is expected that these dipolar interacting spin ensembles will display a number of exotic quantum magnetic behaviours [83].

# 2. Free magnetisation and XYZ spin models

Perhaps the most striking differences between the spin-lattice models of the super-exchange Hamiltonian (Eq. (79)) and the DD lattice Hamiltonian in Eq. (2) arise from the presence of magnetisation-changing collisions. Through the conservation of total angular momentum, these magnetisation-changing collisions introduce an intrinsic nonlinear coupling between the spin degrees of freedom and the orbital degrees of freedom, see also Sec. VI. In the context of lattice systems, this coupling can result in an effective XYZ Hamiltonian

$$
H _ { X Y Z } = \sum _ { i , j } J _ { i , j } \left( \alpha \hat { S } _ { i } ^ { x } . \hat { S } _ { j } ^ { x } + \beta \hat { S } _ { i } ^ { y } . \hat { S } _ { j } ^ { y } + \gamma \hat { S } _ { i } ^ { z } . \hat { S } _ { j } ^ { z } \right) ,
$$

where $\alpha$ , $\beta$ , and $\gamma$ differ. Note that in Eq. (80), the coupling rate $J _ { i , j }$ may also depend on the intersite bond, and the sum is not restricted to nearest neighbours. Since $\begin{array} { r l r } { \alpha \hat { S } _ { i } ^ { x } . \hat { S } _ { j } ^ { x } + \beta \hat { S } _ { i } ^ { y } . \hat { S } _ { j } ^ { y } } & { { } = } & { \frac { \alpha + \beta } { 4 } \left( \hat { S } _ { i } ^ { + } . \hat { S } _ { j } ^ { - } + \hat { S } _ { i } ^ { - } . \hat { S } _ { j } ^ { + } \right) + } \end{array}$ $\begin{array} { r } { \frac { \alpha - \beta } { 4 } \left( \hat { S } _ { i } ^ { + } . \hat { S } _ { j } ^ { + } + \hat { S } _ { i } ^ { - } . \hat { S } _ { j } ^ { - } \right) } \end{array}$ , the fact that $\alpha$ and $\beta$ differ is directly associated with the DDI couplings that do not conserve magnetisation.

This Hamiltonian is associated with novel quantum phases presenting non-trivial topologies [771–774]. In these proposals, the topological states arise due to the spin-orbit coupling associated with the DDI, and the associated circulation. As for the bulk case of dipolar spinor physics (see Sec. VI C), the actual use of the spin-orbit term to achieve coherent coupling between discrete single-particle states with different external (orbit) and internal (spin) properties, may require extremely fine tuning of the experimental parameters such as the magnetic field with a precision better than the 10 $\mu$ G level. Similar to the case of the control of dipolar relaxation, described in $1 1 1 \mathrm { { C } 5 }$ , the presence of a lattice and its associated band gap might relax these conditions.

# 3. Fixed magnetisation and the secular NMR Hamiltonian (XXZ model)

The experiments have first concentrated on the regime where magnetisation-changing collisions may be ignored. Such a situation may be realised naturally when particles never share the same lattice site, as dipolar relaxation is a localised phenomenon when the magnetic field is sufficiently high, see Sec. $\cdot$ . This applies when $R _ { \mathrm { d r } } ( B ) \ll d$ , wher yields $d$ he la, wh pacing, see is the lat$\begin{array} { r } { B \gg \frac { 2 } { \pi ^ { 2 } } \frac { E _ { r } } { g _ { F } \mu _ { B } } } \end{array}$ $E _ { r }$ tice recoil energy, typically of a few $\mathrm { k H z }$ , while is of a few kHz/mG (see Sec. VI C) and off-site dipolar relaxation is practically suppressed for $B \gtrsim 1 0 \mathrm { m G }$ . Additionally, as described in Sec. III C 5, a very strong reduction of magnetisation-changing collisions can also be obtained in optical lattice, when the energy released in a dipolar relaxation event does not match the energy for band excitation. This applies for both on-site and off-site processes and as long as the magnetic field is low enough so that the Zeeman splitting is smaller than the lattice band gaps [164]. Typically the lattice depth $V _ { \mathrm { { L } } }$ is a few tens to hundreds of $E _ { r }$ and the above suppression holds for small $B$ up to few tens of mG.

The effective Hamiltonian that describes interacting dipoles in a lattice in absence of dipolar relaxation is known from the nuclear magnetic resonance community as the secular dipolar Hamiltonian [257], which reads:

$$
\begin{array} { c } { { \displaystyle H _ { \mathrm { s e c } } = \frac { 1 } { 2 } \sum _ { i , j } \frac { \mu _ { 0 } ( g _ { F } \mu _ { B } ) ^ { 2 } } { 4 \pi r _ { i , j } ^ { 3 } } ( 1 - 3 \frac { z _ { i , j } ^ { 2 } } { r _ { i , j } ^ { 2 } } ) \times } } \\ { { \displaystyle \left[ S _ { i } ^ { z } . S _ { j } ^ { z } - \frac { 1 } { 4 } \left( S _ { i } ^ { + } . S _ { j } ^ { - } + S _ { i } ^ { - } . S _ { j } ^ { + } \right) \right] , } } \end{array}
$$

where ${ r } _ { i , j }$ and $z _ { i , j }$ are the distance between sites $i$ and $j$ and its projection along the quantization axis $z$ , respectively. Compared to the Heisenberg Hamiltonian of Eq. (79) introduced above, the main differences are (i) the long-range and anisotropic nature of the coupling $\begin{array} { r } { J _ { i , j } \ \propto \ \frac { 1 } { r _ { i , j } ^ { 3 } } ( 1 - 3 \frac { z _ { i , j } ^ { 2 } } { r _ { i , j } ^ { 2 } } ) } \end{array}$ not restricted to nearest neighbours, and (ii) the fact that the magnitude of the exchange term $\left( S _ { i } ^ { + } . S _ { j } ^ { - } + S _ { i } ^ { - } . S _ { j } ^ { + } \right)$ is different, changed by a factor $- 1 / 2$ . This seemingly slight modification in fact breaks the $S O ( 3 )$ rotational symmetry of the Hamiltonian and can have important consequences both for the magnetic phases in the ground state [83], and for outof-equilibrium properties [775]. $H _ { \mathrm { s e c } }$ in fact corresponds to an XXZ Heisenberg model ( $\alpha = \beta$ compared to the general XYZ model of Eq. (80)).

The Hamiltonians $H _ { \mathrm { X Y Z } }$ and $H _ { \mathrm { s e c } }$ introduced above show that magnetic atoms can become a useful platform to investigate spin lattice models for frozen particles. As previously discussed in the bulk case in Sec. VI A 1, the large DDI from magnetic atoms is the consequence of a large total (spin plus angular) orbital momentum $s > 1 / 2$ , so that these lattice models can typically be investigated for rather large spins. One of the interesting practical consequences is that the large spin of atoms provide new measurement protocols because spin dynamics can be monitored by measuring the evolution of the population of the different Zeeman states directly, contrary to the case of $s = 1 / 2$ particles.

Moreover, the existence of a large spin also introduces novel physics compared to that associated with the pure dipolar-based models, $H _ { \mathrm { X Y Z } }$ or $H _ { \mathrm { s e c } }$ , as well as with $H _ { \mathrm { e x } }$ for $s = 1 / 2$ -particles. For example, spindependent contact interactions, directly related to the existence of spin-dependent scattering lengths (as discussed in Sec. VI A 3), also need to be taken into account. As for the bulk case, the description of the interaction and the different ground state phases becomes increasingly complicated with the spin length, even without dipolar interactions. Reference [776] studies the specific case of spin-1 atoms with antiferromagnetic interactions ( $a _ { 2 } > a _ { 0 }$ ) and shows a phase diagram similar to that obtained with spinless bosons, but with a polar superfluid phase and singlet to nematic phase transitions now present inside the insulating lobes. This spin-1 phase diagram was first experimentally investigated with sodium atoms [777], with negligible dipolar interactions.

Studying the interplay between spin-dependent contact interactions and dipolar interactions in a lattice setting is an extremely appealing prospect, in particular at large lattice depth where spin-exchange processes within a lattice site will result in a spin-dependent superexchange interaction between neighbouring sites. New spin-dependent terms, thereafter denoted as $H _ { \mathrm { s d } }$ , thus arise in the nearest-neighbour interaction in addition to $H _ { \mathrm { e x } }$ and $H _ { \mathrm { s e c } }$ . This results in a very complicated Hamiltonian which has now become experimentally available.

# 5. Magnetism as a function of lattice depth

In the presence of tunnelling, super-exchange processes $H _ { \mathrm { e x } }$ and $H _ { \mathrm { s d } }$ and dipolar interactions $H _ { \mathrm { s e c } }$ must all be taken into account. Interestingly, while the onsite interaction $U$ (possibly spin-dependent) increases with lattice depth, the tunnelling $t$ , and $H _ { \mathrm { e x } }$ and $H _ { \mathrm { s d } }$ decrease, while $H _ { \mathrm { s e c } }$ is more or less independent of lattice depth. By varying the lattice depth, it is thus possible to study the interplay between these different mechanisms. When the lattice depth is weak and tunnelling is allowed, magnetism is driven by the interplay between long-range dipolar interactions and short range physics. When the lattice is very deep and tunnelling if frozen, the arrangement of the atoms in the lattice is typically very regular due to the Mott insulator transition [8, 128, 635, 638, 719–721] (see also discussion in Sec. VII B), $H _ { \mathrm { e x } }$ and $H _ { \mathrm { s d } }$ vanish, and one can then revisit spin lattice models associated with the secular Hamiltonian.

Varying the lattice depth thus offers a unique and exotic situation to study the cross-over between quantum magnetism associated with Heisenberg-like Hamiltonian, the t-J model at intermediate lattice depths, where quantum magnetism and transport compete, and, at low lattice depth, spinor physics. The intermediate regime is especially enticing, as it represents a challenge for a realistic theoretical simulation. While most of the research on magnetic atoms has up to now focused on Bose systems [257, 778], dipolar Fermi gases are also available [264] and should be fascinating systems with which to study quantum magnetism, as tunnelling and spindynamics are expected to be strongly coupled and the atoms are under the strong influence of the Pauli exclusion principle.

# 6. Other experimental systems

Similar spin models can also be studied using either heteronuclear molecules [20, 21, 130, 779] or Rydberg atoms with electric dipoles [25, 131, 132, 780]. In these cases, the reduced collisional lifetime forbids working in the regime where tunnelling is significant. Important experimental results have recently been obtained for these systems exploring the physics of spin-lattice models for an assembly of effective spin- $1 / 2$ particles pinned in a periodic potential. One of the attractive features of these systems is that the relative strength of the exchange and Ising terms of the interaction can be experimentally controlled.

Furthermore, ions have become a prominent platform to study spin-lattice models [31, 781, 782]. In these ensembles of crystallised ions, an effective spin-spin interaction is mediated between the ions using phonons. These systems possess the unique possibility to vary the range of the effective interaction potential between the particles.

While these other systems are extremely promising and offer complementary paradigms of quantum magnetism, a few characteristics distinguish the prospects offered by highly magnetic atoms to date:

• Magnetic atoms uniquely realise large-spin systems, beyond the effective spin-1/2 case (see also Sec. VII C 4). • Up to now, systems of ions, Rydberg atoms and molecules remain limited in the size of the sample under studies or in their densities. While ultracold atoms offer many-body systems of several thousands or tens of thousands of atoms with lattice filling factors on the order of unity, Rydberg and ion assemblies are restricted to a few tens to hundred particles. This size limitation is particularly problematic for the case of long-range interacting systems, for which border and finite-size effects are important. Despite the tremendous progress made on molecular systems, the fillings achieved remain below 0.5 [41].

• Magnetic atoms primarily offer a competition between spin-spin interactions and tunnelling, as both terms can be allowed and tuned on the same scale. This enables the exploration of quantum magnetism when transport competes with spin-spin interactions, which is perhaps the most relevant regime from the point of view of quantum simulation.

# 7. Experimental status with magnetic atoms

The study of dipolar lattice systems has started with two complementary experiments performed with ultracold KRb molecules [130] and a BEC of Cr atoms [257]. For the experiments with KRb, an effective spin $1 / 2$ system is encoded in two rotational states of the vibrational ground state. NMR-like experiments have been performed which revealed the impact of inter-site pairwise dipolar interactions on the decay of the contrast of a molecular Ramsey interferometer. This experiment was performed in a rather dilute environment with a filling factor of typically 5 to 10 percent, and tunnelling was absent to prevent inelastic collisions when two molecules physically meet [130]. In a latter study, the experimental results were compared to a new theoretical model based on a cluster expansion technique, and an extremely good agreement was found [779].

In the Cr experiment [257], a BEC was loaded in a 3D optical lattice, which, at large lattice depth, led to the production of a Mott insulating state with a core with double occupancy and a shell with unit filling. Spin dynamics was studied after spin excitation in a well-defined state. The experiments revealed a non-equilibrium spinor dynamics resulting from inter-site Heisenberg-like spin-spin interactions provided by nonlocal DDI. While mean-field theories could not reproduce the experimental data, a model based on exact diagonalization techniques on a plaquette provided a good agreement with the experiment for short times. This showed the many-body character of spin dynamics, and the importance to take quantum correlations into account. For doubly occupied site, a complex spin dynamics was observed, involving both short-range interactions and intersite DDI. This experiment therefore showed the potential of lattice gases made of strongly magnetic atoms for the study of quantum magnetism of high-spin systems.

In a another set of experiments, the group in Villetaneuse also studied the impact of the lattice depth on spin dynamics [356, 783]. The experiment unveiled a smooth crossover from a complex oscillatory behaviour to an exponential behaviour of the spin populations throughout the Mott-to-superfluid transition, as shown in Fig. 41. The experiment provided data in the intermediate regime between superfluid and Mott insulating, where dipolar interactions, contact interactions, and superexchange mechanisms compete. In this strongly correlated regime, spin dynamics and transport are coupled, which constitutes a challenge for theoretical models of quantum magnetism. As exact modelling of the experimental dynamics exceeds the capabilities of classical computation, experimental results in [783] were compared to approximate models. The comparison between experimental data and theory demonstrated that the dynamics at low lattice depth is qualitatively reproduced by mean-field calculations based on the Gutzwiller ansatz. In this regime, it was found that transport and contact interactions both play an essential role in spin dynamics; on the contrary, only a beyond-mean-field theory could account for the dynamics at large lattice depths, which is then mostly driven by dipolar interactions [783].

The potential offered by magnetic atoms to study outof-equilibrium quantum magnetism was recently further demonstrated by two works that realised clean instances of the above-described XXZ Heisenberg model [264, 778]. The experimental systems were prepared in order to form large unit-filled arrays of magnetic atoms in deep lattices. An out-of-equilibrium dynamics, occurring under the pure effect of intersite DDI, was initiated by preparing the atomic assembly in a given spin state. In the first study [778], the first shell from a Mott insulator made of bosonic Cr was isolated and a spin excitation was performed by tilting the spins with respect to the magnetic field orientation (quantisation axis), yielding a coherent spin state. In the second study [264], a band insulator of fermionic $\mathrm { E r }$ was realised (ensuring single filling from Pauli exclusion principle) and the spin excitation was performed by fully transferring the population from the lowest $m = - F$ -state to an excited $m$ -state, thus forming a spin Fock state. In both studies, the dynamics was observed directly on the evolution of the $m$ -states populations. The effect of quantum correlations on the dynamics was demonstrated by discrepancies in the comparison with mean-field theories.

The good agreement with simulations based on a generalisation of the discrete truncated Wigner approximation [784] to the case of large spins, additionally proves the role of quantum correlation and shows that the spin dynamics leads to a growth of entanglement. In Ref. [778], this was characterised by a calculation of the Renyi entropy. Here, the role quantum correlations was observed to increase when the initial tilting angle with respect to the magnetic field approaches $\pi / 2$ . Experimentally, the isolated ensemble of atoms approaches an effective thermal equilibrium, in the spirit of the Eigenstate Thermalisation Hypothesis [785–787], in which the growth of entanglement conveys a thermal character to local observables.

By performing a Ramsey experiment and analysing the contrast of the interferometer as a function of time for the ensemble of unit-filled Cr atoms, it was also observed that, during spin dynamics, the collective spin length of the atoms decayed under the effect of dipole-dipole interactions, as was theoretically expected [775]. Interestingly, for a pure homogeneous system, the dynamical reduction of the collective spin length is a purely beyond mean-field effect. The results in [579] show that the decay of the spin length was slower than expected by a spin model of frozen particles, a finding that could not be previously deduced from the measurements on population dynamics. This illustrates how measurements of spin coherences provide valuable and complementary information on quantum many-body systems, and shows that further experiments as well as new observables are needed to fully characterise the growth of correlations in this system.

In Ref. [264], the rate of the spin dynamics was additionally tuned thanks to the two distinct knobs available to control the single-spin-state energies. The level spacing could thus be tuned to be equal, providing a resonant condition for the spin-exchange process of $H _ { \mathrm { s e c } }$ . The two control knobs are the light-shift induced by off-resonant laser beams (e.g., the one forming the optical lattice potential, see also Sec. II C) and the Zeeman effect induced by the bias magnetic field. While both effects also exist for bosonic Cr, the missing point lies in the existence of quadratic Zeeman shifts (induced by the hyperfine structure of the fermions) which can be tuned to compensate the quadratic light shifts in the case of fermionic $\mathrm { E r }$ . This exquisite control enables a thorough investigation of the secular Hamiltonian. The large quadratic light shifts can be additionally used for a fast (and potentially local) control of the spin dynamics. Reference [264] additionally studies the effect of the excited $m$ -state on the rate of the initial spin dynamics, deducing a universal scaling, independent on the detail of the initial preparation and probes the effect of tilting the quantization axis compared to the lattice geometries, providing first steps towards more generic lattice models.

These first experiments reveal that dipolar lattice gases provide a new arena with which to study an exotic quantum magnetism of large spin systems, driven by the competition of long-range and short-range interactions and of tunnelling. From the theoretical point of view, the full description of such a system in the presence of tunnelling (thus being analogous to the the t-J model of magnetism) is already a challenge. From the experimental point of view, a number of challenges remain ahead. Here, we only point a few of the challenges and perspectives for magnetic atoms:

• Impact of quantum statistics: Up to now, experiments were only performed with bosons or with fermions in the frozen regime. The study of fermions in presence of tunnelling would be extremely interesting, with an expected interplay between spin and motional dynamics, and the Pauli

![](images/246cb11fd6f60a93021089ec6f3e2517a8a1c73bae517b0fc046f2c916c43de8.jpg)  
FIG. 41: Spin dynamics of chromium atoms as a function of lattice depth, from [356]: (a) Simple representation of the system close to the Mott-to-superfluid transition. Atoms interact both due to intersite (white ellipse) and on-site (black ellipse) interactions. (b) Measurement of the spin components ( $m _ { s } = - 3$ to $m _ { s } = 1$ ) as a function of time for a lattice depth of $1 6 ~ \mathrm { E r }$ . (d) Time evolution the ratio between populations in $m _ { s }$ states -3 and -2, for four different lattice depths (27Er, 16Er, 11.5Er, and $3 \mathrm { E r }$ , from top to bottom). Lines are guides for the eye resulting from fits.

exclusion principle.

• Revealing the expected growth of entanglement in large spin systems: The use of entanglement witnesses is a possibility, although preliminary studies show that the extension of the existing witnesses to large spins is not straightforward nor favourable. Bipartite entanglement could also be revealed by in situ measurements of spin fluctuations.

• Magnetic phases: Up to now, only out-ofequilibrium experiments have been performed. The magnetic ground state close to zero temperature remains out of reach of our current technology, limited by a rather large entropy. However, the analysis of the equilibrium state reached after spin dynamics has occurred is also an interesting avenue for future research, which is readily accessible. For example, the nature of the equilibrium state, the presence of quantum correlations within it, and how it differs from a thermal state, are open questions. Likewise, the study of the nature of this quasi-equilibrium state as a function of the lattice filling factor, and as a function of entropy, is also a very interesting question related to many-body localisation.

# VIII. Perspectives

The present time is highly exciting for research based on magnetic atoms. Many substantial advances are being made at an impressively rapid pace. New experimental apparatus are coming online soon and promise to bring even more excitement. State-of-the-art techniques, recently implemented in other ultracold-atom experiments, will soon become available in lanthanide experiments. These promising to shed new light on the physics that has been revealed within the few last years. For example, single-atom ‘quantum gas’ microscopes are well-poised to reveal additional details regarding the strong correlations of the many-body states that have been observed both in bosonic and fermionic dipolar quantum gases as well as open the way to extend investigations of their far-from-equilibrium dynamics. Control on the singleatom level will also provide novel understanding, at the few-body level, of scattering phenomena in these complex lanthanide systems. Complete magnetic shielding will enable the exploration of the zero-field regime of spin physics. Exploiting the rich optical transition spectrum of the lanthanides will also provide novel capabilities for controlling spins and interactions more exquisitely. The prospect of realising topological quantum states is one of many central aims.

Highly versatile trap geometries will also play a role and provide new prospects for exploring the interplay between the anisotropic and long-range character of the DDI and the geometry of the system. Other ingredients, such as disorder and frustration could also be added to the systems. The mixture of different magnetic and nonmagnetic species will reveal new physics, and in particular, could provide access to dipolar physics with an internal degree of freedom and distinct dipolar moments but without dipolar relaxation. Mass imbalance effects could also be explored. This opens new avenues toward exotic few-body as well as many-body phenomena, including Efimov states, $p$ -wave superfluidity, and other exotic states of matter. One cannot capture all the possible new directions enabled by highly magnetic atoms, but undoubtedly, brand-new physics will arrive in the next years, and we hope for new surprises to match those this review has presented.

# Acknowledgements

All the authors would like to warmly thank their countless collaborators over the years, both from the experiment and for the theory sides. They were all crucial actors to the discoveries summarised in this review. Additionally, we are grateful to Steven Lepoutre, Fabian Boettcher, Wil Kao, and Kuan-Yu Li for their careful reading of the manuscript. L.C., I.F.B., F.F., and T.P. acknowledge the support from the international collaborative network on dipolar quantum gases funded by the DFG and FWF - FOR 2247/PI2790.

F.F., B.L.T., and T.P. acknowledge support through the QuantERA grant MAQS. L.C. acknowledges support by the Deutsche Forschungsgemeinschaft (DFG, German Research Foundation) under Germany’s Excellence Strategy EXC 2181/1-390900948 (the Heidelberg STRUCTURES Excellence Cluster) and Project-ID No. 273811115 (SFB1225 ISOQUANT). B.L.T acknowledges support from CNRS, Conseil Régional d’Ile-de-France under SIRTEQ Agency, and Agence Nationale de la Recherche (Project No. ANR-18-CE47-0004). B.L.L. acknowledges support from the NSF and AFOSR. T.P acknowledges support from the European Research Council (ERC) (Grant agreement No. 101019739).

[1] M. H. Anderson, J. R. Ensher, M. R. Matthews, C. E. Wieman, and E. A. Cornell, Science 269, 198 (1995).   
[2] K. B. Davis, M. O. Mewes, M. R. Andrews, N. J. van Druten, D. S. Durfee, D. M. Kurn, and W. Ketterle, Phys. Rev. Lett. 75, 3969 (1995).   
[3] C. C. Bradley, C. A. Sackett, and R. G. Hulet, Phys. Rev. Lett. 78, 985 (1997). [4] B. DeMarco and D. S. Jin, Science 285, 1703 (1999).   
[5] F. Schreck, L. Khaykovich, K. L. Corwin, G. Ferrari, T. Bourdel, J. Cubizolles, and C. Salomon, Phys. Rev. Lett. 87, 080403 (2001).   
[6] A. G. Truscott, K. E. Strecker, W. I. McAlexander, G. B. Partridge, and R. G. Hulet, Science 291, 2570 (2001). [7] I. Bloch, J. Dalibard, and W. Zwerger, Rev. Mod. Phys. 80, 885 (2008).   
[8] I. Bloch, J. Dalibard, and S. Nascimbène, Nat. Phys. 8, 267 (2012). [9] L. Pitaevskii and S. Stringari, Bose-Einstein condensation and superfluidity, Vol. 164 (Oxford University Press, 2016).   
[10] C. J. Pethick and H. Smith, Bose-Einstein condensation in dilute gases (Cambridge University Press, 2002).   
[11] S. Stringari and L. Pitaevskii, Bose-Einstein condensation and superfluidity (Oxford Science Publications, Oxford, 2016).   
[12] K. Goral, K. Rzazewski, and T. Pfau, Phys. Rev. A 61, 051601 (2000).   
[13] M. Marinescu and L. You, Phys. Rev. Lett. 81, 4596 (1998).   
[14] M. Baranov, M. Dalmonte, G. Pupillo, and P. Zoller, Chemical Reviews 112, 5012 (2012).   
[15] M. Baranov, L. Dobrek, K. Góral, L. Santos, and M. Lewenstein, Physica Scripta T102, 74 (2002).   
[16] M. A. Baranov, Physics Reports 464, 71 (2008).   
[17] T. Lahaye, C. Menotti, L. Santos, M. Lewenstein, and T. Pfau, Reports on Progress in Physics 72, 126401 (2009).   
[18] N. Defenu, T. Donner, T. Macrì, G. Pagano, S. Ruffo, and A. Trombettoni, arXiv preprint arXiv:2109.01063 (2021).   
[19] L. D. Carr, D. DeMille, R. V. Krems, and J. Ye, New J. Phys. 11, 055049 (2009).   
[20] J. L. Bohn, A. M. Rey, and J. Ye, Science 357, 1002 (2017), http://science.sciencemag.org/content/357/6355/1002.f   
[21] S. A. Moses, J. P. Covey, M. T. Miecnikowski, D. S. Jin, and J. Ye, Nature Physics 13, 13 (2017).   
[22] M. Saffman, T. G. Walker, and K. Mølmer, Rev. Mod. Phys. 82, 2313 (2010).   
[23] R. Löw, H. Weimer, J. Nipper, J. B. Balewski, B. Butscher, H. P. Büchler, and T. Pfau, Journal of Physics B: Atomic, Molecular and Optical Physics 45, 113001 (2012).   
[24] H. Labuhn, D. Barredo, S. Ravets, S. De Léséleuc, T. Macrì, T. Lahaye, and A. Browaeys, Nature 534, 667 (2016).   
[25] H. Bernien, S. Schwartz, A. Keesling, H. Levine, A. Omran, H. Pichler, S. Choi, A. S. Zibrov, M. Endres, M. Greiner, V. Vuletić, and M. D. Lukin, Nature 551, 579 (2017).   
[26] H. Ritsch, P. Domokos, F. Brennecke, and T. Esslinger, Rev. Mod. Phys. 85, 553 (2013).   
[27] F. Mivehvar, F. Piazza, T. Donner, and H. Ritsch, Advances in Physics 70, 1 (2021), https://doi.org/10.1080/00018732.2021.1969727.   
[28] S. Gopalakrishnan, B. L. Lev, and P. M. Goldbart, Nature Physics 5, 845 (2009).   
[29] J. S. Douglas, H. Habibian, C.-L. Hung, A. Gorshkov, H. J. Kimble, and D. E. Chang, Nature Photonics 9, 326 (2015).   
[30] V. D. Vaidya, Y. Guo, R. M. Kroeze, K. E. Ballantine, A. J. Kollár, J. Keeling, and B. L. Lev, Phys. Rev. X 8, 011002 (2018).   
[31] R. Blatt and C. F. Roos, Nature Physics 8, 277 (2012).   
[32] M. L. Wall, K. Maeda, and L. D. Carr, Annalen der Physik 525, 845 (2013).   
[33] W. Li, T. Pohl, J. M. Rost, S. T. Rittenhouse, H. R. Sadeghpour, J. Nipper, B. Butscher, J. B. Balewski, V. Bendkowsky, R. Löw, and T. Pfau, Science 334, 1110 (2011), http://science.sciencemag.org/content/334/6059/1110.full.pdf.   
[34] E. A. Goldschmidt, T. Boulier, R. C. Brown, S. B. Koller, J. T. Young, A. V. Gorshkov, S. L. Rolston, and J. V. Porto, Phys. Rev. Lett. 116, 113001 (2016).   
[35] P. Schauß, M. Cheneau, M. Endres, T. Fukuhara, S. Hild, A. Omran, T. Pohl, C. Gross, S. Kuhr, and I. Bloch, Nature 491, 87 (2012).   
[36] P. Schauß, J. Zeiher, T. Fukuhara, S. Hild, M. Cheneau, T. Macrì, T. Pohl, I. Bloch, and C. Groß, Science 347, 1455 (2015).   
[37] P. Scholl, M. Schuler, H. J. Williams, A. A. Eberharter, D. Barredo, K.-N. Schymik, V. Lienhard, L.-P. Henry, T. C. Lang, T. Lahaye, A. M. Läuchli, and A. Browaeys, Nature 595, 233 (2021).   
[38] S. Ebadi, T. T. Wang, H. Levine, A. Keesling, G. Semeghini, A. Omran, D. Bluvstein, R. Samajdar,   
df. H. Pichler, W. W. Ho, S. Choi, S. Sachdev, M. Greiner, V. Vuletić, and M. D. Lukin, Nature 595, 227 (2021).   
[39] A. Browaeys and T. Lahaye, Nature Physics 16, 132 (2020).   
[40] S. Ospelkaus, K.-K. Ni, G. Quéméner, B. Neyenhuis, D. Wang, M. H. G. de Miranda, J. L. Bohn, J. Ye, and D. S. Jin, Phys. Rev. Lett. 104, 030402 (2010).   
[41] S. A. Moses, J. P. Covey, M. T. Miecnikowski, B. Yan, B. Gadway, J. Ye, and D. S. Jin, Science 350, 659 (2015).   
[42] L. De Marco, G. Valtolina, K. Matsuda, W. G. Tobias, J. P. Covey, and J. Ye, Science 363, 853 (2019), https://science.sciencemag.org/content/363/6429/853.fu   
[43] G. Valtolina, K. Matsuda, W. G. Tobias, J.-R. Li, L. De Marco, and J. Ye, Nature 588, 239 (2020).   
[44] J. W. Park, S. A. Will, and M. W. Zwierlein, Phys. Rev. Lett. 114, 205302 (2015).   
[45] S. A. Will, J. W. Park, Z. Z. Yan, H. Loh, and M. W. Zwierlein, Phys. Rev. Lett. 116, 225306 (2016).   
[46] K. K. Voges, P. Gersema, M. Meyer zum Alten Borgloh, T. A. Schulze, T. Hartmann, A. Zenesini, and S. Ospelkaus, Phys. Rev. Lett. 125, 083401 (2020).   
[47] T. Takekoshi, M. Debatin, R. Rameshan, F. Ferlaino, R. Grimm, H.-C. Nägerl, C. R. Le Sueur, J. M. Hutson, P. S. Julienne, S. Kotochigova, and E. Tiemann, Phys. Rev. A 85, 032506 (2012).   
[48] P. K. Molony, P. D. Gregory, Z. Ji, B. Lu, M. P. Köppinger, C. R. Le Sueur, C. L. Blackley, J. M. Hutson, and S. L. Cornish, Phys. Rev. Lett. 113, 255301 (2014).   
[49] M. Guo, B. Zhu, B. Lu, X. Ye, F. Wang, R. Vexiau, N. Bouloufa-Maafa, G. Quéméner, O. Dulieu, and D. Wang, Phys. Rev. Lett. 116, 205303 (2016).   
[50] M. Gröbner, P. Weinmann, F. Meinert, K. Lauber, E. Kirilov, and H.-C. Nägerl, Journal of Modern Optics 63, 1829 (2016), http://dx.doi.org/10.1080/09500340.2016.1143051.   
[51] J. Deiglmayr, A. Grochola, M. Repp, K. Mörtlbauer, C. Glück, J. Lange, O. Dulieu, R. Wester, and M. Weidemüller, Phys. Rev. Lett. 101, 133004 (2008).   
[52] T. M. Rvachov, H. Son, A. T. Sommer, S. Ebadi, J. J. Park, M. W. Zwierlein, W. Ketterle, and A. O. Jamison, Phys. Rev. Lett. 119, 143001 (2017).   
[53] H. Son, J. J. Park, W. Ketterle, and A. O. Jamison, Nature 580, 197 (2020).   
[54] J. Barry, D. McCarron, E. Norrgard, M. Steinecker, and D. DeMille, Nature 512, 286 (2014).   
[55] E. B. Norrgard, D. J. McCarron, M. H. Steinecker, M. R. Tarbutt, and D. DeMille, Phys. Rev. Lett. 116, 063004 (2016).   
[56] A. Prehn, M. Ibrügger, R. Glöckner, G. Rempe, and M. Zeppenfeld, Phys. Rev. Lett. 116, 063005 (2016).   
[57] L. Anderegg, B. L. Augenbraun, E. Chae, B. Hemmerling, N. R. Hutzler, A. Ravi, A. Collopy, J. Ye, W. Ketterle, and J. M. Doyle, Phys. Rev. Lett. 119, 103201 (2017).   
[58] S. Truppe, H. Williams, M. Hambach, L. Caldwell, N. Fitch, E. Hinds, B. Sauer, and M. Tarbutt, Nature Physics 13, 1173 (2017).   
[59] R. Albrecht, M. Scharwaechter, T. Sixt, L. Hofer, and T. Langen, Phys. Rev. A 101, 013413 (2020).   
[60] A. L. Collopy, S. Ding, Y. Wu, I. A. Finneran, L. Anderegg, B. L. Augenbraun, J. M. Doyle, and J. Ye, Phys. Rev. Lett. 121, 213201 (2018).   
[61] S. Ding, Y. Wu, I. A. Finneran, J. J. Burau, and J. Ye, Phys. Rev. X 10, 021049 (2020).   
[62] B. K. Stuhl, M. T. Hummon, M. Yeo, G. Quéméner, J. L. Bohn, and J. Ye, Nature (London) 492, 396 (2012), arXiv:1209.6343 [physics.atom-ph].   
[63] D. Reens, H. Wu, T. Langen, and J. Ye, Phys. Rev. A 96, 063420 (2017).   
[64] P. S. Żuchowski and J. M. Hutson, Phys. Rev. A 81, 060703(R) (2010).   
[65] M. Mayle, G. Quéméner, B. P. Ruzic, and J. L. Bohn,   
df. Phys. Rev. A 87, 012709 (2013).   
[66] M. De Miranda, A. Chotia, B. Neyenhuis, D. Wang, G. Quéméner, S. Ospelkaus, J. Bohn, J. Ye, and D. Jin, Nature Physics 7, 502 (2011).   
[67] A. Chotia, B. Neyenhuis, S. A. Moses, B. Yan, J. P. Covey, M. Foss-Feig, A. M. Rey, D. S. Jin, and J. Ye, Phys. Rev. Lett. 108, 080405 (2012).   
[68] L. R. Liu, J. D. Hood, Y. Yu, J. T. Zhang, K. Wang, Y.- W. Lin, T. Rosenband, and K.-K. Ni, Physical Review X 9, 021039 (2019).   
[69] L. Anderegg, L. W. Cheuk, Y. Bao, S. Burchesky, W. Ketterle, K.-K. Ni, and J. M. Doyle, Science 365, 1156 (2019).   
[70] Searches for a permanent electric dipole moment (EDM) of elementary particles are ongoing [788]; in particular, the search for the electron EDM is underway in several AMO systems. See, e.g., Ref. [789].   
[71] For example, remarkable phenomena have indeed been observed in the case of a lattice interferometer of K [419] and in the context of spinor physics with Rb atoms [570, 571]).   
[72] D. Sukachev, A. Sokolov, K. Chebakov, A. Akimov, S. Kanorsky, N. Kolachevsky, and V. Sorokin, Phys. Rev. A 82, 011405 (2010).   
[73] J. Miao, J. Hostetter, G. Stratis, and M. Saffman, Phys. Rev. A 89, 041401 (2014).   
[74] R. Inoue, Y. Miyazawa, and M. Kozuma, Phys. Rev. A 97, 061607 (2018).   
[75] E. T. Davletov, V. V. Tsyganok, V. A. Khlebnikov, D. A. Pershin, D. V. Shaykin, and A. V. Akimov, Phys. Rev. A 102, 011302 (2020).   
[76] A. Frisch, M. Mark, K. Aikawa, S. Baier, R. Grimm, A. Petrov, S. Kotochigova, G. Quéméner, M. Lepers, O. Dulieu, and F. Ferlaino, Phys. Rev. Lett. 115, 203201 (2015).   
[77] T. Maier, I. Ferrier-Barbut, H. Kadau, M. Schmitt, M. Wenzel, C. Wink, T. Pfau, K. Jachymski, and P. S. Julienne, Phys. Rev. A 92, 060702 (2015).   
[78] Interestingly, however, lanthanide atoms exhibit anisotropic van der Waals interactions; see Sec. II.   
[79] J. Dalibard, in Proceedings of the International School of Physics-Enrico Fermi, Vol. 321 (1999) p. 14.   
[80] L. D. Landau and E. M. Lifshitz, Quantum Mechanics, vol. 3 (Course of theoretical physics) (ButterworthHeinemann, Oxford, 1977).   
[81] E. Arimondo, M. Inguscio, and P. Violino, Rev. Mod. Phys. 49, 31 (1977).   
[82] Z. Hadzibabic and J. Dalibard, arXiv preprint arXiv:0912.1490 (2009).   
[83] D. Peter, S. Müller, S. Wessel, and H. P. Büchler, Phys. Rev. Lett. 109, 025303 (2012).   
[84] S. Giovanazzi, A. Görlitz, and T. Pfau, Phys. Rev. Lett. 89, 130401 (2002).   
[85] Y. Tang, W. Kao, K.-Y. Li, and B. L. Lev, Phys. Rev. Lett. 120, 230401 (2018).   
[86] S. Hensler, J. Werner, A. Griesmaier, P. Schmidt, A. Görlitz, T. Pfau, and K. Giovanazzi, S.and Rzaqlri lied Ph   
[87] The factor of 3 defining $a _ { \mathrm { d d } }$ comes from a normalisation imposed for the convenient discussion of the many-body physics of dipolar gases; see Eq. (12) below.   
[88] N. Bogoliubov, J. Phys 11, 23 (1947).   
[89] E. P. Gross, Il Nuovo Cimento (1955-1965) 20, 454 (1961).   
[90] L. Pitaevskii, Sov. Phys. JETP 13, 451 (1961).   
[91] K. Huang and C. N. Yang, Phys. Rev. 105, 767 (1957).   
[92] S. Yi and L. You, Phys. Rev. A 61, 041604 (2000).   
[93] S. Yi and L. You, Phys. Rev. A 63, 053607 (2001).   
[94] Y. Kawaguchi and M. Ueda, Physics Reports 520, 253 (2012), spinor Bose– Einstein condensates.   
[95] D. M. Stamper-Kurn and M. Ueda, Rev. Mod. Phys. 85, 1191 (2013).   
[96] S. Ronen, D. C. E. Bortolotti, and J. L. Bohn, Phys. Rev. A 74, 013623 (2006).   
[97] K. Góral and L. Santos, Phys. Rev. A 66, 023613 (2002).   
[98] D. H. J. O’Dell, S. Giovanazzi, and G. Kurizki, Phys. Rev. Lett. 90, 110402 (2003).   
[99] L. Santos, G. V. Shlyapnikov, and M. Lewenstein, Phys. Rev. Lett. 90, 250403 (2003).   
[100] S. Giovanazzi and D. H. O’Dell, The European Physical Journal D-Atomic, Molecular, Optical and Plasma Physics 31, 439 (2004).   
[101] L. D. Landau, J. Phys. (Moscow) 5, 71 (1941).   
[102] L. D. Landau, J. Phys. (Moscow) 11, 91 (1947).   
[103] D. G. Henshaw and A. D. B. Woods, Phys. Rev. 121, 1266 (1961).   
[104] R. J. Dodd, M. Edwards, C. J. Williams, C. W. Clark, M. J. Holland, P. A. Ruprecht, and K. Burnett, Phys. Rev. A 54, 661 (1996).   
[105] C. A. Sackett, H. T. C. Stoof, and R. G. Hulet, Phys. Rev. Lett. 80, 2031 (1998).   
[106] J. L. Roberts, N. R. Claussen, S. L. Cornish, E. A. Donley, E. A. Cornell, and C. E. Wieman, Phys. Rev. Lett. 86, 4211 (2001).   
[107] C. Ticknor, N. G. Parker, A. Melatos, S. L. Cornish, D. H. J. O’Dell, and A. M. Martin, Phys. Rev. A 78, 061607 (2008).   
[108] E. A. Donley, N. R. Clausen, S. L. Cornish, J. L. Roberts, E. A. Cornell, and C. E. Wieman, Nature (London) 412, 295 (2001).   
[109] J. M. Gerton, D. Strekalov, I. Prodan, and R. G. Hulet, Nature 408, 692 (2000).   
[110] Y. Kagan, A. E. Muryshev, and G. V. Shlyapnikov, Phys. Rev. Lett. 81, 933 (1998).   
[111] M. Ueda and A. J. Leggett, Phys. Rev. Lett. 80, 1576 (1998).   
[112] M. Houbiers and H. T. C. Stoof, Phys. Rev. A 54, 5055 (1996).   
[113] S. Ronen, D. Bortolotti, and J. L. Bohn, Phys. Rev. Lett. 98, 030406 (2007).   
[114] J. L. Bohn, R. M. Wilson, and S. Ronen, Laser Physics 19, 547 (2009).   
[115] N. G. Parker, C. Ticknor, A. M. Martin, and D. H. J. O’Dell, Phys. Rev. A 79, 013617 (2009).   
[116] T. D. Lee, K. Huang, and C. N. Yang, Phys. Rev. 106, 1135 (1957).   
[117] T. D. Lee and C. N. Yang, Phys. Rev. 105, 1119 (1957).   
[118] N. W. Ashcroft and N. D. Mermin, Solid state physics (Saunders College Publishing, 1976) p. 826.   
[119] K. Góral, B.-G. Englert, and K. Rza¸żewski, Phys. Rev. A 63, 033606 (2001).   
[120] J.-N. Zhang and S. Yi, Phys. Rev. A 80, 053614 (2009).   
[121] J.-N. Zhang and S. Yi, Phys. Rev. A 81, 033617 (2010).   
[122] D. Baillie and P. B. Blakie, Phys. Rev. A 82, 033605 (2010).   
[123] D. Baillie and P. B. Blakie, Phys. Rev. A 86, 023605 (2012).   
[124] F. Wächtler, A. R. P. Lima, and A. Pelster, Phys. Rev. A 96, 043608 (2017).   
[125] N. D. Mermin and H. Wagner, Phys. Rev. Lett. 17, 1133 (1966).   
[126] P. C. Hohenberg, Phys. Rev. 158, 383 (1967).   
[127] T. Giamarchi, Quantum Physics in One Dimension, International Series of Monographs on Physics (Clarendon Press, 2003).   
[128] I. Bloch, Nature (London) 453, 1016 (2008).   
[129] M. Lewenstein, A. Sanpera, V. Ahufinger, B. Damski, A. Sen, and U. Sen, Adv. Phys. 56, 243 (2007).   
[130] B. Yan, S. A. Moses, B. Gadway, J. P. Covey, K. R. A. Hazzard, A. M. Rey, D. S. Jin, and J. Ye, Nature 501, 521 (2013).   
[131] D. Barredo, S. de Léséleuc, V. Lienhard, T. Lahaye, and A. Browaeys, Science 354, 1021 (2016).   
[132] M. Endres, H. Bernien, A. Keesling, H. Levine, E. R. Anschuetz, A. Krajenbrink, C. Senko, V. Vuletić, M. Greiner, and M. D. Lukin, Science 354, 1024 (2016).   
[133] D. Barredo, V. Lienhard, S. De Leseleuc, T. Lahaye, and A. Browaeys, Nature 561, 79 (2018).   
[134] L. Tonks, Phys. Rev. 50, 955 (1936).   
[135] M. Girardeau, J. Math. Phys. 1, 516 (1960).   
[136] E. H. Lieb and W. Liniger, Phys. Rev. 130, 1605 (1963).   
[137] S. Sinha and L. Santos, Phys. Rev. Lett. 99, 140406 (2007).   
[138] F. Deuretzbacher, J. C. Cremon, and S. M. Reimann, Physical Review A 81, 063616 (2010).   
[139] F. Deuretzbacher, J. C. Cremon, and S. M. Reimann, Physical Review A 87, 039903 (2013).   
[140] V. A. Yurovsky, M. Olshanii, and D. S. Weiss (Elsevier, 2008) pp. 61–138.   
[141] Y. Tang, W. Kao, K.-Y. Li, S. Seo, K. Mallayya, M. Rigol, S. Gopalakrishnan, and B. L. Lev, Phys. Rev. X 8, 021030 (2018).   
[142] G. E. Astrakharchik, J. Boronat, J. Casulleras, and S. Giorgini, Phys. Rev. Lett. 95, 190407 (2005).   
[143] E. Haller, M. Gustavsson, M. J. Mark, J. G. Danzl, R. Hart, G. Pupillo, and H. C. Nägerl, Science 325, 1224 (2009).   
[144] W. Kao, K.-Y. Li, K.-Y. Lin, S. Gopalakrishnan, and B. L. Lev, Science 371, 296–300 (2021).   
[145] M. Serbyn, D. A. Abanin, and Z. Papić, Nature Physics 17, 675 (2021).   
[146] S. De Palo, R. Citro, and E. Orignac, Phys. Rev. B 101, 045102 (2020).   
[147] O. Dutta, M. Gajda, P. Hauke, M. Lewenstein, D.-S. Lühmann, B. A. Malomed, T. Sowiński, and J. Zakrzewski, Reports on Progress in Physics 78, 066001 (2015).   
[148] V. Galitski and I. B. Spielman, Nature 494, 49 (2013).   
[149] M. Sato, Y. Takahashi, and S. Fujimoto, Phys. Rev. Lett. 103, 020401[1 (2009).   
[150] L. Jiang, T. Kitagawa, J. Alicea, A. R. Akhmerov, D. Pekker, G. Refael, J. I. Cirac, E. Demler, M. D. Lukin, and P. Zoller, Phys. Rev. Lett. 106, 220402[1 (2011).   
[151] S.-L. Zhu, L.-B. Shao, Z. D. Wang, and L.-M. Duan, Phys. Rev. Lett. 106, 100404 (2011).   
[152] J. Alicea, Rep. Prog. Phys. 75, 076501[1 (2012).   
[153] J. Ruhman, E. Berg, and E. Altman, Phys. Rev. Lett. 114, 100401[1 (2015).   
[154] S. Nascimbene, J. Phys. B: At. Mol. Opt. Phys. 46, 134005[1 (2013).   
[155] A. Celi, P. Massignan, J. Ruseckas, N. Goldman, I. B. Spielman, G. Juzeli¯unas, and M. Lewenstein, Phys. Rev. Lett. 112, 043001[1 (2014).   
[156] M. Kitagawa and M. Ueda, Phys. Rev. A 47, 5138 (1993).   
[157] B. Lian, T.-L. Ho, and H. Zhai, Phys. Rev. A 85, 051606 (2012).   
[158] X. Cui, B. Lian, T. Ho, B. L. Lev, and H. Zhai, Phys. Rev. A 88, 011601[1 (2013).   
[159] T.-L. Ho and B. Huang, Phys. Rev. A 91, 043601[1 (2015).   
[160] N. Goldman, G. Juzeli¯unas, P. Öhberg, and I. B. Spielman, Rep. Prog. Phys. 77, 126401[1 (2014).   
[161] J. Dalibard, in Proceedings of the International School of Physics “Enrico Fermi”, Vol. Volume 191: Quantum Matter at Ultralow Temperatures, edited by M. Inguscio, W. Ketterle, S. Stringari, and G. Roati (IOS, Amsterdam; SIF, Bologna, 2016) pp. 1 – 61.   
[162] B. Pasquiou, G. Bismut, Q. Beaufils, A. Crubellier, E. Maréchal, P. Pedri, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. A 81, 042716 (2010).   
[163] B. Pasquiou, G. Bismut, E. Maréchal, P. Pedri, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. Lett. 106, 015301 (2011).   
[164] A. de Paz, A. Chotia, E. Maréchal, P. Pedri, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. A 87, 051609 (2013).   
[165] N. Q. Burdick, K. Baumann, Y. Tang, M. Lu, and B. L. Lev, Phys. Rev. Lett. 114, 023201 (2015).   
[166] N. Q. Burdick, A. G. Sykes, Y. Tang, and B. L. Lev, New J. Phys. 18, 113004 (2016).   
[167] A. Griesmaier, J. Werner, S. Hensler, J. Stuhler, and T. Pfau, Phys. Rev. Lett. 94, 160401 (2005).   
[168] Q. Beaufils, R. Chicireanu, T. Zanon, B. LaburtheTolra, E. Maréchal, L. Vernac, J.-C. Keller, and O. Gorceix, Phys. Rev. A 77, 061601 (2008).   
[169] J. J. McClelland and J. L. Hanssen, Phys. Rev. Lett. 96, 143005 (2006).   
[170] M. Lu, S. H. Youn, and B. L. Lev, Phys. Rev. Lett. 104, 063001 (2010).   
[171] M. Lu, N. Q. Burdick, S. H. Youn, and B. L. Lev, Phys. Rev. Lett. 107, 190401 (2011).   
[172] M. Lu, N. Q. Burdick, and B. L. Lev, Phys. Rev. Lett. 108, 215301 (2012).   
[173] K. Aikawa, A. Frisch, M. Mark, S. Baier, A. Rietzler, R. Grimm, and F. Ferlaino, Phys. Rev. Lett. 108, 210401 (2012).   
[174] K. Aikawa, A. Frisch, M. Mark, S. Baier, R. Grimm, and F. Ferlaino, Phys. Rev. Lett. 112, 010404 (2014).   
[175] B. Naylor, A. Reigue, E. Maréchal, O. Gorceix, B. Laburthe-Tolra, and L. Vernac, Phys. Rev. A 91, 011603 (2015).   
[176] D. Dreon, L. A. Sidorenkov, C. Bouazza, W. Maineult, J. Dalibard, and S. Nascimbene, Journal of Physics B: Atomic, Molecular and Optical P   
[177] C. Ravensbergen, V. Corre, E. Soave, M. Kreyer, S. Tzanova, E. Kirilov, and R. Grimm, Phys. Rev. Lett. 120, 223001 (2018).   
[178] P. Ilzhöfer, G. Durastante, A. Patscheider, A. Trautmann, M. J. Mark, and F. Ferlaino, Phys. Rev. A 97, 023633 (2018).   
[179] I. S. Cojocaru, S. V. Pyatchenkov, S. A. Snigirev, I. A. Luchnikov, E. S. Kalganova, G. A. Vishnyakova, D. N. Kublikova, V. S. Bushmakin, E. T. Davletov, V. V. Tsyganok, O. V. Belyaeva, A. Khoroshilov, V. N. Sorokin, D. D. Sukachev, and A. V. Akimov, Phys. Rev. A 95, 012706 (2017).   
[180] V. V. Tsyganok, V. A. Khlebnikov, E. S. Kalganova, D. A. Pershin, E. T. Davletov, I. S. Cojocaru, I. A. Luchnikov, A. V. Berezutskii, V. S. Bushmakin, V. N. Sorokin, and A. V. Akimov, Journal of Physics B: Atomic, Molecular and Optical P   
[181] T. Chalopin, C. Bouazza, A. Evrard, V. Makhalov, D. Dreon, J. Dalibard, L. A. Sidorenkov, and S. Nascimbene, Nature communications 9, 4955 (2018).   
[182] A. Evrard, V. Makhalov, T. Chalopin, L. A. Sidorenkov, J. Dalibard, R. Lopes, and S. Nascimbene, Phys. Rev. Lett. 122, 173601 (2019).   
[183] B. Seo, P. Chen, Z. Chen, W. Yuan, M. Huang, S. Du, and G.-B. Jo, Phys. Rev. A 102, 013319 (2020).   
[184] W. Lunden, L. Du, M. Cantara, P. Barral, A. O. Jamison, and W. Ketterle, Phys. Rev. A 101, 063403 (2020).   
[185] H. Kadau, M. Schmitt, M. Wenzel, C. Wink, T. Maier, I. Ferrier-Barbut, and T. Pfau, Nature 530, 194 (2016).   
[186] J. Ulitzsch, D. Babik, R. Roell, and M. Weitz, Phys. Rev. A 95, 043614 (2017).   
[187] E. Lucioni, L. Tanzi, A. Fregosi, J. Catani, S. Gozzini, M. Inguscio, A. Fioretti, C. Gabbanini, and G. Modugno, Phys. Rev. A 97, 060701 (2018).   
[188] A. Trautmann, P. Ilzhöfer, G. Durastante, C. Politi, M. Sohmen, M. J. Mark, and F. Ferlaino, Phys. Rev. Lett. 121, 213601 (2018).   
[189] C. Ravensbergen, V. Corre, E. Soave, M. Kreyer, E. Kirilov, and R. Grimm, Phys. Rev. A 98, 063624 (2018).   
[190] L. Tanzi, E. Lucioni, F. Famà, J. Catani, A. Fioretti, C. Gabbanini, R. N. Bisset, L. Santos, and G. Modugno, Phys. Rev. Lett. 122, 130405 (2019).   
[191] L. Tanzi, S. Roccuzzo, E. Lucioni, F. Famà, A. Fioretti, C. Gabbanini, G. Modugno, A. Recati, and S. Stringari, Nature 574, 382 (2019).   
[192] G. A. Phelps, A. Hébert, A. Krahn, S. Dickerson, F. Öztürk, S. Ebadi, L. Su, and M. Greiner, arXiv preprint arXiv:2007.10807 (2020).   
[193] C. Cohen-Tannoudji and D. Guéry-Odelin, Advances in Atomic Physics: An Overview (World Scientific, 2011).   
[194] B. K. Newman, N. Brahms, Y. S. Au, C. Johnson, C. B. Connolly, J. M. Doyle, D. Kleppner, and T. J. Greytak, Phys. Rev. A 83, 012713 (2011).   
[195] C. B. Connolly, Y. S. Au, S. C. Doret, W. Ketterle, and J. M. Doyle, Phys. Rev. A 81, 010702 (2010).   
[196] J. Werner, A. Griesmaier, S. Hensler, J. Stuhler, T. Pfau, A. Simoni, and E. Tiesinga, Phys. Rev. Lett. 94, 183201 (2005).   
[197] A. de Paz, B. Naylor, J. Huckans, A. Carrance, O. Gorceix, E. Maréchal, P. Pedri, B. Laburthe-Tolra, and L. Vernac, Phys. Rev. A 90, 043607 (2014).   
[198] C. C. Bradley, J. J. McClelland, W. R. Anderson, and   
ics 50, 065005 (2017).R. J. Celotta, Phys. Rev. A 61, 053407 (2000).   
[199] M. K. Oberthaler and T. Pfau, Journal of Physics: Condensed Matter 15, R233 (2003).   
[200] R. Chicireanu, A. Pouderous, R. Barbé, B. LaburtheTolra, E. Maréchal, L. Vernac, J.-C. Keller, and O. Gorceix, Phys. Rev. A 73, 053406 (2006).   
[201] V. V. Volchkov, J. Rührig, T. Pfau, and A. Griesmaier, Phys. Rev. A 89, 043417 (2014).   
[202] P. S. Julienne and J. Vigué, Phys. Rev. A 44, 4464 (1991).   
[203] P. O. Schmidt, S. Hensler, J. Werner, T. Binhammer, A. Görlitz, and T. Pfau, Journal of Optics B: Quantum and Semiclassical Optics   
[204] J. Stuhler, P. O. Schmidt, S. Hensler, J. Werner, J. Mlynek, and T. Pfau, Phys. Rev. A 64, 031405(R) (2001).   
[205] Y. Takasu, K. Maki, K. Komori, T. Takano, K. Honda, M. Kumakura, T. Yabuzaki, and Y. Takahashi, Phys. Rev. Lett. 91, 040404 (2003).   
[206] A. Petrov, E. Tiesinga, and S. Kotochigova, Phys. Rev. Lett. 109, 103002 (2012).   
[207] S. Kotochigova, Reports on Progress in Physics 77, 0939   
[208] M. Li, E. Tiesinga, and S. Kotochigova, Phys. Rev. A 97, 053627 (2018).   
[209] R. V. Krems, G. C. Groenenboom, and A. Dalgarno, J. Phys. Chem. A 108, 8941 (2004).   
[210] S. Kotochigova and A. Petrov, Phys. Chem. Chem. Phys. 13, 19165 (2011).   
[211] X. Chu, A. Dalgarno, and G. C. Groenenboom, Phys. Rev. A 75, 032723 (2007).   
[212] V. A. Dzuba, V. V. Flambaum, and B. L. Lev, Phys. Rev. A 83, 032502 (2011).   
[213] M. Lepers, J.-F. Wyart, and O. Dulieu, Phys. Rev. A 89, 022505 (2014).   
[214] H. Li, J. F. Wyart, O. Dulieu, S. Nascimbène, and M. Lepers, J. Phys. B: At. Mol. Opt. Phys. 50, 014005 (2017).   
[215] W. Kao, Y. Tang, N. Q. Burdick, and B. L. Lev, Opt. Express 25, 3411 (2017).   
[216] J. H. Becher, S. Baier, K. Aikawa, M. Lepers, J.-F. Wyart, O. Dulieu, and F. Ferlaino, Phys. Rev. A 97, 012509 (2018).   
[217] W. C. Martin, R. Zalubas, and L. Hagan, Atomic Energy Levels-The Rare-Earth Elements. The Spectra of Lanthanum, Cerium, Praseodymium, Neodymium, Promethium, Samarium, Europium, Gadolinium, Terbium, Dysprosium, Holmium, Erbium, Thulium, Ytterbium, and Lutetium, Tech. Rep. (NATIONAL STANDARD REFERENCE DATA SYSTEM, 1978).   
[218] H. Y. Ban, M. Jacka, J. L. Hanssen, J. Readerand, and J. J. McClelland, Opt. Express 13, 3185 (2005).   
[219] Y. Ralchenko, A. Kramida, J. Reader, and N. A. Team, NIST Atomic Spectra Database (2018).   
[220] R. D. Cowan, The theory of atomic structure and spectra, 3 (Univ of California Press, 1981).   
[221] J.-F. Wyart, Canadian Journal of Physics 89, 451 (2011).   
[222] B. G. Wybourne and L. Smentek, Optical spectroscopy of lanthanides: magnetic and hyperfine interactions (CRC press, 2007).   
[223] M. Schmitt, E. A. L. Henn, J. Billy, H. Kadau, T. Maier, A. Griesmaier, and T. Pfau, Opt. Lett. 38, 637 (2013).   
[224] D. Studer, L. Maske, P. Windpassinger, and K. Wendt, Phys. Rev. A 98, 042504 (2018).   
[225] A. Golovizin, E. Fedorova, D. Tregubov, D. Sukachev, K. Khabarova, V. Sorokin, and N. Kolachevsky, Nature communications 10, 1 (2019).   
[226] N. Petersen, M. Trümper, and P. Windpassinger, Phys. Rev. A 101, 042502 (2020).   
[227] A. Patscheider, B. Yang, G. Natale, D. Petter, L. Chomaz, M. J. Mark, G. Hovhannesyan, M. Lepers, and F. Ferlaino, Phys. Rev. Research 3, 033256 (2021).   
[228] N. Leefer, a. Cingöz, B. Gerber-Siff, A. Sharma, J. R. Torgerson, and D. Budker, Phys. Rev. A 81, 5 (2010).   
[229] N. A. Leefer, A. Cingöz, D. Budker, S. J. Ferrell, V. V. Yashchuk, A. Lapierre, A. T. Nguyen, S. K. Lamoreaux,   
S170 (2003).and J. R. Torgerson, in Proceedings of the 7th Symposium (WORLD SCIENTIFIC, 2011) pp. 34–43.   
[230] S. H. Youn, M. Lu, U. Ray, and B. L. Lev, Phys. Rev. A 82, 043425 (2010).   
[231] D. Sukachev, K. Chebakov, A. Sokolov, A. Akimov, N. Kolachevsky, and V. Sorokin, Opt. Spectrosc. 111, 633 (2011).   
[232] G. A. Vishnyakova, E. S. Kalganova, D. D. Sukachev, S. A. Fedorov, A. V. Sokolov, A. V.   
(2014).Akimov, N. N. Kolachevsky, and V. N. Sorokin, Laser Physics 24, 074018 (2014).   
[233] A. J. Berglund, S. A. Lee, and J. J. McClelland, Phys. Rev. A 76, 053418 (2007).   
[234] S. H. Youn, M. Lu, and B. L. Lev, Phys. Rev. A 82, 043403 (2010).   
[235] D. Sukachev, A. Sokolov, K. Chebakov, A. Akimov, N. Kolachevsky, and V. Sorokin, JETP Lett. 92, 703 (2010).   
[236] J. Dalibard and C. Cohen-Tannoudji, J. Opt. Soc. Am. B 6, 2023 (1989).   
[237] H. Katori, T. Ido, Y. Isoya, and M. Kuwata-Gonokami, Phys. Rev. Lett. 82, 1116 (1999).   
[238] A. J. Berglund, J. L. Hanssen, and J. J. McClelland, Phys. Rev. Lett. 100, 113002 (2008).   
[239] M. Lu, S. H. Youn, and B. L. Lev, Phys. Rev. A 83, 012510 (2011).   
[240] A. Frisch, K. Aikawa, M. Mark, A. Rietzler, J. Schindler, E. Zupanič, R. Grimm, and F. Ferlaino, Phys. Rev. A 85, 051401 (2012).   
[241] T. Kuwamoto, K. Honda, Y. Takahashi, and T. Yabuzaki, Phys. Rev. A 60, R745 (1999).   
[242] T. Maier, H. Kadau, M. Schmitt, A. Griesmaier, and T. Pfau, Opt. Lett. 39, 3138 (2014).   
[243] F. Mühlbauer, N. Petersen, C. Baumgärtner, L. Maske, and P. Windpassinger, Applied Physics B 124, 120 (2018).   
[244] T. H. Loftus, T. Ido, M. M. Boyd, A. D. Ludlow, and J. Ye, Phys. Rev. A 70, 063413 (2004).   
[245] A. Frisch, Dipolar quantum gases of Erbium, Ph.D. thesis, Ph. D. thesis, University of Inssbruck (2014).   
[246] R. Grimm, M. Weidemüller, and Y. B. Ovchinnikov, Adv. At. Mol. Opt. Phys. 42, 95 (2000).   
[247] M. Schmitt, M. Wenzel, F. Böttcher, I. Ferrier-Barbut, and T. Pfau, Nature 539, 259 (2016).   
[248] T. Chalopin, V. Makhalov, C. Bouazza, A. Evrard, A. Barker, M. Lepers, J.-F. m. c. Wyart, O. Dulieu, J. Dalibard, R. Lopes, and S. Nascimbene, Phys. Rev. A 98, 040502 (2018).   
[249] Y. Tang, N. Q. Burdick, K. Baumann, and B. L. Lev, New J. Phys. 17, 045006 (2015).   
[250] L. Chomaz, S. Baier, D. Petter, M. J. Mark, F. Wächtler, L. Santos, and F. Ferlaino, Phys. Rev. X 6, 041039 (2016).   
[251] T. Maier, Interactions in a Quantum Gas of Dysprosium Atoms (Verlag Dr. Hut, 2016).   
[252] N. Q. Burdick, Y. Tang, and B. L. Lev, Phys. Rev. X 6, 031022 (2016).   
[253] D. A. Steck, “Quantum and atom optics,” (2007).   
[254] I. H. Deutsch and P. S. Jessen, Optics Communications 283, 681 (2010), quo vadis Quantum Optics?   
[255] F. Le Kien, P. Schneeweiss, and A. Rauschenbeutel, The European Physical Journal D 67, 92 (2013).   
[256] R. Chicireanu, Q. Beaufils, A. Pouderous, B. Laburthe-Tolra, É. Maréchal, L. Vernac, J.-C. Keller, and O. Gorceix, The European Physical Journal D 45, 189 (2007).   
[257] A. de Paz, A. Sharma, A. Chotia, E. Maréchal, J. H. Huckans, P. Pedri, L. Santos, O. Gorceix, L. Vernac, and B. Laburthe-Tolra, Phys. Rev. Lett. 111, 185305 (2013).   
[258] S. Lepoutre, K. Kechadi, B. Naylor, B. Zhu, L. Gabardos, L. Isaev, P. Pedri, A. M. Rey, L. Vernac, and B. Laburthe-Tolra, Phys. Rev. A 97, 023610 (2018).   
[259] H. Li, J.-F. m. c. Wyart, O. Dulieu, and M. Lepers, Phys. Rev. A 95, 062508 (2017).   
[260] J. M. Geremia, J. K. Stockton, and H. Mabuchi, Phys. Rev. A 73, 042112[1 (2006).   
[261] S. Lepoutre, L. Gabardos, K. Kechadi, P. Pedri, O. Gorceix, E. Maréchal, L. Vernac, and B. Laburthe-Tolra, Phys. Rev. Lett. 121, 013201 (2018).   
[262] A. A. Golovizin, E. S. Kalganova, D. D. Sukachev, G. A. Vishnyakova, D. O. Tregubov, K. Y. Khabarova, V. N. Sorokin, and N. N. Kolachevsky, Quantum Electronics 47, 479 (2017).   
[263] V. V. Tsyganok, D. A. Pershin, E. T. Davletov, V. A. Khlebnikov, and A. V. Akimov, Phys. Rev. A 100, 042502 (2019).   
[264] A. Patscheider, B. Zhu, L. Chomaz, D. Petter, S. Baier, A.-M. Rey, F. Ferlaino, and M. J. Mark, Phys. Rev. Research 2, 023050 (2020).   
[265] J. Ye, H. J. Kimble, and H. Katori, Science 320, 1734 (2008).   
[266] L. D. Landau and E. M. Lifshitz, Quantum Mechanics (Course of theoretical physics) (Pergamon Press, Oxford, 1965).   
[267] We point out that within first order-Born approximation, the DDI does not modify the van der Waals scattering length but simply appears in the effective Hamiltonian as distinct potential.   
[268] E. Tiesinga, B. J. Verhaar, and H. T. C. Stoof, Phys. Rev. A 47, 4114 (1993).   
[269] C. Chin, R. Grimm, P. S. Julienne, and E. Tiesinga, Rev. Mod. Phys. 82, 1225 (2010).   
[270] For short-range interacting gases in the ultracold regime, this is the only possibility. Note that when the DDI comes into play, other entrance channels of $\ell \neq 0$ may need to be considered.   
[271] H. Feshbach, Ann. Phys. 5, 357 (1958).   
[272] U. Fano, Phys. Rev. 124, 1866 (1961).   
[273] A. J. Moerdijk, B. J. Verhaar, and A. Axelsson, Phys. Rev. A 51, 4852 (1995).   
[274] P. O. Fedichev, Y. Kagan, G. V. Shlyapnikov, and J. T. M. Walraven, Phys. Rev. Lett. 77, 2913 (1996).   
[275] J. L. Bohn and P. S. Julienne, Phys. Rev. A 56, 1486 (1997).   
[276] F. K. Fatemi, K. M. Jones, and P. D. Lett, Phys. Rev. Lett. 85, 4462 (2000).   
[277] M. Theis, G. Thalhammer, K. Winkler, M. Hellwig, G. Ruff, R. Grimm, and J. H. Denschlag, Phys. Rev. Lett. 93, 123001 (2004).   
[278] G. Thalhammer, M. Theis, K. Winkler, R. Grimm, and J. H. Denschlag, Phys. Rev. A 71, 033403 (2005).   
[279] T. Zelevinsky, M. M. Boyd, A. D. Ludlow, T. Ido, J. Ye, R. Ciuryło, P. Naidon, and P. S. Julienne, Phys. Rev. Lett. 96, 203201 (2006).   
[280] S. Blatt, T. L. Nicholson, B. J. Bloom, J. R. Williams, J. W. Thomsen, P. S. Julienne, and J. Ye, Phys. Rev. Lett. 107, 073202 (2011).   
[281] K. Enomoto, K. Kasa, M. Kitagawa, and Y. Takahashi, Phys. Rev. Lett. 101, 203201 (2008).   
[282] R. Yamazaki, S. Taie, S. Sugawa, and Y. Takahashi, Phys. Rev. Lett. 105, 050405 (2010).   
[283] R. Ciuryło, E. Tiesinga, and P. S. Julienne, Phys. Rev. A 71, 030701 (2005).   
[284] D. M. Bauer, M. Lettner, C. Vo, G. Rempe, and S. Dürr, Phys. Rev. A 79, 062713 (2009).   
[285] Z. Fu, P. Wang, L. Huang, Z. Meng, H. Hu, and J. Zhang, Phys. Rev. A 88, 041601 (2013).   
[286] R. A. Williams, M. C. Beeler, L. J. LeBlanc, K. Jiménez-García, and I. B. Spielman, Phys. Rev. Lett. 111, 095301 (2013).   
[287] M. Cetina, M. Jag, R. S. Lous, J. T. M. Walraven, R. Grimm, R. S. Christensen, and G. M. Bruun, Phys. Rev. Lett. 115, 135302 (2015).   
[288] L. W. Clark, L.-C. Ha, C.-Y. Xu, and C. Chin, Phys. Rev. Lett. 115, 155301 (2015).   
[289] A. Jagannathan, N. Arunkumar, J. A. Joseph, and J. E. Thomas, Phys. Rev. Lett. 116, 075301 (2016).   
[290] E. A. Donley, N. R. Clausen, S. T. Thompson, and C. E. Wieman, Nature (London) 417, 529 (2002).   
[291] T. Köhler, K. Goral, and P. S. Julienne, Rev. Mod. Phys. 78, 1131 (2006).   
[292] F. Ferlaino, S. Knoop, and R. Grimm, “Cold molecules: Theory, experiment, applications,” (Taylor & Francis, 2009) Chap. Ultracold Feshbach molecules.   
[293] K. Bergmann, H. Theuer, and B. W. Shore, Rev. Mod. Phys. 70, 1003 (1998).   
[294] Q. Beaufils, A. Crubellier, T. Zanon, B. Laburthe-Tolra, É. Maréchal, L. Vernac, and O. Gorceix, Phys. Rev. A 79, 032706 (2009).   
[295] T. Maier, H. Kadau, M. Schmitt, M. Wenzel, I. Ferrier-Barbut, T. Pfau, A. Frisch, S. Baier, K. Aikawa, L. Chomaz, M. J. Mark, F. Ferlaino, C. Makrides, E. Tiesinga, A. Petrov, and S. Kotochigova, Phys. Rev. X 5, 041029 (2015).   
[296] J. Stuhler, A. Griesmaier, J. Werner, T. Koch, M. Fattori, and T. Pfau, Journal of Modern Optics 54, 647 (2007).   
[297] A. Frisch, M. Mark, K. Aikawa, F. Ferlaino, J. L. Bohn, C. Makrides, A. Petrov, and S. Kotochigova, Nature 507, 475 (2014).   
[298] K. Baumann, N. Q. Burdick, M. Lu, and B. L. Lev, Phys. Rev. A 89, 020701 (2014).   
[299] V. A. Khlebnikov, D. A. Pershin, V. V. Tsyganok, E. T. Davletov, I. S. Cojocaru, E. S. Fedorova, A. A. Buchachenko, and A. V. Akimov, Phys. Rev. Lett. 123, 213402 (2019).   
[300] C. R. Monroe, E. A. Cornell, C. A. Sackett, C. J. Myatt, and C. E. Wieman, Phys. Rev. Lett. 70, 414 (1993).   
[301] B. DeMarco, J. L. Bohn, J. P. Burke, M. Holland, and D. S. Jin, Phys. Rev. Lett. 82, 4208 (1999).   
[302] J. L. Bohn and D. S. Jin, Phys. Rev. A 89, 022702 (2014).   
[303] K. Aikawa, A. Frisch, M. Mark, S. Baier, R. Grimm, J. L. Bohn, D. S. Jin, G. M. Bruun, and F. Ferlaino, Phys. Rev. Lett. 113, 263201 (2014).   
[304] Y. Tang, A. Sykes, N. Q. Burdick, J. L. Bohn, and B. L. Lev, Phys. Rev. A 92, 022703 (2015).   
[305] Y. Tang, A. Sykes, N. Q. Burdick, J. L. Bohn, and B. L. Lev, Phys. Rev. A 93, 059905 (2016).   
[306] Y. Tang, A. G. Sykes, N. Q. Burdick, J. M. DiSciacca, D. S. Petrov, and B. L. Lev, Phys. Rev. Lett. 117, 155301 (2016).   
[307] S. Baier, M. J. Mark, D. Petter, K. Aikawa, L. Chomaz, Z. Cai, M. Baranov, P. Zoller, and F. Ferlaino, Science 352, 201 (2016), http://science.sciencemag.org/content/352/6282/201.ful   
[308] I. Ferrier-Barbut, M. Wenzel, F. Böttcher, T. Langen, M. Isoard, S. Stringari, and T. Pfau, Phys. Rev. Lett. 120, 160402 (2018).   
[309] F. Böttcher, M. Wenzel, J.-N. Schmidt, M. Guo, T. Langen, I. Ferrier-Barbut, T. Pfau, R. Bombín, J. Sánchez-Baena, J. Boronat, and F. Mazzanti, Phys. Rev. Research 1, 033088 (2019).   
[310] We note that a similar down-shift of the scattering length can be observed in $\mathrm { E r }$ based on lattice modulation spectroscopy of a Mott insulator versus that from cross-rethermalisation of a thermal sample. This might also be interpreted as arising from the momentum dependence of the scattering.   
[311] G. Natale, R. M. W. van Bijnen, A. Patscheider, D. Petter, M. J. Mark, L. Chomaz, and F. Ferlaino, Phys. Rev. Lett. 123, 050402 (2019).   
[312] L. Chomaz, R. M. W. van Bijnen, D. Petter, G. Faraoni, S. Baier, J. H. Becher, M. J. Mark, F. Wächtler, L. Santos, and F. Ferlaino, Nat. Phys. 14, 442 (2018).   
[313] D. Petter, G. Natale, R. M. W. van Bijnen, A. Patscheider, M. J. Mark, L. Chomaz, and F. Ferlaino, Phys. Rev. Lett. 122, 183401 (2019).   
[314] S. Baier, D. Petter, J. H. Becher, A. Patscheider, G. Natale, L. Chomaz, M. J. Mark, and F. Ferlaino, Phys. Rev. Lett. 121, 093602 (2018).   
[315] M. Mayle, B. P. Ruzic, and J. L. Bohn, Phys. Rev. A 85, 062712[1 (2012).   
[316] C. Ravensbergen, E. Soave, V. Corre, M. Kreyer, B. Huang, E. Kirilov, and R. Grimm, Phys. Rev. Lett. 124, 203402 (2020).   
[317] K. Zaremba-Kopczyk, P. S. Żuchowski, and M. Tomza, Phys. Rev. A 98, 032704 (2018).   
[318] C. Chin, A. J. Kerman, V. Vuletić, and S. Chu, Phys. Rev. Lett. 90, 033201 (2003).   
[319] C. A. Regal and D. S. Jin, Phys. Rev. Lett. 90, 230404 (2003).   
[320] J. Cubizolles, T. Bourdel, S. J. J. M. F. Kokkelmans, G. V. Shlyapnikov, and C. Salomon, Phys. Rev. Lett. 91, 240401 (2003).   
[321] J. Herbig, T. Kraemer, M. Mark, T. Weber, C. Chin, H.-C. Nägerl, and R. Grimm, Science 301, 1510 (2003).   
[322] E. Hodby, S. T. Thompson, C. A. Regal, M. Greiner, A. C. Wilson, D. S. Jin, E. A. Cornell, and C. E. Wieman, Phys. Rev. Lett. 94, 120402 (2005).   
[323] T. M. Hanna, T. Köhler, and K. Burnett, Phys. Rev. A 75, 013606 (2007).   
[324] S. T. Thompson, E. Hodby, and C. E. Wieman, Phys. Rev. Lett. 95, 190404 (2005).   
[325] C. Weber, G. Barontini, J. Catani, G. Thalhammer, M. Inguscio, and F. Minardi, Phys. Rev. A 78, 061601(R) (2008).   
[326] C. Klempt, T. Henninger, O. Topic, M. Scherer, L. Kattner, E. Tiemann, W. Ertmer, and J. J. Arlt, Phys. Rev. A 78, 061602(R) (2008).   
[327] Q. Beaufils, A. Crubellier, T. Zanon, B. Laburthe-Tolra, É. Maréchal, L. Vernac, and O. Gorceix, Eur. Phys. J. D 56, 99 (2010).   
[328] P. O. Schmidt, S. Hensler, J. Werner, A. Griesmaier, A. Görlitz, T. Pfau, and A. Simoni, Phys. Rev. Lett. 91, 193201 (2003).   
[329] L. Chomaz, D. Petter, P. Ilzhöfer, G. Natale, A. Trautmann, C. Politi, G. Durastante, R. M. W. van Bijnen, A. Patscheider, M. Sohmen, M. J. Mark, and F. Fer  
df. laino, Phys. Rev. X 9, 021012 (2019).   
[330] F. Böttcher, J.-N. Schmidt, M. Wenzel, J. Hertkorn, M. Guo, T. Langen, and T. Pfau, Phys. Rev. X 9, 011051 (2019).   
[331] E. Fermi, Il Nuovo Cimento (1924-1942) 11, 157 (1934).   
[332] This simple formula is not regular everywhere. As described in Refs. [79, 91, 331], a more rigorous regular version exists.   
[333] E. P. Wigner, Phys. Rev. 73, 1002 (1948).   
[334] M. Przybytek, W. Cencek, J. Komasa, G. Łach, B. Jeziorski, and K. Szalewicz, Phys. Rev. Lett. 104, 183003 (2010).   
[335] K. Piszczatowski, G. Łach, M. Przybytek, J. Komasa, K. Pachucki, and B. Jeziorski, Journal of chemical theory and computation 5, 3039 (2009).   
[336] This approximation assumes that the interaction is sufficiently weak that there is no rescattering during the collision. This means that the incident field can be taken as the total field at the scatterer.   
[337] A. Lagendijk, I. F. Silvera, and B. J. Verhaar, Phys. Rev. B 33, 626 (1986).   
[338] G. V. Shlyapnikov, J. T. M. Walraven, U. M. Rahmanov, and M. W. Reynolds, Phys. Rev. Lett. 73, 3247 (1994).   
[339] P. O. Fedichev, M. W. Reynolds, U. M. Rahmanov, and G. V. Shlyapnikov, Phys. Rev. A 53, 1447 (1996).   
[340] J. L. Bohn, M. Cavagnero, and C. Ticknor, New Journal of Physics 11, 055039 (2009).   
[341] R. Ołdziejewski and K. Jachymski, Phys. Rev. A 94, 063638 (2016).   
[342] K.-K. Ni, S. Ospelkaus, M. H. G. de Miranda, A. Pe’er, B. Neyenhuis, J. J. Zirbel, S. Kotochigova, P. S. Julienne, D. S. Jin, and J. Ye, Science 322, 231 (2008).   
[343] W. Ketterle and M. W. Zwierlein, Rivista del Nuovo Cimento 31, 247 (2008).   
[344] Note that previous theoretical treatments appeared in Refs. [337–339].   
[345] H. T. C. Stoof, J. M. V. A. Koelman, and B. J. Verhaar, Phys. Rev. B 38, 4688 (1988).   
[346] A. J. Moerdijk and B. J. Verhaar, Phys. Rev. A 53, R19 (1996).   
[347] J. M. Gerton, C. A. Sackett, B. J. Frew, and R. G. Hulet, Phys. Rev. A 59, 1514 (1999).   
[348] J. D. Weinstein, R. deCarvalho, C. I. Hancox, and J. M. Doyle, Phys. Rev. A 65, 021604 (2002).   
[349] We note that the dipolar relaxation rates have also been measured in bosonic Dy at a few hundred $\mu \mathrm { K }$ [170] and Er and Tm at hundreds of mK [195], as well as Ho and   
[350] B. Sun and L. You, Phys. Rev. Lett. 99, 150402 (2007).   
[351] B. Pasquiou, E. Maréchal, G. Bismut, P. Pedri, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. Lett. 106, 255303 (2011).   
[352] Y. Kawaguchi, H. Saito, and M. Ueda, Phys. Rev. Lett. 96, 080405 (2006).   
[353] L. Santos and T. Pfau, Phys. Rev. Lett. 96, 190404 (2006).   
[354] K. Gawryluk, M. Brewczyk, K. Bongs, and M. Gajda, Phys. Rev. Lett. 99, 130401 (2007).   
[355] D. Peter, A. Griesmaier, T. Pfau, and H. P. Büchler, Phys. Rev. Lett. 110, 145303 (2013).   
[356] A. de Paz, P. Pedri, A. Sharma, M. Efremov, B. Naylor, O. Gorceix, E. Maréchal, L. Vernac, and B. LaburtheTolra, Phys. Rev. A 93, 021603 (2016).   
[357] A. G. Sykes and J. L. Bohn, Phys. Rev. A 91, 013625 (2015).   
[358] R. Legere and K. Gibble, Phys. Rev. Lett. 81, 5780 (1998).   
[359] A. P. Chikkatur, A. Görlitz, D. M. StamperKurn, S. Inouye, S. Gupta, and W. Ketterle, Phys. Rev. Lett. 85, 483 (2000).   
[360] N. R. Thomas, N. Kjærgaard, P. S. Julienne, and A. C. Wilson, Phys. Rev. Lett. 93, 173201 (2004).   
[361] C. Buggle, J. Léonard, W. von Klitzing, and J. T. M. Walraven, Phys. Rev. Lett. 93, 173202 (2004).   
[362] A. Derevianko, Phys. Rev. A 67, 033607 (2003).   
[363] A. Derevianko, Phys. Rev. A 72, 039901 (2005).   
[364] A. Derevianko, Phys. Rev. A 72, 044701 (2005).   
[365] I. E. Mazets and G. Kurizki, Phys. Rev. Lett. 98, 140401 (2007).   
[366] D. C. E. Bortolotti, S. Ronen, J. L. Bohn, and D. Blume, Phys. Rev. Lett. 97, 160402 (2006).   
[367] R. Ołdziejewski and K. Jachymski, Phys. Rev. A 95, 049901 (2017).   
[368] M. A. Baranov, C. Lobo, and G. V. Shlyapnikov, Phys. Rev. A 78, 033620 (2008).   
[369] S. Ronen, D. C. E. Bortolotti, D. Blume, and J. L. Bohn, Phys. Rev. A 74, 033611 (2006).   
[370] J. P. Joule, The London, Edinburgh and Dublin philosophical magazine and journal of science 30, 225 (1847).   
[371] D. H. J. O’Dell, S. Giovanazzi, and C. Eberlein, Phys. Rev. Lett. 92, 250401 (2004).   
[372] C. Eberlein, S. Giovanazzi, and D. H. J. O’Dell, Phys. Rev. A 71, 033618 (2005).   
[373] Expression (49) is valid for an inverted parabola solution of the TF approximation. If one uses a Gaussian variational ansatz for the wavefunction of the BEC, it becomes $\begin{array} { r } { E _ { \mathrm { d d } } = - \varepsilon _ { \mathrm { d d } } g \frac { n _ { 0 } N } { 2 } f _ { \mathrm { d i p } } ( \kappa ) } \end{array}$ .   
[374] S. Giovanazzi, A. GÃ¶rlitz, and T. Pfau, Journal of Optics B: Quantum and Semiclassical Optics   
[375] L. Santos, G. V. Shlyapnikov, P. Zoller, and M. Lewenstein, Phys. Rev. Lett. 85, 1791 (2000).   
[376] M. Wenzel, F. Böttcher, J.-N. Schmidt, M. Eisenmann, T. Langen, T. Pfau, and I. Ferrier-Barbut, Phys. Rev. Lett. 121, 030401 (2018).   
[377] M. J. Holland, D. S. Jin, M. L. Chiofalo, and J. Cooper, Phys. Rev. Lett. 78, 3801 (1997).   
[378] K. M. O’Hara, S. L. Hemmer, M. E. Gehm, S. R. Granade, and J. E. Thomas, Science 298, 2179 (2002).   
[379] Y. Castin and R. Dum, Phys. Rev. Lett. 77, 5315 (1996).   
[380] S. Giovanazzi, P. Pedri, L. Santos, A. Griesmaier, M. Fattori, T. Koch, J. Stuhler, and T. Pfau, Phys. Rev. A 74, 013621 (2006).   
[381] J. Stuhler, A. Griesmaier, T. Koch, M. Fattori, T. Pfau, S. Giovanazzi, P. Pedri, and L. Santos, Phys. Rev. Lett. 95, 150406 (2005).   
[382] A. Griesmaier, J. Stuhler, T. Koch, M. Fattori, T. Pfau, and S. Giovanazzi, Phys. Rev. Lett. 97, 250402 (2006).   
[383] T. Lahaye, T. Koch, B. Frohlich, M. Fattori, J. Metz, A. Griesmaier, S. Giovanazzi, and T. Pfau, Nature 448, 672 (2007).   
[384] J. Stenger, S. Inouye, M. R. Andrews, H.-J. Miesner, D. M. Stamper-Kurn, and W. Ketterle, Phys. Rev. Lett. 82, 2422 (1999).   
[385] D. M. Stamper-Kurn, A. P. Chikkatur, A. Görlitz, S. Inouye, S. Gupta, D. E. Pritchard, and W. Ketterle, Phys. Rev. Lett. 83, 2876 (1999).   
[386] J. Steinhauer, R. Ozeri, N. Katz, and N. Davidson, Phys. Rev. Lett. 88, 120407 (2002).   
[387] J. M. Vogels, K. Xu, C. Raman, J. R. Abo-Shaeer, and W. Ketterle, Phys. Rev. Lett. 88, 060402 (2002).   
[388] R. Ozeri, J. Steinhauer, N. Katz, and N. Davidson, Phys. Rev. Lett. 88, 220401 (2002).   
[389] G. Bismut, B. Laburthe-Tolra, E. Maréchal, P. Pedri, O. Gorceix, and L. Vernac, Phys. Rev. Lett. 109, 155302 (2012).   
[390] Z.-Q. Yu, Phys. Rev. A 95, 033618 (2017).   
[391] C. Ticknor, R. M. Wilson, and J. L. Bohn, Phys. Rev. Lett. 106, 065301 (2011).   
[392] R. M. Wilson, S. Ronen, and J. L. Bohn, Phys. Rev. Lett. 104, 094501 (2010).   
[393] M. Wenzel, F. Böttcher, J.-N. Schmidt, M. Eisenmann, T. Langen, T. Pfau, and I. Ferrier-Barbut, Phys. Rev. Lett. 121, 030401 (2018).   
[394] S. Yi and L. You, Phys. Rev. A 66, 013607 (2002).   
[395] S. Giovanazzi, L. Santos, and T. Pfau, Phys. Rev. A 75, 015604 (2007).   
[396] G. Bismut, B. Pasquiou, E. Maréchal, P. Pedri, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. Lett. 105, 040404 (2010).   
[397] R. Feynman (Elsevier, 1955) pp. 17 – 53.   
[398] P. Nozières, J. Low Temp. Phys. 137, 45 (2004).   
[399] D. A. Kirzhnits and Y. A. Nepomnyashchii, Sov. Phys. JETP 32 (1971).   
[400] T. Schneider and C. P. Enz, Phys. Rev. Lett. 27, 1186 (1971).   
[401] A. D. Martin and P. B. Blakie, Phys. Rev. A 86, 053623 (2012).   
[402] P. B. Blakie, D. Baillie, and R. N. Bisset, Phys. Rev. A 86, 021604 (2012).   
S208 (2003).[403] M. Jona-Lasinio, K. Łakomy, and L. Santos, Phys. Rev. A 88, 013619 (2013).   
[404] R. N. Bisset and P. B. Blakie, Phys. Rev. Lett. 110, 265302 (2013).   
[405] R. M. Wilson, S. Ronen, J. L. Bohn, and H. Pu, Phys. Rev. Lett. 100, 245302 (2008).   
[406] R. Nath and L. Santos, Phys. Rev. A 81, 033626 (2010).   
[407] M. Klawunn, A. Recati, L. P. Pitaevskii, and S. Stringari, Phys. Rev. A 84, 033612 (2011).   
[408] R. N. Bisset, D. Baillie, and P. B. Blakie, Phys. Rev. A 88, 043606 (2013).   
[409] P. B. Blakie, D. Baillie, and R. N. Bisset, Phys. Rev. A 88, 013638 (2013). [410] my, A 88, 025603 (2013).   
[411] S. S. Natu, L. Campanello, and S. Das Sarma, Phys. Rev. A 90, 043617 (2014). [412] R. M. Wilson, S. Ronen, and J. L. Bohn, Phys. Rev. A 80, 023614 (2009).   
[413] J. Hertkorn, J.-N. Schmidt, F. Böttcher, M. Guo, M. Schmidt, K. S. H. Ng, S. D. Graham, H. P. Büchler, T. Langen, M. Zwierlein, and T. Pfau, Phys. Rev. X 11, 011037 (2021). [414] J.-N. Schmidt, J. Hertkorn, M. Guo, F. Böttcher, M. Schmidt, K. S. H. Ng, S. D. Graham, T. Langen, M. Zwierlein, and T. Pfau,   
[415] $\begin{array} { r } { \chi = - { \frac { 1 } { V } } { \frac { \partial V } { \partial P } } = { \frac { 1 } { n } } { \frac { \partial n } { \partial P } } = { \frac { 1 } { n ^ { 2 } } } { \frac { \partial n } { \partial \mu } } } \end{array}$ 2 (2021).. Z. Hadzibabic, and R. P. Smith, Phys. Rev. X 6, 041058 (2016).   
[417] T. Koch, T. Lahaye, J. Metz, B. Fröhlich, A. Griesmaier, and T. Pfau, Nature Physics 4, 218 (2008). [418] S. Giovanazzi, P. Pedri, L. Santos, A. Griesmaier, M. Fattori, T. Koch, J. Stuhler, and T. Pfau, Phys. Rev. A 74, 013621 (2006). [419] M. Fattori, G. Roati, B. Deissler, C. D’Errico, M. Zaccanti, M. Jona-Lasinio, L. Santos, M. Inguscio, and G. Modugno, Phys. Rev. Lett. 101, 190405 (2008). [420] S. Müller, J. Billy, E. A. L. Henn, H. Kadau, A. Griesmaier, M. Jona-Lasinio, L. Santos, and T. Pfau, Phys. Rev. A 84, 053601 (2011). [421] J. Billy, E. A. L. Henn, S. Müller, T. Maier, H. Kadau, A. Griesmaier, M. Jona-Lasinio, L. Santos, and T. Pfau, Phys. Rev. A 86, 051603 (2012).   
[422] S. Ronen and J. L. Bohn, Phys. Rev. A 76, 043607 (2007).   
[423] O. Dutta and P. Meystre, Phys. Rev. A 75, 053604 (2007). [424] P. G. KEVREKIDIS and D. J. FRANTZESKAKIS, Modern Physics Letters B 18, 173 (2004), https://www.worldscientific.com/doi/pdf/10.1142/S021 [425] J. H. Nguyen, D. Luo, and R. G. Hulet, Science 356, 422 (2017). [426] P. J. Everitt, M. A. Sooriyabandara, M. Guasoni, P. B. Wigley, C. H. Wei, G. D. McDonald, K. S. Hardman, P. Manju, J. D. Close, C. C. N. Kuhn, S. S. Szigeti, Y. S. Kivshar, and N. P. Robins, Phys. Rev. A 96, 041601 (2017). [427] L. Salasnich, A. Parola, and L. Reatto, Phys. Rev. Lett. 91, 080405 (2003).   
[428] L. D. Carr and J. Brand, Phys. Rev. Lett. 92, 040401 (2004). [429] J. Metz, T. Lahaye, B. Fröhlich, A. Griesmaier, T. Pfau, H. Saito, Y. Kawaguchi, and M. Ueda, New J. Phys. 11, 055032 (2009).   
[430] I. Ferrier-Barbut, H. Kadau, M. Schmitt, M. Wenzel, and T. Pfau, Phys. Rev. Lett. 116, 215301 (2016). [431] I. Ferrier-Barbut, M. Schmitt, M. Wenzel, H. Kadau, and T. Pfau, J. Phys. B: At. Mol. Opt. Phys. 49, 214004 (2016). [432] F. Wächtler and L. Santos, Phys. Rev. A 93, 061603 (2016). [433] I. Ferrier-Barbut, M. Wenzel, M. Schmitt, F. Böttcher, and T. Pfau, Phys. Rev. A 97, 011604 (2018).   
[434] K. Aikawa, S. Baier, A. Frisch, M. Mark, C. Ravensbergen, and F. Ferlaino, Science 345, 1484 (2014).   
[435] L. M. Sieberer and M. A. Baranov, Phys. Rev. A 84, 063633 (2011).   
[436] Z.-K. Lu and G. V. Shlyapnikov, Phys. Rev. A 85, 023614 (2012).   
[437] M. A. Baranov, M. S. Mar’enko, V. S. Rychkov, and G. V. Shlyapnikov, Phys. Rev. A 66, 013606 (2002).   
[438] A. Pikovski, M. Klawunn, G. V. Shlyapnikov, and L. Santos, Phys. Rev. Lett. 105, 215302 (2010).   
[439] A. C. Potter, E. Berg, D.-W. Wang, B. I. Halperin, and E. Demler, Phys. Rev. Lett. 105, 220406 (2010).   
[440] M. A. Baranov, A. Micheli, S. Ronen, and P. Zoller, Phys. Rev. A 83, 043602 (2011).   
[441] N. R. Cooper and G. V. Shlyapnikov, Phys. Rev. Lett. 103, 155302 (2009).   
[442] B. M. Fregoso and E. Fradkin, Phys. Rev. Lett. 103, 205301 (2009).   
[443] B. M. Fregoso, K. Sun, E. Fradkin, and B. L. Lev, New Journal of Physics 11, 103003 (2009).   
[444] T. Sogo, L. He, T. Miyakawa, S. Yi, H. Lu, and H. Pu, New Journal of Physics 11, 055017 (2009).   
[445] T. Miyakawa, T. Sogo, and H. Pu, Phys. Rev. A 77, 061603 (2008).   
[446] V. Veljic, A. Balaž, and A. Pelster, Phys. Rev. A 95, 053635 (2017).   
[447] J. L. Roberts, N. R. Claussen, S. L. Cornish, and C. E. Wieman, Phys. Rev. Lett. 85, 728 (2000).   
[448] T. Weber, J. Herbig, M. Mark, H.-C. Nägerl, and R. Grimm, Phys. Rev. Lett. 91, 123201 (2003).   
[449] A. Gammal, T. Frederico, L. Tomio, and P. Chomaz, Journal of Physics B: Atomic, Molecular and Optical Physics 33, 40   
[450] A. Bulgac, Phys. Rev. Lett. 89, 050402 (2002).   
[451] K.-T. Xi and H. Saito, Phys. Rev. A 93, 011604 (2016).   
[452] R. N. Bisset and P. B. Blakie, Phys. Rev. A 92, 061603 (2015).   
[453] P. B. Blakie, Phys. Rev. A 93, 033644 (2016).   
[454] R. SCHÜTZHOLD, M. UHLMANN,   
84904006809.Y. XU, and U. R. FISCHER, International Journal of Modern Physics B 20, 3555 (2006), https://www.worldscientific.com/doi/pdf/10.1142/S02179792060356   
[455] A. R. P. Lima and A. Pelster, Phys. Rev. A 84, 041604 (2011).   
[456] A. R. P. Lima and A. Pelster, Phys. Rev. A 86, 063609 (2012).   
[457] R. N. Bisset, R. M. Wilson, D. Baillie, and P. B. Blakie, Phys. Rev. A 94, 033619 (2016).   
[458] H. Saito, J. Phys. Soc. Jpn. 85, 053001 (2016).   
[459] Assuming for simplicity an elongated density distribution, with a central MF chemical potential $\mu \simeq g n \left( 1 - \right.$ ).   
[460] F. Böttcher, J.-N. Schmidt, J. Hertkorn, K. S. H. Ng, S. D. Graham, M. Guo, T. Langen, and T. Pfau, Reports on Progress in Physics 84, 012403 (2021).   
[461] T. Lahaye, J. Metz, B. Fröhlich, T. Koch, M. Meister, A. Griesmaier, T. Pfau, H. Saito, Y. Kawaguchi, and M. Ueda, Phys. Rev. Lett. 101, 080401 (2008).   
[462] Provided the imaginary part of $Q _ { \mathrm { 5 } } ( \varepsilon _ { \mathrm { d d } } )$ can be neglected.   
[463] At $\varepsilon _ { \mathrm { d d } } = 1 . 5$ , $\Re [ Q _ { 5 } ( \varepsilon _ { \mathrm { d d } } ) ] \simeq 3$ , leading to a reduction of the density by roughly an order of magnitude.   
[464] C. R. Cabrera, L. Tanzi, J. Sanz, B. Naylor, P. Thomas, P. Cheiney, and L. Tarruell, Science 359, 301 (2018), http://science.sciencemag.org/content/359/6373/301.full.pdf.   
[465] P. Cheiney, C. R. Cabrera, J. Sanz, B. Naylor, L. Tanzi, and L. Tarruell, Phys. Rev. Lett. 120, 135301 (2018).   
[466] G. Semeghini, G. Ferioli, L. Masi, C. Mazzinghi, L. Wolswijk, F. Minardi, M. Modugno, G. Modugno, M. Inguscio, and M. Fattori, Phys. Rev. Lett. 120, 235301 (2018).   
[467] D. S. Petrov, Phys. Rev. Lett. 115, 155302 (2015).   
[468] F. Wächtler and L. Santos, Phys. Rev. A 94, 043618 (2016).   
[469] N. L. Iudice and F. Palumbo, Phys. Rev. Lett. 41, 1532 (1978).   
[470] E. Lipparini and S. Stringari, Physics Letters B 130, 139 (1983).   
[471] J. Enders, H. Kaiser, P. von NeumannCosel, C. Rangacharyulu, and A. Richter, Phys. Rev. C 59, R1851 (1999).   
[472] D. Guéry-Odelin and S. Stringari, Phys. Rev. Lett. 83, 4452 (1999).   
[473] O. M. Maragò, S. A. Hopkins, J. Arlt, E. Hodby, G. Hechenblaikner, and C. J. Foot, Phys. Rev. Lett. 84, 2056 (2000).   
[474] R. M. W. van Bijnen, N. G. Parker, S. J. J. M. F. Kokkelmans, A. M. Martin, and D. H. J. O’Dell, Phys. Rev. A 82, 033612 (2010).   
[475] D. Baillie, R. M. Wilson, and P. B. Blakie, Phys. Rev. Lett. 119, 255302 (2017).   
[476] D. Baillie, R. M. Wilson, R. N. Bisset, and P. B. Blakie, Phys. Rev. A 94, 021602 (2016).   
[477] The trap has yet a prolate shape with $\lambda = 1 . 3$ . The axial elongation of the dBEC comes from magnetostriction effects, see Sec. IV A 2.   
[478] D. S. Petrov and G. E. Astrakharchik, Phys. Rev. Lett. 117, 100401 (2016).   
[479] D. Edler, C. Mishra, F. Wächtler, R. Nath, S. Sinha, and L. Santos, Phys. Rev. Lett. 119, 050403 (2017).   
[480] O. Penrose and L. Onsager, Phys. Rev. 104, 576 (1956).   
[481] E. P. Gross, Physical Review 106, 161 (1957).   
[482] M. Boninsegni and N. V. Prokof’ev, Rev. Mod. Phys. 84, 759 (2012).   
[483] A. F. Andreev and I. M. Lifshitz, Sov. Phys. JETP 29, 1107 (1969).   
[484] G. V. Chester, Phys. Rev. A 2, 256 (1970).   
[485] A. J. Leggett, Phys. Rev. Lett. 25, 1543 (1970).   
[486] E. Kim and M. H. W. Chan, Nature 427, 225 EP (2004).   
[487] D. Y. Kim and M. H. W. Chan, Phys. Rev. Lett. 109, 155301 (2012).   
[488] S. Balibar, Nature 464, 176 (2010).   
[489] S. Giovanazzi, D. O’Dell, and G. Kurizki, Phys. Rev. Lett. 88, 130402 (2002).   
[490] C. Mora, O. Parcollet, and X. Waintal, Phys. Rev. B 76, 064511 (2007).   
[491] H. P. Büchler, E. Demler, M. Lukin, A. Micheli, N. Prokof’ev, G. Pupillo, and P. Zoller, Phys. Rev. Lett. 98, 060404 (2007).   
[492] G. E. Astrakharchik, J. Boronat, I. L. Kurbakov, and Y. E. Lozovik, Phys. Rev. Lett. 98, 060405 (2007).   
[493] G. Pupillo, A. Micheli, M. Boninsegni, I. Lesanovsky, and P. Zoller, Phys. Rev. Lett. 104, 223002 (2010).   
[494] A. E. Golomedov, G. E. Astrakharchik, and Y. E. Lozovik, Phys. Rev. A 84, 033615 (2011).   
[495] M. Boninsegni, J. Low Temp. Phys. 168, 137 (2012).   
[496] M. Boninsegni, Phys. Rev. A 87, 063604 (2013).   
[497] S. Moroni and M. Boninsegni, Phys. Rev. Lett. 113, 240407 (2014).   
[498] Z.-K. Lu, Y. Li, D. S. Petrov, and G. V. Shlyapnikov, Phys. Rev. Lett. 115, 075303 (2015).   
[499] S. M. Roccuzzo and F. Ancilotto, Phys. Rev. A 99, 041601(R) (2019).   
[500] Y. Pomeau and S. Rica, Phys. Rev. Lett. 72, 2426 (1994).   
[501] J. Léonard, A. Morales, P. Zupancic, T. Esslinger, and T. Donner, Nature 543, 87 EP (2017).   
[502] J.-R. Li, J. Lee, W. Huang, S. Burchesky, B. Shteynas, F. Ç. Top, A. O. Jamison, and W. Ketterle, Nature 543, 91 EP (2017).   
[503] Y. Guo, R. M. Kroeze, B. P. Marsh, S. Gopalakrishnan, J. Keeling, and B. L. Lev, Nature (London) 599, 211 (2021).   
[504] G. Shlyapnikov and P. Pedri, “conference on “correlated and many-body phenomena in dipolar systems,”,” (2006).   
[505] S. Komineas and N. R. Cooper, Phys. Rev. A 75, 023623 (2007).   
[506] M. Wenzel, F. Böttcher, T. Langen, I. Ferrier-Barbut, and T. Pfau, Phys. Rev. A 96, 053630 (2017).   
[507] D. Baillie and P. B. Blakie, Phys. Rev. Lett. 121, 195301 (2018).   
[508] A. Macia, J. Sánchez-Baena, J. Boronat, and F. Mazzanti, Phys. Rev. Lett. 117, 205301 (2016).   
[509] F. Cinti and M. Boninsegni, Phys. Rev. A 96, 013627 (2017).   
[510] P. Ilzhöfer, M. Sohmen, G. Durastante, C. Politi, A. Trautmann, G. Natale, G. Morpurgo, T. Giamarchi, L. Chomaz, M. Mark, et al., Nature Physics 17, 356 (2021).   
[511] Y. Kora and M. Boninsegni, Journal of Low Temperature Physics 197, 337 (2019).   
[512] Y.-C. Zhang, F. Maucher, and T. Pohl, Phys. Rev. Lett. 123, 015301 (2019).   
[513] M. Sohmen, C. Politi, L. Klaus, L. Chomaz, M. J. Mark, M. A. Norcia, and F. Ferlaino, Phys. Rev. Lett. 126, 233401 (2021).   
[514] J. Hertkorn, J.-N. Schmidt, M. Guo, F. Böttcher, K. S. H. Ng, S. D. Graham, P. Uerlings, T. Langen, M. Zwierlein, and T. Pfau, Phys. Rev. Research 3, 033125 (2021).   
[515] P. B. Blakie, D. Baillie, L. Chomaz, and F. Ferlaino, Phys. Rev. Research 2, 043318 (2020).   
[516] D. Petter, A. Patscheider, G. Natale, M. J. Mark, M. A. Baranov, R. van Bijnen, S. M. Roccuzzo, A. Recati, B. Blakie, D. Baillie, L. Chomaz, and F. Ferlaino, Phys. Rev. A 104, L011302 (2021).   
[517] S. Saccani, S. Moroni, and M. Boninsegni, Phys. Rev. Lett. 108, 175301 (2012).   
[518] T. Macrì, F. Maucher, F. Cinti, and T. Pohl, Phys. Rev. A 87, 061602(R) (2013).   
[519] S. Rossotti, M. Teruzzi, D. Pini, D. E. Galli, and G. Bertaina, Phys. Rev. Lett. 119, 215301 (2017).   
[520] A. Macia, D. Hufnagl, F. Mazzanti, J. Boronat, and R. E. Zillich, Phys. Rev. Lett. 109, 235307 (2012).   
[521] J. Goldstone, Il Nuovo Cimento (1955-1965) 19, 154 (1961).   
[522] J. Hertkorn, F. Böttcher, M. Guo, J. N. Schmidt, T. Langen, H. P. Büchler, and T. Pfau, Phys. Rev. Lett. 123, 193002 (2019).   
[523] M. Guo, F. Böttcher, J. Hertkorn, J.-N. Schmidt, M. Wenzel, H. P. Büchler, T. Langen, and T. Pfau, Nature 574, 386 (2019).   
[524] L. Tanzi, J. Maloberti, G. Biagioni, A. Fioretti, C. Gabbanini, and G. Modugno, Science 371, 1162 (2021).   
[525] L. Chomaz, Phys. Rev. A 102, 023333 (2020).   
[526] I. Mazets, D. O’Dell, G. Kurizki, N. Davidson, and W. P. Schleich, Journal of Physics B: Atomic, Molecular and Optical Physics 37, S155 (2004).   
[527] S. M. Roccuzzo, A. Gallemí, A. Recati, and S. Stringari, Phys. Rev. Lett. 124, 045702 (2020).   
[528] F. Ancilotto, M. Barranco, M. Pi, and L. Reatto, Phys. Rev. A 103, 033314 (2021).   
[529] Y.-C. Zhang, T. Pohl, and F. Maucher, Phys. Rev. A 104, 013310 (2021).   
[530] J. Hertkorn, J.-N. Schmidt, M. Guo, F. Böttcher, K. S. H. Ng, S. D. Graham, P. Uerlings, H. P. Büchler, T. Langen, M. Zwierlein, and T. Pfau, Phys. Rev. Lett. 127, 155301 (2021).   
[531] M. A. Norcia, C. Politi, L. Klaus, E. Poli, M. Sohmen, M. J. Mark, R. Bisset, L. Santos, and F. Ferlaino, Nature (London) 596, 357 (2021).   
[532] T. Bland, E. Poli, C. Politi, L. Klaus, M. A. Norcia, F. Ferlaino, L. Santos, and R. N. Bisset, Phys. Rev. Lett. 128, 195302 (2022).   
[533] E. Poli, T. Bland, C. Politi, L. Klaus, M. A. Norcia, F. Ferlaino, R. N. Bisset, and L. Santos, Phys. Rev. A 104, 063307 (2021).   
[534] A. Gallemí, S. M. Roccuzzo, S. Stringari, and A. Recati, Phys. Rev. A 102, 023322 (2020).   
[535] J. S. Krauser, U. Ebling, N. Fläschner, J. Heinze, K. Sengstock, M. Lewenstein, A. Eckardt, and C. Becker, Science 343, 157 (2014), http://science.sciencemag.org/content/343/6167/157.full.p   
[536] T. Fernholz, H. Krauter, K. Jensen, J. F. Sherson, A. S. Sørensen, and E. S. Polzik, Phys. Rev. Lett. 101, 073601 (2008).   
[537] T. Bourdel, J. Cubizolles, L. Khaykovich, K. M. F. Magalhães, S. J. J. M. F. Kokkelmans, G. V. Shlyapnikov, and C. Salomon, Phys. Rev. Lett. 91, 020402 (2003).   
[538] C. A. Regal, M. Greiner, and D. S. Jin, Phys. Rev. Lett. 92, 040403 (2004).   
[539] M. W. Zwierlein, C. A. Stan, C. H. Schunck, S. M. F. Raupach, A. J. Kerman, and W. Ketterle, Phys. Rev. Lett. 92, 120403 (2004).   
[540] M. Bartenstein, A. Altmeyer, S. Riedl, S. Jochim, C. Chin, J. Hecker Denschlag, and R. Grimm, Phys. Rev. Lett. 92, 203201 (2004).   
[541] S. Trotzky, P. Cheinet, S. Fölling, M. Feld, U. Schnorrberger, A. M. Rey, A. Polkovnikov, E. A. Demler, M. D. Lukin, and I. Bloch, Science 319, 295 (2008).   
[542] M. Anderlini, P. J. Lee, B. L. Brown, J. Sebby-Strabley, W. D. Phillips, and J. V. Porto, Nature 448, 452 (2007).   
[543] Z. Pavlović, B. O. Roos, R. Côté, and H. R. Sadeghpour, Phys. Rev. A 69, 030701 (2004).   
[544] H. Schmaljohann, M. Erhard, J. Kronjäger, M. Kottke, S. van Staa, L. Cacciapuoti, J. J. Arlt, K. Bongs, and K. Sengstock, Phys. Rev. Lett. 92, 040402 (2004).   
[545] J. Kronjäger, C. Becker, P. Navez, K. Bongs, and K. Sengstock, Phys. Rev. Lett. 97, 110404 (2006).   
[546] J. M. Sadler, L. E.and Higbie, S. R. Leslie, M. Vengalattore, and D. M. Stamper-Kurn, Nature 443, 312 (2006).   
[547] Y. Liu, S. Jung, S. E. Maxwell, L. D. Turner, E. Tiesinga, and P. D. Lett, Phys. Rev. Lett. 102, 125301 (2009).   
[548] D. Jacob, L. Shao, V. Corre, T. Zibold, L. De Sarlo, E. Mimoun, J. Dalibard, and F. Gerbier, Phys. Rev. A 86, 061601 (2012).   
[549] H. K. Pechkis, J. P. Wrubel, A. Schwettmann, P. F. Griffin, R. Barnett, E. Tiesinga, and P. D. Lett, Phys. Rev. Lett. 111, 025301 (2013).   
[550] J. S. Krauser, J. Heinze, N. Flaschner, S. Gotze, O. Jurgensen, D.-S. Luhmann, C. Becker, and K. Sengstock, Nature Physics 8, 813 (2012).   
[551] B. Evrard, A. Qu, J. Dalibard, and F. Gerbier, Phys. Rev. Lett. 126, 063401 (2021).   
[552] J.-y. Choi, W. J. Kwon, and Y.-i. Shin, Phys. Rev. Lett. 108, 035301 (2012).   
[553] T.-L. Ho, Phys. Rev. Lett. 81, 742 (1998).   
[554] T. Ohmi and K. Machida, Journal of the Physical Society of Japan 67, 1822 (1998).   
[555] E. M. Bookjans, C. D. Hamley, and M. S. Chapman, Phys. Rev. Lett. 107, 210406 (2011).   
[556] C. Klempt, O. Topic, G. Gebreyesus, M. Scherer, T. Henninger, P. Hyllus, W. Ertmer, L. Santos, and J. J. Arlt, Phys. Rev. Lett. 104, 195303 (2010).   
[557] B. Lücke, J. Peise, G. Vitagliano, J. Arlt, L. Santos, G. Tóth, and C. Klempt, Phys. Rev. Lett. 112, 155304 (2014).   
[558] I. Kruse, K. Lange, J. Peise, B. Lücke, L. Pezzè, J. Arlt, W. Ertmer, C. Lisdat, L. Santos, A. Smerzi, and C. Klempt, Phys. Rev. Lett. 117, 143004 (2016).   
[559] C. K. Law, H. Pu, and N. P. Bigelow, Phys. Rev. Lett. 81, 5257 (1998).   
[560] T.-L. Ho and S. K. Yip,   
df. Phys. Rev. Lett. 84, 4031 (2000).   
[561] B. Evrard, A. Qu, J. Dalibard, and F. Gerbier, arXiv preprint arXiv:2010.15739 (2020).   
[562] C. Wu, Mod. Phys. Lett. B 20, 1707 (2006).   
[563] M. Hermele, V. Gurarie, and A. M. Rey, Phys. Rev. Lett. 103, 135301 (2009).   
[564] M. K. Tey, S. Stellmer, R. Grimm, and F. Schreck, Phys. Rev. A 82, 011608 (2010).   
[565] S. Taie, Y. Takasu, S. Sugawa, R. Yamazaki, T. Tsujimoto, R. Murakami, and Y. Takahashi, Phys. Rev. Lett. 105, 190401 (2010).   
[566] S. Taie, R. Yamazaki, S. Sugawa, and Y. Takahashi, Nat. Phys. 8, 825 (2012).   
[567] G. Pagano, M. Mancini, G. Cappellini, P. Lombardi, F. Schäfer, H. Hu, X.-J. Liu, J. Catani, C. Sias, M. Inguscio, and L. Fallani, Nature Physics 10, 198 (2014).   
[568] T.-L. Ho and S. Yip, Phys. Rev. Lett. 82, 247 (1999).   
[569] A. Rapp, G. Zaránd, C. Honerkamp, and W. Hofstetter, Phys. Rev. Lett. 98, 160405 (2007).   
[570] M. Vengalattore, S. R. Leslie, J. Guzman, and D. M. Stamper-Kurn, Phys. Rev. Lett. 100, 170403 (2008).   
[571] Y. Eto, H. Saito, and T. Hirano, Phys. Rev. Lett. 112, 185301 (2014).   
[572] S. Yi, L. You, and H. Pu, Phys. Rev. Lett. 93, 040403 (2004).   
[573] K. Gawryluk, K. Bongs, and M. Brewczyk, Phys. Rev. Lett. 106, 140403 (2011).   
[574] T. Świsłocki, T. Sowiński, J. Pietraszewicz, M. Brewczyk, M. Lewenstein, J. Zakrzewski, and M. Gajda, Phys. Rev. A 83, 063617 (2011).   
[575] Y. Kawaguchi, H. Saito, and M. Ueda, Phys. Rev. Lett. 97, 130404 (2006).   
[576] J. Stenger, S. Inouye, A. P. Chikkatur, D. M. Stamper-Kurn, D. E. Pritchard, and W. Ketterle, Phys. Rev. Lett. 82, 4569 (1999).   
[577] G. E. Marti, A. MacRae, R. Olf, S. Lourette, F. Fang, and D. M. Stamper-Kurn, Phys. Rev. Lett. 113, 155302 (2014).   
[578] Y. Kawaguchi, H. Saito, and M. Ueda, Phys. Rev. Lett. 98, 110406 (2007).   
[579] L. Gabardos, B. Zhu, S. Lepoutre, A. M. Rey, B. Laburthe-Tolra, and L. Vernac, Phys. Rev. Lett. 125, 143401 (2020).   
[580] T. Isoshima, T. Ohmi, and K. Machida, Journal of the Physical Society of Japan 69, 3864 (2000) http://dx.doi.org/10.1143/JPSJ.69.3864.   
[581] B. Pasquiou, E. Maréchal, L. Vernac, O. Gorceix, and B. Laburthe-Tolra, Phys. Rev. Lett. 108, 045307 (2012).   
[582] C. Frapolli, T. Zibold, A. Invernizzi, K. JiménezGarcía, J. Dalibard, and F. Gerbier, Phys. Rev. Lett. 119, 050404 (2017).   
[583] B. Naylor, M. Brewczyk, M. Gajda, O. Gorceix, E. Maréchal, L. Vernac, and B. Laburthe-Tolra, Phys. Rev. Lett. 117, 185302 (2016).   
[584] S. S. Natu and E. J. Mueller, Phys. Rev. A 84, 053625 (2011).   
[585] V. Berezinskii, Soviet Journal of Experimental and Theoretical Physics 34, 610 (1972).   
[586] J. M. Kosterlitz and D. J. Thouless, Journal of Physics C: Solid State Physics 6, 1181 (1973)   
[587] Z. Hadzibabic, P. Krüger, M. Cheneau, B. Battelier, and J. Dalibard, Nature (London) 441, 1118 (2006).   
[588] S. Mukerjee, C. Xu, and J. E. Moore, Phys. Rev. Lett. 97, 120406 (2006).   
[589] R. B. Diener and T.-L. Ho, Phys. Rev. Lett. 96, 190405 (2006).   
[590] T. Świsłocki, J. H. Bauer, M. Gajda, and M. Brewczyk, Phys. Rev. A 89, 023622 (2014).   
[591] A. Farolfi, D. Trypogeorgos, G. Colzi, E. Fava, G. Lamporesi, and G. Ferrari, Review of Scientific Instruments 90, 115114 (2019).   
[592] S. Hensler, A. Greiner, J. Stuhler, and T. Pfau, EPL (Europhysics Letters) 71, 918 (2005).   
[593] M. Fattori, T. Koch, S. Goetz, A. Griesmaier, S. Hensler, J. Stuhler, and T. Pfau, Nat. Phys. 2, 765 (2006).   
[594] Hamilton, Mathew S., Wilson, Rebekah F., and Roberts, Jacob L., Eur. Phys. J. D 68, 14 (2014).   
[595] B. Naylor, E. Maréchal, J. Huckans, O. Gorceix, P. Pedri, L. Vernac, and B. Laburthe-Tolra, Phys. Rev. Lett. 115, 243002 (2015).   
[596] T. Swislocki, M. Gajda, M. Brewczyk, and P. Deuar, Scientific Reports 11, 6441 (2021).   
[597] R. Olf, F. Fang, G. E. Marti, A. MacRae, and D. M. Stamper-Kurn, Nat. Phys 11, 720 (2015).   
[598] P. Medley, D. M. Weld, H. Miyake, D. E. Pritchard, and W. Ketterle, Phys. Rev. Lett. 106, 195301 (2011).   
[599] M. R. de Saint-Vincent, P. Pedri, and B. LaburtheTolra, New Journal of Physics 20, 073037 (2018).   
[600] M. Melé-Messeguer, B. Juliá-Díaz, A. Polls, and L. Santos, Phys. Rev. A 87, 033632 (2013).   
[601] A. Soumyanarayanan, N. Reyren, A. Fert, and C. Panagopoulos, Nature 539, 509 (2016).   
[602] M. Z. Hasan and C. L. Kane, Rev. Mod. Phys. 82, 3045 (2010).   
[603] X.-L. Qi and S.-C. Zhang, Rev. Mod. Phys. 83, 1057 (2011).   
[604] K. v. Klitzing, G. Dorda, and M. Pepper, Phys. Rev. Lett. 45, 494 (1980).   
[605] D. C. Tsui, H. L. Stormer, and A. C. Gossard, Phys. Rev. Lett. 48, 1559 (1982).   
[606] R. B. Laughlin, Phys. Rev. Lett. 50, 1395 (1983).   
[607] A. L. Fetter, Rev. Mod. Phys. 81, 647 (2009).   
[608] R. Dum and M. Olshanii, Phys. Rev. Lett. 76, 1788 (1996).   
[609] Z. Wu, L. Zhang, W. Sun, X.-T. Xu, B.-Z. Wang, S.-C. Ji, Y. Deng, S. Chen, X.-J. Liu, and J.-W. Pan, Science 354, 83 (2016).   
[610] L. Huang, Z. Meng, P. Wang, P. Peng, S.-L. Zhang, L. Chen, D. Li, Q. Zhou, and J. Zhang, Nature Phys. 12, 540 (2016).   
[611] Y.-J. Lin, K. Jimenez-Garcia, and I. B. Spielman, Nature (London) 471, 83 (2011).   
[612] L. W. Cheuk, A. T. Sommer, Z. Hadzibabic, T. Yefsah, W. S. Bakr, and M. W. Zwierlein, Phys. Rev. Lett. 109, 095302[1 (2012).   
[613] P. Wang, Z.-Q. Yu, Z. Fu, J. Miao, L. Huang, S. Chai, H. Zhai, and J. Zhang, Phys. Rev. Lett. 109, 095301[1 (2012).   
[614] I. B. Spielman, Phys. Rev. A 79, 063613 (2009).   
[615] S. Kolkowitz, S. L. Bromley, T. Bothwell, M. L. Wall, G. E. Marti, A. P. Koller, X. Zhang, A. M. Rey, and J. Ye, Nature 542, 66 (2017).   
[616] M. L. Wall, A. P. Koller, S. Li, X. Zhang, N. R. Cooper, J. Ye, and A. M. Rey, Phys. Rev. Lett. 116, 035301[1 (2016).   
[617] M. Mancini, G. Pagano, G. Cappellini, L. Livi, M. Rider, J. Catani, C. Sias, P. Zoller, M. Inguscio, M. Dalmonte, and L. Fallani, Science 349, 1510 (2015).   
[618] A. Yamaguchi, S. Uetake, D. Hashimoto, J. M. Doyle, and Y. Takahashi, Phys. Rev. Lett. 101, 233002 (2008).   
[619] A. Traverso, R. Chakraborty, Y. N. Martinez de Escobar, P. G. Mickelson, S. B. Nagel, M. Yan, and T. C. Killian, Phys. Rev. A 79, 060702(R) (2009).   
[620] S. Uetake, R. Murakami, J. M. Doyle, and Y. Takahashi, Phys. Rev. A 86, 032712[1 (2012).   
[621] I. H. Deutsch and P. S. Jessen, Phys. Rev. A 57, 1972 (1998).   
[622] J. Zhang, H. Hu, X. Liu, and H. Pu, in Annu. Rev. Cold At. Mol. (World Scientific, 2014) p. 81.   
[623] H. Zhai, Rep. Prog. Phys. 78, 026001[1 (2015).   
[624] J. Li, W. Huang, B. Shteynas, S. Burchesky, F. Ç. Top, E. Su, J. Lee, A. O. Jamison, and W. Ketterle, Phys. Rev. Lett. 117, 185301 (2016).   
[625] Y. Deng, J. Cheng, H. Jing, C. P. Sun, and S. Yi, Phys. Rev. Lett. 108, 125301 (2012).   
[626] S. Gopalakrishnan, I. Martin, and E. A. Demler, Phys. Rev. Lett. 111, 185304 (2013).   
[627] B. Lian and S. Zhang, Phys. Rev. B 89, 041110 (2014).   
[628] T. Chalopin, T. Satoor, A. Evrard, V. Makhalov, J. Dalibard, R. Lopes, and S. Nascimbene, Nature Physics , 1 (2020).   
[629] B. Stuhl, H.-I. Lu, L. Aycock, D. Genkina, and I. Spielman, Science 349, 1514 (2015).   
[630] F. A. An, E. J. Meier, and B. Gadway, Science advances 3, e1602685 (2017).   
[631] I. D. Leroux, M. H. Schleier-Smith, and V. Vuletić, Phys. Rev. Lett. 104, 250801 (2010).   
[632] J. G. Bohnet, B. C. Sawyer, J. W. Britton, M. L. Wall, A. M. Rey, M. Foss-Feig, and J. J. Bollinger, Science 352, 1297 (2016), https://science.sciencemag.org/content/352/6291/1297.ful   
[633] K. Mølmer and A. Sørensen, Phys. Rev. Lett. 82, 1835 (1999).   
[634] O. Hosten, R. Krishnakumar, N. J. Engelsen, and M. A. Kasevich, Science 352, 1552 (2016), https://science.sciencemag.org/content/352/6293/1552.ful   
[635] D. Jaksch, C. Bruder, J. I. Cirac, C. W. Gardiner, and P. Zoller, Phys. Rev. Lett. 81, 3108 (1998).   
[636] I. Bloch, Nat. Phys. 1, 23 (2005).   
[637] T. Esslinger, Annu. Rev. Condens. Matter Phys. 1, 129 (2   
[638] C. Gross and I. Bloch, Science 357, 995 (2017), http://science.sciencemag.org/content/357/6355/995.full.p   
[639] P. Nozieres, Theory Of Interacting Fermi Systems, Advanced Books Classics (Avalon Publishing, 1997).   
[640] L. D. Landau, Journal of Experimental and Theoretical Physics 3, 920 (1957).   
[641] M. A. Cazalilla, R. Citro, T. Giamarchi, E. Orignac, and M. Rigol, Rev. Mod. Phys. 83, 1405 (2011).   
[642] M. Olshanii, Phys. Rev. Lett. 81, 938 (1998).   
[643] G. E. Astrakharchik, D. Blume, S. Giorgini, and B. E. Granger, Physical Review Letters 92, 030402 (2004).   
[644] M. T. Batchelor, M. Bortz, X. W. Guan, and N. Oelkers, Journal of Statistical Mechanics: Theory and Experiment   
[645] S. Chen, L. Guan, X. Yin, Y. Hao, and X.-W. Guan, Physical Review A 81, 031609 (2010).   
[646] T. Giamarchi, International Journal of Modern Physics B 26, 1244004 (2012).   
[647] B. Paredes, A. Widera, V. Murg, O. Mandel, S. Fölling, I. Cirac, G. V. Shlyapnikov, T. W. Hänsch, and I. Bloch, Nature 429, 277 (2004).   
[648] T. Kinoshita, T. Wenger, and D. S. Weiss, Science 305, 1125 (2004).   
[649] S. Hofferberth, I. Lesanovsky, T. Schumm, A. Imambekov, V. Gritsev, E. Demler, and J. Schmiedmayer, Nature Physics 4, 489 (2008).   
[650] T. Langen, R. Geiger, and J. Schmiedmayer, Annu. Rev. Condens. Matter Phys. 6, 201 (2015).   
[651] L. D’Alessio, Y. Kafri, A. Polkovnikov, and M. Rigol, Adv. Phys 65, 239 (2016).   
[652] T. Langen, T. Gasenzer, and J. Schmiedmayer, J. Stat. Mech. 2016, 064009 (2016).   
[653] B. L. Tolra, K. M. O’Hara, J. H. Huckans, W. D. Phillips, S. L. Rolston, and J. V. Porto, Phys. Rev. Lett. 92, 190401 (2004).   
[654] T. Kinoshita, T. Wenger, and D. S. Weiss, Phys. Rev. Lett. 95, 190406 (2005).   
[655] C. D. Fertig, K. M. O’Hara, J. H. Huckans, S. L. Rolston, W. D. Phillips, and J. V. Porto, Phys. Rev. Lett. 94, 120403 (2005).   
[656] T. Kinoshita, T. Wenger, and D. S. Weiss, Nature 440, 900 (2006).   
[657] E. Haller, R. Hart, M. J. Mark, J. G. Danzl, L. Reichsöllner, M. Gustavsson, M. Dalmonte, G. Pupillo, and H.-C. Nägerl, Nature (London) 466, 597 (2010).   
[658] N. Fabbri, M. Panfil, D. Clément, L. Fallani, M. Inguscio, C. Fort, and J.-S. Caux, Phys. Rev. A 91, 043617 (2015).   
[659] F. Meinert, M. Panfil, M. J. Mark, K. Lauber, J. S. Caux, and H. C. Nagerl, Phys. Rev. Lett. 115, 085301 (2015).   
[660] B. Yang, Y.-Y. Chen, Y.-G. Zheng, H. Sun, H.- N. Dai, X.-W. Guan, Z.-S. Yuan, and J.-W. Pan,   
l.pdf. Phys. Rev. Lett. 119, 165701 (2017).   
[661] J. M. Wilson, N. Malvania, Y. Le, Y. Zhang, M. Rigol, and D. S. Weiss, Science 367, 1461 (2020).   
[662] T. L. Yang, P. Grišins, Y. T. Chang, Z. H. Zhao, C. Y. Shih, T. Giamarchi, and R. G. Hulet,   
l.pdf. Phys. Rev. Lett. 121, 103001 (2018).   
[663] G. E. Astrakharchik and Y. E. Lozovik, Phys. Rev. A 77, 013404 (2008).   
[664] A. S. Arkhipov, G. E. Astrakharchik, A. V. Belikov,   
010). and Y. E. Lozovik, JETP Letters 82, 39 (2005).   
[665] R. Citro, E. Orignac, S. De Palo, and M. L. Chiofalo,   
df. Physical Review A 75, 051602 (2007).   
[666] P. Pedri, S. De Palo, E. Orignac, R. Citro, and M. L. Chiofalo, Physical Review A 77, 015601 (2008).   
[667] M. D. Girardeau and G. E. Astrakharchik, Physical Review Letters 109, 235305 (2012).   
[668] Y. Tang, Stanford Ph.D. Thesis (2018).   
[669] D. J. Griffiths, American Journal of Physics 50, 698 (1998).   
[670] S. D. Palo, R. Citro, and E. Orignac, Physical Review B 101, 045102 (2020), 1910.05965.   
[671] A. Lamacraft, Physical Review A 87, 012707 (2013).   
[672] C. N. Yang, Phys. Rev. Lett. 19, 1312 (1967).   
2005, L10001 (2005).[673] R. J. Baxter, Annals of Physics 70, 193 (1972).   
[674] I. E. Mazets, T. Schumm, and J. Schmiedmayer, Phys. Rev. Lett. 100, 210403 (2008).   
[675] I. E. Mazets and J. Schmiedmayer, New J. Phys. 12, 055023 (2010).   
[676] S. Tan, M. Pustilnik, and L. I. Glazman, Phys. Rev. Lett. 105, 090404 (2010).   
[677] M. Eckstein, M. Kollar, and P. Werner, Phys. Rev. Lett. 103, 056403 (2009).   
[678] M. Kollar, F. A. Wolf, and M. Eckstein, Phys. Rev. B 84, 054304 (2011).   
[679] N. Nessi, A. Iucci, and M. A. Cazalilla, Phys. Rev. Lett. 113, 210402 (2014).   
[680] M. Babadi, E. Demler, and M. Knap, Phys. Rev. X 5, 041005 (2015).   
[681] B. Bertini, F. H. L. Essler, S. Groha, and N. J. Robinson, Phys. Rev. Lett. 115, 180601 (2015).   
[682] B. Bertini, F. H. L. Essler, S. Groha, and N. J. Robinson, Phys. Rev. B 94, 245117 (2016).   
[683] A. N. Kolmogorov, Dokl. Akad. Nauk SSSR 98 (1954).   
[684] H. S. Dumas, The KAM Story (World Scientific, 2014).   
[685] A. A. Burkov, M. D. Lukin, and E. Demler, Phys. Rev. Lett. 98, 200404 (2007).   
[686] M. Moeckel and S. Kehrein, Phys. Rev. Lett. 100, 175702 (2008).   
[687] M. Rigol, Phys. Rev. Lett. 103, 100403 (2009).   
[688] M. Rigol, Phys. Rev. A 80, 053607 (2009).   
[689] M. Marcuzzi, J. Marino, A. Gambassi, and A. Silva, Phys. Rev. Lett. 111, 197203 (2013).   
[690] M. Rigol, Phys. Rev. Lett. 116, 100601 (2016).   
[691] N. Nessi and A. Iucci, arXiv preprint arXiv:1503.02507 (2015).   
[692] B. Bertini and M. Fagotti, J. Stat. Mech. 2015, P07012 (2015).   
[693] G. P. Brandino, J.-S. Caux, and R. M. Konik, Phys. Rev. X 5, 041043 (2015).   
[694] F. R. A. Biebl and S. Kehrein, Phys. Rev. B 95, 104304 (2017).   
[695] S. Sachdev, Quantum Phase Transitions (Cambridge University Press, 2011).   
[696] E. Tempfli, S. Zöllner, and P. Schmelcher, New Journal of Physics 10, 103021 (2008).   
[697] E. Haller, M. J. Mark, R. Hart, J. G. Danzl, L. Reichsöllner, V. Melezhik, P. Schmelcher, and H.-C. Nägerl, Physical Review Letters 104, 153203 (2010).   
[698] P. Giannakeas, V. S. Melezhik, and P. Schmelcher, Phys. Rev. Lett. 111, 183201 (2013).   
[699] T. Shi and S. Yi, Phys. Rev. A 90, 042710 (2014).   
[700] L. Guan, X. Cui, R. Qi, and H. Zhai, Phys. Rev. A 89, 023604 (2014).   
[701] G. E. Astrakharchik, Phys. Rev. A 72, 063620 (2005).   
[702] A. Bohm, A. Mostafazadeh, H. Koizumi, Q. Niu, and J. Zwanziger, The Geometric Phase in Quantum Systems, Foundation (Springer Science and Business Media, 2003) pp. 407– 427.   
[703] N. Yonezawa, A. Tanaka, and T. Cheon, Physical Review A 87, 062113 (2013).   
[704] S. Kasumie, M. Miyamoto, and A. Tanaka, Phys. Rev. A 93, 042105 (2016).   
[705] A. Tanaka, T. Nakamura, and T. Cheon, Phys. Rev. A 102, 013308 (2020).   
[706] D. J. Thouless, Phys. Rev. B 27, 6083 (1983).   
[707] M. Lohse, C. Schweizer, O. Zilberberg, M. Aidelsburger, and I. Bloch, Nature Physics 12, 350 (2016).   
[708] S. Nakajima, T. Tomita, S. Taie, T. Ichinose, H. Ozawa, L. Wang, M. Troyer, and Y. Takahashi, Nature Physics 12, 296 (2016).   
[709] E. J. Heller, Phys. Rev. Lett. 53, 1515 (1984).   
[710] R. Vasseur and J. E. Moore, Journal of Statistical Mechanics: Theory and Experiment 2016, 064010 (2016).   
[711] D. A. Abanin, E. Altman, I. Bloch, and M. Serbyn, Rev. Mod. Phys. 91, 021001 (2019).   
[712] C. J. Turner, A. A. Michailidis, D. A. Abanin, M. Serbyn, and Z. Papić, Nature Physics 14, 745 (2018).   
[713] V. Khemani, C. R. Laumann, and A. Chandran, Phys. Rev. B 99, 161101 (2019).   
[714] R. P. Feynman, Statistical mechanics: A set of lectures, 0th ed., A Set Of Lectures (CRC Press, California Institute of Technology, Pasadena, United States, 2018).   
[715] C. Wu, Mod. Phys. Lett. B 23, 1 (2011).   
[716] W. Hofstetter, J. I. Cirac, P. Zoller, E. Demler, and M. D. Lukin, Phys. Rev. Lett. 89, 220407 (2002).   
[717] J. Hubbard, Proceedings of the Royal Society of London http://rspa.royalsocietypublishing.org/content/276/1365   
[718] J. Hubbard, Phys. Rev. B 17, 494 (1978).   
[719] M. Greiner, O. Mandel, T. Esslinger, T. W. Hänsch, and I. Bloch, Nature (London) 415, 39 (2002).   
[720] R. Jördens, N. Strohmaier, K. Günter, H. Moritz, and T. Esslinger, Nature (London) 455, 204 (2008).   
[721] U. Schneider, L. Hackermüller, S. Will, T. Best, I. Bloch, T. A. Costi, R. W. Helmes, D. Rasch, and A. Rosch, Science 322, 204 (2008).   
[722] M. J. Mark, E. Haller, K. Lauber, J. G. Danzl, A. J. Daley, and H.-C. Nägerl, Phys. Rev. Lett. 107, 175301 (2011).   
[723] G. Mazzarella, S. M. Giampaolo, and F. Illuminati, Phys. Rev. A 73, 013625 (2006).   
[724] C. Trefzger, C. Menotti, B. CapogrossoSansone, and M. Lewenstein, Journal of Physics B: Atomic, Molecular and Optical Physics 44,   
[725] P. Sengupta, L. P. Pryadko, F. Alet, M. Troyer, and G. Schmid, Phys. Rev. Lett. 94, 207202 (2005).   
[726] G. G. Batrouni, F. Hébert, and R. T. Scalettar, Phys. Rev. Lett. 97, 087209 (2006).   
[727] E. G. Dalla Torre, E. Berg, and E. Altman, Phys. Rev. Lett. 97, 260401 (2006).   
[728] K. Mitra, C. Williams, and C. de Melo, arXiv preprint arXiv:0903.4655 (2009).   
[729] I. Danshita and C. A. R. Sá de Melo, Phys. Rev. Lett. 103, 225301 (2009).   
[730] B. Capogrosso-Sansone, C. Trefzger, M. Lewenstein, P. Zoller, and G. Pupillo, Phys. Rev. Lett. 104, 125301 (2010).   
[731] D. Rossini and R. Fazio, New Journal of Physics 14, 065012 (2012).   
[732] G. G. Batrouni, R. T. Scalettar, V. G. Rousseau, and   
Mathematical Concepts, and Applications in Molecular and Condensed MB. Grémaud, Phys. Rev. Lett. 110, 265303 (2013).   
[733] G. G. Batrouni, V. G. Rousseau, R. T. Scalettar, and B. Grémaud, Phys. Rev. B 90, 205123 (2014).   
[734] K. Kawaki, Y. Kuno, and I. Ichinose, Phys. Rev. B 95, 195101 (2017).   
[735] K. Suthar, R. Kraus, H. Sable, D. Angom, G. Morigi, and J. Zakrzewski, Phys. Rev. B 102, 214503 (2020).   
[736] R. Kraus, K. Biedroń, J. Zakrzewski, and G. Morigi, Phys. Rev. B 101, 174505 (2020).   
[737] R. Kraus, T. Chanda, J. Zakrzewski, and G. Morigi, Phys. Rev. B 106, 035144 (2022).   
[738] M. Dalmonte, M. Di Dio, L. Barbiero, and F. Ortolani, Phys. Rev. B 83, 155110 (2011).   
[739] K. Góral, L. Santos, and M. Lewenstein, Phys. Rev. Lett. 88, 170406 (2002).   
[740] K. Mikelsons and J. K. Freericks, Phys. Rev. A 83, 043609 (2011).   
[741] S. G. Bhongale, L. Mathey, S.-W. Tsai, C. W. Clark, and E. Zhao, Phys. Rev. Lett. 108, 145301 (2012).   
[742] A.-L. Gadsbølle and G. M. Bruun, Phys. Rev. A 86, 033623 (2012).   
[743] A.-L. Gadsbølle and G. M. Bruun, Phys. Rev. A 85, 021604 (2012).   
[744] T.-S. Zeng and L. Yin, Phys. Rev. B 89, 174511 (2014).   
[745] A. Camacho-Guardian and R. Paredes, Phys. Rev. A 94, 043638 (2016).   
[746] E. G. C. P. van Loon, M. I. Katsnelson, L. Chomaz, and M. Lemeshko, Phys. Rev. B 93, 195145 (2016).   
[747] We note that DIT is also relevant for contact-interacting bosons in a lattice. Yet it occurs at a higher order expan  
Mathematical, Physical and Engineering Sciences 276, 238 (1963),sion in the Wannier overlap than in the DDI case, as the   
38.full.pdf.interaction potential is fully localised at one position. Its impact was previously successfully demonstrated in this context, see refs [790, 791].   
[748] S. Nascimbene, N. Goldman, N. R. Cooper, and J. Dalibard, Phys. Rev. Lett. 115, 140401 (2015).   
[749] M. Łącki, M. A. Baranov, H. Pichler, and P. Zoller, Phys. Rev. Lett. 117, 233001 (2016).   
[750] F. Jendrzejewski, S. Eckel, T. G. Tiecke, G. Juzeli¯unas, G. K. Campbell, L. Jiang, and A. V. Gorshkov, Phys. Rev. A 94, 063422 (2016).   
[751] Y. Wang, S. Subhankar, P. Bienias, M. Łącki, T.-C. Tsui, M. A. Baranov, A. V. Gorshkov, P. Zoller, J. V. Porto, and S. L. Rolston, Phys. Rev. Lett. 120, 083601 (2018).   
[752] M. Lacki, P. Zoller, and M. A. Baranov, Phys. Rev. A 100, 033610 (2019).   
[753] T.-C. Tsui, Y. Wang, S. Subhankar, J. V. Porto, and [774] A. W. Glaetzle, M. Dalmonte, R. Nath, S. L. Rolston, Phys. Rev. A 101, 041603 (2020). C. Gross, I. Bloch, and P. Zoller,   
[754] W. Ge and M. S. Zubairy, Phys. Rev. Lett. 114, 173002 (2015). Phys. Rev. A 101, 023403 (2020). [775] K. R. A. Hazzard, S. R. Manmana, M. Foss-Feig, and   
[755] J. F. Sherson, C. Weitenberg, M. En- A. M. Rey, Phys. Rev. Lett. 110, 075301 (2013). dres, M. Cheneau, I. Bloch, and S. Kuhr, [776] A. Imambekov, M. Lukin, and E. Demler, Nature (London) 467, 68 (2010). Phys. Rev. A 68, 063602 (2003).   
[756] W. S. Bakr, J. I. Gillen, A. Peng, S. Fölling, and [777] J. Jiang, L. Zhao, S.-T. Wang, Z. Chen, T. Tang, L.-M. M. Greiner, Nature (London) 462, 74 (2009). Duan, and Y. Liu, Phys. Rev. A 93, 063607 (2016).   
[757] A. B. Kuklov and B. V. Svistunov, [778] S. Lepoutre, J. Schachenmayer, L. Gabardos, B. Zhu, Phys. Rev. Lett. 90, 100401 (2003). B. Naylor, E. Marechal, O. Gorceix, A. M. Rey,   
[758] L.-M. Duan, E. Demler, and M. D. Lukin, L. Vernac, and B. Laburthe-Tolra, Nature CommuniPhys. Rev. Lett. 91, 090402 (2003). cations 10, 1714 (2019).   
[759] J. J. García-Ripoll and J. I. Cirac, [779] K. R. A. Hazzard, B. Gadway, M. Foss-Feig, New Journal of Physics 5, 76 (2003). B. Yan, S. A. Moses, J. P. Covey, N. Y. Yao,   
[760] S. Nascimbène, Y.-A. Chen, M. Atala, M. Aidels- M. D. Lukin, J. Ye, D. S. Jin, and A. M. Rey, burger, S. Trotzky, B. Paredes, and I. Bloch, Phys. Rev. Lett. 113, 195302 (2014). Phys. Rev. Lett. 108, 205301 (2012). [780] D. Barredo, H. Labuhn, S. Ravets, T. La  
[761] T. Fukuhara, P. Schauß, M. Endres, S. Hild, M. Che- haye, A. Browaeys, and C. S. Adams, neau, I. Bloch, and C. Gross, Nature 502, 76 (2013). Phys. Rev. Lett. 114, 113002 (2015).   
[762] S. Hild, T. Fukuhara, P. Schauß, J. Zeiher, [781] J. Zhang, G. Pagano, P. W. Hess, A. Kyprianidis, M. Knap, E. Demler, I. Bloch, and C. Gross, P. Becker, H. Kaplan, A. V. Gorshkov, Z.-X. Gong, and Phys. Rev. Lett. 113, 147205 (2014). C. Monroe, Nature 551, 601 (2017).   
[763] R. C. Brown, R. Wyllie, S. B. Koller, E. A. Goldschmidt, [782] N. Friis, O. Marty, C. Maier, C. Hempel, M. Holzäpfel, M. Foss-Feig, and J. V. Porto, Science 348, 540 (2015), P. Jurcevic, M. B. Plenio, M. Huber, C. Roos, R. Blatt, http://science.sciencemag.org/content/348/6234/540.full.pdf. and B. Lanyon, Phys. Rev. X 8, 021012 (2018).   
[764] D. Greif, T. Uehlinger, G. Jotzu, L. Tarru- [783] P. Fersterer, A. Safavi-Naini, B. Zhu, L. Gabardos, ell, and T. Esslinger, Science 340, 1307 (2013), S. Lepoutre, L. Vernac, B. Laburthe-Tolra, P. B. Blakie, http://science.sciencemag.org/content/340/6138/1307.full.pdf. and A. M. Rey, Phys. Rev. A 100, 033609 (2019).   
[765] D. Greif, G. Jotzu, M. Messer, R. Desbuquois, and [784] J. Schachenmayer, A. Pikovski, and A. M. Rey, T. Esslinger, Phys. Rev. Lett. 115, 260401 (2015). Phys. Rev. X 5, 011022 (2015).   
[766] R. A. Hart, P. M. Duarte, T.-L. Yang, X. Liu, T. Paiva, [785] J. M. Deutsch, Phys. Rev. A 43, 2046 (1991). E. Khatami, R. T. Scalettar, N. Trivedi, D. A. Huse, [786] M. Rigol, V. Dunjko, and M. Olshanii, and R. G. Hulet, Nature 519, 211 (2015). Nature 452, 854 (2008).   
[767] J. H. Drewes, L. A. Miller, E. Cocchi, C. F. Chan, [787] A. M. Kaufman, M. E. Tai, A. Lukin, N. Wurz, M. Gall, D. Pertot, F. Brennecke, and M. Rispoli, R. Schittko, P. M. Preiss, M. Köhl, Phys. Rev. Lett. 118, 170401 (2017). and M. Greiner, Science 353, 794 (2016),   
[768] M. F. Parsons, A. Mazurenko, C. S. Chiu, G. Ji, http://science.sciencemag.org/content/353/6301/794.full.p D. Greif, and M. Greiner, Science 353, 1253 (2016), [788] T. E. Chupp, P. Fierlinger, M. J. Ramsey-Musolf, and http://science.sciencemag.org/content/353/6305/1253.full.pdf. J. T. Singh, Rev. Mod. Phys. 91, 015001 (2019).   
[769] M. Boll, T. A. Hilker, G. Salomon, A. Om- [789] V. Andreev, D. G. Ang, D. DeMille, J. M. Doyle, ran, J. Nespolo, L. Pollet, I. Bloch, G. Gabrielse, J. Haefner, N. R. Hutzler, Z. Lasner, and C. Gross, Science 353, 1257 (2016), C. Meisenhelder, B. R. O’Leary, C. D. Panda, A. D. http://science.sciencemag.org/content/353/6305/1257.full.pdf. West, E. P. West, X. Wu, and A. Collaboration, Na  
[770] L. W. Cheuk, M. A. Nichols, K. R. Lawrence, M. Okan, ture 562, 355 (2018). H. Zhang, E. Khatami, N. Trivedi, T. Paiva, M. Rigol, [790] D.-S. Lühmann, O. Jürgensen, and K. Sengstock, and M. W. Zwierlein, Science 353, 1260 (2016), New Journal of Physics 14, 033021 (2012). http://science.sciencemag.org/content/353/6305/1260.full.pdf.[791] O. Jürgensen, F. Meinert, M. J. Mark,   
[771] S. V. Syzranov, M. L. Wall, V. Gurarie, and A. M. Rey, H.-C. Nägerl, and D.-S. Lühmann, Nature communications 5, 1 (2014). Phys. Rev. Lett. 113, 193003 (2014).   
[772] M. L. Wall, K. Maeda, and L. D. Carr, New Journal of Physics 17, 025001 (2015).   
[773] D. Peter, N. Y. Yao, N. Lang, S. D. Huber, M. D. Lukin, and H. P. Büchler, Phys. Rev. A 91, 053617 (2015).